/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.TypeName;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface FactoryMethod
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FactoryMethod instance) {
        return (Builder)FactoryMethod.builder().from(instance);
    }

    public TypeName declaringType();

    public TypeName returnType();

    public String methodName();

    public Optional<TypeName> parameterType();

    public Optional<String> optionName();

    public static class Builder
    extends BuilderBase<Builder, FactoryMethod>
    implements io.helidon.common.Builder<Builder, FactoryMethod> {
        private Builder() {
        }

        public FactoryMethod buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.FactoryMethodImpl(this);
        }

        public FactoryMethod build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends FactoryMethod>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private String methodName;
        private String optionName;
        private TypeName declaringType;
        private TypeName parameterType;
        private TypeName returnType;

        protected BuilderBase() {
        }

        public BUILDER from(FactoryMethod prototype) {
            this.declaringType(prototype.declaringType());
            this.returnType(prototype.returnType());
            this.methodName(prototype.methodName());
            this.parameterType(prototype.parameterType());
            this.optionName(prototype.optionName());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.declaringType().ifPresent(this::declaringType);
            builder.returnType().ifPresent(this::returnType);
            builder.methodName().ifPresent(this::methodName);
            builder.parameterType().ifPresent(this::parameterType);
            builder.optionName().ifPresent(this::optionName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaringType(TypeName declaringType) {
            Objects.requireNonNull(declaringType);
            this.declaringType = declaringType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaringType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.declaringType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaringType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.declaringType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER returnType(TypeName returnType) {
            Objects.requireNonNull(returnType);
            this.returnType = returnType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER returnType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.returnType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER returnType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.returnType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER methodName(String methodName) {
            Objects.requireNonNull(methodName);
            this.methodName = methodName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearParameterType() {
            this.parameterType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER parameterType(TypeName parameterType) {
            Objects.requireNonNull(parameterType);
            this.parameterType = parameterType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER parameterType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.parameterType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER parameterType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.parameterType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOptionName() {
            this.optionName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER optionName(String optionName) {
            Objects.requireNonNull(optionName);
            this.optionName = optionName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeName> declaringType() {
            return Optional.ofNullable(this.declaringType);
        }

        public Optional<TypeName> returnType() {
            return Optional.ofNullable(this.returnType);
        }

        public Optional<String> methodName() {
            return Optional.ofNullable(this.methodName);
        }

        public Optional<TypeName> parameterType() {
            return Optional.ofNullable(this.parameterType);
        }

        public Optional<String> optionName() {
            return Optional.ofNullable(this.optionName);
        }

        public String toString() {
            return "FactoryMethodBuilder{declaringType=" + String.valueOf(this.declaringType) + ",returnType=" + String.valueOf(this.returnType) + ",methodName=" + this.methodName + ",parameterType=" + String.valueOf(this.parameterType) + ",optionName=" + this.optionName + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.declaringType == null) {
                collector.fatal(this.getClass(), "Property \"declaringType\" must not be null, but not set");
            }
            if (this.returnType == null) {
                collector.fatal(this.getClass(), "Property \"returnType\" must not be null, but not set");
            }
            if (this.methodName == null) {
                collector.fatal(this.getClass(), "Property \"methodName\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER parameterType(Optional<? extends TypeName> parameterType) {
            Objects.requireNonNull(parameterType);
            this.parameterType = parameterType.map(TypeName.class::cast).orElse(this.parameterType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER optionName(Optional<String> optionName) {
            Objects.requireNonNull(optionName);
            this.optionName = optionName.orElse(this.optionName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class FactoryMethodImpl
        implements FactoryMethod {
            private final Optional<TypeName> parameterType;
            private final Optional<String> optionName;
            private final String methodName;
            private final TypeName declaringType;
            private final TypeName returnType;

            protected FactoryMethodImpl(BuilderBase<?, ?> builder) {
                this.declaringType = builder.declaringType().get();
                this.returnType = builder.returnType().get();
                this.methodName = builder.methodName().get();
                this.parameterType = builder.parameterType().map(Function.identity());
                this.optionName = builder.optionName().map(Function.identity());
            }

            @Override
            public TypeName declaringType() {
                return this.declaringType;
            }

            @Override
            public TypeName returnType() {
                return this.returnType;
            }

            @Override
            public String methodName() {
                return this.methodName;
            }

            @Override
            public Optional<TypeName> parameterType() {
                return this.parameterType;
            }

            @Override
            public Optional<String> optionName() {
                return this.optionName;
            }

            public String toString() {
                return "FactoryMethod{declaringType=" + String.valueOf(this.declaringType) + ",returnType=" + String.valueOf(this.returnType) + ",methodName=" + this.methodName + ",parameterType=" + String.valueOf(this.parameterType) + ",optionName=" + String.valueOf(this.optionName) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FactoryMethod)) {
                    return false;
                }
                FactoryMethod other = (FactoryMethod)o;
                return Objects.equals(this.declaringType, other.declaringType()) && Objects.equals(this.returnType, other.returnType()) && Objects.equals(this.methodName, other.methodName()) && Objects.equals(this.parameterType, other.parameterType()) && Objects.equals(this.optionName, other.optionName());
            }

            public int hashCode() {
                return Objects.hash(this.declaringType, this.returnType, this.methodName, this.parameterType, this.optionName);
            }
        }
    }
}

