/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface DeprecatedFactoryMethod
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DeprecatedFactoryMethod instance) {
        return (Builder)DeprecatedFactoryMethod.builder().from(instance);
    }

    public TypedElementInfo method();

    public TypeName declaringType();

    public static class Builder
    extends BuilderBase<Builder, DeprecatedFactoryMethod>
    implements io.helidon.common.Builder<Builder, DeprecatedFactoryMethod> {
        private Builder() {
        }

        public DeprecatedFactoryMethod buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.DeprecatedFactoryMethodImpl(this);
        }

        public DeprecatedFactoryMethod build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends DeprecatedFactoryMethod>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private TypedElementInfo method;
        private TypeName declaringType;

        protected BuilderBase() {
        }

        public BUILDER from(DeprecatedFactoryMethod prototype) {
            this.method(prototype.method());
            this.declaringType(prototype.declaringType());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.method().ifPresent(this::method);
            builder.declaringType().ifPresent(this::declaringType);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(TypedElementInfo method) {
            Objects.requireNonNull(method);
            this.method = method;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(Consumer<TypedElementInfo.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypedElementInfo.Builder builder = TypedElementInfo.builder();
            consumer.accept(builder);
            this.method(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER method(Supplier<? extends TypedElementInfo> supplier) {
            Objects.requireNonNull(supplier);
            this.method(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaringType(TypeName declaringType) {
            Objects.requireNonNull(declaringType);
            this.declaringType = declaringType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaringType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.declaringType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER declaringType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.declaringType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypedElementInfo> method() {
            return Optional.ofNullable(this.method);
        }

        public Optional<TypeName> declaringType() {
            return Optional.ofNullable(this.declaringType);
        }

        public String toString() {
            return "DeprecatedFactoryMethodBuilder{method=" + String.valueOf(this.method) + ",declaringType=" + String.valueOf(this.declaringType) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.method == null) {
                collector.fatal(this.getClass(), "Property \"method\" must not be null, but not set");
            }
            if (this.declaringType == null) {
                collector.fatal(this.getClass(), "Property \"declaringType\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class DeprecatedFactoryMethodImpl
        implements DeprecatedFactoryMethod {
            private final TypedElementInfo method;
            private final TypeName declaringType;

            protected DeprecatedFactoryMethodImpl(BuilderBase<?, ?> builder) {
                this.method = builder.method().get();
                this.declaringType = builder.declaringType().get();
            }

            @Override
            public TypedElementInfo method() {
                return this.method;
            }

            @Override
            public TypeName declaringType() {
                return this.declaringType;
            }

            public String toString() {
                return "DeprecatedFactoryMethod{method=" + String.valueOf(this.method) + ",declaringType=" + String.valueOf(this.declaringType) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DeprecatedFactoryMethod)) {
                    return false;
                }
                DeprecatedFactoryMethod other = (DeprecatedFactoryMethod)o;
                return Objects.equals(this.method, other.method()) && Objects.equals(this.declaringType, other.declaringType());
            }

            public int hashCode() {
                return Objects.hash(this.method, this.declaringType);
            }
        }
    }
}

