/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.AnnotationDataOption;
import io.helidon.builder.codegen.FactoryMethods;
import io.helidon.builder.codegen.MethodSignature;
import io.helidon.builder.codegen.TypeHandler;
import io.helidon.builder.codegen.Types;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.Optional;
import java.util.Set;

record PrototypeProperty(TypedElementInfo element, MethodSignature signature, TypeHandler typeHandler, AnnotationDataOption configuredOption, FactoryMethods factoryMethods, boolean equality, boolean toStringValue, boolean confidential, boolean registryService, List<Annotation> qualifiers) {
    private static final Set<String> RESERVED_WORDS = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null");

    static PrototypeProperty create(CodegenContext ctx, TypeInfo blueprint, TypedElementInfo element, boolean beanStyleAccessors) {
        boolean isBoolean = element.typeName().boxed().equals((Object)TypeNames.BOXED_BOOLEAN);
        String getterName = element.elementName();
        Object name = PrototypeProperty.propertyName(getterName, isBoolean, beanStyleAccessors);
        String setterName = PrototypeProperty.setterName((String)name, beanStyleAccessors);
        if (RESERVED_WORDS.contains(name)) {
            name = "the" + CodegenUtil.capitalize((String)name);
        }
        TypeName returnType = PrototypeProperty.propertyTypeName(element);
        boolean sameGeneric = element.hasAnnotation(Types.OPTION_SAME_GENERIC);
        TypeHandler typeHandler = TypeHandler.create(blueprint.typeName(), element, (String)name, getterName, setterName, returnType, sameGeneric);
        AnnotationDataOption configuredOption = AnnotationDataOption.create(typeHandler, element);
        FactoryMethods factoryMethods = FactoryMethods.create(ctx, blueprint, typeHandler);
        boolean confidential = element.hasAnnotation(Types.OPTION_CONFIDENTIAL);
        Optional redundantAnnotation = element.findAnnotation(Types.OPTION_REDUNDANT);
        boolean toStringValue = redundantAnnotation.flatMap(it -> it.getValue("stringValue")).map(Boolean::parseBoolean).orElse(false) == false;
        boolean equality = redundantAnnotation.flatMap(it -> it.getValue("equality")).map(Boolean::parseBoolean).orElse(false) == false;
        boolean registryService = element.hasAnnotation(Types.OPTION_REGISTRY_SERVICE);
        List<Annotation> qualifiers = element.annotations().stream().filter(a -> a.hasMetaAnnotation(Types.SERVICE_QUALIFIER)).toList();
        return new PrototypeProperty(element, MethodSignature.create(element), typeHandler, configuredOption, factoryMethods, equality, toStringValue, confidential, registryService, qualifiers);
    }

    private static TypeName propertyTypeName(TypedElementInfo element) {
        return element.findAnnotation(Types.OPTION_TYPE).flatMap(rec$ -> ((Annotation)rec$).value()).map(TypeName::create).orElseGet(() -> element.typeName());
    }

    Field.Builder fieldDeclaration(boolean isBuilder) {
        return this.typeHandler.fieldDeclaration(this.configuredOption(), isBuilder, !isBuilder);
    }

    void setters(InnerClass.Builder classBuilder, TypeName builderType, Javadoc blueprintJavadoc) {
        this.typeHandler().setters(classBuilder, this.configuredOption(), this.factoryMethods(), builderType, blueprintJavadoc);
    }

    String name() {
        return this.typeHandler.name();
    }

    String getterName() {
        return this.typeHandler.getterName();
    }

    String setterName() {
        return this.typeHandler.setterName();
    }

    TypeName typeName() {
        return this.typeHandler.declaredType();
    }

    TypeName builderGetterType() {
        return this.typeHandler.builderGetterType(this.configuredOption.required(), this.configuredOption.hasDefault());
    }

    void builderGetter(ContentBuilder<?> contentBuilder) {
        this.typeHandler.generateBuilderGetter(contentBuilder, this.configuredOption.required(), this.configuredOption.hasDefault());
    }

    boolean builderGetterOptional() {
        return this.typeHandler.builderGetterOptional(this.configuredOption.required(), this.configuredOption.hasDefault());
    }

    private static String setterName(String name, boolean beanStyleAccessors) {
        if (beanStyleAccessors || RESERVED_WORDS.contains(name)) {
            return "set" + CodegenUtil.capitalize((String)name);
        }
        return name;
    }

    private static String propertyName(String getterName, boolean isBoolean, boolean beanStyleAccessors) {
        if (beanStyleAccessors) {
            if (isBoolean && getterName.startsWith("is")) {
                return PrototypeProperty.deCapitalize(getterName.substring(2));
            }
            if (getterName.startsWith("get")) {
                return PrototypeProperty.deCapitalize(getterName.substring(3));
            }
        }
        return getterName;
    }

    private static String deCapitalize(String string) {
        if (string.isBlank()) {
            return string;
        }
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }
}

