/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.AnnotationDataOption;
import io.helidon.builder.codegen.FactoryMethods;
import io.helidon.builder.codegen.TypeHandlerList;
import io.helidon.builder.codegen.TypeHandlerMap;
import io.helidon.builder.codegen.TypeHandlerOptional;
import io.helidon.builder.codegen.TypeHandlerSet;
import io.helidon.builder.codegen.TypeHandlerSupplier;
import io.helidon.builder.codegen.Types;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenValidator;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.Size;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.net.URI;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

class TypeHandler {
    private static final Map<TypeName, TypeName> BOXED_TO_PRIMITIVE = Map.of(TypeNames.BOXED_BOOLEAN, TypeNames.PRIMITIVE_BOOLEAN, TypeNames.BOXED_BYTE, TypeNames.PRIMITIVE_BYTE, TypeNames.BOXED_SHORT, TypeNames.PRIMITIVE_SHORT, TypeNames.BOXED_INT, TypeNames.PRIMITIVE_INT, TypeNames.BOXED_LONG, TypeNames.PRIMITIVE_LONG, TypeNames.BOXED_CHAR, TypeNames.PRIMITIVE_CHAR, TypeNames.BOXED_FLOAT, TypeNames.PRIMITIVE_FLOAT, TypeNames.BOXED_DOUBLE, TypeNames.PRIMITIVE_DOUBLE, TypeNames.BOXED_VOID, TypeNames.PRIMITIVE_VOID);
    private final TypeName enclosingType;
    private final TypedElementInfo annotatedMethod;
    private final String name;
    private final String getterName;
    private final String setterName;
    private final TypeName declaredType;

    TypeHandler(TypeName enclosingType, TypedElementInfo annotatedMethod, String name, String getterName, String setterName, TypeName declaredType) {
        this.enclosingType = enclosingType;
        this.annotatedMethod = annotatedMethod;
        this.name = name;
        this.getterName = getterName;
        this.setterName = setterName;
        this.declaredType = declaredType;
    }

    static TypeHandler create(TypeName blueprintType, TypedElementInfo annotatedMethod, String name, String getterName, String setterName, TypeName returnType, boolean sameGeneric) {
        if (TypeNames.OPTIONAL.equals((Object)returnType)) {
            return new TypeHandlerOptional(blueprintType, annotatedMethod, name, getterName, setterName, returnType);
        }
        if (TypeNames.SUPPLIER.equals((Object)returnType)) {
            return new TypeHandlerSupplier(blueprintType, annotatedMethod, name, getterName, setterName, returnType);
        }
        if (TypeNames.SET.equals((Object)returnType)) {
            TypeHandler.checkTypeArgsSizeAndTypes(annotatedMethod, returnType, TypeNames.SET, 1);
            return new TypeHandlerSet(blueprintType, annotatedMethod, name, getterName, setterName, returnType);
        }
        if (TypeNames.LIST.equals((Object)returnType)) {
            TypeHandler.checkTypeArgsSizeAndTypes(annotatedMethod, returnType, TypeNames.LIST, 1);
            return new TypeHandlerList(blueprintType, annotatedMethod, name, getterName, setterName, returnType);
        }
        if (TypeNames.MAP.equals((Object)returnType)) {
            TypeHandler.checkTypeArgsSizeAndTypes(annotatedMethod, returnType, TypeNames.MAP, 2);
            return new TypeHandlerMap(blueprintType, annotatedMethod, name, getterName, setterName, returnType, sameGeneric);
        }
        return new TypeHandler(blueprintType, annotatedMethod, name, getterName, setterName, returnType);
    }

    static AccessModifier setterAccessModifier(AnnotationDataOption configured) {
        return configured.accessModifier();
    }

    static TypeName toWildcard(TypeName typeName) {
        if (typeName.wildcard()) {
            return typeName;
        }
        if (typeName.generic()) {
            return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().className(typeName.className())).wildcard(true)).build();
        }
        return ((TypeName.Builder)TypeName.builder((TypeName)typeName).wildcard(true)).build();
    }

    static boolean isConfigProperty(TypeHandler handler) {
        return "config".equals(handler.name()) && handler.actualType().equals((Object)Types.COMMON_CONFIG);
    }

    protected static TypeName collectionImplType(TypeName typeName) {
        TypeName genericTypeName = typeName.genericTypeName();
        if (genericTypeName.equals((Object)TypeNames.MAP)) {
            return Types.LINKED_HASH_MAP;
        }
        if (genericTypeName.equals((Object)TypeNames.LIST)) {
            return Types.ARRAY_LIST;
        }
        return Types.LINKED_HASH_SET;
    }

    public String toString() {
        return this.declaredType.fqName() + " " + this.name;
    }

    void updateBuilderFromServices(ContentBuilder<?> content, String builder) {
        content.addContent(Types.SERVICES).addContent(".first(").addContent(this.actualType()).addContent(".class).ifPresent(").addContent(builder).addContent("::").addContent(this.setterName()).addContentLine(");");
    }

    void updateBuilderFromRegistry(ContentBuilder<?> content, String builder, String registry) {
        content.addContent(registry).addContent(".first(").addContent(this.actualType()).addContent(".class).ifPresent(").addContent(builder).addContent("::").addContent(this.setterName()).addContentLine(");");
    }

    TypeName builderGetterType(boolean required, boolean hasDefault) {
        if (this.builderGetterOptional(required, hasDefault)) {
            if (this.declaredType().isOptional()) {
                return this.declaredType();
            }
            return ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(this.declaredType().boxed())).build();
        }
        return this.declaredType();
    }

    void generateBuilderGetter(ContentBuilder<?> contentBuilder, boolean required, boolean hasDefault) {
        contentBuilder.addContent("return ");
        if (this.builderGetterOptional(required, hasDefault)) {
            contentBuilder.addContent(Optional.class).addContent(".ofNullable(").addContent(this.name).addContent(")");
        } else {
            contentBuilder.addContent(this.name);
        }
        contentBuilder.addContentLine(";");
    }

    Field.Builder fieldDeclaration(AnnotationDataOption configured, boolean isBuilder, boolean alwaysFinal) {
        Field.Builder builder = ((Field.Builder)Field.builder().name(this.name)).isFinal(alwaysFinal || !isBuilder);
        if (isBuilder && configured.required()) {
            builder.type(this.declaredType.boxed());
        } else {
            builder.type(this.declaredType);
        }
        if (isBuilder && configured.hasDefault()) {
            configured.defaultValue().accept((ContentBuilder<?>)builder);
        }
        return builder;
    }

    Consumer<ContentBuilder<?>> toDefaultValue(String defaultValue) {
        TypeName typeName = this.actualType();
        if (TypeNames.STRING.equals((Object)typeName)) {
            return content -> content.addContent("\"").addContent(defaultValue).addContent("\"");
        }
        if (TypeNames.SIZE.equals((Object)typeName)) {
            CodegenValidator.validateSize((TypeName)this.enclosingType, (TypedElementInfo)this.annotatedMethod, (TypeName)Types.OPTION_DEFAULT, (String)"value", (String)defaultValue);
            return content -> content.addContent(Size.class).addContent(".parse(\"").addContent(defaultValue).addContent("\")");
        }
        if (TypeNames.DURATION.equals((Object)typeName)) {
            CodegenValidator.validateDuration((TypeName)this.enclosingType, (TypedElementInfo)this.annotatedMethod, (TypeName)Types.OPTION_DEFAULT, (String)"value", (String)defaultValue);
            return content -> content.addContent(Duration.class).addContent(".parse(\"").addContent(defaultValue).addContent("\")");
        }
        if (Types.CHAR_ARRAY.equals((Object)typeName)) {
            return content -> content.addContent("\"").addContent(defaultValue).addContent("\".toCharArray()");
        }
        if (Types.PATH.equals((Object)typeName)) {
            return content -> content.addContent(Paths.class).addContent(".get(\"").addContent(defaultValue).addContent("\")");
        }
        if (Types.URI.equals((Object)typeName)) {
            CodegenValidator.validateUri((TypeName)this.enclosingType, (TypedElementInfo)this.annotatedMethod, (TypeName)Types.OPTION_DEFAULT, (String)"value", (String)defaultValue);
            return content -> content.addContent(URI.class).addContent(".create(\"").addContent(defaultValue).addContent("\")");
        }
        if (typeName.primitive()) {
            if (typeName.fqName().equals("char")) {
                return content -> content.addContent("'").addContent(defaultValue).addContent("'");
            }
            return content -> content.addContent(defaultValue);
        }
        if (typeName.name().startsWith("java.")) {
            return content -> content.addContent(defaultValue);
        }
        return content -> content.addContent(typeName.genericTypeName()).addContent(".").addContent(defaultValue);
    }

    Consumer<ContentBuilder<?>> toDefaultValue(List<String> defaultValues, List<Integer> defaultInts, List<Long> defaultLongs, List<Double> defaultDoubles, List<Boolean> defaultBooleans, String defaultCode, AnnotationDataOption.DefaultMethod defaultMethod) {
        if (defaultCode != null) {
            return content -> content.addContent(defaultCode);
        }
        if (defaultMethod != null) {
            return this.toDefaultFromMethod(defaultMethod);
        }
        return this.toDefaultValue(defaultValues, defaultInts, defaultLongs, defaultDoubles, defaultBooleans);
    }

    Consumer<ContentBuilder<?>> toDefaultValue(List<String> defaultValues, List<Integer> defaultInts, List<Long> defaultLongs, List<Double> defaultDoubles, List<Boolean> defaultBooleans) {
        if (defaultValues != null) {
            String string = this.singleDefault(defaultValues);
            return this.toDefaultValue(string);
        }
        if (defaultInts != null) {
            return content -> content.addContent(String.valueOf(this.singleDefault(defaultInts)));
        }
        if (defaultLongs != null) {
            return content -> content.addContent(String.valueOf(this.singleDefault(defaultLongs)) + "L");
        }
        if (defaultDoubles != null) {
            return content -> content.addContent(String.valueOf(this.singleDefault(defaultDoubles)));
        }
        if (defaultBooleans != null) {
            return content -> content.addContent(String.valueOf(this.singleDefault(defaultBooleans)));
        }
        return contentBuilder -> {};
    }

    protected Consumer<ContentBuilder<?>> toDefaultFromMethod(AnnotationDataOption.DefaultMethod defaultMethod) {
        return content -> content.addContent(defaultMethod.type().genericTypeName()).addContent(".").addContent(defaultMethod.method()).addContent("()");
    }

    TypeName declaredType() {
        return this.declaredType;
    }

    TypeName actualType() {
        return this.declaredType;
    }

    String name() {
        return this.name;
    }

    String getterName() {
        return this.getterName;
    }

    String setterName() {
        return this.setterName;
    }

    void generateFromConfig(Method.Builder method, AnnotationDataOption configured, FactoryMethods factoryMethods) {
        method.addContent(this.configGet(configured));
        String fqName = this.actualType().fqName();
        if (fqName.endsWith(".Builder")) {
            if (configured.hasDefault()) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(".as(")).addContent(Types.COMMON_CONFIG)).addContent(".class).ifPresent(")).addContent(this.name())).addContentLine("::config);");
            } else {
                int lastDot = fqName.lastIndexOf(46);
                String builderMethod = fqName.substring(0, lastDot) + ".builder()";
                method.addContentLine(".map(" + builderMethod + "::config).ifPresent(this::" + this.setterName() + ");");
            }
        } else {
            this.generateFromConfig((ContentBuilder<?>)method, factoryMethods);
            method.addContentLine(".ifPresent(this::" + this.setterName() + ");");
        }
    }

    String configGet(AnnotationDataOption configured) {
        if (configured.configMerge().booleanValue()) {
            return "config";
        }
        return "config.get(\"" + configured.configKey() + "\")";
    }

    void generateFromConfig(ContentBuilder<?> content, FactoryMethods factoryMethods) {
        if (this.actualType().fqName().equals("char[]")) {
            content.addContent(".asString().as(").addContent(String.class).addContent("::toCharArray)");
            return;
        }
        Optional<FactoryMethods.FactoryMethod> factoryMethod = factoryMethods.createFromConfig();
        TypeName boxed = this.actualType().boxed();
        if (factoryMethod.isPresent()) {
            FactoryMethods.FactoryMethod fm = factoryMethod.get();
            content.addContent(".map(").addContent(fm.typeWithFactoryMethod().genericTypeName()).addContent("::");
            if (!this.actualType().typeArguments().isEmpty()) {
                content.addContent("<");
                Iterator iterator = this.actualType().typeArguments().iterator();
                while (iterator.hasNext()) {
                    content.addContent((TypeName)iterator.next());
                    if (!iterator.hasNext()) continue;
                    content.addContent(", ");
                }
                content.addContent(">");
            }
            content.addContent(fm.createMethodName()).addContent(")");
        } else {
            content.addContent(".as(").addContent(boxed.genericTypeName()).addContent(".class)");
        }
    }

    TypeName argumentTypeName() {
        return this.declaredType();
    }

    void setters(InnerClass.Builder classBuilder, AnnotationDataOption configured, FactoryMethods factoryMethod, TypeName returnType, Javadoc blueprintJavadoc) {
        String fqName;
        this.declaredSetter(classBuilder, configured, returnType, blueprintJavadoc);
        if (this.actualType().equals((Object)Types.CHAR_ARRAY)) {
            this.charArraySetter(classBuilder, configured, returnType, blueprintJavadoc);
        }
        if (factoryMethod.createTargetType().isPresent()) {
            this.factorySetter(classBuilder, configured, returnType, blueprintJavadoc, factoryMethod.createTargetType().get());
        }
        if (factoryMethod.builder().isPresent()) {
            this.factorySetterConsumer(classBuilder, configured, returnType, blueprintJavadoc, factoryMethod.builder().get());
            this.factorySetterSupplier(classBuilder, configured, returnType, blueprintJavadoc);
        }
        if ((fqName = this.actualType().fqName()).endsWith(".Builder")) {
            this.setterConsumer(classBuilder, configured, returnType, blueprintJavadoc);
        }
    }

    void setterConsumer(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        String argumentName = "consumer";
        ArrayList<String> paramLines = new ArrayList<String>();
        paramLines.add("consumer of builder for");
        paramLines.addAll(blueprintJavadoc.returnDescription());
        Javadoc javadoc = this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, paramLines).build();
        TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(this.actualType())).build();
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(argumentType))).javadoc(javadoc)).accessModifier(TypeHandler.setterAccessModifier(configured))).addContent(Objects.class)).addContentLine(".requireNonNull(" + argumentName + ");")).addContent("var builder = ");
        if (configured.hasDefault()) {
            builder.addContentLine("this." + this.name() + ";");
        } else {
            String fqName = this.actualType().fqName();
            int lastDot = fqName.lastIndexOf(46);
            String builderMethod = fqName.substring(0, lastDot) + ".builder()";
            builder.addContentLine(builderMethod + ";");
        }
        ((Method.Builder)((Method.Builder)builder.addContentLine("consumer.accept(builder);")).addContentLine("this." + this.name() + "(builder);")).addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    protected Javadoc.Builder setterJavadoc(Javadoc blueprintJavadoc) {
        return Javadoc.builder((Javadoc)blueprintJavadoc).addTag("see", "#" + this.getterName() + "()").returnDescription("updated builder instance");
    }

    protected void charArraySetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName())).returnType(returnType).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(TypeNames.STRING))).javadoc(this.setterJavadoc(blueprintJavadoc).addParameter(this.name(), blueprintJavadoc.returnDescription()).build())).accessModifier(TypeHandler.setterAccessModifier(configured))).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addContent(Objects.class)).addContentLine(".requireNonNull(" + this.name() + ");")).addContentLine("this." + this.name() + " = " + this.name() + ".toCharArray();")).addContentLine("return self();"));
    }

    boolean builderGetterOptional(boolean required, boolean hasDefault) {
        if (this.declaredType().isList() || this.declaredType().isMap() || this.declaredType().isSet()) {
            return false;
        }
        if (this.declaredType().isOptional()) {
            return true;
        }
        if (!required && this.declaredType().primitive()) {
            return false;
        }
        return !hasDefault;
    }

    protected void declaredSetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).javadoc(this.setterJavadoc(blueprintJavadoc).addParameter(this.name(), blueprintJavadoc.returnDescription()).build())).returnType(returnType).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.argumentTypeName()))).accessModifier(TypeHandler.setterAccessModifier(configured));
        if (!this.declaredType.primitive()) {
            ((Method.Builder)builder.addContent(Objects.class)).addContentLine(".requireNonNull(" + this.name() + ");");
        }
        if (configured.decorator() != null) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("new ")).addContent(configured.decorator())).addContent("().decorate(this, ")).addContent(this.name())).addContentLine(");");
        }
        builder.addContentLine("this." + this.name() + " = " + this.name() + ";");
        builder.addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    protected TypeName toPrimitive(TypeName typeName) {
        return Optional.ofNullable(BOXED_TO_PRIMITIVE.get(typeName)).orElse(typeName);
    }

    private static void checkTypeArgsSizeAndTypes(TypedElementInfo annotatedMethod, TypeName returnType, TypeName collectionType, int expectedTypeArgs) {
        List typeNames = returnType.typeArguments();
        if (typeNames.size() != expectedTypeArgs) {
            throw new CodegenException("Property of type " + collectionType.fqName() + " must have " + expectedTypeArgs + " type arguments defined", annotatedMethod.originatingElementValue());
        }
        for (TypeName typeName : typeNames) {
            if (!typeName.wildcard()) continue;
            throw new CodegenException("Property of type " + returnType.resolvedName() + " is not supported for builder, as wildcards cannot be handled correctly in setters", annotatedMethod.originatingElementValue());
        }
    }

    private <T> T singleDefault(List<T> defaultValues) {
        if (defaultValues.isEmpty()) {
            throw new IllegalArgumentException("Default values configured for " + this.name() + " are empty, one value is expected.");
        }
        if (defaultValues.size() > 1) {
            throw new IllegalArgumentException("Default values configured for " + this.name() + " contain more than one value, exactly one value is expected.");
        }
        return defaultValues.getFirst();
    }

    private void factorySetterConsumer(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods.FactoryMethod factoryMethod) {
        TypeName builderType = factoryMethod.factoryMethodReturnType().className().equals("Builder") ? factoryMethod.factoryMethodReturnType() : (factoryMethod.factoryMethodReturnType().className().endsWith(".Builder") ? factoryMethod.factoryMethodReturnType() : TypeName.create((String)(factoryMethod.factoryMethodReturnType().fqName() + ".Builder")));
        String argumentName = "consumer";
        ArrayList<String> paramLines = new ArrayList<String>();
        paramLines.add("consumer of builder for");
        paramLines.addAll(blueprintJavadoc.returnDescription());
        Javadoc javadoc = this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, paramLines).build();
        TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(argumentType))).accessModifier(TypeHandler.setterAccessModifier(configured))).javadoc(javadoc)).addContent(Objects.class)).addContentLine(".requireNonNull(" + argumentName + ");")).addContent("var builder = ")).addContent(factoryMethod.typeWithFactoryMethod().genericTypeName())).addContentLine("." + factoryMethod.createMethodName() + "();")).addContentLine("consumer.accept(builder);")).addContentLine("this." + this.name() + "(builder.build());")).addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    private void factorySetterSupplier(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        TypeName supplierType = this.actualType();
        if (!supplierType.wildcard()) {
            supplierType = ((TypeName.Builder)TypeName.builder((TypeName)supplierType).wildcard(true)).build();
        }
        supplierType = ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SUPPLIER).addTypeArgument(supplierType)).build();
        String argumentName = "supplier";
        ArrayList<String> paramLines = new ArrayList<String>();
        paramLines.add("supplier of");
        paramLines.addAll(blueprintJavadoc.returnDescription());
        Javadoc javadoc = this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, paramLines).build();
        TypeName argumentType = supplierType;
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(argumentType))).accessModifier(TypeHandler.setterAccessModifier(configured))).javadoc(javadoc)).addContent(Objects.class)).addContentLine(".requireNonNull(" + argumentName + ");")).addContentLine("this." + this.name() + "(" + argumentName + ".get());")).addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    private void factorySetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods.FactoryMethod factoryMethod) {
        String argumentName = this.name() + "Config";
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).javadoc(this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, blueprintJavadoc.returnDescription()).build())).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(factoryMethod.argumentType()))).accessModifier(TypeHandler.setterAccessModifier(configured))).addContent(Objects.class)).addContentLine(".requireNonNull(" + argumentName + ");")).addContent("this." + this.name() + " = ")).addContent(factoryMethod.typeWithFactoryMethod().genericTypeName())).addContentLine("." + factoryMethod.createMethodName() + "(" + argumentName + ");")).addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    static class OneTypeHandler
    extends TypeHandler {
        private final TypeName actualType;

        OneTypeHandler(TypeName enclosingType, TypedElementInfo annotatedMethod, String name, String getterName, String setterName, TypeName declaredType) {
            super(enclosingType, annotatedMethod, name, getterName, setterName, declaredType);
            this.actualType = declaredType.typeArguments().isEmpty() ? TypeNames.STRING : (TypeName)declaredType.typeArguments().getFirst();
        }

        @Override
        TypeName actualType() {
            return this.actualType;
        }
    }
}

