/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.api;

import io.helidon.common.HelidonServiceLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public final class BuilderSupport {
    private BuilderSupport() {
    }

    public static <C> List<C> discoverServices(Class<C> contract, boolean discoverServices, List<C> existingInstances) {
        if (!discoverServices) {
            return List.of();
        }
        ArrayList newInstances = new ArrayList();
        HashSet existingServiceTypes = new HashSet();
        existingInstances.forEach(it -> existingServiceTypes.add(it.getClass()));
        HelidonServiceLoader.create(contract).forEach(it -> {
            if (!existingServiceTypes.contains(it.getClass())) {
                newInstances.add(it);
            }
        });
        return newInstances;
    }

    public static <C> Optional<C> discoverService(Class<C> contract, boolean discoverServices, Optional<C> existingInstance) {
        if (existingInstance.isPresent() || !discoverServices) {
            return existingInstance;
        }
        return HelidonServiceLoader.create(contract).stream().findFirst();
    }
}

