/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.tests.spring.boot;

import io.hawt.config.ConfigFacade;
import io.hawt.springboot.HawtioPlugin;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class SpringBootService {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootService.class);
    private static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";

    public static void main(String[] args) {
        System.setProperty("hawtio.proxyWhitelist", "localhost, 127.0.0.1");
        System.setProperty("hawtio.authenticationEnabled", "false");
        SpringApplication.run(SpringBootService.class, (String[])args);
    }

    @Bean
    public HawtioPlugin samplePlugin() {
        HawtioPlugin plugin = new HawtioPlugin("http://localhost:10001", "samplePlugin", "./plugin");
        return plugin;
    }

    @Bean(initMethod="init")
    public ConfigFacade configFacade() {
        URL loginResource = this.getClass().getClassLoader().getResource("login.conf");
        if (loginResource != null) {
            this.setSystemPropertyIfNotSet(JAVA_SECURITY_AUTH_LOGIN_CONFIG, loginResource.toExternalForm());
        }
        LOG.info("Using loginResource java.security.auth.login.config : " + System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG));
        URL loginFile = this.getClass().getClassLoader().getResource("realm.properties");
        if (loginFile != null) {
            this.setSystemPropertyIfNotSet("login.file", loginFile.toExternalForm());
        }
        LOG.info("Using login.file : " + System.getProperty("login.file"));
        this.setSystemPropertyIfNotSet("hawtio.roles", "admin");
        this.setSystemPropertyIfNotSet("hawtio.realm", "hawtio");
        this.setSystemPropertyIfNotSet("hawtio.rolePrincipalClasses", "org.eclipse.jetty.jaas.JAASRole");
        if (!Boolean.getBoolean("debugMode")) {
            System.setProperty("hawtio.authenticationEnabled", "true");
        }
        return new ConfigFacade();
    }

    private void setSystemPropertyIfNotSet(String key, String value) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }
}

