/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.tests.spring.boot;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.security.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileLoginModule
extends AbstractLoginModule {
    public static final String DEFAULT_FILENAME = "realm.properties";
    private static final Logger LOG = LoggerFactory.getLogger(PropertyFileLoginModule.class);
    private static final ConcurrentHashMap<String, PropertyUserStore> PROPERTY_USERSTORES = new ConcurrentHashMap();
    private boolean hotReload = false;
    private String filename = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.setupPropertyUserStore(options);
    }

    private void setupPropertyUserStore(Map<String, ?> options) {
        this.parseConfig(options);
        if (PROPERTY_USERSTORES.get(this.filename) == null) {
            PropertyUserStore propertyUserStore = new PropertyUserStore();
            propertyUserStore.setConfig(this.filename);
            propertyUserStore.setHotReload(this.hotReload);
            PropertyUserStore prev = PROPERTY_USERSTORES.putIfAbsent(this.filename, propertyUserStore);
            if (prev == null) {
                LOG.info("setupPropertyUserStore: Starting new PropertyUserStore. PropertiesFile: " + this.filename + " hotReload: " + this.hotReload);
                try {
                    propertyUserStore.start();
                }
                catch (Exception e) {
                    LOG.warn("Exception while starting propertyUserStore: ", (Throwable)e);
                }
            }
        }
    }

    private void parseConfig(Map<String, ?> options) {
        String tmp = (String)options.get("file");
        this.filename = tmp == null ? DEFAULT_FILENAME : tmp;
        this.filename = System.getProperty("login.file", this.filename);
        tmp = (String)options.get("hotReload");
        this.hotReload = tmp == null ? this.hotReload : Boolean.parseBoolean(tmp);
    }

    public UserInfo getUserInfo(String userName) {
        PropertyUserStore propertyUserStore = PROPERTY_USERSTORES.get(this.filename);
        if (propertyUserStore == null) {
            throw new IllegalStateException("PropertyUserStore should never be null here!");
        }
        LOG.trace("Checking PropertyUserStore " + this.filename + " for " + userName);
        UserIdentity userIdentity = propertyUserStore.getUserIdentity(userName);
        if (userIdentity == null) {
            return null;
        }
        Set<Principal> principals = userIdentity.getSubject().getPrincipals();
        ArrayList<String> roles = new ArrayList<String>();
        for (Principal principal : principals) {
            roles.add(principal.getName());
        }
        Credential credential = (Credential)userIdentity.getSubject().getPrivateCredentials().iterator().next();
        LOG.trace("Found: " + userName + " in PropertyUserStore " + this.filename);
        return new UserInfo(userName, credential, roles);
    }

    public boolean logout() throws LoginException {
        return true;
    }
}

