/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.plugin;

import io.hawt.web.plugin.HawtioPluginMBean;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtioPlugin
implements HawtioPluginMBean {
    private static final Logger LOG = LoggerFactory.getLogger(HawtioPlugin.class);
    private String url;
    private String scope;
    private String module;
    private String remoteEntryFileName;
    private Boolean bustRemoteEntryCache;
    private String pluginEntry;
    private ObjectName objectName = null;
    private MBeanServer mBeanServer = null;

    public void init() {
        try {
            if (this.objectName == null) {
                this.objectName = this.getObjectName();
            }
            if (this.mBeanServer == null) {
                this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
            }
            if (this.mBeanServer.isRegistered(this.objectName)) {
                LOG.info("Unregistering existing plugin: {}", (Object)this.objectName);
                this.mBeanServer.unregisterMBean(this.objectName);
            }
            LOG.debug("Registering plugin: {}", (Object)this.objectName);
            this.mBeanServer.registerMBean(this, this.objectName);
        }
        catch (Throwable t) {
            LOG.error("Failed to register plugin:", t);
        }
    }

    public void destroy() {
        try {
            if (this.mBeanServer != null) {
                LOG.debug("Unregistering plugin: {}", (Object)this.objectName);
                this.mBeanServer.unregisterMBean(this.objectName);
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to register plugin:", t);
        }
    }

    public HawtioPlugin url(String url) {
        this.url = url;
        return this;
    }

    public HawtioPlugin scope(String scope) {
        this.scope = scope;
        return this;
    }

    public HawtioPlugin module(String module) {
        this.module = module;
        return this;
    }

    public HawtioPlugin remoteEntryFileName(String remoteEntryFileName) {
        this.remoteEntryFileName = remoteEntryFileName;
        return this;
    }

    public HawtioPlugin bustRemoteEntryCache(Boolean bustRemoteEntryCache) {
        this.bustRemoteEntryCache = bustRemoteEntryCache;
        return this;
    }

    public HawtioPlugin pluginEntry(String pluginEntry) {
        this.pluginEntry = pluginEntry;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public String getRemoteEntryFileName() {
        return this.remoteEntryFileName;
    }

    @Override
    public Boolean getBustRemoteEntryCache() {
        return this.bustRemoteEntryCache;
    }

    @Override
    public String getPluginEntry() {
        return this.pluginEntry;
    }

    protected ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName("hawtio:type=plugin,name=" + this.getScope());
    }
}

