/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.log.support;

import io.hawt.log.LogEvent;
import io.hawt.log.LogFilter;
import io.hawt.log.support.LogQuerySupport;
import io.hawt.log.support.Objects;
import io.hawt.log.support.Predicate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public abstract class LogQueryBase
extends LogQuerySupport {
    protected Predicate<LogEvent> createPredicate(LogFilter filter) {
        String matchesText;
        Long after;
        Long before;
        if (filter == null) {
            return null;
        }
        final ArrayList<Predicate<LogEvent>> predicates = new ArrayList<Predicate<LogEvent>>();
        Set<String> levels = filter.getLevelsSet();
        if (levels.size() > 0) {
            predicates.add(e -> e.getLevel() != null && levels.contains(e.getLevel()));
        }
        if ((before = filter.getBeforeTimestamp()) != null) {
            Date date = new Date(before);
            predicates.add(e -> e.getTimestamp() != null && e.getTimestamp().before(date));
        }
        if ((after = filter.getAfterTimestamp()) != null) {
            Date date = new Date(after);
            predicates.add(e -> e.getTimestamp() != null && e.getTimestamp().after(date));
        }
        if ((matchesText = filter.getMatchesText()) != null && matchesText.length() > 0) {
            predicates.add(e -> this.matches((LogEvent)e, matchesText));
        }
        if (predicates.isEmpty()) {
            return null;
        }
        if (predicates.size() == 1) {
            return (Predicate)predicates.get(0);
        }
        return new Predicate<LogEvent>(){

            public String toString() {
                return "AndPredicate" + predicates;
            }

            @Override
            public boolean matches(LogEvent event) {
                return predicates.stream().allMatch(p -> p.matches(event));
            }
        };
    }

    private boolean matches(LogEvent event, String text) {
        if (Objects.contains(text, event.getClassName(), event.getMessage(), event.getLogger(), event.getThread())) {
            return true;
        }
        String[] throwableStrRep = event.getException();
        if (throwableStrRep != null && Objects.contains(text, throwableStrRep)) {
            return true;
        }
        Map<String, String> properties = event.getProperties();
        return properties != null && Objects.contains(text, properties.toString());
    }
}

