/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.log.log4j;

import io.hawt.log.LogEvent;
import io.hawt.log.LogFilter;
import io.hawt.log.LogResults;
import io.hawt.log.log4j.Log4jLogQueryMBean;
import io.hawt.log.log4j.MavenCoordHelper;
import io.hawt.log.log4j.ThrowableFormatter;
import io.hawt.log.support.LogQuerySupport;
import io.hawt.log.support.LruList;
import io.hawt.log.support.Objects;
import io.hawt.log.support.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4jLogQuery
extends LogQuerySupport
implements Log4jLogQueryMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(Log4jLogQuery.class);
    private int size = 2000;
    private LruList<LoggingEvent> events;
    private boolean addMavenCoordinates = false;
    private Properties properties = new Properties();
    private final Appender appender = new AppenderSkeleton(){

        protected void append(LoggingEvent loggingEvent) {
            Log4jLogQuery.this.logMessage(loggingEvent);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return true;
        }
    };

    @Override
    public void start() {
        super.start();
        this.reconnectAppender();
    }

    @Override
    public void reconnectAppender() {
        org.apache.log4j.Logger root;
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        boolean added = false;
        if (loggerFactory instanceof AppenderAttachable) {
            AppenderAttachable appenderAttachable = (AppenderAttachable)loggerFactory;
            this.appender.setName("LogQuery");
            appenderAttachable.addAppender(this.appender);
            LOG.info("Connected to Log4j appender to trap logs with hawtio log plugin");
            added = true;
        }
        if ((root = LogManager.getRootLogger()) != null) {
            this.appender.setName("LogQuery");
            root.addAppender(this.appender);
            LOG.info("Connected to Log4j appender to trap logs with hawtio log plugin");
            added = true;
        }
        if (!added) {
            LOG.warn("No ILoggerFactory or RootLogger found so cannot attach hatwio log appender!");
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public LogResults getLogResults(int maxCount) throws IOException {
        return this.filterLogResults(null, maxCount);
    }

    @Override
    public LogResults queryLogResults(LogFilter filter) {
        Predicate<LogEvent> predicate = this.createPredicate(filter);
        int maxCount = -1;
        if (filter != null) {
            maxCount = filter.getCount();
        }
        return this.filterLogResults(predicate, maxCount);
    }

    private Predicate<LogEvent> createPredicate(LogFilter filter) {
        String matchesText;
        Long after;
        Long before;
        if (filter == null) {
            return null;
        }
        final ArrayList<Predicate<LogEvent>> predicates = new ArrayList<Predicate<LogEvent>>();
        final Set<String> levels = filter.getLevelsSet();
        if (levels.size() > 0) {
            predicates.add(new Predicate<LogEvent>(){

                @Override
                public boolean matches(LogEvent event) {
                    String level = event.getLevel();
                    return level != null && levels.contains(level.toString());
                }
            });
        }
        if ((before = filter.getBeforeTimestamp()) != null) {
            final Date date = new Date(before);
            predicates.add(new Predicate<LogEvent>(){

                @Override
                public boolean matches(LogEvent event) {
                    Date time = event.getTimestamp();
                    return time != null && time.before(date);
                }
            });
        }
        if ((after = filter.getAfterTimestamp()) != null) {
            final Date date = new Date(after);
            predicates.add(new Predicate<LogEvent>(){

                @Override
                public boolean matches(LogEvent event) {
                    Date time = event.getTimestamp();
                    return time != null && time.after(date);
                }
            });
        }
        if ((matchesText = filter.getMatchesText()) != null && matchesText.length() > 0) {
            predicates.add(new Predicate<LogEvent>(){

                @Override
                public boolean matches(LogEvent event) {
                    if (Objects.contains(matchesText, event.getClassName(), event.getMessage(), event.getLogger(), event.getThread())) {
                        return true;
                    }
                    String[] throwableStrRep = event.getException();
                    if (throwableStrRep != null && Objects.contains(matchesText, throwableStrRep)) {
                        return true;
                    }
                    Map<String, String> properties = event.getProperties();
                    return properties != null && Objects.contains(matchesText, properties.toString());
                }
            });
        }
        if (predicates.size() == 0) {
            return null;
        }
        if (predicates.size() == 1) {
            return (Predicate)predicates.get(0);
        }
        return new Predicate<LogEvent>(){

            public String toString() {
                return "AndPredicate" + predicates;
            }

            @Override
            public boolean matches(LogEvent event) {
                for (Predicate predicate : predicates) {
                    if (predicate.matches(event)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    protected LogResults filterLogResults(Predicate<LogEvent> predicate, int maxCount) {
        int matched = 0;
        long from = Long.MAX_VALUE;
        long to = Long.MIN_VALUE;
        ArrayList<LogEvent> list = new ArrayList<LogEvent>();
        Iterable<LoggingEvent> elements = this.getEvents().getElements();
        for (LoggingEvent element : elements) {
            LogEvent logEvent = this.toLogEvent(element);
            long timestamp = element.getTimeStamp();
            if (timestamp > to) {
                to = timestamp;
            }
            if (timestamp < from) {
                from = timestamp;
            }
            if (logEvent == null || predicate != null && !predicate.matches(logEvent)) continue;
            list.add(logEvent);
            if (maxCount <= 0 || ++matched < maxCount) continue;
            break;
        }
        LogResults results = new LogResults();
        results.setEvents(list);
        if (from < Long.MAX_VALUE) {
            results.setFromTimestamp(from);
        }
        if (to > Long.MIN_VALUE) {
            results.setToTimestamp(to);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested " + maxCount + " logging items. returning " + results.getEvents().size() + " event(s) from a possible " + this.getEvents().size());
        }
        return results;
    }

    protected LogEvent toLogEvent(LoggingEvent element) {
        Level level;
        LocationInfo locationInformation;
        LogEvent answer = new LogEvent();
        answer.setClassName(element.getFQNOfLoggerClass());
        ThrowableInformation throwableInformation = element.getThrowableInformation();
        if (throwableInformation != null) {
            ThrowableFormatter renderer = new ThrowableFormatter();
            String[] stack = renderer.doRender(throwableInformation.getThrowable());
            if (stack == null) {
                stack = element.getThrowableStrRep();
            }
            answer.setException(stack);
        }
        if ((locationInformation = element.getLocationInformation()) != null) {
            answer.setFileName(locationInformation.getFileName());
            answer.setClassName(locationInformation.getClassName());
            answer.setMethodName(locationInformation.getMethodName());
            answer.setLineNumber(locationInformation.getLineNumber());
        }
        if ((level = element.getLevel()) != null) {
            answer.setLevel(level.toString());
        }
        answer.setLogger(element.getLoggerName());
        Category logger = element.getLogger();
        Object message = element.getMessage();
        if (message != null) {
            answer.setMessage(message.toString());
        }
        answer.setProperties(element.getProperties());
        answer.setSeq(element.getTimeStamp());
        answer.setTimestamp(new Date(element.getTimeStamp()));
        answer.setThread(element.getThreadName());
        answer.setHost(this.getHostName());
        return answer;
    }

    protected String filterLogEvents(LogFilter filter) throws IOException {
        return null;
    }

    protected void appendMavenCoordinates(LoggingEvent loggingEvent) {
        String coordinates;
        LocationInfo information = loggingEvent.getLocationInformation();
        if (information != null && (coordinates = MavenCoordHelper.getMavenCoordinates(information.getClassName())) != null) {
            loggingEvent.setProperty("maven.coordinates", coordinates);
        }
    }

    @Override
    protected String loadCoords(String coords, String filePath, String classifier) throws IOException {
        String[] split = coords.split("/");
        if (split != null && split.length > 2) {
            String groupId = split[0];
            String artifactId = split[1];
            String string = split[2];
        }
        return null;
    }

    protected Properties getDefaultProperties() {
        Properties defaultProperties = new Properties();
        defaultProperties.setProperty("org.ops4j.pax.url.mvn.repositories", "http://repo1.maven.org/maven2@id=maven.central.repo, https://repo.fusesource.com/nexus/content/repositories/releases@id=fusesource.release.repo, https://repo.fusesource.com/nexus/content/groups/ea@id=fusesource.ea.repo, http://svn.apache.org/repos/asf/servicemix/m2-repo@id=servicemix.repo, http://repository.springsource.com/maven/bundles/release@id=springsource.release.repo, http://repository.springsource.com/maven/bundles/external@id=springsource.external.repo, https://oss.sonatype.org/content/groups/scala-tools@id=scala.repo");
        return defaultProperties;
    }

    public LruList<LoggingEvent> getEvents() {
        if (this.events == null) {
            this.events = new LruList<LoggingEvent>(LoggingEvent.class, this.getSize());
        }
        return this.events;
    }

    public void setEvents(LruList<LoggingEvent> events) {
        this.events = events;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isAddMavenCoordinates() {
        return this.addMavenCoordinates;
    }

    public void setAddMavenCoordinates(boolean addMavenCoordinates) {
        this.addMavenCoordinates = addMavenCoordinates;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void logMessage(LoggingEvent record) {
        if (this.addMavenCoordinates) {
            this.appendMavenCoordinates(record);
        }
        this.getEvents().add(record);
    }
}

