/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.log.logback;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.AppenderAttachable;
import io.hawt.log.LogEvent;
import io.hawt.log.LogFilter;
import io.hawt.log.LogResults;
import io.hawt.log.logback.LogbackLogQueryMBean;
import io.hawt.log.logback.LoggingEventMapper;
import io.hawt.log.support.LogQueryBase;
import io.hawt.log.support.LruList;
import io.hawt.log.support.Predicate;
import java.util.ArrayList;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackLogQuery
extends LogQueryBase
implements LogbackLogQueryMBean {
    private static final Logger LOG = LoggerFactory.getLogger(LogbackLogQuery.class);
    private static final String APPENDER_NAME = "LogQuery";
    private int size = 2000;
    private LruList<LoggingEvent> events;
    private final Appender<LoggingEvent> appender = new HawtioAppender();
    private final LoggingEventMapper eventMapper = new LoggingEventMapper(this.getHostName());

    public void start() {
        super.start();
        this.appender.start();
        this.reconnectAppender();
    }

    @Override
    public void reconnectAppender() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        Logger root = loggerFactory.getLogger("ROOT");
        if (root instanceof AppenderAttachable) {
            this.appender.setContext((Context)loggerFactory);
            AppenderAttachable attachable = (AppenderAttachable)root;
            attachable.addAppender(this.appender);
            LOG.info("Connected to Logback appender to trap logs with Hawtio log plugin");
        } else {
            LOG.warn("No appender-attachable root logger found so cannot attach Hawtio log appender!");
        }
    }

    @Override
    public void logMessage(LoggingEvent record) {
        this.getEvents().add((Object)record);
    }

    public LogResults getLogResults(int count) {
        return this.filterLogResults(null, count);
    }

    public LogResults queryLogResults(LogFilter filter) {
        Predicate predicate = this.createPredicate(filter);
        int count = filter == null ? -1 : filter.getCount();
        return this.filterLogResults((Predicate<LogEvent>)predicate, count);
    }

    protected LogResults filterLogResults(Predicate<LogEvent> predicate, int maxCount) {
        int matched = 0;
        long from = Long.MAX_VALUE;
        long to = Long.MIN_VALUE;
        ArrayList<LogEvent> list = new ArrayList<LogEvent>();
        Iterable elements = this.getEvents().getElements();
        for (LoggingEvent element : elements) {
            LogEvent logEvent = this.eventMapper.toLogEvent(element);
            long timestamp = element.getTimeStamp();
            if (timestamp > to) {
                to = timestamp;
            }
            if (timestamp < from) {
                from = timestamp;
            }
            if (predicate != null && !predicate.matches((Object)logEvent)) continue;
            list.add(logEvent);
            if (maxCount <= 0 || ++matched < maxCount) continue;
            break;
        }
        LogResults results = new LogResults();
        results.setEvents(list);
        if (from < Long.MAX_VALUE) {
            results.setFromTimestamp(Long.valueOf(from));
        }
        if (to > Long.MIN_VALUE) {
            results.setToTimestamp(Long.valueOf(to));
        }
        LOG.debug("Requested {} logging items, returning {} event(s) from possible {}", new Object[]{maxCount, results.getEvents().size(), this.getEvents().size()});
        return results;
    }

    public LruList<LoggingEvent> getEvents() {
        if (this.events == null) {
            this.events = new LruList(LoggingEvent.class, this.getSize());
        }
        return this.events;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    private class HawtioAppender
    extends AppenderBase<LoggingEvent> {
        public HawtioAppender() {
            this.setName(LogbackLogQuery.APPENDER_NAME);
        }

        protected void append(LoggingEvent event) {
            LogbackLogQuery.this.logMessage(event);
        }
    }
}

