/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.log.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import io.hawt.log.LogEvent;
import io.hawt.log.support.ThrowableFormatter;
import java.util.Date;

public class LoggingEventMapper {
    private final String hostName;

    public LoggingEventMapper(String hostName) {
        this.hostName = hostName;
    }

    public LogEvent toLogEvent(LoggingEvent loggingEvent) {
        Level level;
        StackTraceElement[] callerData;
        ThrowableFormatter formatter;
        String[] stack;
        LogEvent answer = new LogEvent();
        answer.setClassName(loggingEvent.getLoggerName());
        ThrowableProxy throwable = (ThrowableProxy)loggingEvent.getThrowableProxy();
        if (throwable != null && (stack = (formatter = new ThrowableFormatter()).doRender(throwable.getThrowable())) != null) {
            answer.setException(stack);
        }
        if ((callerData = loggingEvent.getCallerData()) != null && callerData.length > 0) {
            StackTraceElement ste = callerData[0];
            answer.setFileName(ste.getFileName());
            answer.setClassName(ste.getClassName());
            answer.setMethodName(ste.getMethodName());
            answer.setLineNumber(String.valueOf(ste.getLineNumber()));
        }
        if ((level = loggingEvent.getLevel()) != null) {
            answer.setLevel(level.toString());
        }
        answer.setLogger(loggingEvent.getLoggerName());
        String message = loggingEvent.getFormattedMessage();
        if (message != null) {
            answer.setMessage(message);
        }
        answer.setProperties(loggingEvent.getMDCPropertyMap());
        answer.setSeq(Long.valueOf(loggingEvent.getTimeStamp()));
        answer.setTimestamp(new Date(loggingEvent.getTimeStamp()));
        answer.setThread(loggingEvent.getThreadName());
        answer.setHost(this.hostName);
        return answer;
    }
}

