/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.example.spring.boot;

import io.hawt.example.spring.boot.PropertyFileLoginModule;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.security.RolePrincipal;
import org.eclipse.jetty.security.UserPrincipal;
import org.eclipse.jetty.security.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileLoginModule
extends AbstractLoginModule {
    public static final String DEFAULT_FILENAME = "realm.properties";
    private static final Logger LOG = LoggerFactory.getLogger(PropertyFileLoginModule.class);
    private static final ConcurrentHashMap<String, PropertyUserStore> PROPERTY_USERSTORES = new ConcurrentHashMap();
    private boolean hotReload = false;
    private String filename = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.setupPropertyUserStore(options);
    }

    private void setupPropertyUserStore(Map<String, ?> options) {
        this.parseConfig(options);
        if (PROPERTY_USERSTORES.get(this.filename) == null) {
            PropertyUserStore propertyUserStore = new PropertyUserStore();
            ResourceFactory resourceFactory = ResourceFactory.of((Container)propertyUserStore);
            Resource config = resourceFactory.newResource(this.filename);
            propertyUserStore.setConfig(config);
            propertyUserStore.setHotReload(this.hotReload);
            PropertyUserStore prev = PROPERTY_USERSTORES.putIfAbsent(this.filename, propertyUserStore);
            if (prev == null) {
                LOG.info("setupPropertyUserStore: Starting new PropertyUserStore. PropertiesFile: " + this.filename + " hotReload: " + this.hotReload);
                try {
                    propertyUserStore.start();
                }
                catch (Exception e) {
                    LOG.warn("Exception while starting propertyUserStore: ", (Throwable)e);
                }
            }
        }
    }

    private void parseConfig(Map<String, ?> options) {
        String tmp = (String)options.get("file");
        this.filename = tmp == null ? DEFAULT_FILENAME : tmp;
        this.filename = System.getProperty("login.file", this.filename);
        tmp = (String)options.get("hotReload");
        this.hotReload = tmp == null ? this.hotReload : Boolean.parseBoolean(tmp);
    }

    public AbstractLoginModule.JAASUser getUser(String userName) throws Exception {
        PropertyUserStore propertyUserStore = (PropertyUserStore)PROPERTY_USERSTORES.get(this.filename);
        if (propertyUserStore == null) {
            throw new IllegalStateException("PropertyUserStore should never be null here!");
        }
        LOG.warn("Checking PropertyUserStore " + this.filename + " for " + userName);
        UserPrincipal userPrincipal = propertyUserStore.getUserPrincipal(userName);
        List rolePrincipals = propertyUserStore.getRolePrincipals(userName);
        if (userPrincipal == null || rolePrincipals == null) {
            LOG.warn("User principal is null");
            return null;
        }
        List roles = rolePrincipals.stream().map(RolePrincipal::getName).collect(Collectors.toList());
        LOG.warn("roles " + userPrincipal.getName() + " " + roles.toString());
        return new HawtioJAASUser(this, userPrincipal, roles);
    }

    public boolean logout() {
        return true;
    }
}

