/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.trust;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.re2j.Pattern;
import io.grpc.internal.SpiffeUtil;
import io.grpc.xds.internal.security.trust.CertificateUtils;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.matcher.v3.RegexMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.matcher.v3.StringMatcher;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

final class XdsX509TrustManager
extends X509ExtendedTrustManager
implements X509TrustManager {
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_URI_NAME = 6;
    private static final int ALT_IPA_NAME = 7;
    private final X509ExtendedTrustManager delegate;
    private final Map<String, X509ExtendedTrustManager> spiffeTrustMapDelegates;
    private final CertificateValidationContext certContext;
    private final boolean autoSniSanValidation;

    XdsX509TrustManager(@Nullable CertificateValidationContext certContext, X509ExtendedTrustManager delegate, boolean autoSniSanValidation) {
        Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.certContext = certContext;
        this.delegate = delegate;
        this.spiffeTrustMapDelegates = null;
        this.autoSniSanValidation = autoSniSanValidation;
    }

    XdsX509TrustManager(@Nullable CertificateValidationContext certContext, Map<String, X509ExtendedTrustManager> spiffeTrustMapDelegates, boolean autoSniSanValidation) {
        Preconditions.checkNotNull(spiffeTrustMapDelegates, (Object)"spiffeTrustMapDelegates");
        this.spiffeTrustMapDelegates = ImmutableMap.copyOf(spiffeTrustMapDelegates);
        this.certContext = certContext;
        this.delegate = null;
        this.autoSniSanValidation = autoSniSanValidation;
    }

    private static boolean verifyDnsNameInPattern(String altNameFromCert, StringMatcher sanToVerifyMatcher) {
        if (Strings.isNullOrEmpty((String)altNameFromCert)) {
            return false;
        }
        switch (sanToVerifyMatcher.getMatchPatternCase()) {
            case EXACT: {
                return XdsX509TrustManager.verifyDnsNameExact(altNameFromCert, sanToVerifyMatcher.getExact(), sanToVerifyMatcher.getIgnoreCase());
            }
            case PREFIX: {
                return XdsX509TrustManager.verifyDnsNamePrefix(altNameFromCert, sanToVerifyMatcher.getPrefix(), sanToVerifyMatcher.getIgnoreCase());
            }
            case SUFFIX: {
                return XdsX509TrustManager.verifyDnsNameSuffix(altNameFromCert, sanToVerifyMatcher.getSuffix(), sanToVerifyMatcher.getIgnoreCase());
            }
            case CONTAINS: {
                return XdsX509TrustManager.verifyDnsNameContains(altNameFromCert, sanToVerifyMatcher.getContains(), sanToVerifyMatcher.getIgnoreCase());
            }
            case SAFE_REGEX: {
                return XdsX509TrustManager.verifyDnsNameSafeRegex(altNameFromCert, sanToVerifyMatcher.getSafeRegex());
            }
        }
        throw new IllegalArgumentException("Unknown match-pattern-case " + (Object)((Object)sanToVerifyMatcher.getMatchPatternCase()));
    }

    private static boolean verifyDnsNameSafeRegex(String altNameFromCert, RegexMatcher sanToVerifySafeRegex) {
        Pattern safeRegExMatch = Pattern.compile((String)sanToVerifySafeRegex.getRegex());
        return safeRegExMatch.matches(altNameFromCert);
    }

    private static boolean verifyDnsNamePrefix(String altNameFromCert, String sanToVerifyPrefix, boolean ignoreCase) {
        if (Strings.isNullOrEmpty((String)sanToVerifyPrefix)) {
            return false;
        }
        return ignoreCase ? altNameFromCert.toLowerCase(Locale.ROOT).startsWith(sanToVerifyPrefix.toLowerCase(Locale.ROOT)) : altNameFromCert.startsWith(sanToVerifyPrefix);
    }

    private static boolean verifyDnsNameSuffix(String altNameFromCert, String sanToVerifySuffix, boolean ignoreCase) {
        if (Strings.isNullOrEmpty((String)sanToVerifySuffix)) {
            return false;
        }
        return ignoreCase ? altNameFromCert.toLowerCase(Locale.ROOT).endsWith(sanToVerifySuffix.toLowerCase(Locale.ROOT)) : altNameFromCert.endsWith(sanToVerifySuffix);
    }

    private static boolean verifyDnsNameContains(String altNameFromCert, String sanToVerifySubstring, boolean ignoreCase) {
        if (Strings.isNullOrEmpty((String)sanToVerifySubstring)) {
            return false;
        }
        return ignoreCase ? altNameFromCert.toLowerCase(Locale.ROOT).contains(sanToVerifySubstring.toLowerCase(Locale.ROOT)) : altNameFromCert.contains(sanToVerifySubstring);
    }

    private static boolean verifyDnsNameExact(String altNameFromCert, String sanToVerifyExact, boolean ignoreCase) {
        if (Strings.isNullOrEmpty((String)sanToVerifyExact)) {
            return false;
        }
        if (sanToVerifyExact.contains("*")) {
            return XdsX509TrustManager.verifyDnsNameWildcard(altNameFromCert, sanToVerifyExact, ignoreCase);
        }
        return ignoreCase ? sanToVerifyExact.equalsIgnoreCase(altNameFromCert) : sanToVerifyExact.equals(altNameFromCert);
    }

    private static boolean verifyDnsNameInSanList(String altNameFromCert, List<StringMatcher> verifySanList) {
        for (StringMatcher verifySan : verifySanList) {
            if (!XdsX509TrustManager.verifyDnsNameInPattern(altNameFromCert, verifySan)) continue;
            return true;
        }
        return false;
    }

    private static boolean verifyOneSanInList(List<?> entry, List<StringMatcher> verifySanList) throws CertificateParsingException {
        if (entry == null || entry.size() < 2) {
            throw new CertificateParsingException("Invalid SAN entry");
        }
        Integer altNameType = (Integer)entry.get(0);
        if (altNameType == null) {
            throw new CertificateParsingException("Invalid SAN entry: null altNameType");
        }
        switch (altNameType) {
            case 2: 
            case 6: 
            case 7: {
                return XdsX509TrustManager.verifyDnsNameInSanList((String)entry.get(1), verifySanList);
            }
        }
        return false;
    }

    private static void verifySubjectAltNameInLeaf(X509Certificate cert, List<StringMatcher> verifyList) throws CertificateException {
        Collection<List<?>> names = cert.getSubjectAlternativeNames();
        if (names == null || names.isEmpty()) {
            throw new CertificateException("Peer certificate SAN check failed");
        }
        for (List<?> name : names) {
            if (!XdsX509TrustManager.verifyOneSanInList(name, verifyList)) continue;
            return;
        }
        throw new CertificateException("Peer certificate SAN check failed");
    }

    @VisibleForTesting
    void verifySubjectAltNameInChain(X509Certificate[] peerCertChain, List<StringMatcher> verifyList) throws CertificateException {
        if (this.certContext == null) {
            return;
        }
        if (verifyList.isEmpty()) {
            return;
        }
        if (peerCertChain == null || peerCertChain.length < 1) {
            throw new CertificateException("Peer certificate(s) missing");
        }
        XdsX509TrustManager.verifySubjectAltNameInLeaf(peerCertChain[0], verifyList);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.chooseDelegate(chain).checkClientTrusted(chain, authType, socket);
        this.verifySubjectAltNameInChain(chain, this.certContext != null ? this.certContext.getMatchSubjectAltNamesList() : new ArrayList());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.chooseDelegate(chain).checkClientTrusted(chain, authType, sslEngine);
        this.verifySubjectAltNameInChain(chain, this.certContext != null ? this.certContext.getMatchSubjectAltNamesList() : new ArrayList());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.chooseDelegate(chain).checkClientTrusted(chain, authType);
        this.verifySubjectAltNameInChain(chain, this.certContext != null ? this.certContext.getMatchSubjectAltNamesList() : new ArrayList());
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        List<StringMatcher> sniMatchers = null;
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLParameters sslParams = sslSocket.getSSLParameters();
            if (sslParams != null) {
                sslParams.setEndpointIdentificationAlgorithm("");
                sslSocket.setSSLParameters(sslParams);
            }
            sniMatchers = this.getAutoSniSanMatchers(sslParams);
        }
        if (sniMatchers.isEmpty() && this.certContext != null) {
            List<StringMatcher> sniMatchersTmp = this.certContext.getMatchSubjectAltNamesList();
            sniMatchers = sniMatchersTmp;
        }
        this.chooseDelegate(chain).checkServerTrusted(chain, authType, socket);
        this.verifySubjectAltNameInChain(chain, sniMatchers);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        List<StringMatcher> sniMatchers = null;
        SSLParameters sslParams = sslEngine.getSSLParameters();
        if (sslParams != null) {
            sslParams.setEndpointIdentificationAlgorithm("");
            sslEngine.setSSLParameters(sslParams);
            sniMatchers = this.getAutoSniSanMatchers(sslParams);
        }
        if (sniMatchers.isEmpty() && this.certContext != null) {
            List<StringMatcher> sniMatchersTmp = this.certContext.getMatchSubjectAltNamesList();
            sniMatchers = sniMatchersTmp;
        }
        this.chooseDelegate(chain).checkServerTrusted(chain, authType, sslEngine);
        this.verifySubjectAltNameInChain(chain, sniMatchers);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.chooseDelegate(chain).checkServerTrusted(chain, authType);
        this.verifySubjectAltNameInChain(chain, this.certContext != null ? this.certContext.getMatchSubjectAltNamesList() : new ArrayList());
    }

    private List<StringMatcher> getAutoSniSanMatchers(SSLParameters sslParams) {
        List<SNIServerName> serverNames;
        ArrayList<StringMatcher> sniNamesToMatch = new ArrayList<StringMatcher>();
        if (CertificateUtils.isXdsSniEnabled && this.autoSniSanValidation && (serverNames = sslParams.getServerNames()) != null) {
            for (SNIServerName serverName : serverNames) {
                if (!(serverName instanceof SNIHostName)) continue;
                SNIHostName sniHostName = (SNIHostName)serverName;
                String hostName = sniHostName.getAsciiName();
                sniNamesToMatch.add(StringMatcher.newBuilder().setExact(hostName).build());
            }
        }
        return sniNamesToMatch;
    }

    private X509ExtendedTrustManager chooseDelegate(X509Certificate[] chain) throws CertificateException {
        if (this.spiffeTrustMapDelegates != null) {
            Optional spiffeId = SpiffeUtil.extractSpiffeId((X509Certificate[])chain);
            if (!spiffeId.isPresent()) {
                throw new CertificateException("Failed to extract SPIFFE ID from peer leaf certificate");
            }
            String trustDomain = ((SpiffeUtil.SpiffeId)spiffeId.get()).getTrustDomain();
            if (!this.spiffeTrustMapDelegates.containsKey(trustDomain)) {
                throw new CertificateException(String.format("Spiffe Trust Map doesn't contain trust domain '%s' from peer leaf certificate", trustDomain));
            }
            return this.spiffeTrustMapDelegates.get(trustDomain);
        }
        return this.delegate;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.spiffeTrustMapDelegates != null) {
            HashSet<X509Certificate> result = new HashSet<X509Certificate>();
            for (X509ExtendedTrustManager tm : this.spiffeTrustMapDelegates.values()) {
                result.addAll(Arrays.asList(tm.getAcceptedIssuers()));
            }
            return result.toArray(new X509Certificate[0]);
        }
        return this.delegate.getAcceptedIssuers();
    }

    private static boolean verifyDnsNameWildcard(String altNameFromCert, String sanToVerify, boolean ignoreCase) {
        String[] splitPattern = XdsX509TrustManager.splitAtFirstDelimiter(ignoreCase ? sanToVerify.toLowerCase(Locale.ROOT) : sanToVerify);
        String[] splitDnsName = XdsX509TrustManager.splitAtFirstDelimiter(ignoreCase ? altNameFromCert.toLowerCase(Locale.ROOT) : altNameFromCert);
        if (splitPattern == null || splitDnsName == null) {
            return false;
        }
        if (splitDnsName[0].startsWith("xn--")) {
            return false;
        }
        if (splitPattern[0].contains("*") && !splitPattern[1].contains("*") && !splitPattern[0].startsWith("xn--")) {
            return splitDnsName[1].equals(splitPattern[1]) && XdsX509TrustManager.labelWildcardMatch(splitDnsName[0], splitPattern[0]);
        }
        return false;
    }

    private static boolean labelWildcardMatch(String dnsLabel, String pattern) {
        int glob = 42;
        if (pattern.equals("*")) {
            return !dnsLabel.isEmpty();
        }
        int globIndex = pattern.indexOf(42);
        if (pattern.indexOf(42, globIndex + 1) == -1) {
            return dnsLabel.length() >= pattern.length() - 1 && dnsLabel.startsWith(pattern.substring(0, globIndex)) && dnsLabel.endsWith(pattern.substring(globIndex + 1));
        }
        return false;
    }

    @Nullable
    private static String[] splitAtFirstDelimiter(String s) {
        int index = s.indexOf(46);
        if (index == -1) {
            return null;
        }
        return new String[]{s.substring(0, index), s.substring(index + 1)};
    }
}

