/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.certprovider;

import io.grpc.internal.CertificateUtils;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.internal.security.certprovider.CertProviderSslContextProvider;
import io.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import io.grpc.xds.internal.security.trust.XdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

final class CertProviderClientSslContextProvider
extends CertProviderSslContextProvider {
    CertProviderClientSslContextProvider(Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext, CertificateProviderStore certificateProviderStore) {
        super(node, certProviders, certInstance, rootCertInstance, staticCertValidationContext, upstreamTlsContext, certificateProviderStore);
    }

    @Override
    protected final AbstractMap.SimpleImmutableEntry<SslContextBuilder, X509TrustManager> getSslContextBuilderAndTrustManager(CertificateValidationContext certificateValidationContext) throws CertStoreException {
        XdsTrustManagerFactory trustManagerFactory;
        SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
        if (this.savedSpiffeTrustMap != null) {
            sslContextBuilder = sslContextBuilder.trustManager((TrustManagerFactory)((Object)new XdsTrustManagerFactory(this.savedSpiffeTrustMap, certificateValidationContext, this.autoSniSanValidationDoesNotApply ? false : ((EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext).getAutoSniSanValidation())));
        } else if (this.savedTrustedRoots != null) {
            sslContextBuilder = sslContextBuilder.trustManager((TrustManagerFactory)((Object)new XdsTrustManagerFactory(this.savedTrustedRoots.toArray(new X509Certificate[0]), certificateValidationContext, this.autoSniSanValidationDoesNotApply ? false : ((EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext).getAutoSniSanValidation())));
        } else {
            throw new IllegalStateException("There must be trusted roots or a SPIFFE trust map");
        }
        if (this.savedSpiffeTrustMap != null) {
            trustManagerFactory = new XdsTrustManagerFactory(this.savedSpiffeTrustMap, certificateValidationContext, ((EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext).getAutoSniSanValidation());
            sslContextBuilder = sslContextBuilder.trustManager((TrustManagerFactory)((Object)trustManagerFactory));
        } else {
            trustManagerFactory = new XdsTrustManagerFactory(this.savedTrustedRoots.toArray(new X509Certificate[0]), certificateValidationContext, ((EnvoyServerProtoData.UpstreamTlsContext)this.tlsContext).getAutoSniSanValidation());
            sslContextBuilder = sslContextBuilder.trustManager((TrustManagerFactory)((Object)trustManagerFactory));
        }
        if (this.isMtls()) {
            sslContextBuilder.keyManager(this.savedKey, (Iterable)this.savedCertChain);
        }
        return new AbstractMap.SimpleImmutableEntry<SslContextBuilder, X509TrustManager>(sslContextBuilder, CertificateUtils.getX509ExtendedTrustManager(Arrays.asList(trustManagerFactory.getTrustManagers())));
    }
}

