// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/config/route/v3/route_components.proto

package io.envoyproxy.envoy.config.route.v3;

/**
 * <pre>
 * The top level element in the routing configuration is a virtual host. Each virtual host has
 * a logical name as well as a set of domains that get routed to it based on the incoming request's
 * host header. This allows a single listener to service multiple top level domain path trees. Once
 * a virtual host is selected based on the domain, the routes are processed in order to see which
 * upstream cluster to route to or whether to perform a redirect.
 * [#next-free-field: 24]
 * </pre>
 *
 * Protobuf type {@code envoy.config.route.v3.VirtualHost}
 */
public final class VirtualHost extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.config.route.v3.VirtualHost)
    VirtualHostOrBuilder {
private static final long serialVersionUID = 0L;
  // Use VirtualHost.newBuilder() to construct.
  private VirtualHost(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private VirtualHost() {
    name_ = "";
    domains_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    routes_ = java.util.Collections.emptyList();
    requireTls_ = 0;
    virtualClusters_ = java.util.Collections.emptyList();
    rateLimits_ = java.util.Collections.emptyList();
    requestHeadersToAdd_ = java.util.Collections.emptyList();
    requestHeadersToRemove_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    responseHeadersToAdd_ = java.util.Collections.emptyList();
    responseHeadersToRemove_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    requestMirrorPolicies_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new VirtualHost();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.config.route.v3.RouteComponentsProto.internal_static_envoy_config_route_v3_VirtualHost_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 15:
        return internalGetTypedPerFilterConfig();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.config.route.v3.RouteComponentsProto.internal_static_envoy_config_route_v3_VirtualHost_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.config.route.v3.VirtualHost.class, io.envoyproxy.envoy.config.route.v3.VirtualHost.Builder.class);
  }

  /**
   * Protobuf enum {@code envoy.config.route.v3.VirtualHost.TlsRequirementType}
   */
  public enum TlsRequirementType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * No TLS requirement for the virtual host.
     * </pre>
     *
     * <code>NONE = 0;</code>
     */
    NONE(0),
    /**
     * <pre>
     * External requests must use TLS. If a request is external and it is not
     * using TLS, a 301 redirect will be sent telling the client to use HTTPS.
     * </pre>
     *
     * <code>EXTERNAL_ONLY = 1;</code>
     */
    EXTERNAL_ONLY(1),
    /**
     * <pre>
     * All requests must use TLS. If a request is not using TLS, a 301 redirect
     * will be sent telling the client to use HTTPS.
     * </pre>
     *
     * <code>ALL = 2;</code>
     */
    ALL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * No TLS requirement for the virtual host.
     * </pre>
     *
     * <code>NONE = 0;</code>
     */
    public static final int NONE_VALUE = 0;
    /**
     * <pre>
     * External requests must use TLS. If a request is external and it is not
     * using TLS, a 301 redirect will be sent telling the client to use HTTPS.
     * </pre>
     *
     * <code>EXTERNAL_ONLY = 1;</code>
     */
    public static final int EXTERNAL_ONLY_VALUE = 1;
    /**
     * <pre>
     * All requests must use TLS. If a request is not using TLS, a 301 redirect
     * will be sent telling the client to use HTTPS.
     * </pre>
     *
     * <code>ALL = 2;</code>
     */
    public static final int ALL_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TlsRequirementType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TlsRequirementType forNumber(int value) {
      switch (value) {
        case 0: return NONE;
        case 1: return EXTERNAL_ONLY;
        case 2: return ALL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TlsRequirementType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        TlsRequirementType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<TlsRequirementType>() {
            public TlsRequirementType findValueByNumber(int number) {
              return TlsRequirementType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.route.v3.VirtualHost.getDescriptor().getEnumTypes().get(0);
    }

    private static final TlsRequirementType[] VALUES = values();

    public static TlsRequirementType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TlsRequirementType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:envoy.config.route.v3.VirtualHost.TlsRequirementType)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * The logical name of the virtual host. This is used when emitting certain
   * statistics but is not relevant for routing.
   * </pre>
   *
   * <code>string name = 1 [(.validate.rules) = { ... }</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The logical name of the virtual host. This is used when emitting certain
   * statistics but is not relevant for routing.
   * </pre>
   *
   * <code>string name = 1 [(.validate.rules) = { ... }</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOMAINS_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList domains_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * A list of domains (host/authority header) that will be matched to this
   * virtual host. Wildcard hosts are supported in the suffix or prefix form.
   *
   * Domain search order:
   *  1. Exact domain names: ``www.foo.com``.
   *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
   *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
   *  4. Special wildcard ``*`` matching any domain.
   *
   * .. note::
   *
   *   The wildcard will not match the empty string.
   *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
   *   The longest wildcards match first.
   *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
   *   must be unique across all virtual hosts or the config will fail to load.
   *
   * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
   * </pre>
   *
   * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
   * @return A list containing the domains.
   */
  public com.google.protobuf.ProtocolStringList
      getDomainsList() {
    return domains_;
  }
  /**
   * <pre>
   * A list of domains (host/authority header) that will be matched to this
   * virtual host. Wildcard hosts are supported in the suffix or prefix form.
   *
   * Domain search order:
   *  1. Exact domain names: ``www.foo.com``.
   *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
   *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
   *  4. Special wildcard ``*`` matching any domain.
   *
   * .. note::
   *
   *   The wildcard will not match the empty string.
   *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
   *   The longest wildcards match first.
   *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
   *   must be unique across all virtual hosts or the config will fail to load.
   *
   * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
   * </pre>
   *
   * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
   * @return The count of domains.
   */
  public int getDomainsCount() {
    return domains_.size();
  }
  /**
   * <pre>
   * A list of domains (host/authority header) that will be matched to this
   * virtual host. Wildcard hosts are supported in the suffix or prefix form.
   *
   * Domain search order:
   *  1. Exact domain names: ``www.foo.com``.
   *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
   *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
   *  4. Special wildcard ``*`` matching any domain.
   *
   * .. note::
   *
   *   The wildcard will not match the empty string.
   *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
   *   The longest wildcards match first.
   *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
   *   must be unique across all virtual hosts or the config will fail to load.
   *
   * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
   * </pre>
   *
   * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
   * @param index The index of the element to return.
   * @return The domains at the given index.
   */
  public java.lang.String getDomains(int index) {
    return domains_.get(index);
  }
  /**
   * <pre>
   * A list of domains (host/authority header) that will be matched to this
   * virtual host. Wildcard hosts are supported in the suffix or prefix form.
   *
   * Domain search order:
   *  1. Exact domain names: ``www.foo.com``.
   *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
   *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
   *  4. Special wildcard ``*`` matching any domain.
   *
   * .. note::
   *
   *   The wildcard will not match the empty string.
   *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
   *   The longest wildcards match first.
   *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
   *   must be unique across all virtual hosts or the config will fail to load.
   *
   * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
   * </pre>
   *
   * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
   * @param index The index of the value to return.
   * @return The bytes of the domains at the given index.
   */
  public com.google.protobuf.ByteString
      getDomainsBytes(int index) {
    return domains_.getByteString(index);
  }

  public static final int ROUTES_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.config.route.v3.Route> routes_;
  /**
   * <pre>
   * The list of routes that will be matched, in order, for incoming requests.
   * The first route that matches will be used.
   * Only one of this and ``matcher`` can be specified.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.config.route.v3.Route> getRoutesList() {
    return routes_;
  }
  /**
   * <pre>
   * The list of routes that will be matched, in order, for incoming requests.
   * The first route that matches will be used.
   * Only one of this and ``matcher`` can be specified.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.config.route.v3.RouteOrBuilder> 
      getRoutesOrBuilderList() {
    return routes_;
  }
  /**
   * <pre>
   * The list of routes that will be matched, in order, for incoming requests.
   * The first route that matches will be used.
   * Only one of this and ``matcher`` can be specified.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
   */
  @java.lang.Override
  public int getRoutesCount() {
    return routes_.size();
  }
  /**
   * <pre>
   * The list of routes that will be matched, in order, for incoming requests.
   * The first route that matches will be used.
   * Only one of this and ``matcher`` can be specified.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.Route getRoutes(int index) {
    return routes_.get(index);
  }
  /**
   * <pre>
   * The list of routes that will be matched, in order, for incoming requests.
   * The first route that matches will be used.
   * Only one of this and ``matcher`` can be specified.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.RouteOrBuilder getRoutesOrBuilder(
      int index) {
    return routes_.get(index);
  }

  public static final int MATCHER_FIELD_NUMBER = 21;
  private com.github.xds.type.matcher.v3.Matcher matcher_;
  /**
   * <pre>
   * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
   * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
   * can be specified.
   * </pre>
   *
   * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
   * @return Whether the matcher field is set.
   */
  @java.lang.Override
  public boolean hasMatcher() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
   * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
   * can be specified.
   * </pre>
   *
   * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
   * @return The matcher.
   */
  @java.lang.Override
  public com.github.xds.type.matcher.v3.Matcher getMatcher() {
    return matcher_ == null ? com.github.xds.type.matcher.v3.Matcher.getDefaultInstance() : matcher_;
  }
  /**
   * <pre>
   * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
   * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
   * can be specified.
   * </pre>
   *
   * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
   */
  @java.lang.Override
  public com.github.xds.type.matcher.v3.MatcherOrBuilder getMatcherOrBuilder() {
    return matcher_ == null ? com.github.xds.type.matcher.v3.Matcher.getDefaultInstance() : matcher_;
  }

  public static final int REQUIRE_TLS_FIELD_NUMBER = 4;
  private int requireTls_ = 0;
  /**
   * <pre>
   * Specifies the type of TLS enforcement the virtual host expects. If this option is not
   * specified, there is no TLS requirement for the virtual host.
   * </pre>
   *
   * <code>.envoy.config.route.v3.VirtualHost.TlsRequirementType require_tls = 4 [(.validate.rules) = { ... }</code>
   * @return The enum numeric value on the wire for requireTls.
   */
  @java.lang.Override public int getRequireTlsValue() {
    return requireTls_;
  }
  /**
   * <pre>
   * Specifies the type of TLS enforcement the virtual host expects. If this option is not
   * specified, there is no TLS requirement for the virtual host.
   * </pre>
   *
   * <code>.envoy.config.route.v3.VirtualHost.TlsRequirementType require_tls = 4 [(.validate.rules) = { ... }</code>
   * @return The requireTls.
   */
  @java.lang.Override public io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType getRequireTls() {
    io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType result = io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType.forNumber(requireTls_);
    return result == null ? io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType.UNRECOGNIZED : result;
  }

  public static final int VIRTUAL_CLUSTERS_FIELD_NUMBER = 5;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.config.route.v3.VirtualCluster> virtualClusters_;
  /**
   * <pre>
   * A list of virtual clusters defined for this virtual host. Virtual clusters
   * are used for additional statistics gathering.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.config.route.v3.VirtualCluster> getVirtualClustersList() {
    return virtualClusters_;
  }
  /**
   * <pre>
   * A list of virtual clusters defined for this virtual host. Virtual clusters
   * are used for additional statistics gathering.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.config.route.v3.VirtualClusterOrBuilder> 
      getVirtualClustersOrBuilderList() {
    return virtualClusters_;
  }
  /**
   * <pre>
   * A list of virtual clusters defined for this virtual host. Virtual clusters
   * are used for additional statistics gathering.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
   */
  @java.lang.Override
  public int getVirtualClustersCount() {
    return virtualClusters_.size();
  }
  /**
   * <pre>
   * A list of virtual clusters defined for this virtual host. Virtual clusters
   * are used for additional statistics gathering.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.VirtualCluster getVirtualClusters(int index) {
    return virtualClusters_.get(index);
  }
  /**
   * <pre>
   * A list of virtual clusters defined for this virtual host. Virtual clusters
   * are used for additional statistics gathering.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.VirtualClusterOrBuilder getVirtualClustersOrBuilder(
      int index) {
    return virtualClusters_.get(index);
  }

  public static final int RATE_LIMITS_FIELD_NUMBER = 6;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.config.route.v3.RateLimit> rateLimits_;
  /**
   * <pre>
   * Specifies a set of rate limit configurations that will be applied to the
   * virtual host.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.config.route.v3.RateLimit> getRateLimitsList() {
    return rateLimits_;
  }
  /**
   * <pre>
   * Specifies a set of rate limit configurations that will be applied to the
   * virtual host.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.config.route.v3.RateLimitOrBuilder> 
      getRateLimitsOrBuilderList() {
    return rateLimits_;
  }
  /**
   * <pre>
   * Specifies a set of rate limit configurations that will be applied to the
   * virtual host.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
   */
  @java.lang.Override
  public int getRateLimitsCount() {
    return rateLimits_.size();
  }
  /**
   * <pre>
   * Specifies a set of rate limit configurations that will be applied to the
   * virtual host.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.RateLimit getRateLimits(int index) {
    return rateLimits_.get(index);
  }
  /**
   * <pre>
   * Specifies a set of rate limit configurations that will be applied to the
   * virtual host.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.RateLimitOrBuilder getRateLimitsOrBuilder(
      int index) {
    return rateLimits_.get(index);
  }

  public static final int REQUEST_HEADERS_TO_ADD_FIELD_NUMBER = 7;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.config.core.v3.HeaderValueOption> requestHeadersToAdd_;
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be added to each request
   * handled by this virtual host. Headers specified at this level are applied
   * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
   * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
   * details on header value syntax, see the documentation on :ref:`custom request headers
   * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.config.core.v3.HeaderValueOption> getRequestHeadersToAddList() {
    return requestHeadersToAdd_;
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be added to each request
   * handled by this virtual host. Headers specified at this level are applied
   * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
   * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
   * details on header value syntax, see the documentation on :ref:`custom request headers
   * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder> 
      getRequestHeadersToAddOrBuilderList() {
    return requestHeadersToAdd_;
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be added to each request
   * handled by this virtual host. Headers specified at this level are applied
   * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
   * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
   * details on header value syntax, see the documentation on :ref:`custom request headers
   * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public int getRequestHeadersToAddCount() {
    return requestHeadersToAdd_.size();
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be added to each request
   * handled by this virtual host. Headers specified at this level are applied
   * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
   * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
   * details on header value syntax, see the documentation on :ref:`custom request headers
   * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.HeaderValueOption getRequestHeadersToAdd(int index) {
    return requestHeadersToAdd_.get(index);
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be added to each request
   * handled by this virtual host. Headers specified at this level are applied
   * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
   * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
   * details on header value syntax, see the documentation on :ref:`custom request headers
   * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder getRequestHeadersToAddOrBuilder(
      int index) {
    return requestHeadersToAdd_.get(index);
  }

  public static final int REQUEST_HEADERS_TO_REMOVE_FIELD_NUMBER = 13;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList requestHeadersToRemove_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be removed from each request
   * handled by this virtual host.
   * </pre>
   *
   * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
   * @return A list containing the requestHeadersToRemove.
   */
  public com.google.protobuf.ProtocolStringList
      getRequestHeadersToRemoveList() {
    return requestHeadersToRemove_;
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be removed from each request
   * handled by this virtual host.
   * </pre>
   *
   * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
   * @return The count of requestHeadersToRemove.
   */
  public int getRequestHeadersToRemoveCount() {
    return requestHeadersToRemove_.size();
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be removed from each request
   * handled by this virtual host.
   * </pre>
   *
   * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
   * @param index The index of the element to return.
   * @return The requestHeadersToRemove at the given index.
   */
  public java.lang.String getRequestHeadersToRemove(int index) {
    return requestHeadersToRemove_.get(index);
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be removed from each request
   * handled by this virtual host.
   * </pre>
   *
   * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
   * @param index The index of the value to return.
   * @return The bytes of the requestHeadersToRemove at the given index.
   */
  public com.google.protobuf.ByteString
      getRequestHeadersToRemoveBytes(int index) {
    return requestHeadersToRemove_.getByteString(index);
  }

  public static final int RESPONSE_HEADERS_TO_ADD_FIELD_NUMBER = 10;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.config.core.v3.HeaderValueOption> responseHeadersToAdd_;
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be added to each response
   * handled by this virtual host. Headers specified at this level are applied
   * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
   * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
   * details on header value syntax, see the documentation on :ref:`custom request headers
   * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.config.core.v3.HeaderValueOption> getResponseHeadersToAddList() {
    return responseHeadersToAdd_;
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be added to each response
   * handled by this virtual host. Headers specified at this level are applied
   * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
   * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
   * details on header value syntax, see the documentation on :ref:`custom request headers
   * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder> 
      getResponseHeadersToAddOrBuilderList() {
    return responseHeadersToAdd_;
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be added to each response
   * handled by this virtual host. Headers specified at this level are applied
   * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
   * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
   * details on header value syntax, see the documentation on :ref:`custom request headers
   * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public int getResponseHeadersToAddCount() {
    return responseHeadersToAdd_.size();
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be added to each response
   * handled by this virtual host. Headers specified at this level are applied
   * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
   * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
   * details on header value syntax, see the documentation on :ref:`custom request headers
   * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.HeaderValueOption getResponseHeadersToAdd(int index) {
    return responseHeadersToAdd_.get(index);
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be added to each response
   * handled by this virtual host. Headers specified at this level are applied
   * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
   * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
   * details on header value syntax, see the documentation on :ref:`custom request headers
   * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
   * </pre>
   *
   * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder getResponseHeadersToAddOrBuilder(
      int index) {
    return responseHeadersToAdd_.get(index);
  }

  public static final int RESPONSE_HEADERS_TO_REMOVE_FIELD_NUMBER = 11;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList responseHeadersToRemove_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be removed from each response
   * handled by this virtual host.
   * </pre>
   *
   * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
   * @return A list containing the responseHeadersToRemove.
   */
  public com.google.protobuf.ProtocolStringList
      getResponseHeadersToRemoveList() {
    return responseHeadersToRemove_;
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be removed from each response
   * handled by this virtual host.
   * </pre>
   *
   * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
   * @return The count of responseHeadersToRemove.
   */
  public int getResponseHeadersToRemoveCount() {
    return responseHeadersToRemove_.size();
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be removed from each response
   * handled by this virtual host.
   * </pre>
   *
   * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
   * @param index The index of the element to return.
   * @return The responseHeadersToRemove at the given index.
   */
  public java.lang.String getResponseHeadersToRemove(int index) {
    return responseHeadersToRemove_.get(index);
  }
  /**
   * <pre>
   * Specifies a list of HTTP headers that should be removed from each response
   * handled by this virtual host.
   * </pre>
   *
   * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
   * @param index The index of the value to return.
   * @return The bytes of the responseHeadersToRemove at the given index.
   */
  public com.google.protobuf.ByteString
      getResponseHeadersToRemoveBytes(int index) {
    return responseHeadersToRemove_.getByteString(index);
  }

  public static final int CORS_FIELD_NUMBER = 8;
  private io.envoyproxy.envoy.config.route.v3.CorsPolicy cors_;
  /**
   * <pre>
   * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
   * found in the
   * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
   *
   * .. attention::
   *
   *   This option has been deprecated. Please use
   *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
   *   to configure the CORS HTTP filter.
   * </pre>
   *
   * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
   * @deprecated envoy.config.route.v3.VirtualHost.cors is deprecated.
   *     See envoy/config/route/v3/route_components.proto;l=153
   * @return Whether the cors field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated public boolean hasCors() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
   * found in the
   * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
   *
   * .. attention::
   *
   *   This option has been deprecated. Please use
   *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
   *   to configure the CORS HTTP filter.
   * </pre>
   *
   * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
   * @deprecated envoy.config.route.v3.VirtualHost.cors is deprecated.
   *     See envoy/config/route/v3/route_components.proto;l=153
   * @return The cors.
   */
  @java.lang.Override
  @java.lang.Deprecated public io.envoyproxy.envoy.config.route.v3.CorsPolicy getCors() {
    return cors_ == null ? io.envoyproxy.envoy.config.route.v3.CorsPolicy.getDefaultInstance() : cors_;
  }
  /**
   * <pre>
   * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
   * found in the
   * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
   *
   * .. attention::
   *
   *   This option has been deprecated. Please use
   *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
   *   to configure the CORS HTTP filter.
   * </pre>
   *
   * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated public io.envoyproxy.envoy.config.route.v3.CorsPolicyOrBuilder getCorsOrBuilder() {
    return cors_ == null ? io.envoyproxy.envoy.config.route.v3.CorsPolicy.getDefaultInstance() : cors_;
  }

  public static final int TYPED_PER_FILTER_CONFIG_FIELD_NUMBER = 15;
  private static final class TypedPerFilterConfigDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, com.google.protobuf.Any> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, com.google.protobuf.Any>newDefaultInstance(
                io.envoyproxy.envoy.config.route.v3.RouteComponentsProto.internal_static_envoy_config_route_v3_VirtualHost_TypedPerFilterConfigEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                com.google.protobuf.Any.getDefaultInstance());
  }
  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
      java.lang.String, com.google.protobuf.Any> typedPerFilterConfig_;
  private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Any>
  internalGetTypedPerFilterConfig() {
    if (typedPerFilterConfig_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          TypedPerFilterConfigDefaultEntryHolder.defaultEntry);
    }
    return typedPerFilterConfig_;
  }
  public int getTypedPerFilterConfigCount() {
    return internalGetTypedPerFilterConfig().getMap().size();
  }
  /**
   * <pre>
   * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
   * The key should match the :ref:`filter config name
   * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
   * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
   * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
   * entry referred by the canonical filter name will be provided to the filters as fallback.
   *
   * Use of this field is filter specific;
   * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
   * [#comment: An entry's value may be wrapped in a
   * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
   * message to specify additional options.]
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
   */
  @java.lang.Override
  public boolean containsTypedPerFilterConfig(
      java.lang.String key) {
    if (key == null) { throw new NullPointerException("map key"); }
    return internalGetTypedPerFilterConfig().getMap().containsKey(key);
  }
  /**
   * Use {@link #getTypedPerFilterConfigMap()} instead.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.protobuf.Any> getTypedPerFilterConfig() {
    return getTypedPerFilterConfigMap();
  }
  /**
   * <pre>
   * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
   * The key should match the :ref:`filter config name
   * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
   * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
   * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
   * entry referred by the canonical filter name will be provided to the filters as fallback.
   *
   * Use of this field is filter specific;
   * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
   * [#comment: An entry's value may be wrapped in a
   * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
   * message to specify additional options.]
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.protobuf.Any> getTypedPerFilterConfigMap() {
    return internalGetTypedPerFilterConfig().getMap();
  }
  /**
   * <pre>
   * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
   * The key should match the :ref:`filter config name
   * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
   * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
   * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
   * entry referred by the canonical filter name will be provided to the filters as fallback.
   *
   * Use of this field is filter specific;
   * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
   * [#comment: An entry's value may be wrapped in a
   * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
   * message to specify additional options.]
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
   */
  @java.lang.Override
  public /* nullable */
com.google.protobuf.Any getTypedPerFilterConfigOrDefault(
      java.lang.String key,
      /* nullable */
com.google.protobuf.Any defaultValue) {
    if (key == null) { throw new NullPointerException("map key"); }
    java.util.Map<java.lang.String, com.google.protobuf.Any> map =
        internalGetTypedPerFilterConfig().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
   * The key should match the :ref:`filter config name
   * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
   * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
   * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
   * entry referred by the canonical filter name will be provided to the filters as fallback.
   *
   * Use of this field is filter specific;
   * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
   * [#comment: An entry's value may be wrapped in a
   * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
   * message to specify additional options.]
   * </pre>
   *
   * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Any getTypedPerFilterConfigOrThrow(
      java.lang.String key) {
    if (key == null) { throw new NullPointerException("map key"); }
    java.util.Map<java.lang.String, com.google.protobuf.Any> map =
        internalGetTypedPerFilterConfig().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int INCLUDE_REQUEST_ATTEMPT_COUNT_FIELD_NUMBER = 14;
  private boolean includeRequestAttemptCount_ = false;
  /**
   * <pre>
   * Decides whether the :ref:`x-envoy-attempt-count
   * &lt;config_http_filters_router_x-envoy-attempt-count&gt;` header should be included
   * in the upstream request. Setting this option will cause it to override any existing header
   * value, so in the case of two Envoys on the request path with this option enabled, the upstream
   * will see the attempt count as perceived by the second Envoy. Defaults to false.
   * This header is unaffected by the
   * :ref:`suppress_envoy_headers
   * &lt;envoy_v3_api_field_extensions.filters.http.router.v3.Router.suppress_envoy_headers&gt;` flag.
   *
   * [#next-major-version: rename to include_attempt_count_in_request.]
   * </pre>
   *
   * <code>bool include_request_attempt_count = 14;</code>
   * @return The includeRequestAttemptCount.
   */
  @java.lang.Override
  public boolean getIncludeRequestAttemptCount() {
    return includeRequestAttemptCount_;
  }

  public static final int INCLUDE_ATTEMPT_COUNT_IN_RESPONSE_FIELD_NUMBER = 19;
  private boolean includeAttemptCountInResponse_ = false;
  /**
   * <pre>
   * Decides whether the :ref:`x-envoy-attempt-count
   * &lt;config_http_filters_router_x-envoy-attempt-count&gt;` header should be included
   * in the downstream response. Setting this option will cause the router to override any existing header
   * value, so in the case of two Envoys on the request path with this option enabled, the downstream
   * will see the attempt count as perceived by the Envoy closest upstream from itself. Defaults to false.
   * This header is unaffected by the
   * :ref:`suppress_envoy_headers
   * &lt;envoy_v3_api_field_extensions.filters.http.router.v3.Router.suppress_envoy_headers&gt;` flag.
   * </pre>
   *
   * <code>bool include_attempt_count_in_response = 19;</code>
   * @return The includeAttemptCountInResponse.
   */
  @java.lang.Override
  public boolean getIncludeAttemptCountInResponse() {
    return includeAttemptCountInResponse_;
  }

  public static final int RETRY_POLICY_FIELD_NUMBER = 16;
  private io.envoyproxy.envoy.config.route.v3.RetryPolicy retryPolicy_;
  /**
   * <pre>
   * Indicates the retry policy for all routes in this virtual host. Note that setting a
   * route level entry will take precedence over this config and it'll be treated
   * independently (e.g.: values are not inherited).
   * </pre>
   *
   * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
   * @return Whether the retryPolicy field is set.
   */
  @java.lang.Override
  public boolean hasRetryPolicy() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Indicates the retry policy for all routes in this virtual host. Note that setting a
   * route level entry will take precedence over this config and it'll be treated
   * independently (e.g.: values are not inherited).
   * </pre>
   *
   * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
   * @return The retryPolicy.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.RetryPolicy getRetryPolicy() {
    return retryPolicy_ == null ? io.envoyproxy.envoy.config.route.v3.RetryPolicy.getDefaultInstance() : retryPolicy_;
  }
  /**
   * <pre>
   * Indicates the retry policy for all routes in this virtual host. Note that setting a
   * route level entry will take precedence over this config and it'll be treated
   * independently (e.g.: values are not inherited).
   * </pre>
   *
   * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.RetryPolicyOrBuilder getRetryPolicyOrBuilder() {
    return retryPolicy_ == null ? io.envoyproxy.envoy.config.route.v3.RetryPolicy.getDefaultInstance() : retryPolicy_;
  }

  public static final int RETRY_POLICY_TYPED_CONFIG_FIELD_NUMBER = 20;
  private com.google.protobuf.Any retryPolicyTypedConfig_;
  /**
   * <pre>
   * [#not-implemented-hide:]
   * Specifies the configuration for retry policy extension. Note that setting a route level entry
   * will take precedence over this config and it'll be treated independently (e.g.: values are not
   * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
   * set if this field is used.
   * </pre>
   *
   * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
   * @return Whether the retryPolicyTypedConfig field is set.
   */
  @java.lang.Override
  public boolean hasRetryPolicyTypedConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * [#not-implemented-hide:]
   * Specifies the configuration for retry policy extension. Note that setting a route level entry
   * will take precedence over this config and it'll be treated independently (e.g.: values are not
   * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
   * set if this field is used.
   * </pre>
   *
   * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
   * @return The retryPolicyTypedConfig.
   */
  @java.lang.Override
  public com.google.protobuf.Any getRetryPolicyTypedConfig() {
    return retryPolicyTypedConfig_ == null ? com.google.protobuf.Any.getDefaultInstance() : retryPolicyTypedConfig_;
  }
  /**
   * <pre>
   * [#not-implemented-hide:]
   * Specifies the configuration for retry policy extension. Note that setting a route level entry
   * will take precedence over this config and it'll be treated independently (e.g.: values are not
   * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
   * set if this field is used.
   * </pre>
   *
   * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
   */
  @java.lang.Override
  public com.google.protobuf.AnyOrBuilder getRetryPolicyTypedConfigOrBuilder() {
    return retryPolicyTypedConfig_ == null ? com.google.protobuf.Any.getDefaultInstance() : retryPolicyTypedConfig_;
  }

  public static final int HEDGE_POLICY_FIELD_NUMBER = 17;
  private io.envoyproxy.envoy.config.route.v3.HedgePolicy hedgePolicy_;
  /**
   * <pre>
   * Indicates the hedge policy for all routes in this virtual host. Note that setting a
   * route level entry will take precedence over this config and it'll be treated
   * independently (e.g.: values are not inherited).
   * </pre>
   *
   * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
   * @return Whether the hedgePolicy field is set.
   */
  @java.lang.Override
  public boolean hasHedgePolicy() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Indicates the hedge policy for all routes in this virtual host. Note that setting a
   * route level entry will take precedence over this config and it'll be treated
   * independently (e.g.: values are not inherited).
   * </pre>
   *
   * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
   * @return The hedgePolicy.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.HedgePolicy getHedgePolicy() {
    return hedgePolicy_ == null ? io.envoyproxy.envoy.config.route.v3.HedgePolicy.getDefaultInstance() : hedgePolicy_;
  }
  /**
   * <pre>
   * Indicates the hedge policy for all routes in this virtual host. Note that setting a
   * route level entry will take precedence over this config and it'll be treated
   * independently (e.g.: values are not inherited).
   * </pre>
   *
   * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.HedgePolicyOrBuilder getHedgePolicyOrBuilder() {
    return hedgePolicy_ == null ? io.envoyproxy.envoy.config.route.v3.HedgePolicy.getDefaultInstance() : hedgePolicy_;
  }

  public static final int INCLUDE_IS_TIMEOUT_RETRY_HEADER_FIELD_NUMBER = 23;
  private boolean includeIsTimeoutRetryHeader_ = false;
  /**
   * <pre>
   * Decides whether to include the :ref:`x-envoy-is-timeout-retry &lt;config_http_filters_router_x-envoy-is-timeout-retry&gt;`
   * request header in retries initiated by per try timeouts.
   * </pre>
   *
   * <code>bool include_is_timeout_retry_header = 23;</code>
   * @return The includeIsTimeoutRetryHeader.
   */
  @java.lang.Override
  public boolean getIncludeIsTimeoutRetryHeader() {
    return includeIsTimeoutRetryHeader_;
  }

  public static final int PER_REQUEST_BUFFER_LIMIT_BYTES_FIELD_NUMBER = 18;
  private com.google.protobuf.UInt32Value perRequestBufferLimitBytes_;
  /**
   * <pre>
   * The maximum bytes which will be buffered for retries and shadowing.
   * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
   * value of this and the listener per_connection_buffer_limit_bytes.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
   * @return Whether the perRequestBufferLimitBytes field is set.
   */
  @java.lang.Override
  public boolean hasPerRequestBufferLimitBytes() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * The maximum bytes which will be buffered for retries and shadowing.
   * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
   * value of this and the listener per_connection_buffer_limit_bytes.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
   * @return The perRequestBufferLimitBytes.
   */
  @java.lang.Override
  public com.google.protobuf.UInt32Value getPerRequestBufferLimitBytes() {
    return perRequestBufferLimitBytes_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : perRequestBufferLimitBytes_;
  }
  /**
   * <pre>
   * The maximum bytes which will be buffered for retries and shadowing.
   * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
   * value of this and the listener per_connection_buffer_limit_bytes.
   * </pre>
   *
   * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
   */
  @java.lang.Override
  public com.google.protobuf.UInt32ValueOrBuilder getPerRequestBufferLimitBytesOrBuilder() {
    return perRequestBufferLimitBytes_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : perRequestBufferLimitBytes_;
  }

  public static final int REQUEST_MIRROR_POLICIES_FIELD_NUMBER = 22;
  @SuppressWarnings("serial")
  private java.util.List<io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy> requestMirrorPolicies_;
  /**
   * <pre>
   * Specify a set of default request mirroring policies for every route under this virtual host.
   * It takes precedence over the route config mirror policy entirely.
   * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
   */
  @java.lang.Override
  public java.util.List<io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy> getRequestMirrorPoliciesList() {
    return requestMirrorPolicies_;
  }
  /**
   * <pre>
   * Specify a set of default request mirroring policies for every route under this virtual host.
   * It takes precedence over the route config mirror policy entirely.
   * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicyOrBuilder> 
      getRequestMirrorPoliciesOrBuilderList() {
    return requestMirrorPolicies_;
  }
  /**
   * <pre>
   * Specify a set of default request mirroring policies for every route under this virtual host.
   * It takes precedence over the route config mirror policy entirely.
   * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
   */
  @java.lang.Override
  public int getRequestMirrorPoliciesCount() {
    return requestMirrorPolicies_.size();
  }
  /**
   * <pre>
   * Specify a set of default request mirroring policies for every route under this virtual host.
   * It takes precedence over the route config mirror policy entirely.
   * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy getRequestMirrorPolicies(int index) {
    return requestMirrorPolicies_.get(index);
  }
  /**
   * <pre>
   * Specify a set of default request mirroring policies for every route under this virtual host.
   * It takes precedence over the route config mirror policy entirely.
   * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
   * </pre>
   *
   * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicyOrBuilder getRequestMirrorPoliciesOrBuilder(
      int index) {
    return requestMirrorPolicies_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    for (int i = 0; i < domains_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, domains_.getRaw(i));
    }
    for (int i = 0; i < routes_.size(); i++) {
      output.writeMessage(3, routes_.get(i));
    }
    if (requireTls_ != io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType.NONE.getNumber()) {
      output.writeEnum(4, requireTls_);
    }
    for (int i = 0; i < virtualClusters_.size(); i++) {
      output.writeMessage(5, virtualClusters_.get(i));
    }
    for (int i = 0; i < rateLimits_.size(); i++) {
      output.writeMessage(6, rateLimits_.get(i));
    }
    for (int i = 0; i < requestHeadersToAdd_.size(); i++) {
      output.writeMessage(7, requestHeadersToAdd_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getCors());
    }
    for (int i = 0; i < responseHeadersToAdd_.size(); i++) {
      output.writeMessage(10, responseHeadersToAdd_.get(i));
    }
    for (int i = 0; i < responseHeadersToRemove_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, responseHeadersToRemove_.getRaw(i));
    }
    for (int i = 0; i < requestHeadersToRemove_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, requestHeadersToRemove_.getRaw(i));
    }
    if (includeRequestAttemptCount_ != false) {
      output.writeBool(14, includeRequestAttemptCount_);
    }
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetTypedPerFilterConfig(),
        TypedPerFilterConfigDefaultEntryHolder.defaultEntry,
        15);
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(16, getRetryPolicy());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(17, getHedgePolicy());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(18, getPerRequestBufferLimitBytes());
    }
    if (includeAttemptCountInResponse_ != false) {
      output.writeBool(19, includeAttemptCountInResponse_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(20, getRetryPolicyTypedConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(21, getMatcher());
    }
    for (int i = 0; i < requestMirrorPolicies_.size(); i++) {
      output.writeMessage(22, requestMirrorPolicies_.get(i));
    }
    if (includeIsTimeoutRetryHeader_ != false) {
      output.writeBool(23, includeIsTimeoutRetryHeader_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < domains_.size(); i++) {
        dataSize += computeStringSizeNoTag(domains_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDomainsList().size();
    }
    for (int i = 0; i < routes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, routes_.get(i));
    }
    if (requireTls_ != io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType.NONE.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, requireTls_);
    }
    for (int i = 0; i < virtualClusters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, virtualClusters_.get(i));
    }
    for (int i = 0; i < rateLimits_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, rateLimits_.get(i));
    }
    for (int i = 0; i < requestHeadersToAdd_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, requestHeadersToAdd_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, getCors());
    }
    for (int i = 0; i < responseHeadersToAdd_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, responseHeadersToAdd_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < responseHeadersToRemove_.size(); i++) {
        dataSize += computeStringSizeNoTag(responseHeadersToRemove_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getResponseHeadersToRemoveList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < requestHeadersToRemove_.size(); i++) {
        dataSize += computeStringSizeNoTag(requestHeadersToRemove_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getRequestHeadersToRemoveList().size();
    }
    if (includeRequestAttemptCount_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(14, includeRequestAttemptCount_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.protobuf.Any> entry
         : internalGetTypedPerFilterConfig().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Any>
      typedPerFilterConfig__ = TypedPerFilterConfigDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(15, typedPerFilterConfig__);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(16, getRetryPolicy());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(17, getHedgePolicy());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(18, getPerRequestBufferLimitBytes());
    }
    if (includeAttemptCountInResponse_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(19, includeAttemptCountInResponse_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(20, getRetryPolicyTypedConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(21, getMatcher());
    }
    for (int i = 0; i < requestMirrorPolicies_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(22, requestMirrorPolicies_.get(i));
    }
    if (includeIsTimeoutRetryHeader_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(23, includeIsTimeoutRetryHeader_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.config.route.v3.VirtualHost)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.config.route.v3.VirtualHost other = (io.envoyproxy.envoy.config.route.v3.VirtualHost) obj;

    if (!getName()
        .equals(other.getName())) return false;
    if (!getDomainsList()
        .equals(other.getDomainsList())) return false;
    if (!getRoutesList()
        .equals(other.getRoutesList())) return false;
    if (hasMatcher() != other.hasMatcher()) return false;
    if (hasMatcher()) {
      if (!getMatcher()
          .equals(other.getMatcher())) return false;
    }
    if (requireTls_ != other.requireTls_) return false;
    if (!getVirtualClustersList()
        .equals(other.getVirtualClustersList())) return false;
    if (!getRateLimitsList()
        .equals(other.getRateLimitsList())) return false;
    if (!getRequestHeadersToAddList()
        .equals(other.getRequestHeadersToAddList())) return false;
    if (!getRequestHeadersToRemoveList()
        .equals(other.getRequestHeadersToRemoveList())) return false;
    if (!getResponseHeadersToAddList()
        .equals(other.getResponseHeadersToAddList())) return false;
    if (!getResponseHeadersToRemoveList()
        .equals(other.getResponseHeadersToRemoveList())) return false;
    if (hasCors() != other.hasCors()) return false;
    if (hasCors()) {
      if (!getCors()
          .equals(other.getCors())) return false;
    }
    if (!internalGetTypedPerFilterConfig().equals(
        other.internalGetTypedPerFilterConfig())) return false;
    if (getIncludeRequestAttemptCount()
        != other.getIncludeRequestAttemptCount()) return false;
    if (getIncludeAttemptCountInResponse()
        != other.getIncludeAttemptCountInResponse()) return false;
    if (hasRetryPolicy() != other.hasRetryPolicy()) return false;
    if (hasRetryPolicy()) {
      if (!getRetryPolicy()
          .equals(other.getRetryPolicy())) return false;
    }
    if (hasRetryPolicyTypedConfig() != other.hasRetryPolicyTypedConfig()) return false;
    if (hasRetryPolicyTypedConfig()) {
      if (!getRetryPolicyTypedConfig()
          .equals(other.getRetryPolicyTypedConfig())) return false;
    }
    if (hasHedgePolicy() != other.hasHedgePolicy()) return false;
    if (hasHedgePolicy()) {
      if (!getHedgePolicy()
          .equals(other.getHedgePolicy())) return false;
    }
    if (getIncludeIsTimeoutRetryHeader()
        != other.getIncludeIsTimeoutRetryHeader()) return false;
    if (hasPerRequestBufferLimitBytes() != other.hasPerRequestBufferLimitBytes()) return false;
    if (hasPerRequestBufferLimitBytes()) {
      if (!getPerRequestBufferLimitBytes()
          .equals(other.getPerRequestBufferLimitBytes())) return false;
    }
    if (!getRequestMirrorPoliciesList()
        .equals(other.getRequestMirrorPoliciesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getDomainsCount() > 0) {
      hash = (37 * hash) + DOMAINS_FIELD_NUMBER;
      hash = (53 * hash) + getDomainsList().hashCode();
    }
    if (getRoutesCount() > 0) {
      hash = (37 * hash) + ROUTES_FIELD_NUMBER;
      hash = (53 * hash) + getRoutesList().hashCode();
    }
    if (hasMatcher()) {
      hash = (37 * hash) + MATCHER_FIELD_NUMBER;
      hash = (53 * hash) + getMatcher().hashCode();
    }
    hash = (37 * hash) + REQUIRE_TLS_FIELD_NUMBER;
    hash = (53 * hash) + requireTls_;
    if (getVirtualClustersCount() > 0) {
      hash = (37 * hash) + VIRTUAL_CLUSTERS_FIELD_NUMBER;
      hash = (53 * hash) + getVirtualClustersList().hashCode();
    }
    if (getRateLimitsCount() > 0) {
      hash = (37 * hash) + RATE_LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getRateLimitsList().hashCode();
    }
    if (getRequestHeadersToAddCount() > 0) {
      hash = (37 * hash) + REQUEST_HEADERS_TO_ADD_FIELD_NUMBER;
      hash = (53 * hash) + getRequestHeadersToAddList().hashCode();
    }
    if (getRequestHeadersToRemoveCount() > 0) {
      hash = (37 * hash) + REQUEST_HEADERS_TO_REMOVE_FIELD_NUMBER;
      hash = (53 * hash) + getRequestHeadersToRemoveList().hashCode();
    }
    if (getResponseHeadersToAddCount() > 0) {
      hash = (37 * hash) + RESPONSE_HEADERS_TO_ADD_FIELD_NUMBER;
      hash = (53 * hash) + getResponseHeadersToAddList().hashCode();
    }
    if (getResponseHeadersToRemoveCount() > 0) {
      hash = (37 * hash) + RESPONSE_HEADERS_TO_REMOVE_FIELD_NUMBER;
      hash = (53 * hash) + getResponseHeadersToRemoveList().hashCode();
    }
    if (hasCors()) {
      hash = (37 * hash) + CORS_FIELD_NUMBER;
      hash = (53 * hash) + getCors().hashCode();
    }
    if (!internalGetTypedPerFilterConfig().getMap().isEmpty()) {
      hash = (37 * hash) + TYPED_PER_FILTER_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTypedPerFilterConfig().hashCode();
    }
    hash = (37 * hash) + INCLUDE_REQUEST_ATTEMPT_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getIncludeRequestAttemptCount());
    hash = (37 * hash) + INCLUDE_ATTEMPT_COUNT_IN_RESPONSE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getIncludeAttemptCountInResponse());
    if (hasRetryPolicy()) {
      hash = (37 * hash) + RETRY_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getRetryPolicy().hashCode();
    }
    if (hasRetryPolicyTypedConfig()) {
      hash = (37 * hash) + RETRY_POLICY_TYPED_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRetryPolicyTypedConfig().hashCode();
    }
    if (hasHedgePolicy()) {
      hash = (37 * hash) + HEDGE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getHedgePolicy().hashCode();
    }
    hash = (37 * hash) + INCLUDE_IS_TIMEOUT_RETRY_HEADER_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getIncludeIsTimeoutRetryHeader());
    if (hasPerRequestBufferLimitBytes()) {
      hash = (37 * hash) + PER_REQUEST_BUFFER_LIMIT_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + getPerRequestBufferLimitBytes().hashCode();
    }
    if (getRequestMirrorPoliciesCount() > 0) {
      hash = (37 * hash) + REQUEST_MIRROR_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getRequestMirrorPoliciesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.route.v3.VirtualHost parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.config.route.v3.VirtualHost prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * The top level element in the routing configuration is a virtual host. Each virtual host has
   * a logical name as well as a set of domains that get routed to it based on the incoming request's
   * host header. This allows a single listener to service multiple top level domain path trees. Once
   * a virtual host is selected based on the domain, the routes are processed in order to see which
   * upstream cluster to route to or whether to perform a redirect.
   * [#next-free-field: 24]
   * </pre>
   *
   * Protobuf type {@code envoy.config.route.v3.VirtualHost}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.config.route.v3.VirtualHost)
      io.envoyproxy.envoy.config.route.v3.VirtualHostOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.route.v3.RouteComponentsProto.internal_static_envoy_config_route_v3_VirtualHost_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 15:
          return internalGetTypedPerFilterConfig();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 15:
          return internalGetMutableTypedPerFilterConfig();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.config.route.v3.RouteComponentsProto.internal_static_envoy_config_route_v3_VirtualHost_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.config.route.v3.VirtualHost.class, io.envoyproxy.envoy.config.route.v3.VirtualHost.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.config.route.v3.VirtualHost.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getRoutesFieldBuilder();
        getMatcherFieldBuilder();
        getVirtualClustersFieldBuilder();
        getRateLimitsFieldBuilder();
        getRequestHeadersToAddFieldBuilder();
        getResponseHeadersToAddFieldBuilder();
        getCorsFieldBuilder();
        getRetryPolicyFieldBuilder();
        getRetryPolicyTypedConfigFieldBuilder();
        getHedgePolicyFieldBuilder();
        getPerRequestBufferLimitBytesFieldBuilder();
        getRequestMirrorPoliciesFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      domains_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      if (routesBuilder_ == null) {
        routes_ = java.util.Collections.emptyList();
      } else {
        routes_ = null;
        routesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      matcher_ = null;
      if (matcherBuilder_ != null) {
        matcherBuilder_.dispose();
        matcherBuilder_ = null;
      }
      requireTls_ = 0;
      if (virtualClustersBuilder_ == null) {
        virtualClusters_ = java.util.Collections.emptyList();
      } else {
        virtualClusters_ = null;
        virtualClustersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (rateLimitsBuilder_ == null) {
        rateLimits_ = java.util.Collections.emptyList();
      } else {
        rateLimits_ = null;
        rateLimitsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (requestHeadersToAddBuilder_ == null) {
        requestHeadersToAdd_ = java.util.Collections.emptyList();
      } else {
        requestHeadersToAdd_ = null;
        requestHeadersToAddBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      requestHeadersToRemove_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      if (responseHeadersToAddBuilder_ == null) {
        responseHeadersToAdd_ = java.util.Collections.emptyList();
      } else {
        responseHeadersToAdd_ = null;
        responseHeadersToAddBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      responseHeadersToRemove_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      cors_ = null;
      if (corsBuilder_ != null) {
        corsBuilder_.dispose();
        corsBuilder_ = null;
      }
      internalGetMutableTypedPerFilterConfig().clear();
      includeRequestAttemptCount_ = false;
      includeAttemptCountInResponse_ = false;
      retryPolicy_ = null;
      if (retryPolicyBuilder_ != null) {
        retryPolicyBuilder_.dispose();
        retryPolicyBuilder_ = null;
      }
      retryPolicyTypedConfig_ = null;
      if (retryPolicyTypedConfigBuilder_ != null) {
        retryPolicyTypedConfigBuilder_.dispose();
        retryPolicyTypedConfigBuilder_ = null;
      }
      hedgePolicy_ = null;
      if (hedgePolicyBuilder_ != null) {
        hedgePolicyBuilder_.dispose();
        hedgePolicyBuilder_ = null;
      }
      includeIsTimeoutRetryHeader_ = false;
      perRequestBufferLimitBytes_ = null;
      if (perRequestBufferLimitBytesBuilder_ != null) {
        perRequestBufferLimitBytesBuilder_.dispose();
        perRequestBufferLimitBytesBuilder_ = null;
      }
      if (requestMirrorPoliciesBuilder_ == null) {
        requestMirrorPolicies_ = java.util.Collections.emptyList();
      } else {
        requestMirrorPolicies_ = null;
        requestMirrorPoliciesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00100000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.config.route.v3.RouteComponentsProto.internal_static_envoy_config_route_v3_VirtualHost_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.route.v3.VirtualHost getDefaultInstanceForType() {
      return io.envoyproxy.envoy.config.route.v3.VirtualHost.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.route.v3.VirtualHost build() {
      io.envoyproxy.envoy.config.route.v3.VirtualHost result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.route.v3.VirtualHost buildPartial() {
      io.envoyproxy.envoy.config.route.v3.VirtualHost result = new io.envoyproxy.envoy.config.route.v3.VirtualHost(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(io.envoyproxy.envoy.config.route.v3.VirtualHost result) {
      if (routesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          routes_ = java.util.Collections.unmodifiableList(routes_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.routes_ = routes_;
      } else {
        result.routes_ = routesBuilder_.build();
      }
      if (virtualClustersBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          virtualClusters_ = java.util.Collections.unmodifiableList(virtualClusters_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.virtualClusters_ = virtualClusters_;
      } else {
        result.virtualClusters_ = virtualClustersBuilder_.build();
      }
      if (rateLimitsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          rateLimits_ = java.util.Collections.unmodifiableList(rateLimits_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.rateLimits_ = rateLimits_;
      } else {
        result.rateLimits_ = rateLimitsBuilder_.build();
      }
      if (requestHeadersToAddBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          requestHeadersToAdd_ = java.util.Collections.unmodifiableList(requestHeadersToAdd_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.requestHeadersToAdd_ = requestHeadersToAdd_;
      } else {
        result.requestHeadersToAdd_ = requestHeadersToAddBuilder_.build();
      }
      if (responseHeadersToAddBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          responseHeadersToAdd_ = java.util.Collections.unmodifiableList(responseHeadersToAdd_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.responseHeadersToAdd_ = responseHeadersToAdd_;
      } else {
        result.responseHeadersToAdd_ = responseHeadersToAddBuilder_.build();
      }
      if (requestMirrorPoliciesBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)) {
          requestMirrorPolicies_ = java.util.Collections.unmodifiableList(requestMirrorPolicies_);
          bitField0_ = (bitField0_ & ~0x00100000);
        }
        result.requestMirrorPolicies_ = requestMirrorPolicies_;
      } else {
        result.requestMirrorPolicies_ = requestMirrorPoliciesBuilder_.build();
      }
    }

    private void buildPartial0(io.envoyproxy.envoy.config.route.v3.VirtualHost result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        domains_.makeImmutable();
        result.domains_ = domains_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.matcher_ = matcherBuilder_ == null
            ? matcher_
            : matcherBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.requireTls_ = requireTls_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        requestHeadersToRemove_.makeImmutable();
        result.requestHeadersToRemove_ = requestHeadersToRemove_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        responseHeadersToRemove_.makeImmutable();
        result.responseHeadersToRemove_ = responseHeadersToRemove_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.cors_ = corsBuilder_ == null
            ? cors_
            : corsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.typedPerFilterConfig_ = internalGetTypedPerFilterConfig();
        result.typedPerFilterConfig_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.includeRequestAttemptCount_ = includeRequestAttemptCount_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.includeAttemptCountInResponse_ = includeAttemptCountInResponse_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.retryPolicy_ = retryPolicyBuilder_ == null
            ? retryPolicy_
            : retryPolicyBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.retryPolicyTypedConfig_ = retryPolicyTypedConfigBuilder_ == null
            ? retryPolicyTypedConfig_
            : retryPolicyTypedConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.hedgePolicy_ = hedgePolicyBuilder_ == null
            ? hedgePolicy_
            : hedgePolicyBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.includeIsTimeoutRetryHeader_ = includeIsTimeoutRetryHeader_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.perRequestBufferLimitBytes_ = perRequestBufferLimitBytesBuilder_ == null
            ? perRequestBufferLimitBytes_
            : perRequestBufferLimitBytesBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.config.route.v3.VirtualHost) {
        return mergeFrom((io.envoyproxy.envoy.config.route.v3.VirtualHost)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.config.route.v3.VirtualHost other) {
      if (other == io.envoyproxy.envoy.config.route.v3.VirtualHost.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.domains_.isEmpty()) {
        if (domains_.isEmpty()) {
          domains_ = other.domains_;
          bitField0_ |= 0x00000002;
        } else {
          ensureDomainsIsMutable();
          domains_.addAll(other.domains_);
        }
        onChanged();
      }
      if (routesBuilder_ == null) {
        if (!other.routes_.isEmpty()) {
          if (routes_.isEmpty()) {
            routes_ = other.routes_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRoutesIsMutable();
            routes_.addAll(other.routes_);
          }
          onChanged();
        }
      } else {
        if (!other.routes_.isEmpty()) {
          if (routesBuilder_.isEmpty()) {
            routesBuilder_.dispose();
            routesBuilder_ = null;
            routes_ = other.routes_;
            bitField0_ = (bitField0_ & ~0x00000004);
            routesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getRoutesFieldBuilder() : null;
          } else {
            routesBuilder_.addAllMessages(other.routes_);
          }
        }
      }
      if (other.hasMatcher()) {
        mergeMatcher(other.getMatcher());
      }
      if (other.requireTls_ != 0) {
        setRequireTlsValue(other.getRequireTlsValue());
      }
      if (virtualClustersBuilder_ == null) {
        if (!other.virtualClusters_.isEmpty()) {
          if (virtualClusters_.isEmpty()) {
            virtualClusters_ = other.virtualClusters_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureVirtualClustersIsMutable();
            virtualClusters_.addAll(other.virtualClusters_);
          }
          onChanged();
        }
      } else {
        if (!other.virtualClusters_.isEmpty()) {
          if (virtualClustersBuilder_.isEmpty()) {
            virtualClustersBuilder_.dispose();
            virtualClustersBuilder_ = null;
            virtualClusters_ = other.virtualClusters_;
            bitField0_ = (bitField0_ & ~0x00000020);
            virtualClustersBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getVirtualClustersFieldBuilder() : null;
          } else {
            virtualClustersBuilder_.addAllMessages(other.virtualClusters_);
          }
        }
      }
      if (rateLimitsBuilder_ == null) {
        if (!other.rateLimits_.isEmpty()) {
          if (rateLimits_.isEmpty()) {
            rateLimits_ = other.rateLimits_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureRateLimitsIsMutable();
            rateLimits_.addAll(other.rateLimits_);
          }
          onChanged();
        }
      } else {
        if (!other.rateLimits_.isEmpty()) {
          if (rateLimitsBuilder_.isEmpty()) {
            rateLimitsBuilder_.dispose();
            rateLimitsBuilder_ = null;
            rateLimits_ = other.rateLimits_;
            bitField0_ = (bitField0_ & ~0x00000040);
            rateLimitsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getRateLimitsFieldBuilder() : null;
          } else {
            rateLimitsBuilder_.addAllMessages(other.rateLimits_);
          }
        }
      }
      if (requestHeadersToAddBuilder_ == null) {
        if (!other.requestHeadersToAdd_.isEmpty()) {
          if (requestHeadersToAdd_.isEmpty()) {
            requestHeadersToAdd_ = other.requestHeadersToAdd_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureRequestHeadersToAddIsMutable();
            requestHeadersToAdd_.addAll(other.requestHeadersToAdd_);
          }
          onChanged();
        }
      } else {
        if (!other.requestHeadersToAdd_.isEmpty()) {
          if (requestHeadersToAddBuilder_.isEmpty()) {
            requestHeadersToAddBuilder_.dispose();
            requestHeadersToAddBuilder_ = null;
            requestHeadersToAdd_ = other.requestHeadersToAdd_;
            bitField0_ = (bitField0_ & ~0x00000080);
            requestHeadersToAddBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getRequestHeadersToAddFieldBuilder() : null;
          } else {
            requestHeadersToAddBuilder_.addAllMessages(other.requestHeadersToAdd_);
          }
        }
      }
      if (!other.requestHeadersToRemove_.isEmpty()) {
        if (requestHeadersToRemove_.isEmpty()) {
          requestHeadersToRemove_ = other.requestHeadersToRemove_;
          bitField0_ |= 0x00000100;
        } else {
          ensureRequestHeadersToRemoveIsMutable();
          requestHeadersToRemove_.addAll(other.requestHeadersToRemove_);
        }
        onChanged();
      }
      if (responseHeadersToAddBuilder_ == null) {
        if (!other.responseHeadersToAdd_.isEmpty()) {
          if (responseHeadersToAdd_.isEmpty()) {
            responseHeadersToAdd_ = other.responseHeadersToAdd_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureResponseHeadersToAddIsMutable();
            responseHeadersToAdd_.addAll(other.responseHeadersToAdd_);
          }
          onChanged();
        }
      } else {
        if (!other.responseHeadersToAdd_.isEmpty()) {
          if (responseHeadersToAddBuilder_.isEmpty()) {
            responseHeadersToAddBuilder_.dispose();
            responseHeadersToAddBuilder_ = null;
            responseHeadersToAdd_ = other.responseHeadersToAdd_;
            bitField0_ = (bitField0_ & ~0x00000200);
            responseHeadersToAddBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getResponseHeadersToAddFieldBuilder() : null;
          } else {
            responseHeadersToAddBuilder_.addAllMessages(other.responseHeadersToAdd_);
          }
        }
      }
      if (!other.responseHeadersToRemove_.isEmpty()) {
        if (responseHeadersToRemove_.isEmpty()) {
          responseHeadersToRemove_ = other.responseHeadersToRemove_;
          bitField0_ |= 0x00000400;
        } else {
          ensureResponseHeadersToRemoveIsMutable();
          responseHeadersToRemove_.addAll(other.responseHeadersToRemove_);
        }
        onChanged();
      }
      if (other.hasCors()) {
        mergeCors(other.getCors());
      }
      internalGetMutableTypedPerFilterConfig().mergeFrom(
          other.internalGetTypedPerFilterConfig());
      bitField0_ |= 0x00001000;
      if (other.getIncludeRequestAttemptCount() != false) {
        setIncludeRequestAttemptCount(other.getIncludeRequestAttemptCount());
      }
      if (other.getIncludeAttemptCountInResponse() != false) {
        setIncludeAttemptCountInResponse(other.getIncludeAttemptCountInResponse());
      }
      if (other.hasRetryPolicy()) {
        mergeRetryPolicy(other.getRetryPolicy());
      }
      if (other.hasRetryPolicyTypedConfig()) {
        mergeRetryPolicyTypedConfig(other.getRetryPolicyTypedConfig());
      }
      if (other.hasHedgePolicy()) {
        mergeHedgePolicy(other.getHedgePolicy());
      }
      if (other.getIncludeIsTimeoutRetryHeader() != false) {
        setIncludeIsTimeoutRetryHeader(other.getIncludeIsTimeoutRetryHeader());
      }
      if (other.hasPerRequestBufferLimitBytes()) {
        mergePerRequestBufferLimitBytes(other.getPerRequestBufferLimitBytes());
      }
      if (requestMirrorPoliciesBuilder_ == null) {
        if (!other.requestMirrorPolicies_.isEmpty()) {
          if (requestMirrorPolicies_.isEmpty()) {
            requestMirrorPolicies_ = other.requestMirrorPolicies_;
            bitField0_ = (bitField0_ & ~0x00100000);
          } else {
            ensureRequestMirrorPoliciesIsMutable();
            requestMirrorPolicies_.addAll(other.requestMirrorPolicies_);
          }
          onChanged();
        }
      } else {
        if (!other.requestMirrorPolicies_.isEmpty()) {
          if (requestMirrorPoliciesBuilder_.isEmpty()) {
            requestMirrorPoliciesBuilder_.dispose();
            requestMirrorPoliciesBuilder_ = null;
            requestMirrorPolicies_ = other.requestMirrorPolicies_;
            bitField0_ = (bitField0_ & ~0x00100000);
            requestMirrorPoliciesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getRequestMirrorPoliciesFieldBuilder() : null;
          } else {
            requestMirrorPoliciesBuilder_.addAllMessages(other.requestMirrorPolicies_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              name_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureDomainsIsMutable();
              domains_.add(s);
              break;
            } // case 18
            case 26: {
              io.envoyproxy.envoy.config.route.v3.Route m =
                  input.readMessage(
                      io.envoyproxy.envoy.config.route.v3.Route.parser(),
                      extensionRegistry);
              if (routesBuilder_ == null) {
                ensureRoutesIsMutable();
                routes_.add(m);
              } else {
                routesBuilder_.addMessage(m);
              }
              break;
            } // case 26
            case 32: {
              requireTls_ = input.readEnum();
              bitField0_ |= 0x00000010;
              break;
            } // case 32
            case 42: {
              io.envoyproxy.envoy.config.route.v3.VirtualCluster m =
                  input.readMessage(
                      io.envoyproxy.envoy.config.route.v3.VirtualCluster.parser(),
                      extensionRegistry);
              if (virtualClustersBuilder_ == null) {
                ensureVirtualClustersIsMutable();
                virtualClusters_.add(m);
              } else {
                virtualClustersBuilder_.addMessage(m);
              }
              break;
            } // case 42
            case 50: {
              io.envoyproxy.envoy.config.route.v3.RateLimit m =
                  input.readMessage(
                      io.envoyproxy.envoy.config.route.v3.RateLimit.parser(),
                      extensionRegistry);
              if (rateLimitsBuilder_ == null) {
                ensureRateLimitsIsMutable();
                rateLimits_.add(m);
              } else {
                rateLimitsBuilder_.addMessage(m);
              }
              break;
            } // case 50
            case 58: {
              io.envoyproxy.envoy.config.core.v3.HeaderValueOption m =
                  input.readMessage(
                      io.envoyproxy.envoy.config.core.v3.HeaderValueOption.parser(),
                      extensionRegistry);
              if (requestHeadersToAddBuilder_ == null) {
                ensureRequestHeadersToAddIsMutable();
                requestHeadersToAdd_.add(m);
              } else {
                requestHeadersToAddBuilder_.addMessage(m);
              }
              break;
            } // case 58
            case 66: {
              input.readMessage(
                  getCorsFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000800;
              break;
            } // case 66
            case 82: {
              io.envoyproxy.envoy.config.core.v3.HeaderValueOption m =
                  input.readMessage(
                      io.envoyproxy.envoy.config.core.v3.HeaderValueOption.parser(),
                      extensionRegistry);
              if (responseHeadersToAddBuilder_ == null) {
                ensureResponseHeadersToAddIsMutable();
                responseHeadersToAdd_.add(m);
              } else {
                responseHeadersToAddBuilder_.addMessage(m);
              }
              break;
            } // case 82
            case 90: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureResponseHeadersToRemoveIsMutable();
              responseHeadersToRemove_.add(s);
              break;
            } // case 90
            case 106: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureRequestHeadersToRemoveIsMutable();
              requestHeadersToRemove_.add(s);
              break;
            } // case 106
            case 112: {
              includeRequestAttemptCount_ = input.readBool();
              bitField0_ |= 0x00002000;
              break;
            } // case 112
            case 122: {
              com.google.protobuf.MapEntry<java.lang.String, com.google.protobuf.Any>
              typedPerFilterConfig__ = input.readMessage(
                  TypedPerFilterConfigDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              internalGetMutableTypedPerFilterConfig().getMutableMap().put(
                  typedPerFilterConfig__.getKey(), typedPerFilterConfig__.getValue());
              bitField0_ |= 0x00001000;
              break;
            } // case 122
            case 130: {
              input.readMessage(
                  getRetryPolicyFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00008000;
              break;
            } // case 130
            case 138: {
              input.readMessage(
                  getHedgePolicyFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00020000;
              break;
            } // case 138
            case 146: {
              input.readMessage(
                  getPerRequestBufferLimitBytesFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00080000;
              break;
            } // case 146
            case 152: {
              includeAttemptCountInResponse_ = input.readBool();
              bitField0_ |= 0x00004000;
              break;
            } // case 152
            case 162: {
              input.readMessage(
                  getRetryPolicyTypedConfigFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00010000;
              break;
            } // case 162
            case 170: {
              input.readMessage(
                  getMatcherFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000008;
              break;
            } // case 170
            case 178: {
              io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy m =
                  input.readMessage(
                      io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.parser(),
                      extensionRegistry);
              if (requestMirrorPoliciesBuilder_ == null) {
                ensureRequestMirrorPoliciesIsMutable();
                requestMirrorPolicies_.add(m);
              } else {
                requestMirrorPoliciesBuilder_.addMessage(m);
              }
              break;
            } // case 178
            case 184: {
              includeIsTimeoutRetryHeader_ = input.readBool();
              bitField0_ |= 0x00040000;
              break;
            } // case 184
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * The logical name of the virtual host. This is used when emitting certain
     * statistics but is not relevant for routing.
     * </pre>
     *
     * <code>string name = 1 [(.validate.rules) = { ... }</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The logical name of the virtual host. This is used when emitting certain
     * statistics but is not relevant for routing.
     * </pre>
     *
     * <code>string name = 1 [(.validate.rules) = { ... }</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The logical name of the virtual host. This is used when emitting certain
     * statistics but is not relevant for routing.
     * </pre>
     *
     * <code>string name = 1 [(.validate.rules) = { ... }</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The logical name of the virtual host. This is used when emitting certain
     * statistics but is not relevant for routing.
     * </pre>
     *
     * <code>string name = 1 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The logical name of the virtual host. This is used when emitting certain
     * statistics but is not relevant for routing.
     * </pre>
     *
     * <code>string name = 1 [(.validate.rules) = { ... }</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList domains_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureDomainsIsMutable() {
      if (!domains_.isModifiable()) {
        domains_ = new com.google.protobuf.LazyStringArrayList(domains_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     * <pre>
     * A list of domains (host/authority header) that will be matched to this
     * virtual host. Wildcard hosts are supported in the suffix or prefix form.
     *
     * Domain search order:
     *  1. Exact domain names: ``www.foo.com``.
     *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
     *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
     *  4. Special wildcard ``*`` matching any domain.
     *
     * .. note::
     *
     *   The wildcard will not match the empty string.
     *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
     *   The longest wildcards match first.
     *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
     *   must be unique across all virtual hosts or the config will fail to load.
     *
     * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
     * </pre>
     *
     * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
     * @return A list containing the domains.
     */
    public com.google.protobuf.ProtocolStringList
        getDomainsList() {
      domains_.makeImmutable();
      return domains_;
    }
    /**
     * <pre>
     * A list of domains (host/authority header) that will be matched to this
     * virtual host. Wildcard hosts are supported in the suffix or prefix form.
     *
     * Domain search order:
     *  1. Exact domain names: ``www.foo.com``.
     *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
     *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
     *  4. Special wildcard ``*`` matching any domain.
     *
     * .. note::
     *
     *   The wildcard will not match the empty string.
     *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
     *   The longest wildcards match first.
     *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
     *   must be unique across all virtual hosts or the config will fail to load.
     *
     * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
     * </pre>
     *
     * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
     * @return The count of domains.
     */
    public int getDomainsCount() {
      return domains_.size();
    }
    /**
     * <pre>
     * A list of domains (host/authority header) that will be matched to this
     * virtual host. Wildcard hosts are supported in the suffix or prefix form.
     *
     * Domain search order:
     *  1. Exact domain names: ``www.foo.com``.
     *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
     *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
     *  4. Special wildcard ``*`` matching any domain.
     *
     * .. note::
     *
     *   The wildcard will not match the empty string.
     *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
     *   The longest wildcards match first.
     *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
     *   must be unique across all virtual hosts or the config will fail to load.
     *
     * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
     * </pre>
     *
     * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
     * @param index The index of the element to return.
     * @return The domains at the given index.
     */
    public java.lang.String getDomains(int index) {
      return domains_.get(index);
    }
    /**
     * <pre>
     * A list of domains (host/authority header) that will be matched to this
     * virtual host. Wildcard hosts are supported in the suffix or prefix form.
     *
     * Domain search order:
     *  1. Exact domain names: ``www.foo.com``.
     *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
     *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
     *  4. Special wildcard ``*`` matching any domain.
     *
     * .. note::
     *
     *   The wildcard will not match the empty string.
     *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
     *   The longest wildcards match first.
     *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
     *   must be unique across all virtual hosts or the config will fail to load.
     *
     * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
     * </pre>
     *
     * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
     * @param index The index of the value to return.
     * @return The bytes of the domains at the given index.
     */
    public com.google.protobuf.ByteString
        getDomainsBytes(int index) {
      return domains_.getByteString(index);
    }
    /**
     * <pre>
     * A list of domains (host/authority header) that will be matched to this
     * virtual host. Wildcard hosts are supported in the suffix or prefix form.
     *
     * Domain search order:
     *  1. Exact domain names: ``www.foo.com``.
     *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
     *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
     *  4. Special wildcard ``*`` matching any domain.
     *
     * .. note::
     *
     *   The wildcard will not match the empty string.
     *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
     *   The longest wildcards match first.
     *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
     *   must be unique across all virtual hosts or the config will fail to load.
     *
     * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
     * </pre>
     *
     * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
     * @param index The index to set the value at.
     * @param value The domains to set.
     * @return This builder for chaining.
     */
    public Builder setDomains(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureDomainsIsMutable();
      domains_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of domains (host/authority header) that will be matched to this
     * virtual host. Wildcard hosts are supported in the suffix or prefix form.
     *
     * Domain search order:
     *  1. Exact domain names: ``www.foo.com``.
     *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
     *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
     *  4. Special wildcard ``*`` matching any domain.
     *
     * .. note::
     *
     *   The wildcard will not match the empty string.
     *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
     *   The longest wildcards match first.
     *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
     *   must be unique across all virtual hosts or the config will fail to load.
     *
     * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
     * </pre>
     *
     * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
     * @param value The domains to add.
     * @return This builder for chaining.
     */
    public Builder addDomains(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureDomainsIsMutable();
      domains_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of domains (host/authority header) that will be matched to this
     * virtual host. Wildcard hosts are supported in the suffix or prefix form.
     *
     * Domain search order:
     *  1. Exact domain names: ``www.foo.com``.
     *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
     *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
     *  4. Special wildcard ``*`` matching any domain.
     *
     * .. note::
     *
     *   The wildcard will not match the empty string.
     *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
     *   The longest wildcards match first.
     *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
     *   must be unique across all virtual hosts or the config will fail to load.
     *
     * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
     * </pre>
     *
     * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
     * @param values The domains to add.
     * @return This builder for chaining.
     */
    public Builder addAllDomains(
        java.lang.Iterable<java.lang.String> values) {
      ensureDomainsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, domains_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of domains (host/authority header) that will be matched to this
     * virtual host. Wildcard hosts are supported in the suffix or prefix form.
     *
     * Domain search order:
     *  1. Exact domain names: ``www.foo.com``.
     *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
     *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
     *  4. Special wildcard ``*`` matching any domain.
     *
     * .. note::
     *
     *   The wildcard will not match the empty string.
     *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
     *   The longest wildcards match first.
     *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
     *   must be unique across all virtual hosts or the config will fail to load.
     *
     * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
     * </pre>
     *
     * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearDomains() {
      domains_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * A list of domains (host/authority header) that will be matched to this
     * virtual host. Wildcard hosts are supported in the suffix or prefix form.
     *
     * Domain search order:
     *  1. Exact domain names: ``www.foo.com``.
     *  2. Suffix domain wildcards: ``*.foo.com`` or ``*-bar.foo.com``.
     *  3. Prefix domain wildcards: ``foo.*`` or ``foo-*``.
     *  4. Special wildcard ``*`` matching any domain.
     *
     * .. note::
     *
     *   The wildcard will not match the empty string.
     *   e.g. ``*-bar.foo.com`` will match ``baz-bar.foo.com`` but not ``-bar.foo.com``.
     *   The longest wildcards match first.
     *   Only a single virtual host in the entire route configuration can match on ``*``. A domain
     *   must be unique across all virtual hosts or the config will fail to load.
     *
     * Domains cannot contain control characters. This is validated by the well_known_regex HTTP_HEADER_VALUE.
     * </pre>
     *
     * <code>repeated string domains = 2 [(.validate.rules) = { ... }</code>
     * @param value The bytes of the domains to add.
     * @return This builder for chaining.
     */
    public Builder addDomainsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureDomainsIsMutable();
      domains_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<io.envoyproxy.envoy.config.route.v3.Route> routes_ =
      java.util.Collections.emptyList();
    private void ensureRoutesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        routes_ = new java.util.ArrayList<io.envoyproxy.envoy.config.route.v3.Route>(routes_);
        bitField0_ |= 0x00000004;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.Route, io.envoyproxy.envoy.config.route.v3.Route.Builder, io.envoyproxy.envoy.config.route.v3.RouteOrBuilder> routesBuilder_;

    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.route.v3.Route> getRoutesList() {
      if (routesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(routes_);
      } else {
        return routesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public int getRoutesCount() {
      if (routesBuilder_ == null) {
        return routes_.size();
      } else {
        return routesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.Route getRoutes(int index) {
      if (routesBuilder_ == null) {
        return routes_.get(index);
      } else {
        return routesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public Builder setRoutes(
        int index, io.envoyproxy.envoy.config.route.v3.Route value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.set(index, value);
        onChanged();
      } else {
        routesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public Builder setRoutes(
        int index, io.envoyproxy.envoy.config.route.v3.Route.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.set(index, builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public Builder addRoutes(io.envoyproxy.envoy.config.route.v3.Route value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.add(value);
        onChanged();
      } else {
        routesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public Builder addRoutes(
        int index, io.envoyproxy.envoy.config.route.v3.Route value) {
      if (routesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutesIsMutable();
        routes_.add(index, value);
        onChanged();
      } else {
        routesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public Builder addRoutes(
        io.envoyproxy.envoy.config.route.v3.Route.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.add(builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public Builder addRoutes(
        int index, io.envoyproxy.envoy.config.route.v3.Route.Builder builderForValue) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.add(index, builderForValue.build());
        onChanged();
      } else {
        routesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public Builder addAllRoutes(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.route.v3.Route> values) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, routes_);
        onChanged();
      } else {
        routesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public Builder clearRoutes() {
      if (routesBuilder_ == null) {
        routes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        routesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public Builder removeRoutes(int index) {
      if (routesBuilder_ == null) {
        ensureRoutesIsMutable();
        routes_.remove(index);
        onChanged();
      } else {
        routesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.Route.Builder getRoutesBuilder(
        int index) {
      return getRoutesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RouteOrBuilder getRoutesOrBuilder(
        int index) {
      if (routesBuilder_ == null) {
        return routes_.get(index);  } else {
        return routesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.route.v3.RouteOrBuilder> 
         getRoutesOrBuilderList() {
      if (routesBuilder_ != null) {
        return routesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(routes_);
      }
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.Route.Builder addRoutesBuilder() {
      return getRoutesFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.route.v3.Route.getDefaultInstance());
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.Route.Builder addRoutesBuilder(
        int index) {
      return getRoutesFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.route.v3.Route.getDefaultInstance());
    }
    /**
     * <pre>
     * The list of routes that will be matched, in order, for incoming requests.
     * The first route that matches will be used.
     * Only one of this and ``matcher`` can be specified.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.Route routes = 3;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.route.v3.Route.Builder> 
         getRoutesBuilderList() {
      return getRoutesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.Route, io.envoyproxy.envoy.config.route.v3.Route.Builder, io.envoyproxy.envoy.config.route.v3.RouteOrBuilder> 
        getRoutesFieldBuilder() {
      if (routesBuilder_ == null) {
        routesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.route.v3.Route, io.envoyproxy.envoy.config.route.v3.Route.Builder, io.envoyproxy.envoy.config.route.v3.RouteOrBuilder>(
                routes_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        routes_ = null;
      }
      return routesBuilder_;
    }

    private com.github.xds.type.matcher.v3.Matcher matcher_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.github.xds.type.matcher.v3.Matcher, com.github.xds.type.matcher.v3.Matcher.Builder, com.github.xds.type.matcher.v3.MatcherOrBuilder> matcherBuilder_;
    /**
     * <pre>
     * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
     * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
     * can be specified.
     * </pre>
     *
     * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
     * @return Whether the matcher field is set.
     */
    public boolean hasMatcher() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
     * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
     * can be specified.
     * </pre>
     *
     * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
     * @return The matcher.
     */
    public com.github.xds.type.matcher.v3.Matcher getMatcher() {
      if (matcherBuilder_ == null) {
        return matcher_ == null ? com.github.xds.type.matcher.v3.Matcher.getDefaultInstance() : matcher_;
      } else {
        return matcherBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
     * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
     * can be specified.
     * </pre>
     *
     * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
     */
    public Builder setMatcher(com.github.xds.type.matcher.v3.Matcher value) {
      if (matcherBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        matcher_ = value;
      } else {
        matcherBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
     * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
     * can be specified.
     * </pre>
     *
     * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
     */
    public Builder setMatcher(
        com.github.xds.type.matcher.v3.Matcher.Builder builderForValue) {
      if (matcherBuilder_ == null) {
        matcher_ = builderForValue.build();
      } else {
        matcherBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
     * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
     * can be specified.
     * </pre>
     *
     * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
     */
    public Builder mergeMatcher(com.github.xds.type.matcher.v3.Matcher value) {
      if (matcherBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0) &&
          matcher_ != null &&
          matcher_ != com.github.xds.type.matcher.v3.Matcher.getDefaultInstance()) {
          getMatcherBuilder().mergeFrom(value);
        } else {
          matcher_ = value;
        }
      } else {
        matcherBuilder_.mergeFrom(value);
      }
      if (matcher_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
     * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
     * can be specified.
     * </pre>
     *
     * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
     */
    public Builder clearMatcher() {
      bitField0_ = (bitField0_ & ~0x00000008);
      matcher_ = null;
      if (matcherBuilder_ != null) {
        matcherBuilder_.dispose();
        matcherBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
     * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
     * can be specified.
     * </pre>
     *
     * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
     */
    public com.github.xds.type.matcher.v3.Matcher.Builder getMatcherBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getMatcherFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
     * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
     * can be specified.
     * </pre>
     *
     * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
     */
    public com.github.xds.type.matcher.v3.MatcherOrBuilder getMatcherOrBuilder() {
      if (matcherBuilder_ != null) {
        return matcherBuilder_.getMessageOrBuilder();
      } else {
        return matcher_ == null ?
            com.github.xds.type.matcher.v3.Matcher.getDefaultInstance() : matcher_;
      }
    }
    /**
     * <pre>
     * [#next-major-version: This should be included in a oneof with routes wrapped in a message.]
     * The match tree to use when resolving route actions for incoming requests. Only one of this and ``routes``
     * can be specified.
     * </pre>
     *
     * <code>.xds.type.matcher.v3.Matcher matcher = 21 [(.xds.annotations.v3.field_status) = { ... }</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.github.xds.type.matcher.v3.Matcher, com.github.xds.type.matcher.v3.Matcher.Builder, com.github.xds.type.matcher.v3.MatcherOrBuilder> 
        getMatcherFieldBuilder() {
      if (matcherBuilder_ == null) {
        matcherBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.github.xds.type.matcher.v3.Matcher, com.github.xds.type.matcher.v3.Matcher.Builder, com.github.xds.type.matcher.v3.MatcherOrBuilder>(
                getMatcher(),
                getParentForChildren(),
                isClean());
        matcher_ = null;
      }
      return matcherBuilder_;
    }

    private int requireTls_ = 0;
    /**
     * <pre>
     * Specifies the type of TLS enforcement the virtual host expects. If this option is not
     * specified, there is no TLS requirement for the virtual host.
     * </pre>
     *
     * <code>.envoy.config.route.v3.VirtualHost.TlsRequirementType require_tls = 4 [(.validate.rules) = { ... }</code>
     * @return The enum numeric value on the wire for requireTls.
     */
    @java.lang.Override public int getRequireTlsValue() {
      return requireTls_;
    }
    /**
     * <pre>
     * Specifies the type of TLS enforcement the virtual host expects. If this option is not
     * specified, there is no TLS requirement for the virtual host.
     * </pre>
     *
     * <code>.envoy.config.route.v3.VirtualHost.TlsRequirementType require_tls = 4 [(.validate.rules) = { ... }</code>
     * @param value The enum numeric value on the wire for requireTls to set.
     * @return This builder for chaining.
     */
    public Builder setRequireTlsValue(int value) {
      requireTls_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the type of TLS enforcement the virtual host expects. If this option is not
     * specified, there is no TLS requirement for the virtual host.
     * </pre>
     *
     * <code>.envoy.config.route.v3.VirtualHost.TlsRequirementType require_tls = 4 [(.validate.rules) = { ... }</code>
     * @return The requireTls.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType getRequireTls() {
      io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType result = io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType.forNumber(requireTls_);
      return result == null ? io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies the type of TLS enforcement the virtual host expects. If this option is not
     * specified, there is no TLS requirement for the virtual host.
     * </pre>
     *
     * <code>.envoy.config.route.v3.VirtualHost.TlsRequirementType require_tls = 4 [(.validate.rules) = { ... }</code>
     * @param value The requireTls to set.
     * @return This builder for chaining.
     */
    public Builder setRequireTls(io.envoyproxy.envoy.config.route.v3.VirtualHost.TlsRequirementType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      requireTls_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the type of TLS enforcement the virtual host expects. If this option is not
     * specified, there is no TLS requirement for the virtual host.
     * </pre>
     *
     * <code>.envoy.config.route.v3.VirtualHost.TlsRequirementType require_tls = 4 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearRequireTls() {
      bitField0_ = (bitField0_ & ~0x00000010);
      requireTls_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<io.envoyproxy.envoy.config.route.v3.VirtualCluster> virtualClusters_ =
      java.util.Collections.emptyList();
    private void ensureVirtualClustersIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        virtualClusters_ = new java.util.ArrayList<io.envoyproxy.envoy.config.route.v3.VirtualCluster>(virtualClusters_);
        bitField0_ |= 0x00000020;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.VirtualCluster, io.envoyproxy.envoy.config.route.v3.VirtualCluster.Builder, io.envoyproxy.envoy.config.route.v3.VirtualClusterOrBuilder> virtualClustersBuilder_;

    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.route.v3.VirtualCluster> getVirtualClustersList() {
      if (virtualClustersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(virtualClusters_);
      } else {
        return virtualClustersBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public int getVirtualClustersCount() {
      if (virtualClustersBuilder_ == null) {
        return virtualClusters_.size();
      } else {
        return virtualClustersBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.VirtualCluster getVirtualClusters(int index) {
      if (virtualClustersBuilder_ == null) {
        return virtualClusters_.get(index);
      } else {
        return virtualClustersBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public Builder setVirtualClusters(
        int index, io.envoyproxy.envoy.config.route.v3.VirtualCluster value) {
      if (virtualClustersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVirtualClustersIsMutable();
        virtualClusters_.set(index, value);
        onChanged();
      } else {
        virtualClustersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public Builder setVirtualClusters(
        int index, io.envoyproxy.envoy.config.route.v3.VirtualCluster.Builder builderForValue) {
      if (virtualClustersBuilder_ == null) {
        ensureVirtualClustersIsMutable();
        virtualClusters_.set(index, builderForValue.build());
        onChanged();
      } else {
        virtualClustersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public Builder addVirtualClusters(io.envoyproxy.envoy.config.route.v3.VirtualCluster value) {
      if (virtualClustersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVirtualClustersIsMutable();
        virtualClusters_.add(value);
        onChanged();
      } else {
        virtualClustersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public Builder addVirtualClusters(
        int index, io.envoyproxy.envoy.config.route.v3.VirtualCluster value) {
      if (virtualClustersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVirtualClustersIsMutable();
        virtualClusters_.add(index, value);
        onChanged();
      } else {
        virtualClustersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public Builder addVirtualClusters(
        io.envoyproxy.envoy.config.route.v3.VirtualCluster.Builder builderForValue) {
      if (virtualClustersBuilder_ == null) {
        ensureVirtualClustersIsMutable();
        virtualClusters_.add(builderForValue.build());
        onChanged();
      } else {
        virtualClustersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public Builder addVirtualClusters(
        int index, io.envoyproxy.envoy.config.route.v3.VirtualCluster.Builder builderForValue) {
      if (virtualClustersBuilder_ == null) {
        ensureVirtualClustersIsMutable();
        virtualClusters_.add(index, builderForValue.build());
        onChanged();
      } else {
        virtualClustersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public Builder addAllVirtualClusters(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.route.v3.VirtualCluster> values) {
      if (virtualClustersBuilder_ == null) {
        ensureVirtualClustersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, virtualClusters_);
        onChanged();
      } else {
        virtualClustersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public Builder clearVirtualClusters() {
      if (virtualClustersBuilder_ == null) {
        virtualClusters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        virtualClustersBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public Builder removeVirtualClusters(int index) {
      if (virtualClustersBuilder_ == null) {
        ensureVirtualClustersIsMutable();
        virtualClusters_.remove(index);
        onChanged();
      } else {
        virtualClustersBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.VirtualCluster.Builder getVirtualClustersBuilder(
        int index) {
      return getVirtualClustersFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.VirtualClusterOrBuilder getVirtualClustersOrBuilder(
        int index) {
      if (virtualClustersBuilder_ == null) {
        return virtualClusters_.get(index);  } else {
        return virtualClustersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.route.v3.VirtualClusterOrBuilder> 
         getVirtualClustersOrBuilderList() {
      if (virtualClustersBuilder_ != null) {
        return virtualClustersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(virtualClusters_);
      }
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.VirtualCluster.Builder addVirtualClustersBuilder() {
      return getVirtualClustersFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.route.v3.VirtualCluster.getDefaultInstance());
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.VirtualCluster.Builder addVirtualClustersBuilder(
        int index) {
      return getVirtualClustersFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.route.v3.VirtualCluster.getDefaultInstance());
    }
    /**
     * <pre>
     * A list of virtual clusters defined for this virtual host. Virtual clusters
     * are used for additional statistics gathering.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.VirtualCluster virtual_clusters = 5;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.route.v3.VirtualCluster.Builder> 
         getVirtualClustersBuilderList() {
      return getVirtualClustersFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.VirtualCluster, io.envoyproxy.envoy.config.route.v3.VirtualCluster.Builder, io.envoyproxy.envoy.config.route.v3.VirtualClusterOrBuilder> 
        getVirtualClustersFieldBuilder() {
      if (virtualClustersBuilder_ == null) {
        virtualClustersBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.route.v3.VirtualCluster, io.envoyproxy.envoy.config.route.v3.VirtualCluster.Builder, io.envoyproxy.envoy.config.route.v3.VirtualClusterOrBuilder>(
                virtualClusters_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        virtualClusters_ = null;
      }
      return virtualClustersBuilder_;
    }

    private java.util.List<io.envoyproxy.envoy.config.route.v3.RateLimit> rateLimits_ =
      java.util.Collections.emptyList();
    private void ensureRateLimitsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        rateLimits_ = new java.util.ArrayList<io.envoyproxy.envoy.config.route.v3.RateLimit>(rateLimits_);
        bitField0_ |= 0x00000040;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.RateLimit, io.envoyproxy.envoy.config.route.v3.RateLimit.Builder, io.envoyproxy.envoy.config.route.v3.RateLimitOrBuilder> rateLimitsBuilder_;

    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.route.v3.RateLimit> getRateLimitsList() {
      if (rateLimitsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rateLimits_);
      } else {
        return rateLimitsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public int getRateLimitsCount() {
      if (rateLimitsBuilder_ == null) {
        return rateLimits_.size();
      } else {
        return rateLimitsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RateLimit getRateLimits(int index) {
      if (rateLimitsBuilder_ == null) {
        return rateLimits_.get(index);
      } else {
        return rateLimitsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public Builder setRateLimits(
        int index, io.envoyproxy.envoy.config.route.v3.RateLimit value) {
      if (rateLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRateLimitsIsMutable();
        rateLimits_.set(index, value);
        onChanged();
      } else {
        rateLimitsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public Builder setRateLimits(
        int index, io.envoyproxy.envoy.config.route.v3.RateLimit.Builder builderForValue) {
      if (rateLimitsBuilder_ == null) {
        ensureRateLimitsIsMutable();
        rateLimits_.set(index, builderForValue.build());
        onChanged();
      } else {
        rateLimitsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public Builder addRateLimits(io.envoyproxy.envoy.config.route.v3.RateLimit value) {
      if (rateLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRateLimitsIsMutable();
        rateLimits_.add(value);
        onChanged();
      } else {
        rateLimitsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public Builder addRateLimits(
        int index, io.envoyproxy.envoy.config.route.v3.RateLimit value) {
      if (rateLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRateLimitsIsMutable();
        rateLimits_.add(index, value);
        onChanged();
      } else {
        rateLimitsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public Builder addRateLimits(
        io.envoyproxy.envoy.config.route.v3.RateLimit.Builder builderForValue) {
      if (rateLimitsBuilder_ == null) {
        ensureRateLimitsIsMutable();
        rateLimits_.add(builderForValue.build());
        onChanged();
      } else {
        rateLimitsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public Builder addRateLimits(
        int index, io.envoyproxy.envoy.config.route.v3.RateLimit.Builder builderForValue) {
      if (rateLimitsBuilder_ == null) {
        ensureRateLimitsIsMutable();
        rateLimits_.add(index, builderForValue.build());
        onChanged();
      } else {
        rateLimitsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public Builder addAllRateLimits(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.route.v3.RateLimit> values) {
      if (rateLimitsBuilder_ == null) {
        ensureRateLimitsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, rateLimits_);
        onChanged();
      } else {
        rateLimitsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public Builder clearRateLimits() {
      if (rateLimitsBuilder_ == null) {
        rateLimits_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        rateLimitsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public Builder removeRateLimits(int index) {
      if (rateLimitsBuilder_ == null) {
        ensureRateLimitsIsMutable();
        rateLimits_.remove(index);
        onChanged();
      } else {
        rateLimitsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RateLimit.Builder getRateLimitsBuilder(
        int index) {
      return getRateLimitsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RateLimitOrBuilder getRateLimitsOrBuilder(
        int index) {
      if (rateLimitsBuilder_ == null) {
        return rateLimits_.get(index);  } else {
        return rateLimitsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.route.v3.RateLimitOrBuilder> 
         getRateLimitsOrBuilderList() {
      if (rateLimitsBuilder_ != null) {
        return rateLimitsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rateLimits_);
      }
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RateLimit.Builder addRateLimitsBuilder() {
      return getRateLimitsFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.route.v3.RateLimit.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RateLimit.Builder addRateLimitsBuilder(
        int index) {
      return getRateLimitsFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.route.v3.RateLimit.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies a set of rate limit configurations that will be applied to the
     * virtual host.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RateLimit rate_limits = 6;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.route.v3.RateLimit.Builder> 
         getRateLimitsBuilderList() {
      return getRateLimitsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.RateLimit, io.envoyproxy.envoy.config.route.v3.RateLimit.Builder, io.envoyproxy.envoy.config.route.v3.RateLimitOrBuilder> 
        getRateLimitsFieldBuilder() {
      if (rateLimitsBuilder_ == null) {
        rateLimitsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.route.v3.RateLimit, io.envoyproxy.envoy.config.route.v3.RateLimit.Builder, io.envoyproxy.envoy.config.route.v3.RateLimitOrBuilder>(
                rateLimits_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        rateLimits_ = null;
      }
      return rateLimitsBuilder_;
    }

    private java.util.List<io.envoyproxy.envoy.config.core.v3.HeaderValueOption> requestHeadersToAdd_ =
      java.util.Collections.emptyList();
    private void ensureRequestHeadersToAddIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        requestHeadersToAdd_ = new java.util.ArrayList<io.envoyproxy.envoy.config.core.v3.HeaderValueOption>(requestHeadersToAdd_);
        bitField0_ |= 0x00000080;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.HeaderValueOption, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder, io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder> requestHeadersToAddBuilder_;

    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v3.HeaderValueOption> getRequestHeadersToAddList() {
      if (requestHeadersToAddBuilder_ == null) {
        return java.util.Collections.unmodifiableList(requestHeadersToAdd_);
      } else {
        return requestHeadersToAddBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public int getRequestHeadersToAddCount() {
      if (requestHeadersToAddBuilder_ == null) {
        return requestHeadersToAdd_.size();
      } else {
        return requestHeadersToAddBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.core.v3.HeaderValueOption getRequestHeadersToAdd(int index) {
      if (requestHeadersToAddBuilder_ == null) {
        return requestHeadersToAdd_.get(index);
      } else {
        return requestHeadersToAddBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder setRequestHeadersToAdd(
        int index, io.envoyproxy.envoy.config.core.v3.HeaderValueOption value) {
      if (requestHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.set(index, value);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder setRequestHeadersToAdd(
        int index, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder builderForValue) {
      if (requestHeadersToAddBuilder_ == null) {
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.set(index, builderForValue.build());
        onChanged();
      } else {
        requestHeadersToAddBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder addRequestHeadersToAdd(io.envoyproxy.envoy.config.core.v3.HeaderValueOption value) {
      if (requestHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.add(value);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder addRequestHeadersToAdd(
        int index, io.envoyproxy.envoy.config.core.v3.HeaderValueOption value) {
      if (requestHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.add(index, value);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder addRequestHeadersToAdd(
        io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder builderForValue) {
      if (requestHeadersToAddBuilder_ == null) {
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.add(builderForValue.build());
        onChanged();
      } else {
        requestHeadersToAddBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder addRequestHeadersToAdd(
        int index, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder builderForValue) {
      if (requestHeadersToAddBuilder_ == null) {
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.add(index, builderForValue.build());
        onChanged();
      } else {
        requestHeadersToAddBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder addAllRequestHeadersToAdd(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.core.v3.HeaderValueOption> values) {
      if (requestHeadersToAddBuilder_ == null) {
        ensureRequestHeadersToAddIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, requestHeadersToAdd_);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder clearRequestHeadersToAdd() {
      if (requestHeadersToAddBuilder_ == null) {
        requestHeadersToAdd_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public Builder removeRequestHeadersToAdd(int index) {
      if (requestHeadersToAddBuilder_ == null) {
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.remove(index);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder getRequestHeadersToAddBuilder(
        int index) {
      return getRequestHeadersToAddFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder getRequestHeadersToAddOrBuilder(
        int index) {
      if (requestHeadersToAddBuilder_ == null) {
        return requestHeadersToAdd_.get(index);  } else {
        return requestHeadersToAddBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder> 
         getRequestHeadersToAddOrBuilderList() {
      if (requestHeadersToAddBuilder_ != null) {
        return requestHeadersToAddBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(requestHeadersToAdd_);
      }
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder addRequestHeadersToAddBuilder() {
      return getRequestHeadersToAddFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.core.v3.HeaderValueOption.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder addRequestHeadersToAddBuilder(
        int index) {
      return getRequestHeadersToAddFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each request
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption request_headers_to_add = 7 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder> 
         getRequestHeadersToAddBuilderList() {
      return getRequestHeadersToAddFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.HeaderValueOption, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder, io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder> 
        getRequestHeadersToAddFieldBuilder() {
      if (requestHeadersToAddBuilder_ == null) {
        requestHeadersToAddBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v3.HeaderValueOption, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder, io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder>(
                requestHeadersToAdd_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        requestHeadersToAdd_ = null;
      }
      return requestHeadersToAddBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList requestHeadersToRemove_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureRequestHeadersToRemoveIsMutable() {
      if (!requestHeadersToRemove_.isModifiable()) {
        requestHeadersToRemove_ = new com.google.protobuf.LazyStringArrayList(requestHeadersToRemove_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each request
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
     * @return A list containing the requestHeadersToRemove.
     */
    public com.google.protobuf.ProtocolStringList
        getRequestHeadersToRemoveList() {
      requestHeadersToRemove_.makeImmutable();
      return requestHeadersToRemove_;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each request
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
     * @return The count of requestHeadersToRemove.
     */
    public int getRequestHeadersToRemoveCount() {
      return requestHeadersToRemove_.size();
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each request
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
     * @param index The index of the element to return.
     * @return The requestHeadersToRemove at the given index.
     */
    public java.lang.String getRequestHeadersToRemove(int index) {
      return requestHeadersToRemove_.get(index);
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each request
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
     * @param index The index of the value to return.
     * @return The bytes of the requestHeadersToRemove at the given index.
     */
    public com.google.protobuf.ByteString
        getRequestHeadersToRemoveBytes(int index) {
      return requestHeadersToRemove_.getByteString(index);
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each request
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
     * @param index The index to set the value at.
     * @param value The requestHeadersToRemove to set.
     * @return This builder for chaining.
     */
    public Builder setRequestHeadersToRemove(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureRequestHeadersToRemoveIsMutable();
      requestHeadersToRemove_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each request
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
     * @param value The requestHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addRequestHeadersToRemove(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureRequestHeadersToRemoveIsMutable();
      requestHeadersToRemove_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each request
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
     * @param values The requestHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequestHeadersToRemove(
        java.lang.Iterable<java.lang.String> values) {
      ensureRequestHeadersToRemoveIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, requestHeadersToRemove_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each request
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearRequestHeadersToRemove() {
      requestHeadersToRemove_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each request
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 13 [(.validate.rules) = { ... }</code>
     * @param value The bytes of the requestHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addRequestHeadersToRemoveBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureRequestHeadersToRemoveIsMutable();
      requestHeadersToRemove_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.util.List<io.envoyproxy.envoy.config.core.v3.HeaderValueOption> responseHeadersToAdd_ =
      java.util.Collections.emptyList();
    private void ensureResponseHeadersToAddIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        responseHeadersToAdd_ = new java.util.ArrayList<io.envoyproxy.envoy.config.core.v3.HeaderValueOption>(responseHeadersToAdd_);
        bitField0_ |= 0x00000200;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.HeaderValueOption, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder, io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder> responseHeadersToAddBuilder_;

    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v3.HeaderValueOption> getResponseHeadersToAddList() {
      if (responseHeadersToAddBuilder_ == null) {
        return java.util.Collections.unmodifiableList(responseHeadersToAdd_);
      } else {
        return responseHeadersToAddBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public int getResponseHeadersToAddCount() {
      if (responseHeadersToAddBuilder_ == null) {
        return responseHeadersToAdd_.size();
      } else {
        return responseHeadersToAddBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.core.v3.HeaderValueOption getResponseHeadersToAdd(int index) {
      if (responseHeadersToAddBuilder_ == null) {
        return responseHeadersToAdd_.get(index);
      } else {
        return responseHeadersToAddBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public Builder setResponseHeadersToAdd(
        int index, io.envoyproxy.envoy.config.core.v3.HeaderValueOption value) {
      if (responseHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.set(index, value);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public Builder setResponseHeadersToAdd(
        int index, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder builderForValue) {
      if (responseHeadersToAddBuilder_ == null) {
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.set(index, builderForValue.build());
        onChanged();
      } else {
        responseHeadersToAddBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public Builder addResponseHeadersToAdd(io.envoyproxy.envoy.config.core.v3.HeaderValueOption value) {
      if (responseHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.add(value);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public Builder addResponseHeadersToAdd(
        int index, io.envoyproxy.envoy.config.core.v3.HeaderValueOption value) {
      if (responseHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.add(index, value);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public Builder addResponseHeadersToAdd(
        io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder builderForValue) {
      if (responseHeadersToAddBuilder_ == null) {
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.add(builderForValue.build());
        onChanged();
      } else {
        responseHeadersToAddBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public Builder addResponseHeadersToAdd(
        int index, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder builderForValue) {
      if (responseHeadersToAddBuilder_ == null) {
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.add(index, builderForValue.build());
        onChanged();
      } else {
        responseHeadersToAddBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public Builder addAllResponseHeadersToAdd(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.core.v3.HeaderValueOption> values) {
      if (responseHeadersToAddBuilder_ == null) {
        ensureResponseHeadersToAddIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, responseHeadersToAdd_);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public Builder clearResponseHeadersToAdd() {
      if (responseHeadersToAddBuilder_ == null) {
        responseHeadersToAdd_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public Builder removeResponseHeadersToAdd(int index) {
      if (responseHeadersToAddBuilder_ == null) {
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.remove(index);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder getResponseHeadersToAddBuilder(
        int index) {
      return getResponseHeadersToAddFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder getResponseHeadersToAddOrBuilder(
        int index) {
      if (responseHeadersToAddBuilder_ == null) {
        return responseHeadersToAdd_.get(index);  } else {
        return responseHeadersToAddBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder> 
         getResponseHeadersToAddOrBuilderList() {
      if (responseHeadersToAddBuilder_ != null) {
        return responseHeadersToAddBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(responseHeadersToAdd_);
      }
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder addResponseHeadersToAddBuilder() {
      return getResponseHeadersToAddFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.core.v3.HeaderValueOption.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder addResponseHeadersToAddBuilder(
        int index) {
      return getResponseHeadersToAddFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be added to each response
     * handled by this virtual host. Headers specified at this level are applied
     * after headers from enclosed :ref:`envoy_v3_api_msg_config.route.v3.Route` and before headers from the
     * enclosing :ref:`envoy_v3_api_msg_config.route.v3.RouteConfiguration`. For more information, including
     * details on header value syntax, see the documentation on :ref:`custom request headers
     * &lt;config_http_conn_man_headers_custom_request_headers&gt;`.
     * </pre>
     *
     * <code>repeated .envoy.config.core.v3.HeaderValueOption response_headers_to_add = 10 [(.validate.rules) = { ... }</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder> 
         getResponseHeadersToAddBuilderList() {
      return getResponseHeadersToAddFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.HeaderValueOption, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder, io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder> 
        getResponseHeadersToAddFieldBuilder() {
      if (responseHeadersToAddBuilder_ == null) {
        responseHeadersToAddBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v3.HeaderValueOption, io.envoyproxy.envoy.config.core.v3.HeaderValueOption.Builder, io.envoyproxy.envoy.config.core.v3.HeaderValueOptionOrBuilder>(
                responseHeadersToAdd_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        responseHeadersToAdd_ = null;
      }
      return responseHeadersToAddBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList responseHeadersToRemove_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureResponseHeadersToRemoveIsMutable() {
      if (!responseHeadersToRemove_.isModifiable()) {
        responseHeadersToRemove_ = new com.google.protobuf.LazyStringArrayList(responseHeadersToRemove_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each response
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
     * @return A list containing the responseHeadersToRemove.
     */
    public com.google.protobuf.ProtocolStringList
        getResponseHeadersToRemoveList() {
      responseHeadersToRemove_.makeImmutable();
      return responseHeadersToRemove_;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each response
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
     * @return The count of responseHeadersToRemove.
     */
    public int getResponseHeadersToRemoveCount() {
      return responseHeadersToRemove_.size();
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each response
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
     * @param index The index of the element to return.
     * @return The responseHeadersToRemove at the given index.
     */
    public java.lang.String getResponseHeadersToRemove(int index) {
      return responseHeadersToRemove_.get(index);
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each response
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
     * @param index The index of the value to return.
     * @return The bytes of the responseHeadersToRemove at the given index.
     */
    public com.google.protobuf.ByteString
        getResponseHeadersToRemoveBytes(int index) {
      return responseHeadersToRemove_.getByteString(index);
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each response
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
     * @param index The index to set the value at.
     * @param value The responseHeadersToRemove to set.
     * @return This builder for chaining.
     */
    public Builder setResponseHeadersToRemove(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureResponseHeadersToRemoveIsMutable();
      responseHeadersToRemove_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each response
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
     * @param value The responseHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addResponseHeadersToRemove(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureResponseHeadersToRemoveIsMutable();
      responseHeadersToRemove_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each response
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
     * @param values The responseHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addAllResponseHeadersToRemove(
        java.lang.Iterable<java.lang.String> values) {
      ensureResponseHeadersToRemoveIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, responseHeadersToRemove_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each response
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResponseHeadersToRemove() {
      responseHeadersToRemove_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies a list of HTTP headers that should be removed from each response
     * handled by this virtual host.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 11 [(.validate.rules) = { ... }</code>
     * @param value The bytes of the responseHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addResponseHeadersToRemoveBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureResponseHeadersToRemoveIsMutable();
      responseHeadersToRemove_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private io.envoyproxy.envoy.config.route.v3.CorsPolicy cors_;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.CorsPolicy, io.envoyproxy.envoy.config.route.v3.CorsPolicy.Builder, io.envoyproxy.envoy.config.route.v3.CorsPolicyOrBuilder> corsBuilder_;
    /**
     * <pre>
     * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
     * found in the
     * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
     *
     * .. attention::
     *
     *   This option has been deprecated. Please use
     *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
     *   to configure the CORS HTTP filter.
     * </pre>
     *
     * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
     * @deprecated envoy.config.route.v3.VirtualHost.cors is deprecated.
     *     See envoy/config/route/v3/route_components.proto;l=153
     * @return Whether the cors field is set.
     */
    @java.lang.Deprecated public boolean hasCors() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     * <pre>
     * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
     * found in the
     * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
     *
     * .. attention::
     *
     *   This option has been deprecated. Please use
     *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
     *   to configure the CORS HTTP filter.
     * </pre>
     *
     * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
     * @deprecated envoy.config.route.v3.VirtualHost.cors is deprecated.
     *     See envoy/config/route/v3/route_components.proto;l=153
     * @return The cors.
     */
    @java.lang.Deprecated public io.envoyproxy.envoy.config.route.v3.CorsPolicy getCors() {
      if (corsBuilder_ == null) {
        return cors_ == null ? io.envoyproxy.envoy.config.route.v3.CorsPolicy.getDefaultInstance() : cors_;
      } else {
        return corsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
     * found in the
     * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
     *
     * .. attention::
     *
     *   This option has been deprecated. Please use
     *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
     *   to configure the CORS HTTP filter.
     * </pre>
     *
     * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
     */
    @java.lang.Deprecated public Builder setCors(io.envoyproxy.envoy.config.route.v3.CorsPolicy value) {
      if (corsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cors_ = value;
      } else {
        corsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
     * found in the
     * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
     *
     * .. attention::
     *
     *   This option has been deprecated. Please use
     *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
     *   to configure the CORS HTTP filter.
     * </pre>
     *
     * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
     */
    @java.lang.Deprecated public Builder setCors(
        io.envoyproxy.envoy.config.route.v3.CorsPolicy.Builder builderForValue) {
      if (corsBuilder_ == null) {
        cors_ = builderForValue.build();
      } else {
        corsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
     * found in the
     * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
     *
     * .. attention::
     *
     *   This option has been deprecated. Please use
     *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
     *   to configure the CORS HTTP filter.
     * </pre>
     *
     * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
     */
    @java.lang.Deprecated public Builder mergeCors(io.envoyproxy.envoy.config.route.v3.CorsPolicy value) {
      if (corsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0) &&
          cors_ != null &&
          cors_ != io.envoyproxy.envoy.config.route.v3.CorsPolicy.getDefaultInstance()) {
          getCorsBuilder().mergeFrom(value);
        } else {
          cors_ = value;
        }
      } else {
        corsBuilder_.mergeFrom(value);
      }
      if (cors_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
     * found in the
     * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
     *
     * .. attention::
     *
     *   This option has been deprecated. Please use
     *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
     *   to configure the CORS HTTP filter.
     * </pre>
     *
     * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
     */
    @java.lang.Deprecated public Builder clearCors() {
      bitField0_ = (bitField0_ & ~0x00000800);
      cors_ = null;
      if (corsBuilder_ != null) {
        corsBuilder_.dispose();
        corsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
     * found in the
     * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
     *
     * .. attention::
     *
     *   This option has been deprecated. Please use
     *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
     *   to configure the CORS HTTP filter.
     * </pre>
     *
     * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
     */
    @java.lang.Deprecated public io.envoyproxy.envoy.config.route.v3.CorsPolicy.Builder getCorsBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getCorsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
     * found in the
     * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
     *
     * .. attention::
     *
     *   This option has been deprecated. Please use
     *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
     *   to configure the CORS HTTP filter.
     * </pre>
     *
     * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
     */
    @java.lang.Deprecated public io.envoyproxy.envoy.config.route.v3.CorsPolicyOrBuilder getCorsOrBuilder() {
      if (corsBuilder_ != null) {
        return corsBuilder_.getMessageOrBuilder();
      } else {
        return cors_ == null ?
            io.envoyproxy.envoy.config.route.v3.CorsPolicy.getDefaultInstance() : cors_;
      }
    }
    /**
     * <pre>
     * Indicates that the virtual host has a CORS policy. This field is ignored if related cors policy is
     * found in the
     * :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`.
     *
     * .. attention::
     *
     *   This option has been deprecated. Please use
     *   :ref:`VirtualHost.typed_per_filter_config&lt;envoy_v3_api_field_config.route.v3.VirtualHost.typed_per_filter_config&gt;`
     *   to configure the CORS HTTP filter.
     * </pre>
     *
     * <code>.envoy.config.route.v3.CorsPolicy cors = 8 [deprecated = true, (.envoy.annotations.deprecated_at_minor_version) = "3.0"];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.CorsPolicy, io.envoyproxy.envoy.config.route.v3.CorsPolicy.Builder, io.envoyproxy.envoy.config.route.v3.CorsPolicyOrBuilder> 
        getCorsFieldBuilder() {
      if (corsBuilder_ == null) {
        corsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.config.route.v3.CorsPolicy, io.envoyproxy.envoy.config.route.v3.CorsPolicy.Builder, io.envoyproxy.envoy.config.route.v3.CorsPolicyOrBuilder>(
                getCors(),
                getParentForChildren(),
                isClean());
        cors_ = null;
      }
      return corsBuilder_;
    }

    private com.google.protobuf.MapField<
        java.lang.String, com.google.protobuf.Any> typedPerFilterConfig_;
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Any>
        internalGetTypedPerFilterConfig() {
      if (typedPerFilterConfig_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            TypedPerFilterConfigDefaultEntryHolder.defaultEntry);
      }
      return typedPerFilterConfig_;
    }
    private com.google.protobuf.MapField<java.lang.String, com.google.protobuf.Any>
        internalGetMutableTypedPerFilterConfig() {
      if (typedPerFilterConfig_ == null) {
        typedPerFilterConfig_ = com.google.protobuf.MapField.newMapField(
            TypedPerFilterConfigDefaultEntryHolder.defaultEntry);
      }
      if (!typedPerFilterConfig_.isMutable()) {
        typedPerFilterConfig_ = typedPerFilterConfig_.copy();
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return typedPerFilterConfig_;
    }
    public int getTypedPerFilterConfigCount() {
      return internalGetTypedPerFilterConfig().getMap().size();
    }
    /**
     * <pre>
     * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
     * The key should match the :ref:`filter config name
     * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
     * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
     * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
     * entry referred by the canonical filter name will be provided to the filters as fallback.
     *
     * Use of this field is filter specific;
     * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
     * [#comment: An entry's value may be wrapped in a
     * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
     * message to specify additional options.]
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
     */
    @java.lang.Override
    public boolean containsTypedPerFilterConfig(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      return internalGetTypedPerFilterConfig().getMap().containsKey(key);
    }
    /**
     * Use {@link #getTypedPerFilterConfigMap()} instead.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Any> getTypedPerFilterConfig() {
      return getTypedPerFilterConfigMap();
    }
    /**
     * <pre>
     * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
     * The key should match the :ref:`filter config name
     * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
     * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
     * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
     * entry referred by the canonical filter name will be provided to the filters as fallback.
     *
     * Use of this field is filter specific;
     * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
     * [#comment: An entry's value may be wrapped in a
     * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
     * message to specify additional options.]
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.protobuf.Any> getTypedPerFilterConfigMap() {
      return internalGetTypedPerFilterConfig().getMap();
    }
    /**
     * <pre>
     * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
     * The key should match the :ref:`filter config name
     * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
     * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
     * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
     * entry referred by the canonical filter name will be provided to the filters as fallback.
     *
     * Use of this field is filter specific;
     * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
     * [#comment: An entry's value may be wrapped in a
     * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
     * message to specify additional options.]
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
     */
    @java.lang.Override
    public /* nullable */
com.google.protobuf.Any getTypedPerFilterConfigOrDefault(
        java.lang.String key,
        /* nullable */
com.google.protobuf.Any defaultValue) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, com.google.protobuf.Any> map =
          internalGetTypedPerFilterConfig().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
     * The key should match the :ref:`filter config name
     * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
     * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
     * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
     * entry referred by the canonical filter name will be provided to the filters as fallback.
     *
     * Use of this field is filter specific;
     * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
     * [#comment: An entry's value may be wrapped in a
     * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
     * message to specify additional options.]
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Any getTypedPerFilterConfigOrThrow(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      java.util.Map<java.lang.String, com.google.protobuf.Any> map =
          internalGetTypedPerFilterConfig().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }
    public Builder clearTypedPerFilterConfig() {
      bitField0_ = (bitField0_ & ~0x00001000);
      internalGetMutableTypedPerFilterConfig().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
     * The key should match the :ref:`filter config name
     * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
     * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
     * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
     * entry referred by the canonical filter name will be provided to the filters as fallback.
     *
     * Use of this field is filter specific;
     * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
     * [#comment: An entry's value may be wrapped in a
     * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
     * message to specify additional options.]
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
     */
    public Builder removeTypedPerFilterConfig(
        java.lang.String key) {
      if (key == null) { throw new NullPointerException("map key"); }
      internalGetMutableTypedPerFilterConfig().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.protobuf.Any>
        getMutableTypedPerFilterConfig() {
      bitField0_ |= 0x00001000;
      return internalGetMutableTypedPerFilterConfig().getMutableMap();
    }
    /**
     * <pre>
     * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
     * The key should match the :ref:`filter config name
     * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
     * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
     * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
     * entry referred by the canonical filter name will be provided to the filters as fallback.
     *
     * Use of this field is filter specific;
     * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
     * [#comment: An entry's value may be wrapped in a
     * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
     * message to specify additional options.]
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
     */
    public Builder putTypedPerFilterConfig(
        java.lang.String key,
        com.google.protobuf.Any value) {
      if (key == null) { throw new NullPointerException("map key"); }
      if (value == null) { throw new NullPointerException("map value"); }
      internalGetMutableTypedPerFilterConfig().getMutableMap()
          .put(key, value);
      bitField0_ |= 0x00001000;
      return this;
    }
    /**
     * <pre>
     * The per_filter_config field can be used to provide virtual host-specific configurations for filters.
     * The key should match the :ref:`filter config name
     * &lt;envoy_v3_api_field_extensions.filters.network.http_connection_manager.v3.HttpFilter.name&gt;`.
     * The canonical filter name (e.g., ``envoy.filters.http.buffer`` for the HTTP buffer filter) can also
     * be used for the backwards compatibility. If there is no entry referred by the filter config name, the
     * entry referred by the canonical filter name will be provided to the filters as fallback.
     *
     * Use of this field is filter specific;
     * see the :ref:`HTTP filter documentation &lt;config_http_filters&gt;` for if and how it is utilized.
     * [#comment: An entry's value may be wrapped in a
     * :ref:`FilterConfig&lt;envoy_v3_api_msg_config.route.v3.FilterConfig&gt;`
     * message to specify additional options.]
     * </pre>
     *
     * <code>map&lt;string, .google.protobuf.Any&gt; typed_per_filter_config = 15;</code>
     */
    public Builder putAllTypedPerFilterConfig(
        java.util.Map<java.lang.String, com.google.protobuf.Any> values) {
      internalGetMutableTypedPerFilterConfig().getMutableMap()
          .putAll(values);
      bitField0_ |= 0x00001000;
      return this;
    }

    private boolean includeRequestAttemptCount_ ;
    /**
     * <pre>
     * Decides whether the :ref:`x-envoy-attempt-count
     * &lt;config_http_filters_router_x-envoy-attempt-count&gt;` header should be included
     * in the upstream request. Setting this option will cause it to override any existing header
     * value, so in the case of two Envoys on the request path with this option enabled, the upstream
     * will see the attempt count as perceived by the second Envoy. Defaults to false.
     * This header is unaffected by the
     * :ref:`suppress_envoy_headers
     * &lt;envoy_v3_api_field_extensions.filters.http.router.v3.Router.suppress_envoy_headers&gt;` flag.
     *
     * [#next-major-version: rename to include_attempt_count_in_request.]
     * </pre>
     *
     * <code>bool include_request_attempt_count = 14;</code>
     * @return The includeRequestAttemptCount.
     */
    @java.lang.Override
    public boolean getIncludeRequestAttemptCount() {
      return includeRequestAttemptCount_;
    }
    /**
     * <pre>
     * Decides whether the :ref:`x-envoy-attempt-count
     * &lt;config_http_filters_router_x-envoy-attempt-count&gt;` header should be included
     * in the upstream request. Setting this option will cause it to override any existing header
     * value, so in the case of two Envoys on the request path with this option enabled, the upstream
     * will see the attempt count as perceived by the second Envoy. Defaults to false.
     * This header is unaffected by the
     * :ref:`suppress_envoy_headers
     * &lt;envoy_v3_api_field_extensions.filters.http.router.v3.Router.suppress_envoy_headers&gt;` flag.
     *
     * [#next-major-version: rename to include_attempt_count_in_request.]
     * </pre>
     *
     * <code>bool include_request_attempt_count = 14;</code>
     * @param value The includeRequestAttemptCount to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeRequestAttemptCount(boolean value) {

      includeRequestAttemptCount_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Decides whether the :ref:`x-envoy-attempt-count
     * &lt;config_http_filters_router_x-envoy-attempt-count&gt;` header should be included
     * in the upstream request. Setting this option will cause it to override any existing header
     * value, so in the case of two Envoys on the request path with this option enabled, the upstream
     * will see the attempt count as perceived by the second Envoy. Defaults to false.
     * This header is unaffected by the
     * :ref:`suppress_envoy_headers
     * &lt;envoy_v3_api_field_extensions.filters.http.router.v3.Router.suppress_envoy_headers&gt;` flag.
     *
     * [#next-major-version: rename to include_attempt_count_in_request.]
     * </pre>
     *
     * <code>bool include_request_attempt_count = 14;</code>
     * @return This builder for chaining.
     */
    public Builder clearIncludeRequestAttemptCount() {
      bitField0_ = (bitField0_ & ~0x00002000);
      includeRequestAttemptCount_ = false;
      onChanged();
      return this;
    }

    private boolean includeAttemptCountInResponse_ ;
    /**
     * <pre>
     * Decides whether the :ref:`x-envoy-attempt-count
     * &lt;config_http_filters_router_x-envoy-attempt-count&gt;` header should be included
     * in the downstream response. Setting this option will cause the router to override any existing header
     * value, so in the case of two Envoys on the request path with this option enabled, the downstream
     * will see the attempt count as perceived by the Envoy closest upstream from itself. Defaults to false.
     * This header is unaffected by the
     * :ref:`suppress_envoy_headers
     * &lt;envoy_v3_api_field_extensions.filters.http.router.v3.Router.suppress_envoy_headers&gt;` flag.
     * </pre>
     *
     * <code>bool include_attempt_count_in_response = 19;</code>
     * @return The includeAttemptCountInResponse.
     */
    @java.lang.Override
    public boolean getIncludeAttemptCountInResponse() {
      return includeAttemptCountInResponse_;
    }
    /**
     * <pre>
     * Decides whether the :ref:`x-envoy-attempt-count
     * &lt;config_http_filters_router_x-envoy-attempt-count&gt;` header should be included
     * in the downstream response. Setting this option will cause the router to override any existing header
     * value, so in the case of two Envoys on the request path with this option enabled, the downstream
     * will see the attempt count as perceived by the Envoy closest upstream from itself. Defaults to false.
     * This header is unaffected by the
     * :ref:`suppress_envoy_headers
     * &lt;envoy_v3_api_field_extensions.filters.http.router.v3.Router.suppress_envoy_headers&gt;` flag.
     * </pre>
     *
     * <code>bool include_attempt_count_in_response = 19;</code>
     * @param value The includeAttemptCountInResponse to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeAttemptCountInResponse(boolean value) {

      includeAttemptCountInResponse_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Decides whether the :ref:`x-envoy-attempt-count
     * &lt;config_http_filters_router_x-envoy-attempt-count&gt;` header should be included
     * in the downstream response. Setting this option will cause the router to override any existing header
     * value, so in the case of two Envoys on the request path with this option enabled, the downstream
     * will see the attempt count as perceived by the Envoy closest upstream from itself. Defaults to false.
     * This header is unaffected by the
     * :ref:`suppress_envoy_headers
     * &lt;envoy_v3_api_field_extensions.filters.http.router.v3.Router.suppress_envoy_headers&gt;` flag.
     * </pre>
     *
     * <code>bool include_attempt_count_in_response = 19;</code>
     * @return This builder for chaining.
     */
    public Builder clearIncludeAttemptCountInResponse() {
      bitField0_ = (bitField0_ & ~0x00004000);
      includeAttemptCountInResponse_ = false;
      onChanged();
      return this;
    }

    private io.envoyproxy.envoy.config.route.v3.RetryPolicy retryPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.RetryPolicy, io.envoyproxy.envoy.config.route.v3.RetryPolicy.Builder, io.envoyproxy.envoy.config.route.v3.RetryPolicyOrBuilder> retryPolicyBuilder_;
    /**
     * <pre>
     * Indicates the retry policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
     * @return Whether the retryPolicy field is set.
     */
    public boolean hasRetryPolicy() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     * <pre>
     * Indicates the retry policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
     * @return The retryPolicy.
     */
    public io.envoyproxy.envoy.config.route.v3.RetryPolicy getRetryPolicy() {
      if (retryPolicyBuilder_ == null) {
        return retryPolicy_ == null ? io.envoyproxy.envoy.config.route.v3.RetryPolicy.getDefaultInstance() : retryPolicy_;
      } else {
        return retryPolicyBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Indicates the retry policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
     */
    public Builder setRetryPolicy(io.envoyproxy.envoy.config.route.v3.RetryPolicy value) {
      if (retryPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retryPolicy_ = value;
      } else {
        retryPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates the retry policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
     */
    public Builder setRetryPolicy(
        io.envoyproxy.envoy.config.route.v3.RetryPolicy.Builder builderForValue) {
      if (retryPolicyBuilder_ == null) {
        retryPolicy_ = builderForValue.build();
      } else {
        retryPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates the retry policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
     */
    public Builder mergeRetryPolicy(io.envoyproxy.envoy.config.route.v3.RetryPolicy value) {
      if (retryPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0) &&
          retryPolicy_ != null &&
          retryPolicy_ != io.envoyproxy.envoy.config.route.v3.RetryPolicy.getDefaultInstance()) {
          getRetryPolicyBuilder().mergeFrom(value);
        } else {
          retryPolicy_ = value;
        }
      } else {
        retryPolicyBuilder_.mergeFrom(value);
      }
      if (retryPolicy_ != null) {
        bitField0_ |= 0x00008000;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Indicates the retry policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
     */
    public Builder clearRetryPolicy() {
      bitField0_ = (bitField0_ & ~0x00008000);
      retryPolicy_ = null;
      if (retryPolicyBuilder_ != null) {
        retryPolicyBuilder_.dispose();
        retryPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates the retry policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RetryPolicy.Builder getRetryPolicyBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getRetryPolicyFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Indicates the retry policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RetryPolicyOrBuilder getRetryPolicyOrBuilder() {
      if (retryPolicyBuilder_ != null) {
        return retryPolicyBuilder_.getMessageOrBuilder();
      } else {
        return retryPolicy_ == null ?
            io.envoyproxy.envoy.config.route.v3.RetryPolicy.getDefaultInstance() : retryPolicy_;
      }
    }
    /**
     * <pre>
     * Indicates the retry policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.RetryPolicy retry_policy = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.RetryPolicy, io.envoyproxy.envoy.config.route.v3.RetryPolicy.Builder, io.envoyproxy.envoy.config.route.v3.RetryPolicyOrBuilder> 
        getRetryPolicyFieldBuilder() {
      if (retryPolicyBuilder_ == null) {
        retryPolicyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.config.route.v3.RetryPolicy, io.envoyproxy.envoy.config.route.v3.RetryPolicy.Builder, io.envoyproxy.envoy.config.route.v3.RetryPolicyOrBuilder>(
                getRetryPolicy(),
                getParentForChildren(),
                isClean());
        retryPolicy_ = null;
      }
      return retryPolicyBuilder_;
    }

    private com.google.protobuf.Any retryPolicyTypedConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Any, com.google.protobuf.Any.Builder, com.google.protobuf.AnyOrBuilder> retryPolicyTypedConfigBuilder_;
    /**
     * <pre>
     * [#not-implemented-hide:]
     * Specifies the configuration for retry policy extension. Note that setting a route level entry
     * will take precedence over this config and it'll be treated independently (e.g.: values are not
     * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
     * set if this field is used.
     * </pre>
     *
     * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
     * @return Whether the retryPolicyTypedConfig field is set.
     */
    public boolean hasRetryPolicyTypedConfig() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * Specifies the configuration for retry policy extension. Note that setting a route level entry
     * will take precedence over this config and it'll be treated independently (e.g.: values are not
     * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
     * set if this field is used.
     * </pre>
     *
     * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
     * @return The retryPolicyTypedConfig.
     */
    public com.google.protobuf.Any getRetryPolicyTypedConfig() {
      if (retryPolicyTypedConfigBuilder_ == null) {
        return retryPolicyTypedConfig_ == null ? com.google.protobuf.Any.getDefaultInstance() : retryPolicyTypedConfig_;
      } else {
        return retryPolicyTypedConfigBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * Specifies the configuration for retry policy extension. Note that setting a route level entry
     * will take precedence over this config and it'll be treated independently (e.g.: values are not
     * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
     * set if this field is used.
     * </pre>
     *
     * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
     */
    public Builder setRetryPolicyTypedConfig(com.google.protobuf.Any value) {
      if (retryPolicyTypedConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retryPolicyTypedConfig_ = value;
      } else {
        retryPolicyTypedConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * Specifies the configuration for retry policy extension. Note that setting a route level entry
     * will take precedence over this config and it'll be treated independently (e.g.: values are not
     * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
     * set if this field is used.
     * </pre>
     *
     * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
     */
    public Builder setRetryPolicyTypedConfig(
        com.google.protobuf.Any.Builder builderForValue) {
      if (retryPolicyTypedConfigBuilder_ == null) {
        retryPolicyTypedConfig_ = builderForValue.build();
      } else {
        retryPolicyTypedConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * Specifies the configuration for retry policy extension. Note that setting a route level entry
     * will take precedence over this config and it'll be treated independently (e.g.: values are not
     * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
     * set if this field is used.
     * </pre>
     *
     * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
     */
    public Builder mergeRetryPolicyTypedConfig(com.google.protobuf.Any value) {
      if (retryPolicyTypedConfigBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0) &&
          retryPolicyTypedConfig_ != null &&
          retryPolicyTypedConfig_ != com.google.protobuf.Any.getDefaultInstance()) {
          getRetryPolicyTypedConfigBuilder().mergeFrom(value);
        } else {
          retryPolicyTypedConfig_ = value;
        }
      } else {
        retryPolicyTypedConfigBuilder_.mergeFrom(value);
      }
      if (retryPolicyTypedConfig_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * Specifies the configuration for retry policy extension. Note that setting a route level entry
     * will take precedence over this config and it'll be treated independently (e.g.: values are not
     * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
     * set if this field is used.
     * </pre>
     *
     * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
     */
    public Builder clearRetryPolicyTypedConfig() {
      bitField0_ = (bitField0_ & ~0x00010000);
      retryPolicyTypedConfig_ = null;
      if (retryPolicyTypedConfigBuilder_ != null) {
        retryPolicyTypedConfigBuilder_.dispose();
        retryPolicyTypedConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * Specifies the configuration for retry policy extension. Note that setting a route level entry
     * will take precedence over this config and it'll be treated independently (e.g.: values are not
     * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
     * set if this field is used.
     * </pre>
     *
     * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
     */
    public com.google.protobuf.Any.Builder getRetryPolicyTypedConfigBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getRetryPolicyTypedConfigFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * Specifies the configuration for retry policy extension. Note that setting a route level entry
     * will take precedence over this config and it'll be treated independently (e.g.: values are not
     * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
     * set if this field is used.
     * </pre>
     *
     * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
     */
    public com.google.protobuf.AnyOrBuilder getRetryPolicyTypedConfigOrBuilder() {
      if (retryPolicyTypedConfigBuilder_ != null) {
        return retryPolicyTypedConfigBuilder_.getMessageOrBuilder();
      } else {
        return retryPolicyTypedConfig_ == null ?
            com.google.protobuf.Any.getDefaultInstance() : retryPolicyTypedConfig_;
      }
    }
    /**
     * <pre>
     * [#not-implemented-hide:]
     * Specifies the configuration for retry policy extension. Note that setting a route level entry
     * will take precedence over this config and it'll be treated independently (e.g.: values are not
     * inherited). :ref:`Retry policy &lt;envoy_v3_api_field_config.route.v3.VirtualHost.retry_policy&gt;` should not be
     * set if this field is used.
     * </pre>
     *
     * <code>.google.protobuf.Any retry_policy_typed_config = 20;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Any, com.google.protobuf.Any.Builder, com.google.protobuf.AnyOrBuilder> 
        getRetryPolicyTypedConfigFieldBuilder() {
      if (retryPolicyTypedConfigBuilder_ == null) {
        retryPolicyTypedConfigBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any, com.google.protobuf.Any.Builder, com.google.protobuf.AnyOrBuilder>(
                getRetryPolicyTypedConfig(),
                getParentForChildren(),
                isClean());
        retryPolicyTypedConfig_ = null;
      }
      return retryPolicyTypedConfigBuilder_;
    }

    private io.envoyproxy.envoy.config.route.v3.HedgePolicy hedgePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.HedgePolicy, io.envoyproxy.envoy.config.route.v3.HedgePolicy.Builder, io.envoyproxy.envoy.config.route.v3.HedgePolicyOrBuilder> hedgePolicyBuilder_;
    /**
     * <pre>
     * Indicates the hedge policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
     * @return Whether the hedgePolicy field is set.
     */
    public boolean hasHedgePolicy() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     * <pre>
     * Indicates the hedge policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
     * @return The hedgePolicy.
     */
    public io.envoyproxy.envoy.config.route.v3.HedgePolicy getHedgePolicy() {
      if (hedgePolicyBuilder_ == null) {
        return hedgePolicy_ == null ? io.envoyproxy.envoy.config.route.v3.HedgePolicy.getDefaultInstance() : hedgePolicy_;
      } else {
        return hedgePolicyBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Indicates the hedge policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
     */
    public Builder setHedgePolicy(io.envoyproxy.envoy.config.route.v3.HedgePolicy value) {
      if (hedgePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hedgePolicy_ = value;
      } else {
        hedgePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates the hedge policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
     */
    public Builder setHedgePolicy(
        io.envoyproxy.envoy.config.route.v3.HedgePolicy.Builder builderForValue) {
      if (hedgePolicyBuilder_ == null) {
        hedgePolicy_ = builderForValue.build();
      } else {
        hedgePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates the hedge policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
     */
    public Builder mergeHedgePolicy(io.envoyproxy.envoy.config.route.v3.HedgePolicy value) {
      if (hedgePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0) &&
          hedgePolicy_ != null &&
          hedgePolicy_ != io.envoyproxy.envoy.config.route.v3.HedgePolicy.getDefaultInstance()) {
          getHedgePolicyBuilder().mergeFrom(value);
        } else {
          hedgePolicy_ = value;
        }
      } else {
        hedgePolicyBuilder_.mergeFrom(value);
      }
      if (hedgePolicy_ != null) {
        bitField0_ |= 0x00020000;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Indicates the hedge policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
     */
    public Builder clearHedgePolicy() {
      bitField0_ = (bitField0_ & ~0x00020000);
      hedgePolicy_ = null;
      if (hedgePolicyBuilder_ != null) {
        hedgePolicyBuilder_.dispose();
        hedgePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Indicates the hedge policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.HedgePolicy.Builder getHedgePolicyBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getHedgePolicyFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Indicates the hedge policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.HedgePolicyOrBuilder getHedgePolicyOrBuilder() {
      if (hedgePolicyBuilder_ != null) {
        return hedgePolicyBuilder_.getMessageOrBuilder();
      } else {
        return hedgePolicy_ == null ?
            io.envoyproxy.envoy.config.route.v3.HedgePolicy.getDefaultInstance() : hedgePolicy_;
      }
    }
    /**
     * <pre>
     * Indicates the hedge policy for all routes in this virtual host. Note that setting a
     * route level entry will take precedence over this config and it'll be treated
     * independently (e.g.: values are not inherited).
     * </pre>
     *
     * <code>.envoy.config.route.v3.HedgePolicy hedge_policy = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.HedgePolicy, io.envoyproxy.envoy.config.route.v3.HedgePolicy.Builder, io.envoyproxy.envoy.config.route.v3.HedgePolicyOrBuilder> 
        getHedgePolicyFieldBuilder() {
      if (hedgePolicyBuilder_ == null) {
        hedgePolicyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.config.route.v3.HedgePolicy, io.envoyproxy.envoy.config.route.v3.HedgePolicy.Builder, io.envoyproxy.envoy.config.route.v3.HedgePolicyOrBuilder>(
                getHedgePolicy(),
                getParentForChildren(),
                isClean());
        hedgePolicy_ = null;
      }
      return hedgePolicyBuilder_;
    }

    private boolean includeIsTimeoutRetryHeader_ ;
    /**
     * <pre>
     * Decides whether to include the :ref:`x-envoy-is-timeout-retry &lt;config_http_filters_router_x-envoy-is-timeout-retry&gt;`
     * request header in retries initiated by per try timeouts.
     * </pre>
     *
     * <code>bool include_is_timeout_retry_header = 23;</code>
     * @return The includeIsTimeoutRetryHeader.
     */
    @java.lang.Override
    public boolean getIncludeIsTimeoutRetryHeader() {
      return includeIsTimeoutRetryHeader_;
    }
    /**
     * <pre>
     * Decides whether to include the :ref:`x-envoy-is-timeout-retry &lt;config_http_filters_router_x-envoy-is-timeout-retry&gt;`
     * request header in retries initiated by per try timeouts.
     * </pre>
     *
     * <code>bool include_is_timeout_retry_header = 23;</code>
     * @param value The includeIsTimeoutRetryHeader to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeIsTimeoutRetryHeader(boolean value) {

      includeIsTimeoutRetryHeader_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Decides whether to include the :ref:`x-envoy-is-timeout-retry &lt;config_http_filters_router_x-envoy-is-timeout-retry&gt;`
     * request header in retries initiated by per try timeouts.
     * </pre>
     *
     * <code>bool include_is_timeout_retry_header = 23;</code>
     * @return This builder for chaining.
     */
    public Builder clearIncludeIsTimeoutRetryHeader() {
      bitField0_ = (bitField0_ & ~0x00040000);
      includeIsTimeoutRetryHeader_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.UInt32Value perRequestBufferLimitBytes_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> perRequestBufferLimitBytesBuilder_;
    /**
     * <pre>
     * The maximum bytes which will be buffered for retries and shadowing.
     * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
     * value of this and the listener per_connection_buffer_limit_bytes.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
     * @return Whether the perRequestBufferLimitBytes field is set.
     */
    public boolean hasPerRequestBufferLimitBytes() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     * <pre>
     * The maximum bytes which will be buffered for retries and shadowing.
     * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
     * value of this and the listener per_connection_buffer_limit_bytes.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
     * @return The perRequestBufferLimitBytes.
     */
    public com.google.protobuf.UInt32Value getPerRequestBufferLimitBytes() {
      if (perRequestBufferLimitBytesBuilder_ == null) {
        return perRequestBufferLimitBytes_ == null ? com.google.protobuf.UInt32Value.getDefaultInstance() : perRequestBufferLimitBytes_;
      } else {
        return perRequestBufferLimitBytesBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * The maximum bytes which will be buffered for retries and shadowing.
     * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
     * value of this and the listener per_connection_buffer_limit_bytes.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
     */
    public Builder setPerRequestBufferLimitBytes(com.google.protobuf.UInt32Value value) {
      if (perRequestBufferLimitBytesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        perRequestBufferLimitBytes_ = value;
      } else {
        perRequestBufferLimitBytesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The maximum bytes which will be buffered for retries and shadowing.
     * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
     * value of this and the listener per_connection_buffer_limit_bytes.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
     */
    public Builder setPerRequestBufferLimitBytes(
        com.google.protobuf.UInt32Value.Builder builderForValue) {
      if (perRequestBufferLimitBytesBuilder_ == null) {
        perRequestBufferLimitBytes_ = builderForValue.build();
      } else {
        perRequestBufferLimitBytesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The maximum bytes which will be buffered for retries and shadowing.
     * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
     * value of this and the listener per_connection_buffer_limit_bytes.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
     */
    public Builder mergePerRequestBufferLimitBytes(com.google.protobuf.UInt32Value value) {
      if (perRequestBufferLimitBytesBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0) &&
          perRequestBufferLimitBytes_ != null &&
          perRequestBufferLimitBytes_ != com.google.protobuf.UInt32Value.getDefaultInstance()) {
          getPerRequestBufferLimitBytesBuilder().mergeFrom(value);
        } else {
          perRequestBufferLimitBytes_ = value;
        }
      } else {
        perRequestBufferLimitBytesBuilder_.mergeFrom(value);
      }
      if (perRequestBufferLimitBytes_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * The maximum bytes which will be buffered for retries and shadowing.
     * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
     * value of this and the listener per_connection_buffer_limit_bytes.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
     */
    public Builder clearPerRequestBufferLimitBytes() {
      bitField0_ = (bitField0_ & ~0x00080000);
      perRequestBufferLimitBytes_ = null;
      if (perRequestBufferLimitBytesBuilder_ != null) {
        perRequestBufferLimitBytesBuilder_.dispose();
        perRequestBufferLimitBytesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The maximum bytes which will be buffered for retries and shadowing.
     * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
     * value of this and the listener per_connection_buffer_limit_bytes.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
     */
    public com.google.protobuf.UInt32Value.Builder getPerRequestBufferLimitBytesBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getPerRequestBufferLimitBytesFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * The maximum bytes which will be buffered for retries and shadowing.
     * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
     * value of this and the listener per_connection_buffer_limit_bytes.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
     */
    public com.google.protobuf.UInt32ValueOrBuilder getPerRequestBufferLimitBytesOrBuilder() {
      if (perRequestBufferLimitBytesBuilder_ != null) {
        return perRequestBufferLimitBytesBuilder_.getMessageOrBuilder();
      } else {
        return perRequestBufferLimitBytes_ == null ?
            com.google.protobuf.UInt32Value.getDefaultInstance() : perRequestBufferLimitBytes_;
      }
    }
    /**
     * <pre>
     * The maximum bytes which will be buffered for retries and shadowing.
     * If set and a route-specific limit is not set, the bytes actually buffered will be the minimum
     * value of this and the listener per_connection_buffer_limit_bytes.
     * </pre>
     *
     * <code>.google.protobuf.UInt32Value per_request_buffer_limit_bytes = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder> 
        getPerRequestBufferLimitBytesFieldBuilder() {
      if (perRequestBufferLimitBytesBuilder_ == null) {
        perRequestBufferLimitBytesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.UInt32Value, com.google.protobuf.UInt32Value.Builder, com.google.protobuf.UInt32ValueOrBuilder>(
                getPerRequestBufferLimitBytes(),
                getParentForChildren(),
                isClean());
        perRequestBufferLimitBytes_ = null;
      }
      return perRequestBufferLimitBytesBuilder_;
    }

    private java.util.List<io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy> requestMirrorPolicies_ =
      java.util.Collections.emptyList();
    private void ensureRequestMirrorPoliciesIsMutable() {
      if (!((bitField0_ & 0x00100000) != 0)) {
        requestMirrorPolicies_ = new java.util.ArrayList<io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy>(requestMirrorPolicies_);
        bitField0_ |= 0x00100000;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.Builder, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicyOrBuilder> requestMirrorPoliciesBuilder_;

    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy> getRequestMirrorPoliciesList() {
      if (requestMirrorPoliciesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(requestMirrorPolicies_);
      } else {
        return requestMirrorPoliciesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public int getRequestMirrorPoliciesCount() {
      if (requestMirrorPoliciesBuilder_ == null) {
        return requestMirrorPolicies_.size();
      } else {
        return requestMirrorPoliciesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy getRequestMirrorPolicies(int index) {
      if (requestMirrorPoliciesBuilder_ == null) {
        return requestMirrorPolicies_.get(index);
      } else {
        return requestMirrorPoliciesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public Builder setRequestMirrorPolicies(
        int index, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy value) {
      if (requestMirrorPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestMirrorPoliciesIsMutable();
        requestMirrorPolicies_.set(index, value);
        onChanged();
      } else {
        requestMirrorPoliciesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public Builder setRequestMirrorPolicies(
        int index, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.Builder builderForValue) {
      if (requestMirrorPoliciesBuilder_ == null) {
        ensureRequestMirrorPoliciesIsMutable();
        requestMirrorPolicies_.set(index, builderForValue.build());
        onChanged();
      } else {
        requestMirrorPoliciesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public Builder addRequestMirrorPolicies(io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy value) {
      if (requestMirrorPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestMirrorPoliciesIsMutable();
        requestMirrorPolicies_.add(value);
        onChanged();
      } else {
        requestMirrorPoliciesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public Builder addRequestMirrorPolicies(
        int index, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy value) {
      if (requestMirrorPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestMirrorPoliciesIsMutable();
        requestMirrorPolicies_.add(index, value);
        onChanged();
      } else {
        requestMirrorPoliciesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public Builder addRequestMirrorPolicies(
        io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.Builder builderForValue) {
      if (requestMirrorPoliciesBuilder_ == null) {
        ensureRequestMirrorPoliciesIsMutable();
        requestMirrorPolicies_.add(builderForValue.build());
        onChanged();
      } else {
        requestMirrorPoliciesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public Builder addRequestMirrorPolicies(
        int index, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.Builder builderForValue) {
      if (requestMirrorPoliciesBuilder_ == null) {
        ensureRequestMirrorPoliciesIsMutable();
        requestMirrorPolicies_.add(index, builderForValue.build());
        onChanged();
      } else {
        requestMirrorPoliciesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public Builder addAllRequestMirrorPolicies(
        java.lang.Iterable<? extends io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy> values) {
      if (requestMirrorPoliciesBuilder_ == null) {
        ensureRequestMirrorPoliciesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, requestMirrorPolicies_);
        onChanged();
      } else {
        requestMirrorPoliciesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public Builder clearRequestMirrorPolicies() {
      if (requestMirrorPoliciesBuilder_ == null) {
        requestMirrorPolicies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00100000);
        onChanged();
      } else {
        requestMirrorPoliciesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public Builder removeRequestMirrorPolicies(int index) {
      if (requestMirrorPoliciesBuilder_ == null) {
        ensureRequestMirrorPoliciesIsMutable();
        requestMirrorPolicies_.remove(index);
        onChanged();
      } else {
        requestMirrorPoliciesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.Builder getRequestMirrorPoliciesBuilder(
        int index) {
      return getRequestMirrorPoliciesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicyOrBuilder getRequestMirrorPoliciesOrBuilder(
        int index) {
      if (requestMirrorPoliciesBuilder_ == null) {
        return requestMirrorPolicies_.get(index);  } else {
        return requestMirrorPoliciesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicyOrBuilder> 
         getRequestMirrorPoliciesOrBuilderList() {
      if (requestMirrorPoliciesBuilder_ != null) {
        return requestMirrorPoliciesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(requestMirrorPolicies_);
      }
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.Builder addRequestMirrorPoliciesBuilder() {
      return getRequestMirrorPoliciesFieldBuilder().addBuilder(
          io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.getDefaultInstance());
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.Builder addRequestMirrorPoliciesBuilder(
        int index) {
      return getRequestMirrorPoliciesFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.getDefaultInstance());
    }
    /**
     * <pre>
     * Specify a set of default request mirroring policies for every route under this virtual host.
     * It takes precedence over the route config mirror policy entirely.
     * That is, policies are not merged, the most specific non-empty one becomes the mirror policies.
     * </pre>
     *
     * <code>repeated .envoy.config.route.v3.RouteAction.RequestMirrorPolicy request_mirror_policies = 22;</code>
     */
    public java.util.List<io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.Builder> 
         getRequestMirrorPoliciesBuilderList() {
      return getRequestMirrorPoliciesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.Builder, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicyOrBuilder> 
        getRequestMirrorPoliciesFieldBuilder() {
      if (requestMirrorPoliciesBuilder_ == null) {
        requestMirrorPoliciesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicy.Builder, io.envoyproxy.envoy.config.route.v3.RouteAction.RequestMirrorPolicyOrBuilder>(
                requestMirrorPolicies_,
                ((bitField0_ & 0x00100000) != 0),
                getParentForChildren(),
                isClean());
        requestMirrorPolicies_ = null;
      }
      return requestMirrorPoliciesBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.config.route.v3.VirtualHost)
  }

  // @@protoc_insertion_point(class_scope:envoy.config.route.v3.VirtualHost)
  private static final io.envoyproxy.envoy.config.route.v3.VirtualHost DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.route.v3.VirtualHost();
  }

  public static io.envoyproxy.envoy.config.route.v3.VirtualHost getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VirtualHost>
      PARSER = new com.google.protobuf.AbstractParser<VirtualHost>() {
    @java.lang.Override
    public VirtualHost parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<VirtualHost> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VirtualHost> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.config.route.v3.VirtualHost getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

