/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds.trust;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;

final class CertificateUtils {
    private static CertificateFactory factory;

    private static synchronized void initInstance() throws CertificateException {
        if (factory == null) {
            factory = CertificateFactory.getInstance("X.509");
        }
    }

    static X509Certificate[] toX509Certificates(File file) throws CertificateException, IOException {
        FileInputStream fis = new FileInputStream(file);
        return CertificateUtils.toX509Certificates(new BufferedInputStream(fis));
    }

    static synchronized X509Certificate[] toX509Certificates(InputStream inputStream) throws CertificateException, IOException {
        CertificateUtils.initInstance();
        try {
            Collection<? extends Certificate> certs = factory.generateCertificates(inputStream);
            X509Certificate[] x509CertificateArray = certs.toArray(new X509Certificate[0]);
            return x509CertificateArray;
        }
        finally {
            inputStream.close();
        }
    }

    private CertificateUtils() {
    }
}

