/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.DataSource;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsCertificate;
import javax.annotation.Nullable;

final class CommonTlsContextUtil {
    private CommonTlsContextUtil() {
    }

    static boolean hasAllSecretsUsingFilename(CommonTlsContext commonTlsContext) {
        Preconditions.checkNotNull((Object)commonTlsContext, (Object)"commonTlsContext");
        return commonTlsContext.getTlsCertificateSdsSecretConfigsCount() == 0 && !commonTlsContext.hasValidationContextSdsSecretConfig();
    }

    static boolean hasAllSecretsUsingSds(CommonTlsContext commonTlsContext) {
        Preconditions.checkNotNull((Object)commonTlsContext, (Object)"commonTlsContext");
        return commonTlsContext.getTlsCertificatesCount() == 0 && !commonTlsContext.hasValidationContext();
    }

    @Nullable
    static CertificateValidationContext getCertificateValidationContext(CommonTlsContext commonTlsContext) {
        Preconditions.checkNotNull((Object)commonTlsContext, (Object)"commonTlsContext");
        CommonTlsContext.ValidationContextTypeCase type = commonTlsContext.getValidationContextTypeCase();
        Preconditions.checkState((type == CommonTlsContext.ValidationContextTypeCase.VALIDATION_CONTEXT || type == CommonTlsContext.ValidationContextTypeCase.VALIDATIONCONTEXTTYPE_NOT_SET ? 1 : 0) != 0, (Object)"incorrect ValidationContextTypeCase");
        return type == CommonTlsContext.ValidationContextTypeCase.VALIDATION_CONTEXT ? commonTlsContext.getValidationContext() : null;
    }

    @Nullable
    static CertificateValidationContext validateCertificateContext(@Nullable CertificateValidationContext certContext, boolean optional) {
        if (certContext == null || !certContext.hasTrustedCa()) {
            Preconditions.checkArgument((boolean)optional, (Object)"certContext is required");
            return null;
        }
        Preconditions.checkArgument((certContext.getTrustedCa().getSpecifierCase() == DataSource.SpecifierCase.FILENAME ? 1 : 0) != 0, (Object)"filename expected");
        return certContext;
    }

    @Nullable
    static TlsCertificate validateTlsCertificate(@Nullable TlsCertificate tlsCertificate, boolean optional) {
        if (tlsCertificate == null) {
            Preconditions.checkArgument((boolean)optional, (Object)"tlsCertificate is required");
            return null;
        }
        if (optional && tlsCertificate.getPrivateKey().getSpecifierCase() == DataSource.SpecifierCase.SPECIFIER_NOT_SET && tlsCertificate.getCertificateChain().getSpecifierCase() == DataSource.SpecifierCase.SPECIFIER_NOT_SET) {
            return null;
        }
        Preconditions.checkArgument((tlsCertificate.getPrivateKey().getSpecifierCase() == DataSource.SpecifierCase.FILENAME ? 1 : 0) != 0, (Object)"filename expected");
        Preconditions.checkArgument((tlsCertificate.getCertificateChain().getSpecifierCase() == DataSource.SpecifierCase.FILENAME ? 1 : 0) != 0, (Object)"filename expected");
        return tlsCertificate;
    }
}

