/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.certprovider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.xds.internal.certprovider.CertificateProviderProvider;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CertificateProviderRegistry {
    private static CertificateProviderRegistry instance;
    private final LinkedHashMap<String, CertificateProviderProvider> providers = new LinkedHashMap();

    @VisibleForTesting
    CertificateProviderRegistry() {
    }

    public static synchronized CertificateProviderRegistry getInstance() {
        if (instance == null) {
            instance = new CertificateProviderRegistry();
        }
        return instance;
    }

    public synchronized void register(CertificateProviderProvider certificateProviderProvider) {
        Preconditions.checkNotNull((Object)certificateProviderProvider, (Object)"certificateProviderProvider");
        this.providers.put(certificateProviderProvider.getName(), certificateProviderProvider);
    }

    public synchronized void deregister(CertificateProviderProvider certificateProviderProvider) {
        Preconditions.checkNotNull((Object)certificateProviderProvider, (Object)"certificateProviderProvider");
        this.providers.remove(certificateProviderProvider.getName());
    }

    @Nullable
    synchronized CertificateProviderProvider getProvider(String name) {
        return this.providers.get(Preconditions.checkNotNull((Object)name, (Object)"name"));
    }
}

