/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import io.grpc.ForwardingChannelBuilder;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.xds.internal.sds.SdsProtocolNegotiators;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.UpstreamTlsContext;
import java.net.SocketAddress;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class XdsChannelBuilder
extends ForwardingChannelBuilder<XdsChannelBuilder> {
    private final NettyChannelBuilder delegate;
    @Nullable
    private UpstreamTlsContext upstreamTlsContext;

    private XdsChannelBuilder(NettyChannelBuilder delegate) {
        this.delegate = delegate;
    }

    @CheckReturnValue
    public static XdsChannelBuilder forAddress(SocketAddress serverAddress) {
        return new XdsChannelBuilder(NettyChannelBuilder.forAddress((SocketAddress)serverAddress));
    }

    @CheckReturnValue
    public static XdsChannelBuilder forAddress(String host, int port) {
        return new XdsChannelBuilder(NettyChannelBuilder.forAddress((String)host, (int)port));
    }

    @CheckReturnValue
    public static XdsChannelBuilder forTarget(String target) {
        return new XdsChannelBuilder(NettyChannelBuilder.forTarget((String)target));
    }

    public XdsChannelBuilder tlsContext(@Nullable UpstreamTlsContext upstreamTlsContext) {
        this.upstreamTlsContext = upstreamTlsContext;
        return this;
    }

    protected ManagedChannelBuilder<?> delegate() {
        return this.delegate;
    }

    public ManagedChannel build() {
        InternalNettyChannelBuilder.setProtocolNegotiatorFactory((NettyChannelBuilder)this.delegate, (InternalNettyChannelBuilder.ProtocolNegotiatorFactory)SdsProtocolNegotiators.clientProtocolNegotiatorFactory(this.upstreamTlsContext));
        return this.delegate.build();
    }
}

