/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancer;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.XdsLoadBalancerProvider;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.List;
import java.util.Map;

final class FallbackLb
extends ForwardingLoadBalancer {
    private final LoadBalancer.Helper fallbackLbHelper;
    private final LoadBalancerRegistry lbRegistry;
    private final GracefulSwitchLoadBalancer fallbackPolicyLb;

    FallbackLb(LoadBalancer.Helper fallbackLbHelper) {
        this((LoadBalancer.Helper)Preconditions.checkNotNull((Object)fallbackLbHelper, (Object)"fallbackLbHelper"), LoadBalancerRegistry.getDefaultRegistry());
    }

    @VisibleForTesting
    FallbackLb(LoadBalancer.Helper fallbackLbHelper, LoadBalancerRegistry lbRegistry) {
        this.fallbackLbHelper = fallbackLbHelper;
        this.lbRegistry = lbRegistry;
        this.fallbackPolicyLb = new GracefulSwitchLoadBalancer(fallbackLbHelper);
    }

    protected LoadBalancer delegate() {
        return this.fallbackPolicyLb;
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        XdsLoadBalancerProvider.XdsConfig xdsConfig;
        Attributes attributes = resolvedAddresses.getAttributes();
        Object lbConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
        if (lbConfig != null) {
            if (!(lbConfig instanceof XdsLoadBalancerProvider.XdsConfig)) {
                this.fallbackLbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("Load balancing config '" + lbConfig + "' is not an XdsConfig")));
                return;
            }
            xdsConfig = (XdsLoadBalancerProvider.XdsConfig)lbConfig;
        } else {
            Map newRawLbConfig = (Map)attributes.get(ATTR_LOAD_BALANCING_CONFIG);
            if (newRawLbConfig == null) {
                this.fallbackLbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("ATTR_LOAD_BALANCING_CONFIG not available")));
                return;
            }
            NameResolver.ConfigOrError cfg = XdsLoadBalancerProvider.parseLoadBalancingConfigPolicy(newRawLbConfig, this.lbRegistry);
            if (cfg.getError() != null) {
                this.fallbackLbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(cfg.getError()));
                return;
            }
            xdsConfig = (XdsLoadBalancerProvider.XdsConfig)cfg.getConfig();
        }
        ServiceConfigUtil.LbConfig fallbackPolicy = xdsConfig.fallbackPolicy;
        if (fallbackPolicy == null) {
            this.fallbackLbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("Fallback is not supported")));
            return;
        }
        String newFallbackPolicyName = fallbackPolicy.getPolicyName();
        this.fallbackPolicyLb.switchTo((LoadBalancer.Factory)this.lbRegistry.getProvider(newFallbackPolicyName));
        List servers = resolvedAddresses.getAddresses();
        if (servers.isEmpty() && !this.fallbackPolicyLb.canHandleEmptyAddressListFromNameResolution()) {
            this.fallbackPolicyLb.handleNameResolutionError(Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. addrs=" + resolvedAddresses));
        } else {
            LoadBalancer.ResolvedAddresses fallbackResolvedAddresses = resolvedAddresses.toBuilder().setAddresses(servers).setAttributes(attributes.toBuilder().set(ATTR_LOAD_BALANCING_CONFIG, (Object)fallbackPolicy.getRawConfigValue()).build()).build();
            this.fallbackPolicyLb.handleResolvedAddresses(fallbackResolvedAddresses);
        }
    }
}

