/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import io.grpc.Context;
import io.opencensus.common.Scope;
import io.opencensus.stats.Measure;
import io.opencensus.stats.MeasureMap;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.Tag;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagMetadata;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.propagation.TagContextBinarySerializer;
import io.opencensus.tags.propagation.TagContextDeserializationException;
import io.opencensus.tags.unsafe.ContextUtils;
import io.opencensus.trace.Annotation;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Link;
import io.opencensus.trace.MessageEvent;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanBuilder;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class StatsTestUtils {
    public static final TagKey EXTRA_TAG = TagKey.create((String)"/rpc/test/extratag");
    private static final String EXTRA_TAG_HEADER_VALUE_PREFIX = "extratag:";

    private StatsTestUtils() {
    }

    private static ImmutableMap<TagKey, TagValue> getTags(TagContext tags) {
        return tags instanceof FakeTagContext ? ((FakeTagContext)tags).getTags() : ImmutableMap.of();
    }

    public static class MockableSpan
    extends Span {
        public static MockableSpan generateRandomSpan(Random random) {
            return new MockableSpan(SpanContext.create((TraceId)TraceId.generateRandomId((Random)random), (SpanId)SpanId.generateRandomId((Random)random), (TraceOptions)TraceOptions.DEFAULT), null);
        }

        public void putAttributes(Map<String, AttributeValue> attributes) {
        }

        public void addAnnotation(String description, Map<String, AttributeValue> attributes) {
        }

        public void addAnnotation(Annotation annotation) {
        }

        public void addMessageEvent(MessageEvent messageEvent) {
        }

        public void addLink(Link link) {
        }

        public void end(EndSpanOptions options) {
        }

        private MockableSpan(SpanContext context, @Nullable EnumSet<Span.Options> options) {
            super(context, options);
        }

        public static class Builder
        extends SpanBuilder {
            public SpanBuilder setSampler(Sampler sampler) {
                return this;
            }

            public SpanBuilder setParentLinks(List<Span> parentLinks) {
                return this;
            }

            public SpanBuilder setRecordEvents(boolean recordEvents) {
                return this;
            }

            public Span startSpan() {
                return null;
            }
        }
    }

    public static class FakeTagContextBuilder
    extends TagContextBuilder {
        private final Map<TagKey, TagValue> tagsBuilder = Maps.newHashMap();

        private FakeTagContextBuilder(Map<TagKey, TagValue> tags) {
            this.tagsBuilder.putAll(tags);
        }

        public TagContextBuilder put(TagKey key, TagValue value) {
            this.tagsBuilder.put(key, value);
            return this;
        }

        public TagContextBuilder remove(TagKey key) {
            this.tagsBuilder.remove(key);
            return this;
        }

        public TagContext build() {
            FakeTagContext context = new FakeTagContext(ImmutableMap.copyOf(this.tagsBuilder));
            return context;
        }

        public Scope buildScoped() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FakeTagContext
    extends TagContext {
        private static final FakeTagContext EMPTY = new FakeTagContext((ImmutableMap<TagKey, TagValue>)ImmutableMap.of());
        private static final TagMetadata METADATA_PROPAGATING = TagMetadata.create((TagMetadata.TagTtl)TagMetadata.TagTtl.UNLIMITED_PROPAGATION);
        private final ImmutableMap<TagKey, TagValue> tags;

        private FakeTagContext(ImmutableMap<TagKey, TagValue> tags) {
            this.tags = tags;
        }

        public ImmutableMap<TagKey, TagValue> getTags() {
            return this.tags;
        }

        public String toString() {
            return "[tags=" + this.tags + "]";
        }

        protected Iterator<Tag> getIterator() {
            return Iterators.transform((Iterator)this.tags.entrySet().iterator(), (Function)new Function<Map.Entry<TagKey, TagValue>, Tag>(){

                public Tag apply(@Nullable Map.Entry<TagKey, TagValue> entry) {
                    return Tag.create((TagKey)entry.getKey(), (TagValue)entry.getValue(), (TagMetadata)METADATA_PROPAGATING);
                }
            });
        }
    }

    public static final class FakeStatsRecord
    extends MeasureMap {
        private final BlockingQueue<MetricsRecord> recordSink;
        public final Map<Measure, Number> metrics = Maps.newHashMap();

        private FakeStatsRecord(FakeStatsRecorder statsRecorder) {
            this.recordSink = statsRecorder.getCurrentRecordSink();
        }

        public MeasureMap put(Measure.MeasureDouble measure, double value) {
            this.metrics.put((Measure)measure, value);
            return this;
        }

        public MeasureMap put(Measure.MeasureLong measure, long value) {
            this.metrics.put((Measure)measure, value);
            return this;
        }

        public void record(TagContext tags) {
            this.recordSink.add(new MetricsRecord(StatsTestUtils.getTags(tags), ImmutableMap.copyOf(this.metrics)));
        }

        public void record() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FakeTagContextBinarySerializer
    extends TagContextBinarySerializer {
        private final FakeTagger tagger = new FakeTagger();

        public TagContext fromByteArray(byte[] bytes) throws TagContextDeserializationException {
            String serializedString = new String(bytes, Charsets.UTF_8);
            if (serializedString.startsWith(StatsTestUtils.EXTRA_TAG_HEADER_VALUE_PREFIX)) {
                return this.tagger.emptyBuilder().putPropagating(EXTRA_TAG, TagValue.create((String)serializedString.substring(StatsTestUtils.EXTRA_TAG_HEADER_VALUE_PREFIX.length()))).build();
            }
            throw new TagContextDeserializationException("Malformed value");
        }

        public byte[] toByteArray(TagContext tags) {
            TagValue extraTagValue = (TagValue)StatsTestUtils.getTags(tags).get((Object)EXTRA_TAG);
            if (extraTagValue == null) {
                throw new UnsupportedOperationException("TagContext must contain EXTRA_TAG");
            }
            return (StatsTestUtils.EXTRA_TAG_HEADER_VALUE_PREFIX + extraTagValue.asString()).getBytes(Charsets.UTF_8);
        }
    }

    public static final class FakeTagger
    extends Tagger {
        public FakeTagContext empty() {
            return FakeTagContext.EMPTY;
        }

        public TagContext getCurrentTagContext() {
            return ContextUtils.getValue((Context)Context.current());
        }

        public TagContextBuilder emptyBuilder() {
            return new FakeTagContextBuilder((Map)ImmutableMap.of());
        }

        public FakeTagContextBuilder toBuilder(TagContext tags) {
            return new FakeTagContextBuilder((Map)StatsTestUtils.getTags(tags));
        }

        public TagContextBuilder currentBuilder() {
            throw new UnsupportedOperationException();
        }

        public Scope withTagContext(TagContext tags) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FakeStatsRecorder
    extends StatsRecorder {
        private BlockingQueue<MetricsRecord> records;

        public FakeStatsRecorder() {
            this.rolloverRecords();
        }

        public MeasureMap newMeasureMap() {
            return new FakeStatsRecord(this);
        }

        public MetricsRecord pollRecord() {
            return (MetricsRecord)this.getCurrentRecordSink().poll();
        }

        public MetricsRecord pollRecord(long timeout, TimeUnit unit) throws InterruptedException {
            return this.getCurrentRecordSink().poll(timeout, unit);
        }

        public synchronized void rolloverRecords() {
            this.records = new LinkedBlockingQueue<MetricsRecord>();
        }

        private synchronized BlockingQueue<MetricsRecord> getCurrentRecordSink() {
            return this.records;
        }
    }

    public static class MetricsRecord {
        public final ImmutableMap<TagKey, TagValue> tags;
        public final ImmutableMap<Measure, Number> metrics;

        private MetricsRecord(ImmutableMap<TagKey, TagValue> tags, ImmutableMap<Measure, Number> metrics) {
            this.tags = tags;
            this.metrics = metrics;
        }

        @Nullable
        public Double getMetric(Measure measure) {
            for (Map.Entry m : this.metrics.entrySet()) {
                if (!((Measure)m.getKey()).equals(measure)) continue;
                Number value = (Number)m.getValue();
                if (value instanceof Double) {
                    return (Double)value;
                }
                if (value instanceof Long) {
                    return (double)((Long)value);
                }
                throw new AssertionError((Object)("Unexpected measure value type: " + value.getClass().getName()));
            }
            return null;
        }

        public long getMetricAsLongOrFail(Measure measure) {
            Double doubleValue = this.getMetric(measure);
            Preconditions.checkNotNull((Object)doubleValue, (String)"Measure not found: %s", (Object)measure.getName());
            long longValue = (long)(Math.abs(doubleValue) + 1.0E-4);
            if (doubleValue < 0.0) {
                longValue = -longValue;
            }
            return longValue;
        }

        public String toString() {
            return "[tags=" + this.tags + ", metrics=" + this.metrics + "]";
        }
    }
}

