/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ClientStreamTracer;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.internal.Channelz;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.Instrumented;
import io.grpc.internal.InternalServer;
import io.grpc.internal.IoUtils;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StreamListener;
import io.grpc.internal.testing.TestClientStreamTracer;
import io.grpc.internal.testing.TestServerStreamTracer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public abstract class AbstractTransportTest {
    private static final int TIMEOUT_MS = 1000;
    private static final Attributes.Key<String> ADDITIONAL_TRANSPORT_ATTR_KEY = Attributes.Key.of((String)"additional-attr");
    private InternalServer server;
    private ServerTransport serverTransport;
    private ManagedClientTransport client;
    private MethodDescriptor<String, String> methodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNKNOWN).setFullMethodName("service/method").setRequestMarshaller((MethodDescriptor.Marshaller)StringMarshaller.INSTANCE).setResponseMarshaller((MethodDescriptor.Marshaller)StringMarshaller.INSTANCE).build();
    private CallOptions callOptions;
    private Metadata.Key<String> asciiKey = Metadata.Key.of((String)"ascii-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private Metadata.Key<String> binaryKey = Metadata.Key.of((String)"key-bin", (Metadata.BinaryMarshaller)StringBinaryMarshaller.INSTANCE);
    private ManagedClientTransport.Listener mockClientTransportListener = (ManagedClientTransport.Listener)Mockito.mock(ManagedClientTransport.Listener.class);
    private MockServerListener serverListener = new MockServerListener();
    private ArgumentCaptor<Throwable> throwableCaptor = ArgumentCaptor.forClass(Throwable.class);
    private final ClientStreamTracer.Factory clientStreamTracerFactory = (ClientStreamTracer.Factory)Mockito.mock(ClientStreamTracer.Factory.class);
    private final TestClientStreamTracer clientStreamTracer1 = new TestClientStreamTracer();
    private final TestClientStreamTracer clientStreamTracer2 = new TestClientStreamTracer();
    private final ServerStreamTracer.Factory serverStreamTracerFactory = (ServerStreamTracer.Factory)Mockito.mock(ServerStreamTracer.Factory.class);
    private final TestServerStreamTracer serverStreamTracer1 = new TestServerStreamTracer();
    private final TestServerStreamTracer serverStreamTracer2 = new TestServerStreamTracer();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    protected abstract InternalServer newServer(List<ServerStreamTracer.Factory> var1);

    protected abstract InternalServer newServer(InternalServer var1, List<ServerStreamTracer.Factory> var2);

    protected abstract ManagedClientTransport newClientTransport(InternalServer var1);

    protected abstract String testAuthority(InternalServer var1);

    protected boolean sizesReported() {
        return true;
    }

    @Before
    public void setUp() {
        this.server = this.newServer(Arrays.asList(this.serverStreamTracerFactory));
        Mockito.when((Object)this.clientStreamTracerFactory.newClientStreamTracer((CallOptions)Matchers.any(CallOptions.class), (Metadata)Matchers.any(Metadata.class))).thenReturn((Object)this.clientStreamTracer1).thenReturn((Object)this.clientStreamTracer2);
        Mockito.when((Object)this.serverStreamTracerFactory.newServerStreamTracer(Matchers.anyString(), (Metadata)Matchers.any(Metadata.class))).thenReturn((Object)this.serverStreamTracer1).thenReturn((Object)this.serverStreamTracer2);
        this.callOptions = CallOptions.DEFAULT.withStreamTracerFactory(this.clientStreamTracerFactory);
    }

    @After
    public void tearDown() throws InterruptedException {
        if (this.client != null) {
            this.client.shutdownNow(Status.UNKNOWN.withDescription("teardown"));
        }
        if (this.serverTransport != null) {
            this.serverTransport.shutdownNow(Status.UNKNOWN.withDescription("teardown"));
        }
        if (this.server != null) {
            this.server.shutdown();
            Assert.assertTrue((boolean)this.serverListener.waitForShutdown(1000L, TimeUnit.MILLISECONDS));
        }
    }

    protected void advanceClock(long offset, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    protected long currentTimeMillis() {
        throw new UnsupportedOperationException();
    }

    @Test
    public void frameAfterRstStreamShouldNotBreakClientChannel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        stream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        stream.flush();
        stream.writeMessage(this.methodDescriptor.streamRequest((Object)"foo"));
        stream.flush();
        stream.cancel(Status.CANCELLED);
        stream.flush();
        serverStreamCreation.stream.writeHeaders(new Metadata());
        serverStreamCreation.stream.flush();
        serverStreamCreation.stream.writeMessage(this.methodDescriptor.streamResponse((Object)"bar"));
        serverStreamCreation.stream.flush();
        Assert.assertEquals((Object)Status.CANCELLED, (Object)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        ClientStreamListener mockClientStreamListener2 = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
        stream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        stream.start(mockClientStreamListener2);
        serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        serverStreamCreation.stream.writeHeaders(new Metadata());
        serverStreamCreation.stream.flush();
        ((ClientStreamListener)Mockito.verify((Object)mockClientStreamListener2, (VerificationMode)Mockito.timeout((int)250))).headersRead((Metadata)Matchers.any(Metadata.class));
    }

    @Test
    public void serverNotListening() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.server.shutdown();
        Assert.assertTrue((boolean)this.serverListener.waitForShutdown(1000L, TimeUnit.MILLISECONDS));
        this.server = null;
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockClientTransportListener});
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ArgumentCaptor statusCaptor = ArgumentCaptor.forClass(Status.class);
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportShutdown((Status)statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.UNAVAILABLE, (Status)statusCaptor.getValue());
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportReady();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void clientStartStop() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockClientTransportListener});
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        Status shutdownReason = Status.UNAVAILABLE.withDescription("shutdown called");
        this.client.shutdown(shutdownReason);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportShutdown((Status)Matchers.same((Object)shutdownReason));
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void clientStartAndStopOnceConnected() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockClientTransportListener});
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportReady();
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.client.shutdown(Status.UNAVAILABLE);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportShutdown((Status)Matchers.any(Status.class));
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportTerminated();
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(1000L, TimeUnit.MILLISECONDS));
        this.server.shutdown();
        Assert.assertTrue((boolean)this.serverListener.waitForShutdown(1000L, TimeUnit.MILLISECONDS));
        this.server = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void serverAlreadyListening() throws Exception {
        this.client = null;
        this.server.start((ServerListener)this.serverListener);
        InternalServer server2 = this.newServer(this.server, Arrays.asList(this.serverStreamTracerFactory));
        this.thrown.expect(IOException.class);
        server2.start((ServerListener)new MockServerListener());
    }

    @Test
    public void openStreamPreventsTermination() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(true);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        this.client.shutdown(Status.UNAVAILABLE);
        this.client = null;
        this.server.shutdown();
        this.serverTransport.shutdown();
        this.serverTransport = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportShutdown((Status)Matchers.any(Status.class));
        Assert.assertTrue((boolean)this.serverListener.waitForShutdown(1000L, TimeUnit.MILLISECONDS));
        this.serverListener = new MockServerListener();
        this.server = this.newServer(this.server, Arrays.asList(this.serverStreamTracerFactory));
        this.server.start((ServerListener)this.serverListener);
        serverStream.writeHeaders(new Metadata());
        clientStream.halfClose();
        Assert.assertNotNull((Object)clientStreamListener.headers.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverStreamListener.awaitHalfClosed(1000, TimeUnit.MILLISECONDS));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(false);
        Assert.assertFalse((boolean)serverTransportListener.isTerminated());
        clientStream.cancel(Status.CANCELLED);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(false);
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void shutdownNowKillsClientStream() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(true);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        Status status = Status.UNKNOWN.withDescription("test shutdownNow");
        this.client.shutdownNow(status);
        this.client = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportShutdown((Status)Matchers.any(Status.class));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(false);
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverTransportListener.isTerminated());
        Assert.assertEquals((Object)status, (Object)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Status serverStatus = (Status)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)serverStatus.isOk());
        Assert.assertTrue((boolean)this.clientStreamTracer1.await(1000L, TimeUnit.MILLISECONDS));
        AbstractTransportTest.assertStatusEquals(status, this.clientStreamTracer1.getStatus());
        Assert.assertTrue((boolean)this.serverStreamTracer1.await(1000L, TimeUnit.MILLISECONDS));
        AbstractTransportTest.assertStatusEquals(serverStatus, this.serverStreamTracer1.getStatus());
    }

    @Test
    public void shutdownNowKillsServerStream() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(true);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        Status shutdownStatus = Status.UNKNOWN.withDescription("test shutdownNow");
        this.serverTransport.shutdownNow(shutdownStatus);
        this.serverTransport = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportShutdown((Status)Matchers.any(Status.class));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(false);
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverTransportListener.isTerminated());
        Status clientStreamStatus = (Status)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)clientStreamStatus.isOk());
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)this.clientStreamTracer1.await(1000L, TimeUnit.MILLISECONDS));
        AbstractTransportTest.assertStatusEquals(clientStreamStatus, this.clientStreamTracer1.getStatus());
        Assert.assertTrue((boolean)this.serverStreamTracer1.await(1000L, TimeUnit.MILLISECONDS));
        AbstractTransportTest.assertStatusEquals(shutdownStatus, this.serverStreamTracer1.getStatus());
        Assert.assertNotNull((Object)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void ping() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientTransport.PingCallback mockPingCallback = (ClientTransport.PingCallback)Mockito.mock(ClientTransport.PingCallback.class);
        try {
            this.client.ping(mockPingCallback, MoreExecutors.directExecutor());
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeTrue((boolean)false);
        }
        ((ClientTransport.PingCallback)Mockito.verify((Object)mockPingCallback, (VerificationMode)Mockito.timeout((int)1000))).onSuccess(Matchers.anyLong());
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void ping_duringShutdown() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        stream.start((ClientStreamListener)clientStreamListener);
        this.client.shutdown(Status.UNAVAILABLE);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportShutdown((Status)Matchers.any(Status.class));
        ClientTransport.PingCallback mockPingCallback = (ClientTransport.PingCallback)Mockito.mock(ClientTransport.PingCallback.class);
        try {
            this.client.ping(mockPingCallback, MoreExecutors.directExecutor());
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeTrue((boolean)false);
        }
        ((ClientTransport.PingCallback)Mockito.verify((Object)mockPingCallback, (VerificationMode)Mockito.timeout((int)1000))).onSuccess(Matchers.anyLong());
        stream.cancel(Status.CANCELLED);
    }

    @Test
    public void ping_afterTermination() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportReady();
        Status shutdownReason = Status.UNAVAILABLE.withDescription("shutdown called");
        this.client.shutdown(shutdownReason);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        ClientTransport.PingCallback mockPingCallback = (ClientTransport.PingCallback)Mockito.mock(ClientTransport.PingCallback.class);
        try {
            this.client.ping(mockPingCallback, MoreExecutors.directExecutor());
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeTrue((boolean)false);
        }
        ((ClientTransport.PingCallback)Mockito.verify((Object)mockPingCallback, (VerificationMode)Mockito.timeout((int)1000))).onFailure((Throwable)this.throwableCaptor.capture());
        Status status = Status.fromThrowable((Throwable)((Throwable)this.throwableCaptor.getValue()));
        Assert.assertSame((Object)shutdownReason, (Object)status);
    }

    @Test
    public void newStream_duringShutdown() throws Exception {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.clientStreamTracerFactory});
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ((ClientStreamTracer.Factory)inOrder.verify((Object)this.clientStreamTracerFactory)).newClientStreamTracer((CallOptions)Matchers.any(CallOptions.class), (Metadata)Matchers.any(Metadata.class));
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        stream.start((ClientStreamListener)clientStreamListener);
        this.client.shutdown(Status.UNAVAILABLE);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportShutdown((Status)Matchers.any(Status.class));
        ClientStream stream2 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ((ClientStreamTracer.Factory)inOrder.verify((Object)this.clientStreamTracerFactory)).newClientStreamTracer((CallOptions)Matchers.any(CallOptions.class), (Metadata)Matchers.any(Metadata.class));
        ClientStreamListenerBase clientStreamListener2 = new ClientStreamListenerBase();
        stream2.start((ClientStreamListener)clientStreamListener2);
        Status clientStreamStatus2 = (Status)clientStreamListener2.status.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)clientStreamListener2.trailers.get(1000L, TimeUnit.MILLISECONDS));
        AbstractTransportTest.assertCodeEquals(Status.UNAVAILABLE, clientStreamStatus2);
        Assert.assertSame((Object)clientStreamStatus2, (Object)this.clientStreamTracer2.getStatus());
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(20000L, TimeUnit.MILLISECONDS);
        serverStreamCreation.stream.close(Status.OK, new Metadata());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void newStream_afterTermination() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportReady();
        Status shutdownReason = Status.UNAVAILABLE.withDescription("shutdown called");
        this.client.shutdown(shutdownReason);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportTerminated();
        Thread.sleep(100L);
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        stream.start((ClientStreamListener)clientStreamListener);
        Assert.assertEquals((Object)shutdownReason, (Object)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
        ((ClientStreamTracer.Factory)Mockito.verify((Object)this.clientStreamTracerFactory)).newClientStreamTracer((CallOptions)Matchers.any(CallOptions.class), (Metadata)Matchers.any(Metadata.class));
        Assert.assertSame((Object)shutdownReason, (Object)this.clientStreamTracer1.getStatus());
        Assert.assertNull(this.serverStreamTracer1.getServerCallInfo());
    }

    @Test
    public void transportInUse_normalClose() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream stream1 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener1 = new ClientStreamListenerBase();
        stream1.start((ClientStreamListener)clientStreamListener1);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(true);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation1 = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ClientStream stream2 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener2 = new ClientStreamListenerBase();
        stream2.start((ClientStreamListener)clientStreamListener2);
        StreamCreation serverStreamCreation2 = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        stream1.halfClose();
        serverStreamCreation1.stream.close(Status.OK, new Metadata());
        stream2.halfClose();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(false);
        serverStreamCreation2.stream.close(Status.OK, new Metadata());
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(false);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(true);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(false);
    }

    @Test
    public void transportInUse_clientCancel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream stream1 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener1 = new ClientStreamListenerBase();
        stream1.start((ClientStreamListener)clientStreamListener1);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(true);
        ClientStream stream2 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener2 = new ClientStreamListenerBase();
        stream2.start((ClientStreamListener)clientStreamListener2);
        stream1.cancel(Status.CANCELLED);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(false);
        stream2.cancel(Status.CANCELLED);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)1000))).transportInUse(false);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(true);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(false);
    }

    @Test
    public void basicStream() throws Exception {
        InOrder clientInOrder = Mockito.inOrder((Object[])new Object[]{this.clientStreamTracerFactory});
        InOrder serverInOrder = Mockito.inOrder((Object[])new Object[]{this.serverStreamTracerFactory});
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        Metadata clientHeaders = new Metadata();
        clientHeaders.put(this.asciiKey, (Object)"client");
        clientHeaders.put(this.asciiKey, (Object)"dupvalue");
        clientHeaders.put(this.asciiKey, (Object)"dupvalue");
        clientHeaders.put(this.binaryKey, (Object)"\u00e4binaryclient");
        Metadata clientHeadersCopy = new Metadata();
        clientHeadersCopy.merge(clientHeaders);
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, clientHeaders, this.callOptions);
        ((ClientStreamTracer.Factory)clientInOrder.verify((Object)this.clientStreamTracerFactory)).newClientStreamTracer((CallOptions)Matchers.same((Object)this.callOptions), (Metadata)Matchers.same((Object)clientHeaders));
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)this.clientStreamTracer1.awaitOutboundHeaders(1000, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)this.methodDescriptor.getFullMethodName(), (Object)serverStreamCreation.method);
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)clientHeadersCopy.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)serverStreamCreation.headers.getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)clientHeadersCopy.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)serverStreamCreation.headers.getAll(this.binaryKey)));
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        ((ServerStreamTracer.Factory)serverInOrder.verify((Object)this.serverStreamTracerFactory)).newServerStreamTracer((String)Matchers.eq((Object)this.methodDescriptor.getFullMethodName()), (Metadata)Matchers.any(Metadata.class));
        Assert.assertEquals((Object)"additional attribute value", (Object)serverStream.getAttributes().get(ADDITIONAL_TRANSPORT_ATTR_KEY));
        Assert.assertNotNull((Object)serverStream.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
        serverStream.request(1);
        Assert.assertTrue((boolean)clientStreamListener.awaitOnReady(1000, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)clientStream.isReady());
        clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)"Hello!"));
        Truth.assertThat((String)this.clientStreamTracer1.nextOutboundEvent()).isEqualTo((Object)"outboundMessage(0)");
        clientStream.flush();
        InputStream message = (InputStream)serverStreamListener.messageQueue.poll(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)"Hello!", (Object)this.methodDescriptor.parseRequest(message));
        message.close();
        Truth.assertThat((String)this.clientStreamTracer1.nextOutboundEvent()).matches("outboundMessageSent\\(0, -?[0-9]+, -?[0-9]+\\)");
        if (this.sizesReported()) {
            Truth.assertThat((Long)this.clientStreamTracer1.getOutboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.clientStreamTracer1.getOutboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
        } else {
            Truth.assertThat((Long)this.clientStreamTracer1.getOutboundWireSize()).isEqualTo((Object)0L);
            Truth.assertThat((Long)this.clientStreamTracer1.getOutboundUncompressedSize()).isEqualTo((Object)0L);
        }
        Truth.assertThat((String)this.serverStreamTracer1.nextInboundEvent()).isEqualTo((Object)"inboundMessage(0)");
        Assert.assertNull((String)"no additional message expected", serverStreamListener.messageQueue.poll());
        clientStream.halfClose();
        Assert.assertTrue((boolean)serverStreamListener.awaitHalfClosed(1000, TimeUnit.MILLISECONDS));
        if (this.sizesReported()) {
            Truth.assertThat((Long)this.serverStreamTracer1.getInboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.serverStreamTracer1.getInboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
        } else {
            Truth.assertThat((Long)this.serverStreamTracer1.getInboundWireSize()).isEqualTo((Object)0L);
            Truth.assertThat((Long)this.serverStreamTracer1.getInboundUncompressedSize()).isEqualTo((Object)0L);
        }
        Truth.assertThat((String)this.serverStreamTracer1.nextInboundEvent()).matches("inboundMessageRead\\(0, -?[0-9]+, -?[0-9]+\\)");
        Metadata serverHeaders = new Metadata();
        serverHeaders.put(this.asciiKey, (Object)"server");
        serverHeaders.put(this.asciiKey, (Object)"dupvalue");
        serverHeaders.put(this.asciiKey, (Object)"dupvalue");
        serverHeaders.put(this.binaryKey, (Object)"\u00e4binaryserver");
        Metadata serverHeadersCopy = new Metadata();
        serverHeadersCopy.merge(serverHeaders);
        serverStream.writeHeaders(serverHeaders);
        Metadata headers = (Metadata)clientStreamListener.headers.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)serverHeadersCopy.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)headers.getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)serverHeadersCopy.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)headers.getAll(this.binaryKey)));
        clientStream.request(1);
        Assert.assertTrue((boolean)serverStreamListener.awaitOnReady(1000, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverStream.isReady());
        serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)"Hi. Who are you?"));
        Truth.assertThat((String)this.serverStreamTracer1.nextOutboundEvent()).isEqualTo((Object)"outboundMessage(0)");
        serverStream.flush();
        message = (InputStream)clientStreamListener.messageQueue.poll(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((String)"message expected", (Object)message);
        Truth.assertThat((String)this.serverStreamTracer1.nextOutboundEvent()).matches("outboundMessageSent\\(0, -?[0-9]+, -?[0-9]+\\)");
        if (this.sizesReported()) {
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
        } else {
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundWireSize()).isEqualTo((Object)0L);
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundUncompressedSize()).isEqualTo((Object)0L);
        }
        Assert.assertTrue((boolean)this.clientStreamTracer1.getInboundHeaders());
        Truth.assertThat((String)this.clientStreamTracer1.nextInboundEvent()).isEqualTo((Object)"inboundMessage(0)");
        Assert.assertEquals((Object)"Hi. Who are you?", (Object)this.methodDescriptor.parseResponse(message));
        Truth.assertThat((String)this.clientStreamTracer1.nextInboundEvent()).matches("inboundMessageRead\\(0, -?[0-9]+, -?[0-9]+\\)");
        if (this.sizesReported()) {
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
        } else {
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundWireSize()).isEqualTo((Object)0L);
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundUncompressedSize()).isEqualTo((Object)0L);
        }
        message.close();
        Assert.assertNull((String)"no additional message expected", clientStreamListener.messageQueue.poll());
        Status status = Status.OK.withDescription("That was normal");
        Metadata trailers = new Metadata();
        trailers.put(this.asciiKey, (Object)"trailers");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.binaryKey, (Object)"\u00e4binarytrailers");
        serverStream.close(status, trailers);
        Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
        Assert.assertNull((Object)this.serverStreamTracer1.nextInboundEvent());
        Assert.assertNull((Object)this.serverStreamTracer1.nextOutboundEvent());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Status clientStreamStatus = (Status)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Metadata clientStreamTrailers = (Metadata)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertSame((Object)clientStreamStatus, (Object)this.clientStreamTracer1.getStatus());
        Assert.assertNull((Object)this.clientStreamTracer1.nextInboundEvent());
        Assert.assertNull((Object)this.clientStreamTracer1.nextOutboundEvent());
        Assert.assertEquals((Object)status.getCode(), (Object)clientStreamStatus.getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)clientStreamStatus.getDescription());
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)clientStreamTrailers.getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)clientStreamTrailers.getAll(this.binaryKey)));
    }

    @Test
    public void authorityPropagation() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        Metadata clientHeaders = new Metadata();
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, clientHeaders, this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        Assert.assertEquals((Object)this.testAuthority(this.server), (Object)serverStream.getAuthority());
    }

    @Test
    public void zeroMessageStream() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        clientStream.halfClose();
        Assert.assertTrue((boolean)serverStreamListener.awaitHalfClosed(1000, TimeUnit.MILLISECONDS));
        serverStream.writeHeaders(new Metadata());
        Assert.assertNotNull((Object)clientStreamListener.headers.get(1000L, TimeUnit.MILLISECONDS));
        Status status = Status.OK.withDescription("Nice talking to you");
        serverStream.close(status, new Metadata());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Status clientStreamStatus = (Status)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)status.getCode(), (Object)clientStreamStatus.getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)clientStreamStatus.getDescription());
        Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
        Assert.assertTrue((boolean)this.clientStreamTracer1.getInboundHeaders());
        Assert.assertSame((Object)clientStreamStatus, (Object)this.clientStreamTracer1.getStatus());
        Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
    }

    @Test
    public void earlyServerClose_withServerHeaders() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        serverStream.writeHeaders(new Metadata());
        Assert.assertNotNull((Object)clientStreamListener.headers.get(1000L, TimeUnit.MILLISECONDS));
        Status strippedStatus = Status.OK.withDescription("Hello. Goodbye.");
        Status status = strippedStatus.withCause((Throwable)new Exception());
        serverStream.close(status, new Metadata());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Status clientStreamStatus = (Status)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)status.getCode(), (Object)clientStreamStatus.getCode());
        Assert.assertEquals((Object)"Hello. Goodbye.", (Object)clientStreamStatus.getDescription());
        Assert.assertNull((Object)clientStreamStatus.getCause());
        Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
        Assert.assertTrue((boolean)this.clientStreamTracer1.getInboundHeaders());
        Assert.assertSame((Object)clientStreamStatus, (Object)this.clientStreamTracer1.getStatus());
        Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
    }

    @Test
    public void earlyServerClose_noServerHeaders() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        Status strippedStatus = Status.OK.withDescription("Hellogoodbye");
        Status status = strippedStatus.withCause((Throwable)new Exception());
        Metadata trailers = new Metadata();
        trailers.put(this.asciiKey, (Object)"trailers");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.binaryKey, (Object)"\u00e4binarytrailers");
        serverStream.close(status, trailers);
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Status clientStreamStatus = (Status)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Metadata clientStreamTrailers = (Metadata)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)status.getCode(), (Object)clientStreamStatus.getCode());
        Assert.assertEquals((Object)"Hellogoodbye", (Object)clientStreamStatus.getDescription());
        Assert.assertNull((Object)clientStreamStatus.getCause());
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)clientStreamTrailers.getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)clientStreamTrailers.getAll(this.binaryKey)));
        Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
        Assert.assertSame((Object)clientStreamStatus, (Object)this.clientStreamTracer1.getStatus());
        Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
    }

    @Test
    public void earlyServerClose_serverFailure() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        Status strippedStatus = Status.INTERNAL.withDescription("I'm not listening");
        Status status = strippedStatus.withCause((Throwable)new Exception());
        serverStream.close(status, new Metadata());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Status clientStreamStatus = (Status)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)status.getCode(), (Object)clientStreamStatus.getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)clientStreamStatus.getDescription());
        Assert.assertNull((Object)clientStreamStatus.getCause());
        Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
        Assert.assertSame((Object)clientStreamStatus, (Object)this.clientStreamTracer1.getStatus());
        Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
    }

    @Test
    public void earlyServerClose_serverFailure_withClientCancelOnListenerClosed() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        final ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase(){

            @Override
            public void closed(Status status, Metadata trailers) {
                super.closed(status, trailers);
                clientStream.cancel(Status.CANCELLED.withCause((Throwable)status.asRuntimeException()));
            }

            @Override
            public void closed(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata trailers) {
                super.closed(status, rpcProgress, trailers);
                clientStream.cancel(Status.CANCELLED.withCause((Throwable)status.asRuntimeException()));
            }
        };
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        Status strippedStatus = Status.INTERNAL.withDescription("I'm not listening");
        Status status = strippedStatus.withCause((Throwable)new Exception());
        serverStream.close(status, new Metadata());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Status clientStreamStatus = (Status)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)status.getCode(), (Object)clientStreamStatus.getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)clientStreamStatus.getDescription());
        Assert.assertNull((Object)clientStreamStatus.getCause());
        Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
        Assert.assertSame((Object)clientStreamStatus, (Object)this.clientStreamTracer1.getStatus());
        Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
    }

    @Test
    public void clientCancel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        Status status = Status.CANCELLED.withDescription("Nevermind").withCause((Throwable)new Exception());
        clientStream.cancel(status);
        Assert.assertEquals((Object)status, (Object)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Status serverStatus = (Status)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotEquals((Object)Status.Code.OK, (Object)serverStatus.getCode());
        Assert.assertNull((Object)serverStatus.getCause());
        clientStream.cancel(status);
        Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
        Assert.assertSame((Object)status, (Object)this.clientStreamTracer1.getStatus());
        Assert.assertSame((Object)serverStatus, (Object)this.serverStreamTracer1.getStatus());
    }

    @Test
    public void clientCancelFromWithinMessageRead() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        final SettableFuture closedCalled = SettableFuture.create();
        final ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        final Status status = Status.CANCELLED.withDescription("nevermind");
        clientStream.start(new ClientStreamListener(){
            private boolean messageReceived = false;

            public void headersRead(Metadata headers) {
            }

            public void closed(Status status2, Metadata trailers) {
                this.closed(status2, ClientStreamListener.RpcProgress.PROCESSED, trailers);
            }

            public void closed(Status status2, ClientStreamListener.RpcProgress rpcProgress, Metadata trailers) {
                Assert.assertEquals((Object)Status.CANCELLED.getCode(), (Object)status2.getCode());
                Assert.assertEquals((Object)"nevermind", (Object)status2.getDescription());
                closedCalled.set((Object)true);
            }

            public void messagesAvailable(StreamListener.MessageProducer producer) {
                InputStream message;
                while ((message = producer.next()) != null) {
                    Assert.assertFalse((String)"too many messages received", (boolean)this.messageReceived);
                    this.messageReceived = true;
                    Assert.assertEquals((Object)"foo", (Object)AbstractTransportTest.this.methodDescriptor.parseResponse(message));
                    clientStream.cancel(status);
                }
            }

            public void onReady() {
            }
        });
        clientStream.halfClose();
        clientStream.request(1);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)this.methodDescriptor.getFullMethodName(), (Object)serverStreamCreation.method);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        Assert.assertTrue((boolean)serverStreamListener.awaitOnReady(1000, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverStream.isReady());
        serverStream.writeHeaders(new Metadata());
        serverStream.writeMessage(this.methodDescriptor.streamRequest((Object)"foo"));
        serverStream.flush();
        closedCalled.get(5L, TimeUnit.SECONDS);
        serverStream.close(Status.OK, new Metadata());
        Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
        Assert.assertTrue((boolean)this.clientStreamTracer1.getInboundHeaders());
        if (this.sizesReported()) {
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundWireSize()).isGreaterThan((Comparable)Long.valueOf(0L));
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundUncompressedSize()).isGreaterThan((Comparable)Long.valueOf(0L));
        } else {
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundWireSize()).isEqualTo((Object)0L);
            Truth.assertThat((Long)this.clientStreamTracer1.getInboundUncompressedSize()).isEqualTo((Object)0L);
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundWireSize()).isEqualTo((Object)0L);
            Truth.assertThat((Long)this.serverStreamTracer1.getOutboundUncompressedSize()).isEqualTo((Object)0L);
        }
        Assert.assertSame((Object)status, (Object)this.clientStreamTracer1.getStatus());
        Assert.assertTrue((boolean)this.serverStreamTracer1.await(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)this.serverStreamTracer1.getStatus());
    }

    @Test
    public void serverCancel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        Status status = Status.DEADLINE_EXCEEDED.withDescription("It was bound to happen").withCause((Throwable)new Exception());
        serverStream.cancel(status);
        Assert.assertEquals((Object)status, (Object)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Status clientStreamStatus = (Status)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        AbstractTransportTest.assertCodeEquals(Status.CANCELLED, clientStreamStatus);
        Assert.assertNull((Object)clientStreamStatus.getCause());
        ((ClientStreamTracer.Factory)Mockito.verify((Object)this.clientStreamTracerFactory)).newClientStreamTracer((CallOptions)Matchers.any(CallOptions.class), (Metadata)Matchers.any(Metadata.class));
        Assert.assertTrue((boolean)this.clientStreamTracer1.getOutboundHeaders());
        Assert.assertSame((Object)clientStreamStatus, (Object)this.clientStreamTracer1.getStatus());
        ((ServerStreamTracer.Factory)Mockito.verify((Object)this.serverStreamTracerFactory)).newServerStreamTracer(Matchers.anyString(), (Metadata)Matchers.any(Metadata.class));
        Assert.assertSame((Object)status, (Object)this.serverStreamTracer1.getStatus());
        serverStream.cancel(status);
        this.doPingPong(this.serverListener);
    }

    @Test
    public void flowControlPushBack() throws Exception {
        this.clientStreamTracer2.setFailDuplicateCallbacks(false);
        this.serverStreamTracer2.setFailDuplicateCallbacks(false);
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)this.methodDescriptor.getFullMethodName(), (Object)serverStreamCreation.method);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        serverStream.writeHeaders(new Metadata());
        int size = 1024;
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            sb.append('a');
        }
        String largeMessage = sb.toString();
        serverStream.request(1);
        Assert.assertTrue((boolean)clientStreamListener.awaitOnReady(1000, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)clientStream.isReady());
        int maxToSend = 10240;
        int clientSent = 0;
        while (clientStream.isReady()) {
            if (clientSent > 10240) {
                Assert.fail((String)"Too many messages sent before isReady() returned false");
            }
            clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)largeMessage));
            clientStream.flush();
            ++clientSent;
        }
        Assert.assertTrue((clientSent > 0 ? 1 : 0) != 0);
        while (clientSent < 5) {
            clientStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            clientStream.flush();
            ++clientSent;
        }
        this.doPingPong(this.serverListener);
        int serverReceived = this.verifyMessageCountAndClose(serverStreamListener.messageQueue, 1);
        clientStream.request(1);
        Assert.assertTrue((boolean)serverStreamListener.awaitOnReady(1000, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverStream.isReady());
        int serverSent = 0;
        while (serverStream.isReady()) {
            if (serverSent > 10240) {
                Assert.fail((String)"Too many messages sent before isReady() returned false");
            }
            serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            serverStream.flush();
            ++serverSent;
        }
        Assert.assertTrue((serverSent > 0 ? 1 : 0) != 0);
        while (serverSent < 5) {
            serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            serverStream.flush();
            ++serverSent;
        }
        this.doPingPong(this.serverListener);
        int clientReceived = this.verifyMessageCountAndClose(clientStreamListener.messageQueue, 1);
        serverStream.request(3);
        clientStream.request(3);
        this.doPingPong(this.serverListener);
        clientReceived += this.verifyMessageCountAndClose(clientStreamListener.messageQueue, 3);
        serverReceived += this.verifyMessageCountAndClose(serverStreamListener.messageQueue, 3);
        serverStream.request(clientSent);
        clientStream.request(serverSent);
        clientReceived += this.verifyMessageCountAndClose(clientStreamListener.messageQueue, serverSent - clientReceived);
        serverReceived += this.verifyMessageCountAndClose(serverStreamListener.messageQueue, clientSent - serverReceived);
        Assert.assertTrue((boolean)clientStreamListener.awaitOnReady(1000, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)clientStreamListener.awaitOnReady(1000, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)clientStream.isReady());
        Assert.assertTrue((boolean)serverStreamListener.awaitOnReady(1000, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverStream.isReady());
        for (int i = 0; i < 5; ++i) {
            clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)largeMessage));
            clientStream.flush();
            serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            serverStream.flush();
        }
        this.doPingPong(this.serverListener);
        clientReceived += this.verifyMessageCountAndClose(clientStreamListener.messageQueue, 4);
        serverReceived += this.verifyMessageCountAndClose(serverStreamListener.messageQueue, 4);
        serverStream.request(1);
        clientStream.request(1);
        clientReceived += this.verifyMessageCountAndClose(clientStreamListener.messageQueue, 1);
        serverReceived += this.verifyMessageCountAndClose(serverStreamListener.messageQueue, 1);
        clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)largeMessage));
        clientStream.flush();
        clientStream.halfClose();
        this.doPingPong(this.serverListener);
        Assert.assertFalse((boolean)serverStreamListener.awaitHalfClosed(1000, TimeUnit.MILLISECONDS));
        serverStream.request(1);
        Assert.assertEquals((long)(clientSent + 6), (long)(serverReceived += this.verifyMessageCountAndClose(serverStreamListener.messageQueue, 1)));
        Assert.assertTrue((boolean)serverStreamListener.awaitHalfClosed(1000, TimeUnit.MILLISECONDS));
        serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
        serverStream.flush();
        Status status = Status.OK.withDescription("... quite a lengthy discussion");
        serverStream.close(status, new Metadata());
        this.doPingPong(this.serverListener);
        try {
            clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected TimeoutException");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        clientStream.request(1);
        Assert.assertEquals((long)(serverSent + 6), (long)(clientReceived += this.verifyMessageCountAndClose(clientStreamListener.messageQueue, 1)));
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Status clientStreamStatus = (Status)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)status.getCode(), (Object)clientStreamStatus.getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)clientStreamStatus.getDescription());
    }

    private int verifyMessageCountAndClose(BlockingQueue<InputStream> messageQueue, int count) throws Exception {
        for (int i = 0; i < count; ++i) {
            InputStream message = messageQueue.poll(1000L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull((Object)message);
            message.close();
        }
        Assert.assertNull((String)"no additional message expected", messageQueue.poll());
        return count;
    }

    @Test
    public void interactionsAfterServerStreamCloseAreNoops() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation server = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        clientStream.request(1);
        server.stream.close(Status.INTERNAL, new Metadata());
        Assert.assertNotNull((Object)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        server.stream.writeHeaders(new Metadata());
        server.stream.writeMessage(this.methodDescriptor.streamResponse((Object)"response"));
        server.stream.close(Status.INTERNAL, new Metadata());
        this.doPingPong(this.serverListener);
    }

    @Test
    public void interactionsAfterClientStreamCancelAreNoops() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListener clientListener = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
        clientStream.start(clientListener);
        StreamCreation server = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        server.stream.request(1);
        clientStream.cancel(Status.UNKNOWN);
        Assert.assertNotNull((Object)server.listener.status.get(1000L, TimeUnit.MILLISECONDS));
        clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)"request"));
        clientStream.halfClose();
        clientStream.cancel(Status.UNKNOWN);
        this.doPingPong(this.serverListener);
    }

    protected boolean haveTransportTracer() {
        return false;
    }

    @Test
    public void transportTracer_streamStarted() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        if (!this.haveTransportTracer()) {
            return;
        }
        Channelz.TransportStats serverBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)0L, (long)serverBefore.streamsStarted);
        Assert.assertEquals((long)0L, (long)serverBefore.lastRemoteStreamCreatedTimeNanos);
        Channelz.TransportStats clientBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)0L, (long)clientBefore.streamsStarted);
        Assert.assertEquals((long)0L, (long)clientBefore.lastRemoteStreamCreatedTimeNanos);
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        Channelz.TransportStats serverAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)1L, (long)serverAfter.streamsStarted);
        long serverFirstTimestampNanos = serverAfter.lastRemoteStreamCreatedTimeNanos;
        Assert.assertEquals((long)this.currentTimeMillis(), (long)TimeUnit.NANOSECONDS.toMillis(serverAfter.lastRemoteStreamCreatedTimeNanos));
        Channelz.TransportStats clientAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)1L, (long)clientAfter.streamsStarted);
        long clientFirstTimestampNanos = clientAfter.lastLocalStreamCreatedTimeNanos;
        Assert.assertEquals((long)this.currentTimeMillis(), (long)TimeUnit.NANOSECONDS.toMillis(clientFirstTimestampNanos));
        ServerStream serverStream = serverStreamCreation.stream;
        serverStream.close(Status.OK, new Metadata());
        long elapsedMillis = 100L;
        this.advanceClock(100L, TimeUnit.MILLISECONDS);
        Channelz.TransportStats serverBefore2 = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)1L, (long)serverBefore2.streamsStarted);
        Channelz.TransportStats clientBefore2 = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)1L, (long)clientBefore2.streamsStarted);
        ClientStream clientStream2 = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener2 = new ClientStreamListenerBase();
        clientStream2.start((ClientStreamListener)clientStreamListener2);
        StreamCreation serverStreamCreation2 = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        Channelz.TransportStats serverAfter2 = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)2L, (long)serverAfter2.streamsStarted);
        Assert.assertEquals((long)TimeUnit.MILLISECONDS.toNanos(100L), (long)(serverAfter2.lastRemoteStreamCreatedTimeNanos - serverFirstTimestampNanos));
        long serverSecondTimestamp = TimeUnit.NANOSECONDS.toMillis(serverAfter2.lastRemoteStreamCreatedTimeNanos);
        Assert.assertEquals((long)this.currentTimeMillis(), (long)serverSecondTimestamp);
        Channelz.TransportStats clientAfter2 = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)2L, (long)clientAfter2.streamsStarted);
        Assert.assertEquals((long)TimeUnit.MILLISECONDS.toNanos(100L), (long)(clientAfter2.lastLocalStreamCreatedTimeNanos - clientFirstTimestampNanos));
        long clientSecondTimestamp = TimeUnit.NANOSECONDS.toMillis(clientAfter2.lastLocalStreamCreatedTimeNanos);
        Assert.assertEquals((long)this.currentTimeMillis(), (long)clientSecondTimestamp);
        ServerStream serverStream2 = serverStreamCreation2.stream;
        serverStream2.close(Status.OK, new Metadata());
    }

    @Test
    public void transportTracer_server_streamEnded_ok() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        if (!this.haveTransportTracer()) {
            return;
        }
        Channelz.TransportStats serverBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)0L, (long)serverBefore.streamsSucceeded);
        Assert.assertEquals((long)0L, (long)serverBefore.streamsFailed);
        Channelz.TransportStats clientBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)0L, (long)clientBefore.streamsSucceeded);
        Assert.assertEquals((long)0L, (long)clientBefore.streamsFailed);
        clientStream.halfClose();
        serverStream.close(Status.OK, new Metadata());
        Assert.assertNotNull((Object)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Channelz.TransportStats serverAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)1L, (long)serverAfter.streamsSucceeded);
        Assert.assertEquals((long)0L, (long)serverAfter.streamsFailed);
        Channelz.TransportStats clientAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)1L, (long)clientAfter.streamsSucceeded);
        Assert.assertEquals((long)0L, (long)clientAfter.streamsFailed);
    }

    @Test
    public void transportTracer_server_streamEnded_nonOk() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        if (!this.haveTransportTracer()) {
            return;
        }
        Channelz.TransportStats serverBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)0L, (long)serverBefore.streamsFailed);
        Assert.assertEquals((long)0L, (long)serverBefore.streamsSucceeded);
        Channelz.TransportStats clientBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)0L, (long)clientBefore.streamsFailed);
        Assert.assertEquals((long)0L, (long)clientBefore.streamsSucceeded);
        serverStream.close(Status.UNKNOWN, new Metadata());
        Assert.assertNotNull((Object)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Channelz.TransportStats serverAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)1L, (long)serverAfter.streamsFailed);
        Assert.assertEquals((long)0L, (long)serverAfter.streamsSucceeded);
        Channelz.TransportStats clientAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)1L, (long)clientAfter.streamsFailed);
        Assert.assertEquals((long)0L, (long)clientAfter.streamsSucceeded);
        this.client.shutdown(Status.UNAVAILABLE);
    }

    @Test
    public void transportTracer_client_streamEnded_nonOk() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        if (!this.haveTransportTracer()) {
            return;
        }
        Channelz.TransportStats serverBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)0L, (long)serverBefore.streamsFailed);
        Assert.assertEquals((long)0L, (long)serverBefore.streamsSucceeded);
        Channelz.TransportStats clientBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)0L, (long)clientBefore.streamsFailed);
        Assert.assertEquals((long)0L, (long)clientBefore.streamsSucceeded);
        clientStream.cancel(Status.UNKNOWN);
        Assert.assertNotNull((Object)serverStreamCreation.listener.status.get(1000L, TimeUnit.MILLISECONDS));
        Channelz.TransportStats serverAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)1L, (long)serverAfter.streamsFailed);
        Assert.assertEquals((long)0L, (long)serverAfter.streamsSucceeded);
        Channelz.TransportStats clientAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)1L, (long)clientAfter.streamsFailed);
        Assert.assertEquals((long)0L, (long)clientAfter.streamsSucceeded);
    }

    @Test
    public void transportTracer_server_receive_msg() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        if (!this.haveTransportTracer()) {
            return;
        }
        Channelz.TransportStats serverBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)0L, (long)serverBefore.messagesReceived);
        Assert.assertEquals((long)0L, (long)serverBefore.lastMessageReceivedTimeNanos);
        Channelz.TransportStats clientBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)0L, (long)clientBefore.messagesSent);
        Assert.assertEquals((long)0L, (long)clientBefore.lastMessageSentTimeNanos);
        serverStream.request(1);
        clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)"request"));
        clientStream.flush();
        clientStream.halfClose();
        this.verifyMessageCountAndClose(serverStreamListener.messageQueue, 1);
        Channelz.TransportStats serverAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)1L, (long)serverAfter.messagesReceived);
        long serverTimestamp = TimeUnit.NANOSECONDS.toMillis(serverAfter.lastMessageReceivedTimeNanos);
        Assert.assertEquals((long)this.currentTimeMillis(), (long)serverTimestamp);
        Channelz.TransportStats clientAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)1L, (long)clientAfter.messagesSent);
        long clientTimestamp = TimeUnit.NANOSECONDS.toMillis(clientAfter.lastMessageSentTimeNanos);
        Assert.assertEquals((long)this.currentTimeMillis(), (long)clientTimestamp);
        serverStream.close(Status.OK, new Metadata());
    }

    @Test
    public void transportTracer_server_send_msg() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(this.client.start(this.mockClientTransportListener));
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        if (!this.haveTransportTracer()) {
            return;
        }
        Channelz.TransportStats serverBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)0L, (long)serverBefore.messagesSent);
        Assert.assertEquals((long)0L, (long)serverBefore.lastMessageSentTimeNanos);
        Channelz.TransportStats clientBefore = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)0L, (long)clientBefore.messagesReceived);
        Assert.assertEquals((long)0L, (long)clientBefore.lastMessageReceivedTimeNanos);
        clientStream.request(1);
        serverStream.writeHeaders(new Metadata());
        serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)"response"));
        serverStream.flush();
        this.verifyMessageCountAndClose(clientStreamListener.messageQueue, 1);
        Channelz.TransportStats serverAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)serverTransportListener.transport);
        Assert.assertEquals((long)1L, (long)serverAfter.messagesSent);
        long serverTimestmap = TimeUnit.NANOSECONDS.toMillis(serverAfter.lastMessageSentTimeNanos);
        Assert.assertEquals((long)this.currentTimeMillis(), (long)serverTimestmap);
        Channelz.TransportStats clientAfter = AbstractTransportTest.getTransportStats((Instrumented<Channelz.SocketStats>)this.client);
        Assert.assertEquals((long)1L, (long)clientAfter.messagesReceived);
        long clientTimestmap = TimeUnit.NANOSECONDS.toMillis(clientAfter.lastMessageReceivedTimeNanos);
        Assert.assertEquals((long)this.currentTimeMillis(), (long)clientTimestmap);
        serverStream.close(Status.OK, new Metadata());
    }

    @Test
    public void socketStats_addresses() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        ManagedClientTransport client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(client.start((ManagedClientTransport.Listener)Mockito.mock(ManagedClientTransport.Listener.class)));
        ClientStream clientStream = client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        InetSocketAddress serverAddress = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), this.server.getPort());
        SocketAddress clientAddress = (SocketAddress)serverStream.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
        Channelz.SocketStats clientSocketStats = (Channelz.SocketStats)client.getStats().get();
        Assert.assertEquals((Object)clientAddress, (Object)clientSocketStats.local);
        Assert.assertEquals((Object)serverAddress, (Object)clientSocketStats.remote);
        Channelz.SocketStats serverSocketStats = (Channelz.SocketStats)serverTransportListener.transport.getStats().get();
        Assert.assertEquals((Object)serverAddress, (Object)serverSocketStats.local);
        Assert.assertEquals((Object)clientAddress, (Object)serverSocketStats.remote);
    }

    private void doPingPong(MockServerListener serverListener) throws Exception {
        ManagedClientTransport client = this.newClientTransport(this.server);
        AbstractTransportTest.runIfNotNull(client.start((ManagedClientTransport.Listener)Mockito.mock(ManagedClientTransport.Listener.class)));
        ClientStream clientStream = client.newStream(this.methodDescriptor, new Metadata(), this.callOptions);
        ClientStreamListenerBase clientStreamListener = new ClientStreamListenerBase();
        clientStream.start((ClientStreamListener)clientStreamListener);
        MockServerTransportListener serverTransportListener = serverListener.takeListenerOrFail(1000L, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(1000L, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListenerBase serverStreamListener = serverStreamCreation.listener;
        serverStream.close(Status.OK, new Metadata());
        Assert.assertNotNull((Object)clientStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)clientStreamListener.trailers.get(1000L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull((Object)serverStreamListener.status.get(1000L, TimeUnit.MILLISECONDS));
        client.shutdown(Status.UNAVAILABLE);
    }

    private static void assertCodeEquals(String message, Status expected, Status actual) {
        if (expected == null) {
            Assert.fail((String)"expected should not be null");
        }
        if (actual == null || !expected.getCode().equals((Object)actual.getCode())) {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
        }
    }

    private static void assertCodeEquals(Status expected, Status actual) {
        AbstractTransportTest.assertCodeEquals(null, expected, actual);
    }

    private static void assertStatusEquals(Status expected, Status actual) {
        if (expected == null) {
            Assert.fail((String)"expected should not be null");
        }
        if (!(actual != null && expected.getCode().equals((Object)actual.getCode()) && Objects.equal((Object)expected.getDescription(), (Object)actual.getDescription()) && Objects.equal((Object)expected.getCause(), (Object)actual.getCause()))) {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    private static boolean waitForFuture(Future<?> future, long timeout, TimeUnit unit) throws InterruptedException {
        try {
            future.get(timeout, unit);
        }
        catch (ExecutionException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (TimeoutException ex) {
            return false;
        }
        return true;
    }

    private static void runIfNotNull(Runnable runnable) {
        if (runnable != null) {
            runnable.run();
        }
    }

    private static Channelz.TransportStats getTransportStats(Instrumented<Channelz.SocketStats> socket) throws ExecutionException, InterruptedException {
        return ((Channelz.SocketStats)socket.getStats().get()).data;
    }

    private static class StringBinaryMarshaller
    implements Metadata.BinaryMarshaller<String> {
        public static final StringBinaryMarshaller INSTANCE = new StringBinaryMarshaller();

        private StringBinaryMarshaller() {
        }

        public byte[] toBytes(String value) {
            return value.getBytes(Charsets.UTF_8);
        }

        public String parseBytes(byte[] serialized) {
            return new String(serialized, Charsets.UTF_8);
        }
    }

    private static class StringMarshaller
    implements MethodDescriptor.Marshaller<String> {
        public static final StringMarshaller INSTANCE = new StringMarshaller();

        private StringMarshaller() {
        }

        public InputStream stream(String value) {
            return new ByteArrayInputStream(value.getBytes(Charsets.UTF_8));
        }

        public String parse(InputStream stream) {
            try {
                return new String(IoUtils.toByteArray((InputStream)stream), Charsets.UTF_8);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class StreamCreation {
        public final ServerStream stream;
        public final String method;
        public final Metadata headers;
        public final ServerStreamListenerBase listener;

        public StreamCreation(ServerStream stream, String method, Metadata headers, ServerStreamListenerBase listener) {
            this.stream = stream;
            this.method = method;
            this.headers = headers;
            this.listener = listener;
        }
    }

    private static class ClientStreamListenerBase
    implements ClientStreamListener {
        private final BlockingQueue<InputStream> messageQueue = new LinkedBlockingQueue<InputStream>();
        private final CountDownLatch onReadyLatch = new CountDownLatch(1);
        private final SettableFuture<Metadata> headers = SettableFuture.create();
        private final SettableFuture<Metadata> trailers = SettableFuture.create();
        private final SettableFuture<Status> status = SettableFuture.create();

        private ClientStreamListenerBase() {
        }

        private boolean awaitOnReady(int timeout, TimeUnit unit) throws Exception {
            return this.onReadyLatch.await(timeout, unit);
        }

        public void messagesAvailable(StreamListener.MessageProducer producer) {
            InputStream message;
            if (this.status.isDone()) {
                Assert.fail((String)"messagesAvailable invoked after closed");
            }
            while ((message = producer.next()) != null) {
                this.messageQueue.add(message);
            }
        }

        public void onReady() {
            if (this.status.isDone()) {
                Assert.fail((String)"onReady invoked after closed");
            }
            this.onReadyLatch.countDown();
        }

        public void headersRead(Metadata headers) {
            if (this.status.isDone()) {
                Assert.fail((String)"headersRead invoked after closed");
            }
            this.headers.set((Object)headers);
        }

        public void closed(Status status, Metadata trailers) {
            this.closed(status, ClientStreamListener.RpcProgress.PROCESSED, trailers);
        }

        public void closed(Status status, ClientStreamListener.RpcProgress rpcProgress, Metadata trailers) {
            if (this.status.isDone()) {
                Assert.fail((String)"headersRead invoked after closed");
            }
            this.status.set((Object)status);
            this.trailers.set((Object)trailers);
        }
    }

    private static class ServerStreamListenerBase
    implements ServerStreamListener {
        private final BlockingQueue<InputStream> messageQueue = new LinkedBlockingQueue<InputStream>();
        private final CountDownLatch onReadyLatch = new CountDownLatch(1);
        private final CountDownLatch halfClosedLatch = new CountDownLatch(1);
        private final SettableFuture<Status> status = SettableFuture.create();

        private ServerStreamListenerBase() {
        }

        private boolean awaitOnReady(int timeout, TimeUnit unit) throws Exception {
            return this.onReadyLatch.await(timeout, unit);
        }

        private boolean awaitHalfClosed(int timeout, TimeUnit unit) throws Exception {
            return this.halfClosedLatch.await(timeout, unit);
        }

        public void messagesAvailable(StreamListener.MessageProducer producer) {
            InputStream message;
            if (this.status.isDone()) {
                Assert.fail((String)"messagesAvailable invoked after closed");
            }
            while ((message = producer.next()) != null) {
                this.messageQueue.add(message);
            }
        }

        public void onReady() {
            if (this.status.isDone()) {
                Assert.fail((String)"onReady invoked after closed");
            }
            this.onReadyLatch.countDown();
        }

        public void halfClosed() {
            if (this.status.isDone()) {
                Assert.fail((String)"halfClosed invoked after closed");
            }
            this.halfClosedLatch.countDown();
        }

        public void closed(Status status) {
            if (this.status.isDone()) {
                Assert.fail((String)"closed invoked more than once");
            }
            this.status.set((Object)status);
        }
    }

    private static class MockServerTransportListener
    implements ServerTransportListener {
        public final ServerTransport transport;
        public final BlockingQueue<StreamCreation> streams = new LinkedBlockingQueue<StreamCreation>();
        private final SettableFuture<?> terminated = SettableFuture.create();

        public MockServerTransportListener(ServerTransport transport) {
            this.transport = transport;
        }

        public void streamCreated(ServerStream stream, String method, Metadata headers) {
            ServerStreamListenerBase listener = new ServerStreamListenerBase();
            this.streams.add(new StreamCreation(stream, method, headers, listener));
            stream.setListener((ServerStreamListener)listener);
        }

        public Attributes transportReady(Attributes attributes) {
            return Attributes.newBuilder().setAll(attributes).set(ADDITIONAL_TRANSPORT_ATTR_KEY, (Object)"additional attribute value").build();
        }

        public void transportTerminated() {
            Assert.assertTrue((boolean)this.terminated.set(null));
        }

        public boolean waitForTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return AbstractTransportTest.waitForFuture(this.terminated, timeout, unit);
        }

        public boolean isTerminated() {
            return this.terminated.isDone();
        }

        public StreamCreation takeStreamOrFail(long timeout, TimeUnit unit) throws InterruptedException {
            StreamCreation stream = this.streams.poll(timeout, unit);
            if (stream == null) {
                Assert.fail((String)"Timed out waiting for server stream");
            }
            return stream;
        }
    }

    private static class MockServerListener
    implements ServerListener {
        public final BlockingQueue<MockServerTransportListener> listeners = new LinkedBlockingQueue<MockServerTransportListener>();
        private final SettableFuture<?> shutdown = SettableFuture.create();

        private MockServerListener() {
        }

        public ServerTransportListener transportCreated(ServerTransport transport) {
            MockServerTransportListener listener = new MockServerTransportListener(transport);
            this.listeners.add(listener);
            return listener;
        }

        public void serverShutdown() {
            Assert.assertTrue((boolean)this.shutdown.set(null));
        }

        public boolean waitForShutdown(long timeout, TimeUnit unit) throws InterruptedException {
            return AbstractTransportTest.waitForFuture(this.shutdown, timeout, unit);
        }

        public MockServerTransportListener takeListenerOrFail(long timeout, TimeUnit unit) throws InterruptedException {
            MockServerTransportListener listener = this.listeners.poll(timeout, unit);
            if (listener == null) {
                Assert.fail((String)"Timed out waiting for server transport");
            }
            return listener;
        }
    }
}

