/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a.internal.handshaker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.s2a.proto.v2.S2AServiceGrpc;
import io.grpc.Channel;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerAdapter;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import io.grpc.s2a.internal.handshaker.S2AIdentity;
import io.grpc.s2a.internal.handshaker.S2AStub;
import io.grpc.s2a.internal.handshaker.SslContextFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;

@ThreadSafe
public final class S2AProtocolNegotiatorFactory {
    @VisibleForTesting
    static final int DEFAULT_PORT = 443;
    private static final AsciiString SCHEME = AsciiString.of((CharSequence)"https");

    public static InternalProtocolNegotiator.ClientFactory createClientFactory(@Nullable S2AIdentity localIdentity, ObjectPool<Channel> s2aChannelPool, @Nullable S2AStub stub) {
        Preconditions.checkNotNull(s2aChannelPool, (Object)"S2A channel pool should not be null.");
        return new S2AClientProtocolNegotiatorFactory(localIdentity, s2aChannelPool, stub);
    }

    private S2AProtocolNegotiatorFactory() {
    }

    private static final class S2AProtocolNegotiationHandler
    extends InternalProtocolNegotiators.ProtocolNegotiationHandler {
        @Nullable
        private final Channel channel;
        private final Optional<S2AIdentity> localIdentity;
        private final String hostname;
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final ListeningExecutorService service;
        @Nullable
        private final S2AStub stub;

        private S2AProtocolNegotiationHandler(GrpcHttp2ConnectionHandler grpcHandler, Channel channel, Optional<S2AIdentity> localIdentity, String hostname, ListeningExecutorService service, @Nullable S2AStub stub) {
            super((ChannelHandler)new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }, grpcHandler.getNegotiationLogger());
            this.grpcHandler = grpcHandler;
            this.channel = channel;
            this.localIdentity = localIdentity;
            this.hostname = hostname;
            Preconditions.checkNotNull((Object)service, (Object)"service should not be null.");
            this.service = service;
            this.stub = stub;
        }

        protected void handlerAdded0(final ChannelHandlerContext ctx) {
            S2AStub s2aStub;
            final BufferReadsHandler bufferReads = new BufferReadsHandler();
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)bufferReads);
            if (this.stub == null) {
                Preconditions.checkNotNull((Object)this.channel, (Object)"Channel to S2A should not be null");
                s2aStub = S2AStub.newInstance(S2AServiceGrpc.newStub((Channel)this.channel));
            } else {
                s2aStub = this.stub;
            }
            ListenableFuture sslContextFuture = this.service.submit(() -> SslContextFactory.createForClient(s2aStub, this.hostname, this.localIdentity));
            Futures.addCallback((ListenableFuture)sslContextFuture, (FutureCallback)new FutureCallback<SslContext>(){

                public void onSuccess(SslContext sslContext) {
                    ChannelHandler handler = InternalProtocolNegotiators.tls((SslContext)sslContext, (ObjectPool)SharedResourcePool.forResource((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR), (com.google.common.base.Optional)com.google.common.base.Optional.of((Object)new Runnable(){

                        @Override
                        public void run() {
                            s2aStub.close();
                        }
                    })).newHandler(grpcHandler);
                    ctx.pipeline().addAfter(ctx.name(), null, handler);
                    this.fireProtocolNegotiationEvent(ctx);
                    ctx.pipeline().remove((ChannelHandler)bufferReads);
                }

                public void onFailure(Throwable t) {
                    ctx.fireExceptionCaught(t);
                }
            }, (Executor)this.service);
        }
    }

    @VisibleForTesting
    static class BufferReadsHandler
    extends ChannelInboundHandlerAdapter {
        private final List<Object> reads = new ArrayList<Object>();
        private boolean readComplete;

        BufferReadsHandler() {
        }

        public List<Object> getReads() {
            return this.reads;
        }

        public void channelRead(ChannelHandlerContext unused, Object msg) {
            this.reads.add(msg);
        }

        public void channelReadComplete(ChannelHandlerContext unused) {
            this.readComplete = true;
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            for (Object msg : this.reads) {
                super.channelRead(ctx, msg);
            }
            if (this.readComplete) {
                super.channelReadComplete(ctx);
            }
        }
    }

    @VisibleForTesting
    static final class S2AProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final ObjectPool<Channel> channelPool;
        @Nullable
        private Channel channel = null;
        private final Optional<S2AIdentity> localIdentity;
        @Nullable
        private final S2AStub stub;
        private final ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1));

        static S2AProtocolNegotiator createForClient(ObjectPool<Channel> channelPool, @Nullable S2AIdentity localIdentity, @Nullable S2AStub stub) {
            Preconditions.checkNotNull(channelPool, (Object)"Channel pool should not be null.");
            if (localIdentity == null) {
                return new S2AProtocolNegotiator(channelPool, Optional.empty(), stub);
            }
            return new S2AProtocolNegotiator(channelPool, Optional.of(localIdentity), stub);
        }

        @Nullable
        @VisibleForTesting
        static String getHostNameFromAuthority(@Nullable String authority) {
            if (authority == null) {
                return null;
            }
            return HostAndPort.fromString((String)authority).getHost();
        }

        private S2AProtocolNegotiator(ObjectPool<Channel> channelPool, Optional<S2AIdentity> localIdentity, @Nullable S2AStub stub) {
            this.channelPool = channelPool;
            this.localIdentity = localIdentity;
            this.stub = stub;
            if (this.stub == null) {
                this.channel = (Channel)channelPool.getObject();
            }
        }

        public AsciiString scheme() {
            return SCHEME;
        }

        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            Preconditions.checkNotNull((Object)grpcHandler, (Object)"grpcHandler should not be null.");
            String hostname = S2AProtocolNegotiator.getHostNameFromAuthority(grpcHandler.getAuthority());
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)hostname) ? 1 : 0) != 0, (Object)"hostname should not be null or empty.");
            return new S2AProtocolNegotiationHandler(grpcHandler, this.channel, this.localIdentity, hostname, this.service, this.stub);
        }

        public void close() {
            this.service.shutdown();
            if (this.channel != null) {
                this.channelPool.returnObject((Object)this.channel);
            }
        }
    }

    static final class S2AClientProtocolNegotiatorFactory
    implements InternalProtocolNegotiator.ClientFactory {
        @Nullable
        private final S2AIdentity localIdentity;
        private final ObjectPool<Channel> channelPool;
        @Nullable
        private final S2AStub stub;

        S2AClientProtocolNegotiatorFactory(@Nullable S2AIdentity localIdentity, ObjectPool<Channel> channelPool, @Nullable S2AStub stub) {
            this.localIdentity = localIdentity;
            this.channelPool = channelPool;
            this.stub = stub;
        }

        public InternalProtocolNegotiator.ProtocolNegotiator newNegotiator() {
            return S2AProtocolNegotiator.createForClient(this.channelPool, this.localIdentity, this.stub);
        }

        public int getDefaultPort() {
            return 443;
        }
    }
}

