/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a.internal.handshaker;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.s2a.proto.v2.Identity;

@ThreadSafe
public final class S2AIdentity {
    private final Identity identity;

    public static S2AIdentity fromSpiffeId(String spiffeId) {
        Preconditions.checkNotNull((Object)spiffeId);
        return new S2AIdentity(Identity.newBuilder().setSpiffeId(spiffeId).build());
    }

    public static S2AIdentity fromHostname(String hostname) {
        Preconditions.checkNotNull((Object)hostname);
        return new S2AIdentity(Identity.newBuilder().setHostname(hostname).build());
    }

    public static S2AIdentity fromUid(String uid) {
        Preconditions.checkNotNull((Object)uid);
        return new S2AIdentity(Identity.newBuilder().setUid(uid).build());
    }

    public static S2AIdentity fromIdentity(Identity identity) {
        return new S2AIdentity(identity == null ? Identity.getDefaultInstance() : identity);
    }

    private S2AIdentity(Identity identity) {
        this.identity = identity;
    }

    public Identity getIdentity() {
        return this.identity;
    }
}

