/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.Http2ClientStream;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import io.grpc.okhttp.AsyncFrameWriter;
import io.grpc.okhttp.Headers;
import io.grpc.okhttp.OkHttpClientTransport;
import io.grpc.okhttp.OkHttpReadableBuffer;
import io.grpc.okhttp.OkHttpWritableBuffer;
import io.grpc.okhttp.OkHttpWritableBufferAllocator;
import io.grpc.okhttp.OutboundFlowController;
import io.grpc.okhttp.Utils;
import io.grpc.okhttp.internal.framed.ErrorCode;
import io.grpc.okhttp.internal.framed.Header;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;
import okio.Buffer;

class OkHttpClientStream
extends Http2ClientStream {
    private static final int WINDOW_UPDATE_THRESHOLD = Short.MAX_VALUE;
    private static final Buffer EMPTY_BUFFER = new Buffer();
    @GuardedBy(value="lock")
    private int window = 65535;
    @GuardedBy(value="lock")
    private int processedWindow = 65535;
    private final MethodDescriptor<?, ?> method;
    private Metadata headers;
    private final AsyncFrameWriter frameWriter;
    private final OutboundFlowController outboundFlow;
    private final OkHttpClientTransport transport;
    private final Object lock;
    private final String userAgent;
    private final StatsTraceContext statsTraceCtx;
    private String authority;
    private Object outboundFlowState;
    private volatile int id = -1;
    @GuardedBy(value="lock")
    private List<Header> requestHeaders;
    @GuardedBy(value="lock")
    private Queue<PendingData> pendingData = new ArrayDeque<PendingData>();
    @GuardedBy(value="lock")
    private boolean cancelSent = false;

    OkHttpClientStream(MethodDescriptor<?, ?> method, Metadata headers, AsyncFrameWriter frameWriter, OkHttpClientTransport transport, OutboundFlowController outboundFlow, Object lock, int maxMessageSize, String authority, String userAgent, StatsTraceContext statsTraceCtx) {
        super((WritableBufferAllocator)new OkHttpWritableBufferAllocator(), maxMessageSize, statsTraceCtx);
        this.statsTraceCtx = (StatsTraceContext)Preconditions.checkNotNull((Object)statsTraceCtx, (Object)"statsTraceCtx");
        this.method = method;
        this.headers = headers;
        this.frameWriter = frameWriter;
        this.transport = transport;
        this.outboundFlow = outboundFlow;
        this.lock = lock;
        this.authority = authority;
        this.userAgent = userAgent;
    }

    public MethodDescriptor.MethodType getType() {
        return this.method.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(int numMessages) {
        Object object = this.lock;
        synchronized (object) {
            this.requestMessagesFromDeframer(numMessages);
        }
    }

    public int id() {
        return this.id;
    }

    public void setAuthority(String authority) {
        Preconditions.checkState((this.listener() == null ? 1 : 0) != 0, (Object)"must be call before start");
        this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
    }

    public Attributes getAttributes() {
        return Attributes.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClientStreamListener listener) {
        super.start(listener);
        String defaultPath = "/" + this.method.getFullMethodName();
        this.headers.discardAll(GrpcUtil.USER_AGENT_KEY);
        List<Header> requestHeaders = Headers.createRequestHeaders(this.headers, defaultPath, this.authority, this.userAgent);
        this.headers = null;
        Object object = this.lock;
        synchronized (object) {
            this.requestHeaders = requestHeaders;
            this.transport.streamReadyToStart(this);
        }
    }

    @GuardedBy(value="lock")
    public void start(int id) {
        Preconditions.checkState((this.id == -1 ? 1 : 0) != 0, (String)"the stream has been started with id %s", (Object[])new Object[]{this.id});
        this.id = id;
        if (this.pendingData != null) {
            this.frameWriter.synStream(false, false, id, 0, this.requestHeaders);
            this.statsTraceCtx.clientOutboundHeaders();
            this.requestHeaders = null;
            boolean flush = false;
            while (!this.pendingData.isEmpty()) {
                PendingData data = this.pendingData.poll();
                this.outboundFlow.data(data.endOfStream, id, data.buffer, false);
                if (!data.flush) continue;
                flush = true;
            }
            if (flush) {
                this.outboundFlow.flush();
            }
            this.pendingData = null;
        }
    }

    public void allocated() {
        this.onStreamAllocated();
    }

    void onStreamSentBytes(int numBytes) {
        this.onSentBytes(numBytes);
    }

    @GuardedBy(value="lock")
    public void transportHeadersReceived(List<Header> headers, boolean endOfStream) {
        if (endOfStream) {
            this.transportTrailersReceived(Utils.convertTrailers(headers));
        } else {
            this.transportHeadersReceived(Utils.convertHeaders(headers));
        }
    }

    @GuardedBy(value="lock")
    public void transportDataReceived(Buffer frame, boolean endOfStream) {
        long length = frame.size();
        this.window = (int)((long)this.window - length);
        if (this.window < 0) {
            this.frameWriter.rstStream(this.id(), ErrorCode.FLOW_CONTROL_ERROR);
            this.transport.finishStream(this.id(), Status.INTERNAL.withDescription("Received data size exceeded our receiving window size"), null);
            return;
        }
        super.transportDataReceived((ReadableBuffer)new OkHttpReadableBuffer(frame), endOfStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        Buffer buffer;
        if (frame == null) {
            buffer = EMPTY_BUFFER;
        } else {
            buffer = ((OkHttpWritableBuffer)frame).buffer();
            int size = (int)buffer.size();
            if (size > 0) {
                this.onSendingBytes(size);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelSent) {
                return;
            }
            if (this.pendingData != null) {
                this.pendingData.add(new PendingData(buffer, endOfStream, flush));
            } else {
                Preconditions.checkState((this.id() != -1 ? 1 : 0) != 0, (Object)"streamId should be set");
                this.outboundFlow.data(endOfStream, this.id(), buffer, flush);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void returnProcessedBytes(int processedBytes) {
        Object object = this.lock;
        synchronized (object) {
            this.processedWindow -= processedBytes;
            if (this.processedWindow <= Short.MAX_VALUE) {
                int delta = 65535 - this.processedWindow;
                this.window += delta;
                this.processedWindow += delta;
                this.frameWriter.windowUpdate(this.id(), delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCancel(Status reason) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cancelSent) {
                return;
            }
            this.cancelSent = true;
            if (this.pendingData != null) {
                this.transport.removePendingStream(this);
                this.requestHeaders = null;
                for (PendingData data : this.pendingData) {
                    data.buffer.clear();
                }
                this.pendingData = null;
                this.transportReportStatus(reason, true, new Metadata());
            } else {
                this.transport.finishStream(this.id(), reason, ErrorCode.CANCEL);
            }
        }
    }

    public void remoteEndClosed() {
        super.remoteEndClosed();
        if (this.canSend()) {
            this.frameWriter.rstStream(this.id(), ErrorCode.CANCEL);
        }
        this.transport.finishStream(this.id(), null, null);
    }

    void setOutboundFlowState(Object outboundFlowState) {
        this.outboundFlowState = outboundFlowState;
    }

    Object getOutboundFlowState() {
        return this.outboundFlowState;
    }

    private static class PendingData {
        Buffer buffer;
        boolean endOfStream;
        boolean flush;

        PendingData(Buffer buffer, boolean endOfStream, boolean flush) {
            this.buffer = buffer;
            this.endOfStream = endOfStream;
            this.flush = flush;
        }
    }
}

