/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.okhttp.OkHttpProtocolNegotiator;
import io.grpc.okhttp.internal.ConnectionSpec;
import io.grpc.okhttp.internal.OkHostnameVerifier;
import io.grpc.okhttp.internal.Protocol;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

final class OkHttpTlsUpgrader {
    @VisibleForTesting
    static final List<Protocol> TLS_PROTOCOLS = Collections.unmodifiableList(Arrays.asList(Protocol.GRPC_EXP, Protocol.HTTP_2));

    OkHttpTlsUpgrader() {
    }

    public static SSLSocket upgrade(SSLSocketFactory sslSocketFactory, Socket socket, String host, int port, ConnectionSpec spec) throws IOException {
        Preconditions.checkNotNull((Object)sslSocketFactory, (Object)"sslSocketFactory");
        Preconditions.checkNotNull((Object)socket, (Object)"socket");
        Preconditions.checkNotNull((Object)spec, (Object)"spec");
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, host, port, true);
        spec.apply(sslSocket, false);
        String negotiatedProtocol = OkHttpProtocolNegotiator.get().negotiate(sslSocket, host, spec.supportsTlsExtensions() ? TLS_PROTOCOLS : null);
        Preconditions.checkState((boolean)TLS_PROTOCOLS.contains((Object)Protocol.get(negotiatedProtocol)), (String)("Only " + TLS_PROTOCOLS + " are supported, but negotiated protocol is %s"), (Object)negotiatedProtocol);
        if (!OkHostnameVerifier.INSTANCE.verify(host, sslSocket.getSession())) {
            throw new SSLPeerUnverifiedException("Cannot verify hostname: " + host);
        }
        return sslSocket;
    }
}

