/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.base.Preconditions;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.FrameWriter;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.Settings;
import io.grpc.internal.SerializingExecutor;
import io.grpc.okhttp.OkHttpClientTransport;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.Buffer;

class AsyncFrameWriter
implements FrameWriter {
    private static final Logger log = Logger.getLogger(OkHttpClientTransport.class.getName());
    private FrameWriter frameWriter;
    private Socket socket;
    private final SerializingExecutor executor;
    private final OkHttpClientTransport transport;

    public AsyncFrameWriter(OkHttpClientTransport transport, SerializingExecutor executor) {
        this.transport = transport;
        this.executor = executor;
    }

    void becomeConnected(FrameWriter frameWriter, Socket socket) {
        Preconditions.checkState((this.frameWriter == null ? 1 : 0) != 0, (Object)"AsyncFrameWriter's setFrameWriter() should only be called once.");
        this.frameWriter = (FrameWriter)Preconditions.checkNotNull((Object)frameWriter);
        this.socket = (Socket)Preconditions.checkNotNull((Object)socket);
    }

    public void connectionPreface() {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.connectionPreface();
            }
        });
    }

    public void ackSettings(final Settings peerSettings) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.ackSettings(peerSettings);
            }
        });
    }

    public void pushPromise(final int streamId, final int promisedStreamId, final List<Header> requestHeaders) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.pushPromise(streamId, promisedStreamId, requestHeaders);
            }
        });
    }

    public void flush() {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.flush();
            }
        });
    }

    public void synStream(final boolean outFinished, final boolean inFinished, final int streamId, final int associatedStreamId, final List<Header> headerBlock) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.synStream(outFinished, inFinished, streamId, associatedStreamId, headerBlock);
            }
        });
    }

    public void synReply(final boolean outFinished, final int streamId, final List<Header> headerBlock) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.synReply(outFinished, streamId, headerBlock);
            }
        });
    }

    public void headers(final int streamId, final List<Header> headerBlock) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.headers(streamId, headerBlock);
            }
        });
    }

    public void rstStream(final int streamId, final ErrorCode errorCode) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.rstStream(streamId, errorCode);
            }
        });
    }

    public void data(final boolean outFinished, final int streamId, final Buffer source, final int byteCount) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.data(outFinished, streamId, source, byteCount);
            }
        });
    }

    public void settings(final Settings okHttpSettings) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.settings(okHttpSettings);
            }
        });
    }

    public void ping(final boolean ack, final int payload1, final int payload2) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.ping(ack, payload1, payload2);
            }
        });
    }

    public void goAway(final int lastGoodStreamId, final ErrorCode errorCode, final byte[] debugData) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.goAway(lastGoodStreamId, errorCode, debugData);
                AsyncFrameWriter.this.frameWriter.flush();
            }
        });
    }

    public void windowUpdate(final int streamId, final long windowSizeIncrement) {
        this.executor.execute((Runnable)new WriteRunnable(){

            @Override
            public void doRun() throws IOException {
                AsyncFrameWriter.this.frameWriter.windowUpdate(streamId, windowSizeIncrement);
            }
        });
    }

    public void close() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (AsyncFrameWriter.this.frameWriter != null) {
                    try {
                        AsyncFrameWriter.this.frameWriter.close();
                        AsyncFrameWriter.this.socket.close();
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Failed closing connection", e);
                    }
                }
            }
        });
    }

    public int maxDataLength() {
        return this.frameWriter == null ? 16384 : this.frameWriter.maxDataLength();
    }

    private abstract class WriteRunnable
    implements Runnable {
        private WriteRunnable() {
        }

        @Override
        public final void run() {
            try {
                if (AsyncFrameWriter.this.frameWriter == null) {
                    throw new IOException("Unable to perform write due to unavailable frameWriter.");
                }
                this.doRun();
            }
            catch (RuntimeException e) {
                AsyncFrameWriter.this.transport.onException(e);
                throw e;
            }
            catch (Exception e) {
                AsyncFrameWriter.this.transport.onException(e);
                throw new RuntimeException(e);
            }
        }

        public abstract void doRun() throws IOException;
    }
}

