/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.util.concurrent.SettableFuture;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.OkHttpTlsUpgrader;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.FrameReader;
import com.squareup.okhttp.internal.spdy.FrameWriter;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.HeadersMode;
import com.squareup.okhttp.internal.spdy.Http2;
import com.squareup.okhttp.internal.spdy.OkHttpSettingsUtil;
import com.squareup.okhttp.internal.spdy.Settings;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.Http2Ping;
import io.grpc.internal.HttpUtil;
import io.grpc.internal.SerializingExecutor;
import io.grpc.okhttp.AsyncFrameWriter;
import io.grpc.okhttp.Headers;
import io.grpc.okhttp.OkHttpClientStream;
import io.grpc.okhttp.OutboundFlowController;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.SSLSocketFactory;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;

class OkHttpClientTransport
implements ClientTransport {
    private static final Map<ErrorCode, Status> ERROR_CODE_TO_STATUS;
    private static final Logger log;
    private static final OkHttpClientStream[] EMPTY_STREAM_ARRAY;
    private final String host;
    private final int port;
    private final String authorityHost;
    private final String defaultAuthority;
    private final Random random = new Random();
    private final Ticker ticker;
    private ClientTransport.Listener listener;
    private FrameReader testFrameReader;
    private AsyncFrameWriter frameWriter;
    private OutboundFlowController outboundFlow;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int nextStreamId;
    @GuardedBy(value="lock")
    private final Map<Integer, OkHttpClientStream> streams = new HashMap<Integer, OkHttpClientStream>();
    private final Executor executor;
    private final SerializingExecutor serializingExecutor;
    private int connectionUnacknowledgedBytesRead;
    private ClientFrameHandler clientFrameHandler;
    @GuardedBy(value="lock")
    private boolean goAway;
    @GuardedBy(value="lock")
    private Status goAwayStatus;
    @GuardedBy(value="lock")
    private Http2Ping ping;
    @GuardedBy(value="lock")
    private boolean stopped;
    private SSLSocketFactory sslSocketFactory;
    private Socket socket;
    @GuardedBy(value="lock")
    private int maxConcurrentStreams = 0;
    @GuardedBy(value="lock")
    private LinkedList<OkHttpClientStream> pendingStreams = new LinkedList();
    private final ConnectionSpec connectionSpec;
    private FrameWriter testFrameWriter;
    Runnable connectingCallback;
    SettableFuture<Void> connectedFuture;

    OkHttpClientTransport(String host, int port, String authorityHost, Executor executor, @Nullable SSLSocketFactory sslSocketFactory, ConnectionSpec connectionSpec) {
        this.host = (String)Preconditions.checkNotNull((Object)host);
        this.port = port;
        this.authorityHost = authorityHost;
        this.defaultAuthority = authorityHost + ":" + port;
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.serializingExecutor = new SerializingExecutor(executor);
        this.nextStreamId = 3;
        this.sslSocketFactory = sslSocketFactory;
        this.connectionSpec = (ConnectionSpec)Preconditions.checkNotNull((Object)connectionSpec);
        this.ticker = Ticker.systemTicker();
    }

    @VisibleForTesting
    OkHttpClientTransport(Executor executor, FrameReader frameReader, FrameWriter testFrameWriter, int nextStreamId, Socket socket, Ticker ticker, @Nullable Runnable connectingCallback, SettableFuture<Void> connectedFuture) {
        this.host = null;
        this.port = 0;
        this.authorityHost = null;
        this.defaultAuthority = "notarealauthority:80";
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.serializingExecutor = new SerializingExecutor(executor);
        this.testFrameReader = (FrameReader)Preconditions.checkNotNull((Object)frameReader);
        this.testFrameWriter = (FrameWriter)Preconditions.checkNotNull((Object)testFrameWriter);
        this.socket = (Socket)Preconditions.checkNotNull((Object)socket);
        this.nextStreamId = nextStreamId;
        this.ticker = ticker;
        this.connectionSpec = null;
        this.connectingCallback = connectingCallback;
        this.connectedFuture = (SettableFuture)Preconditions.checkNotNull(connectedFuture);
    }

    private boolean isForTest() {
        return this.host == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(ClientTransport.PingCallback callback, Executor executor) {
        boolean writePing;
        Http2Ping p;
        Preconditions.checkState((this.frameWriter != null ? 1 : 0) != 0);
        long data = 0L;
        Object object = this.lock;
        synchronized (object) {
            if (this.stopped) {
                Http2Ping.notifyFailed((ClientTransport.PingCallback)callback, (Executor)executor, (Throwable)this.getPingFailure());
                return;
            }
            if (this.ping != null) {
                p = this.ping;
                writePing = false;
            } else {
                data = this.random.nextLong();
                p = this.ping = new Http2Ping(data, Stopwatch.createStarted((Ticker)this.ticker));
                writePing = true;
            }
        }
        if (writePing) {
            this.frameWriter.ping(false, (int)(data >>> 32), (int)data);
        }
        p.addCallback(callback, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OkHttpClientStream newStream(MethodDescriptor<?, ?> method, Metadata.Headers headers, ClientStreamListener listener) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        Preconditions.checkNotNull((Object)listener, (Object)"listener");
        String defaultPath = "/" + method.getFullMethodName();
        OkHttpClientStream clientStream = OkHttpClientStream.newStream(listener, this.frameWriter, this, this.outboundFlow, method.getType(), this.lock, Headers.createRequestHeaders(headers, defaultPath, this.defaultAuthority));
        Object object = this.lock;
        synchronized (object) {
            if (this.goAway) {
                clientStream.transportReportStatus(this.goAwayStatus, true, new Metadata.Trailers());
            } else if (this.streams.size() >= this.maxConcurrentStreams) {
                this.pendingStreams.add(clientStream);
            } else {
                this.startStream(clientStream);
            }
        }
        return clientStream;
    }

    @GuardedBy(value="lock")
    private void startStream(OkHttpClientStream stream) {
        Preconditions.checkState((stream.id() == null ? 1 : 0) != 0, (Object)"StreamId already assigned");
        this.streams.put(this.nextStreamId, stream);
        stream.start(this.nextStreamId);
        stream.allocated();
        if (stream.getType() != MethodDescriptor.MethodType.UNARY && stream.getType() != MethodDescriptor.MethodType.SERVER_STREAMING) {
            this.frameWriter.flush();
        }
        if (this.nextStreamId >= 0x7FFFFFFD) {
            this.nextStreamId = Integer.MAX_VALUE;
            this.onGoAway(Integer.MAX_VALUE, Status.INTERNAL.withDescription("Stream ids exhausted"));
        } else {
            this.nextStreamId += 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startPendingStreams() {
        boolean hasStreamStarted = false;
        Object object = this.lock;
        synchronized (object) {
            while (!this.pendingStreams.isEmpty() && this.streams.size() < this.maxConcurrentStreams) {
                OkHttpClientStream stream = this.pendingStreams.poll();
                this.startStream(stream);
                hasStreamStarted = true;
            }
        }
        return hasStreamStarted;
    }

    @GuardedBy(value="lock")
    void removePendingStream(OkHttpClientStream pendingStream) {
        this.pendingStreams.remove((Object)pendingStream);
    }

    public void start(ClientTransport.Listener listener) {
        this.listener = (ClientTransport.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.frameWriter = new AsyncFrameWriter(this, this.serializingExecutor);
        this.outboundFlow = new OutboundFlowController(this, this.frameWriter);
        this.serializingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedSink sink;
                BufferedSource source;
                Socket sock;
                if (OkHttpClientTransport.this.isForTest()) {
                    if (OkHttpClientTransport.this.connectingCallback != null) {
                        OkHttpClientTransport.this.connectingCallback.run();
                    }
                    OkHttpClientTransport.this.clientFrameHandler = new ClientFrameHandler(OkHttpClientTransport.this.testFrameReader);
                    OkHttpClientTransport.this.executor.execute(OkHttpClientTransport.this.clientFrameHandler);
                    Object object = OkHttpClientTransport.this.lock;
                    synchronized (object) {
                        OkHttpClientTransport.this.maxConcurrentStreams = Integer.MAX_VALUE;
                    }
                    OkHttpClientTransport.this.frameWriter.becomeConnected(OkHttpClientTransport.this.testFrameWriter, OkHttpClientTransport.this.socket);
                    OkHttpClientTransport.this.startPendingStreams();
                    OkHttpClientTransport.this.connectedFuture.set(null);
                    return;
                }
                try {
                    sock = new Socket(OkHttpClientTransport.this.host, OkHttpClientTransport.this.port);
                    if (OkHttpClientTransport.this.sslSocketFactory != null) {
                        sock = OkHttpTlsUpgrader.upgrade(OkHttpClientTransport.this.sslSocketFactory, sock, OkHttpClientTransport.this.authorityHost, OkHttpClientTransport.this.port, OkHttpClientTransport.this.connectionSpec);
                    }
                    sock.setTcpNoDelay(true);
                    source = Okio.buffer((Source)Okio.source((Socket)sock));
                    sink = Okio.buffer((Sink)Okio.sink((Socket)sock));
                }
                catch (IOException e) {
                    OkHttpClientTransport.this.onIoException(e);
                    throw new RuntimeException(e);
                }
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    if (OkHttpClientTransport.this.stopped) {
                        try {
                            sock.close();
                        }
                        catch (IOException e) {
                            log.log(Level.WARNING, "Failed closing socket", e);
                        }
                        return;
                    }
                    OkHttpClientTransport.this.socket = sock;
                    OkHttpClientTransport.this.maxConcurrentStreams = Integer.MAX_VALUE;
                }
                Http2 variant = new Http2();
                FrameWriter rawFrameWriter = variant.newWriter(sink, true);
                OkHttpClientTransport.this.frameWriter.becomeConnected(rawFrameWriter, OkHttpClientTransport.this.socket);
                try {
                    rawFrameWriter.connectionPreface();
                    Settings settings = new Settings();
                    rawFrameWriter.settings(settings);
                }
                catch (IOException e) {
                    OkHttpClientTransport.this.onIoException(e);
                    throw new RuntimeException(e);
                }
                OkHttpClientTransport.this.clientFrameHandler = new ClientFrameHandler(variant.newReader(source, true));
                Object object2 = OkHttpClientTransport.this.lock;
                synchronized (object2) {
                    OkHttpClientTransport.this.listener.transportReady();
                }
                OkHttpClientTransport.this.executor.execute(OkHttpClientTransport.this.clientFrameHandler);
                OkHttpClientTransport.this.startPendingStreams();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAway) {
                return;
            }
        }
        this.frameWriter.goAway(0, ErrorCode.NO_ERROR, new byte[0]);
        this.onGoAway(Integer.MAX_VALUE, Status.UNAVAILABLE.withDescription("Transport stopped"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OkHttpClientStream[] getActiveStreams() {
        Object object = this.lock;
        synchronized (object) {
            return this.streams.values().toArray(EMPTY_STREAM_ARRAY);
        }
    }

    @VisibleForTesting
    ClientFrameHandler getHandler() {
        return this.clientFrameHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getPendingStreamSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams.size();
        }
    }

    void onIoException(IOException failureCause) {
        log.log(Level.SEVERE, "Transport failed", failureCause);
        this.onGoAway(0, Status.INTERNAL.withCause((Throwable)failureCause));
    }

    private void onError(ErrorCode errorCode, String moreDetail) {
        this.frameWriter.goAway(0, errorCode, new byte[0]);
        this.onGoAway(0, OkHttpClientTransport.toGrpcStatus(errorCode).augmentDescription(moreDetail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onGoAway(int lastKnownStreamId, Status status) {
        boolean notifyShutdown;
        Object object = this.lock;
        synchronized (object) {
            notifyShutdown = !this.goAway;
            this.goAway = true;
            this.goAwayStatus = status;
            Iterator<Map.Entry<Integer, OkHttpClientStream>> it = this.streams.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, OkHttpClientStream> entry = it.next();
                if (entry.getKey() <= lastKnownStreamId) continue;
                it.remove();
                entry.getValue().transportReportStatus(status, false, new Metadata.Trailers());
            }
            for (OkHttpClientStream stream : this.pendingStreams) {
                stream.transportReportStatus(status, true, new Metadata.Trailers());
            }
            this.pendingStreams.clear();
        }
        if (notifyShutdown) {
            this.listener.transportShutdown(status);
        }
        this.stopIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishStream(int streamId, @Nullable Status status, @Nullable ErrorCode errorCode) {
        Object object = this.lock;
        synchronized (object) {
            OkHttpClientStream stream = this.streams.remove(streamId);
            if (stream != null) {
                if (errorCode != null) {
                    this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                }
                if (status != null) {
                    boolean isCancelled = status.getCode() == Status.Code.CANCELLED || status.getCode() == Status.Code.DEADLINE_EXCEEDED;
                    stream.transportReportStatus(status, isCancelled, new Metadata.Trailers());
                }
                if (!this.startPendingStreams()) {
                    this.stopIfNecessary();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopIfNecessary() {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAway && this.streams.size() == 0 && !this.stopped) {
                this.stopped = true;
                this.frameWriter.close();
                if (this.ping != null) {
                    this.ping.failed(this.getPingFailure());
                    this.ping = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable getPingFailure() {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus != null) {
                return this.goAwayStatus.asException();
            }
            return Status.UNAVAILABLE.withDescription("Connection closed").asException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mayHaveCreatedStream(int streamId) {
        Object object = this.lock;
        synchronized (object) {
            return streamId < this.nextStreamId && (streamId & 1) == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OkHttpClientStream getStream(int streamId) {
        Object object = this.lock;
        synchronized (object) {
            return this.streams.get(streamId);
        }
    }

    @VisibleForTesting
    static Status toGrpcStatus(ErrorCode code) {
        Status status = ERROR_CODE_TO_STATUS.get(code);
        return status != null ? status : Status.UNKNOWN.withDescription("Unknown http2 error code: " + code.httpCode);
    }

    static {
        log = Logger.getLogger(OkHttpClientTransport.class.getName());
        EMPTY_STREAM_ARRAY = new OkHttpClientStream[0];
        HashMap<ErrorCode, Status> errorToStatus = new HashMap<ErrorCode, Status>();
        errorToStatus.put(ErrorCode.NO_ERROR, Status.INTERNAL.withDescription("No error: A GRPC status of OK should have been sent"));
        errorToStatus.put(ErrorCode.PROTOCOL_ERROR, Status.INTERNAL.withDescription("Protocol error"));
        errorToStatus.put(ErrorCode.INTERNAL_ERROR, Status.INTERNAL.withDescription("Internal error"));
        errorToStatus.put(ErrorCode.FLOW_CONTROL_ERROR, Status.INTERNAL.withDescription("Flow control error"));
        errorToStatus.put(ErrorCode.STREAM_CLOSED, Status.INTERNAL.withDescription("Stream closed"));
        errorToStatus.put(ErrorCode.FRAME_TOO_LARGE, Status.INTERNAL.withDescription("Frame too large"));
        errorToStatus.put(ErrorCode.REFUSED_STREAM, Status.UNAVAILABLE.withDescription("Refused stream"));
        errorToStatus.put(ErrorCode.CANCEL, Status.CANCELLED.withDescription("Cancelled"));
        errorToStatus.put(ErrorCode.COMPRESSION_ERROR, Status.INTERNAL.withDescription("Compression error"));
        errorToStatus.put(ErrorCode.CONNECT_ERROR, Status.INTERNAL.withDescription("Connect error"));
        errorToStatus.put(ErrorCode.ENHANCE_YOUR_CALM, Status.RESOURCE_EXHAUSTED.withDescription("Enhance your calm"));
        errorToStatus.put(ErrorCode.INADEQUATE_SECURITY, Status.PERMISSION_DENIED.withDescription("Inadequate security"));
        ERROR_CODE_TO_STATUS = Collections.unmodifiableMap(errorToStatus);
    }

    @VisibleForTesting
    class ClientFrameHandler
    implements FrameReader.Handler,
    Runnable {
        FrameReader frameReader;

        ClientFrameHandler(FrameReader frameReader) {
            this.frameReader = frameReader;
        }

        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName("OkHttpClientTransport");
            try {
                while (this.frameReader.nextFrame((FrameReader.Handler)this)) {
                }
            }
            catch (IOException ioe) {
                OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, ioe.getMessage());
            }
            finally {
                try {
                    this.frameReader.close();
                }
                catch (IOException ex) {
                    log.log(Level.INFO, "Exception closing frame reader", ex);
                }
                OkHttpClientTransport.this.listener.transportTerminated();
                Thread.currentThread().setName(threadName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void data(boolean inFinished, int streamId, BufferedSource in, int length) throws IOException {
            OkHttpClientStream stream = OkHttpClientTransport.this.getStream(streamId);
            if (stream == null) {
                if (!OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received data for unknown stream: " + streamId);
                    return;
                }
                OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.INVALID_STREAM);
            } else {
                in.require((long)length);
                Buffer buf = new Buffer();
                buf.write(in.buffer(), (long)length);
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    stream.transportDataReceived(buf, inFinished);
                }
            }
            OkHttpClientTransport.this.connectionUnacknowledgedBytesRead = OkHttpClientTransport.this.connectionUnacknowledgedBytesRead + length;
            if (OkHttpClientTransport.this.connectionUnacknowledgedBytesRead >= Short.MAX_VALUE) {
                OkHttpClientTransport.this.frameWriter.windowUpdate(0, OkHttpClientTransport.this.connectionUnacknowledgedBytesRead);
                OkHttpClientTransport.this.connectionUnacknowledgedBytesRead = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock, HeadersMode headersMode) {
            boolean unknownStream = false;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                OkHttpClientStream stream = (OkHttpClientStream)((Object)OkHttpClientTransport.this.streams.get(streamId));
                if (stream == null) {
                    if (OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                        OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.INVALID_STREAM);
                    } else {
                        unknownStream = true;
                    }
                } else {
                    stream.transportHeadersReceived(headerBlock, inFinished);
                }
            }
            if (unknownStream) {
                OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received header for unknown stream: " + streamId);
            }
        }

        public void rstStream(int streamId, ErrorCode errorCode) {
            OkHttpClientTransport.this.finishStream(streamId, OkHttpClientTransport.toGrpcStatus(errorCode), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void settings(boolean clearPrevious, Settings settings) {
            Object object;
            if (OkHttpSettingsUtil.isSet(settings, 4)) {
                int receivedMaxConcurrentStreams = OkHttpSettingsUtil.get(settings, 4);
                object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.maxConcurrentStreams = receivedMaxConcurrentStreams;
                }
            }
            if (OkHttpSettingsUtil.isSet(settings, 7)) {
                int initialWindowSize = OkHttpSettingsUtil.get(settings, 7);
                object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.outboundFlow.initialOutboundWindowSize(initialWindowSize);
                }
            }
            OkHttpClientTransport.this.frameWriter.ackSettings(settings);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ping(boolean ack, int payload1, int payload2) {
            if (!ack) {
                OkHttpClientTransport.this.frameWriter.ping(true, payload1, payload2);
            } else {
                Http2Ping p = null;
                long ackPayload = (long)payload1 << 32 | (long)payload2 & 0xFFFFFFFFL;
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    if (OkHttpClientTransport.this.ping != null) {
                        if (OkHttpClientTransport.this.ping.payload() == ackPayload) {
                            p = OkHttpClientTransport.this.ping;
                            OkHttpClientTransport.this.ping = null;
                        } else {
                            log.log(Level.WARNING, String.format("Received unexpected ping ack. Expecting %d, got %d", OkHttpClientTransport.this.ping.payload(), ackPayload));
                        }
                    } else {
                        log.warning("Received unexpected ping ack. No ping outstanding");
                    }
                }
                if (p != null) {
                    p.complete();
                }
            }
        }

        public void ackSettings() {
        }

        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            Status status = HttpUtil.Http2Error.statusForCode((long)errorCode.httpCode);
            if (debugData != null && debugData.size() > 0) {
                status.augmentDescription(debugData.utf8());
            }
            OkHttpClientTransport.this.onGoAway(lastGoodStreamId, status);
        }

        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) throws IOException {
            OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.PROTOCOL_ERROR);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowUpdate(int streamId, long delta) {
            if (delta == 0L) {
                String errorMsg = "Received 0 flow control window increment.";
                if (streamId == 0) {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, errorMsg);
                } else {
                    OkHttpClientTransport.this.finishStream(streamId, Status.INTERNAL.withDescription(errorMsg), ErrorCode.PROTOCOL_ERROR);
                }
                return;
            }
            boolean unknownStream = false;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                if (streamId == 0) {
                    OkHttpClientTransport.this.outboundFlow.windowUpdate(null, (int)delta);
                    return;
                }
                OkHttpClientStream stream = (OkHttpClientStream)((Object)OkHttpClientTransport.this.streams.get(streamId));
                if (stream != null) {
                    OkHttpClientTransport.this.outboundFlow.windowUpdate(stream, (int)delta);
                } else if (!OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                    unknownStream = true;
                }
            }
            if (unknownStream) {
                OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received window_update for unknown stream: " + streamId);
            }
        }

        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        public void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
        }
    }
}

