/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.okhttp;

import com.google.common.base.Preconditions;
import com.squareup.okhttp.ConnectionSpec;
import io.grpc.transport.ClientTransport;
import io.grpc.transport.ClientTransportFactory;
import io.grpc.transport.okhttp.OkHttpClientTransport;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLSocketFactory;

class OkHttpClientTransportFactory
implements ClientTransportFactory {
    private final InetSocketAddress address;
    private final ExecutorService executor;
    private final String authorityHost;
    private final SSLSocketFactory sslSocketFactory;
    private final ConnectionSpec connectionSpec;

    public OkHttpClientTransportFactory(InetSocketAddress address, String authorityHost, ExecutorService executor, SSLSocketFactory factory, ConnectionSpec connectionSpec) {
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.authorityHost = (String)Preconditions.checkNotNull((Object)authorityHost, (Object)"authorityHost");
        this.sslSocketFactory = factory;
        this.connectionSpec = connectionSpec;
    }

    public ClientTransport newClientTransport() {
        return new OkHttpClientTransport(this.address, this.authorityHost, this.executor, this.sslSocketFactory, this.connectionSpec);
    }
}

