/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import com.squareup.okhttp.CipherSuite;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.OkHttpTlsUpgrader;
import com.squareup.okhttp.TlsVersion;
import com.squareup.okhttp.internal.spdy.ErrorCode;
import com.squareup.okhttp.internal.spdy.FrameReader;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.HeadersMode;
import com.squareup.okhttp.internal.spdy.Http2;
import com.squareup.okhttp.internal.spdy.OkHttpSettingsUtil;
import com.squareup.okhttp.internal.spdy.Settings;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.MethodType;
import io.grpc.Status;
import io.grpc.transport.ClientStreamListener;
import io.grpc.transport.ClientTransport;
import io.grpc.transport.okhttp.AsyncFrameWriter;
import io.grpc.transport.okhttp.Headers;
import io.grpc.transport.okhttp.OkHttpClientStream;
import io.grpc.transport.okhttp.OutboundFlowController;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.SSLSocketFactory;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class OkHttpClientTransport
implements ClientTransport {
    public static final ConnectionSpec DEFAULT_CONNECTION_SPEC = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384}).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).supportsTlsExtensions(true).build();
    @VisibleForTesting
    static final int DEFAULT_INITIAL_WINDOW_SIZE = 65536;
    private static final Map<ErrorCode, Status> ERROR_CODE_TO_STATUS;
    private static final Logger log;
    private final InetSocketAddress address;
    private final String authorityHost;
    private final String defaultAuthority;
    private ClientTransport.Listener listener;
    private FrameReader frameReader;
    private AsyncFrameWriter frameWriter;
    private OutboundFlowController outboundFlow;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int nextStreamId;
    private final Map<Integer, OkHttpClientStream> streams = Collections.synchronizedMap(new HashMap());
    private final Executor executor;
    private int connectionUnacknowledgedBytesRead;
    private ClientFrameHandler clientFrameHandler;
    @GuardedBy(value="lock")
    private boolean goAway;
    @GuardedBy(value="lock")
    private Status goAwayStatus;
    @GuardedBy(value="lock")
    private boolean stopped;
    private SSLSocketFactory sslSocketFactory;
    private Socket socket;
    @GuardedBy(value="lock")
    private int maxConcurrentStreams = Integer.MAX_VALUE;
    @GuardedBy(value="lock")
    private LinkedList<PendingStream> pendingStreams = new LinkedList();
    private ConnectionSpec connectionSpec = DEFAULT_CONNECTION_SPEC;

    OkHttpClientTransport(InetSocketAddress address, String authorityHost, Executor executor, @Nullable SSLSocketFactory sslSocketFactory, @Nullable ConnectionSpec connectionSpec) {
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address);
        this.authorityHost = authorityHost;
        this.defaultAuthority = authorityHost + ":" + address.getPort();
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.nextStreamId = 3;
        this.sslSocketFactory = sslSocketFactory;
        if (connectionSpec != null) {
            this.connectionSpec = connectionSpec;
        }
    }

    @VisibleForTesting
    OkHttpClientTransport(Executor executor, FrameReader frameReader, AsyncFrameWriter frameWriter, int nextStreamId, Socket socket) {
        this.address = null;
        this.authorityHost = null;
        this.defaultAuthority = "notarealauthority:80";
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.frameReader = (FrameReader)Preconditions.checkNotNull((Object)frameReader);
        this.frameWriter = (AsyncFrameWriter)Preconditions.checkNotNull((Object)frameWriter);
        this.socket = (Socket)Preconditions.checkNotNull((Object)socket);
        this.outboundFlow = new OutboundFlowController(this, frameWriter);
        this.nextStreamId = nextStreamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OkHttpClientStream newStream(MethodDescriptor<?, ?> method, Metadata.Headers headers, ClientStreamListener listener) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        Preconditions.checkNotNull((Object)listener, (Object)"listener");
        OkHttpClientStream clientStream = OkHttpClientStream.newStream(listener, this.frameWriter, this, this.outboundFlow, method.getType());
        String defaultPath = "/" + method.getName();
        List<Header> requestHeaders = Headers.createRequestHeaders(headers, defaultPath, this.defaultAuthority);
        SettableFuture pendingFuture = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.goAway) {
                clientStream.transportReportStatus(this.goAwayStatus, true, new Metadata.Trailers());
            } else if (this.streams.size() >= this.maxConcurrentStreams) {
                pendingFuture = SettableFuture.create();
                this.pendingStreams.add(new PendingStream(clientStream, (SettableFuture<Void>)pendingFuture, requestHeaders));
            } else {
                this.startStream(clientStream, requestHeaders);
            }
        }
        if (pendingFuture != null) {
            try {
                pendingFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                clientStream.cancel();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                clientStream.cancel();
                throw new RuntimeException(e.getCause() != null ? e.getCause() : e);
            }
        }
        return clientStream;
    }

    @GuardedBy(value="lock")
    private void startStream(OkHttpClientStream stream, List<Header> requestHeaders) {
        Preconditions.checkState((stream.id() == null ? 1 : 0) != 0, (Object)"StreamId already assigned");
        stream.id(this.nextStreamId);
        this.streams.put(stream.id(), stream);
        this.frameWriter.synStream(false, false, stream.id(), 0, requestHeaders);
        stream.allocated();
        if (stream.getType() != MethodType.UNARY && stream.getType() != MethodType.SERVER_STREAMING) {
            this.frameWriter.flush();
        }
        if (this.nextStreamId >= 0x7FFFFFFD) {
            this.onGoAway(Integer.MAX_VALUE, Status.INTERNAL.withDescription("Stream ids exhausted"));
        } else {
            this.nextStreamId += 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startPendingStreams() {
        boolean hasStreamStarted = false;
        Object object = this.lock;
        synchronized (object) {
            while (!this.pendingStreams.isEmpty() && this.streams.size() < this.maxConcurrentStreams) {
                PendingStream pendingStream = this.pendingStreams.poll();
                this.startStream(pendingStream.clientStream, pendingStream.requestHeaders);
                pendingStream.createdFuture.set(null);
                hasStreamStarted = true;
            }
        }
        return hasStreamStarted;
    }

    public void start(ClientTransport.Listener listener) {
        this.listener = (ClientTransport.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        if (this.address != null) {
            BufferedSink sink;
            BufferedSource source;
            try {
                this.socket = this.address.isUnresolved() ? new Socket(this.address.getHostName(), this.address.getPort()) : new Socket(this.address.getAddress(), this.address.getPort());
                if (this.sslSocketFactory != null) {
                    this.socket = OkHttpTlsUpgrader.upgrade(this.sslSocketFactory, this.socket, this.authorityHost, this.address.getPort(), this.connectionSpec);
                }
                this.socket.setTcpNoDelay(true);
                source = Okio.buffer((Source)Okio.source((Socket)this.socket));
                sink = Okio.buffer((Sink)Okio.sink((Socket)this.socket));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Http2 variant = new Http2();
            this.frameReader = variant.newReader(source, true);
            this.frameWriter = new AsyncFrameWriter(variant.newWriter(sink, true), this, this.executor);
            this.outboundFlow = new OutboundFlowController(this, this.frameWriter);
            this.frameWriter.connectionPreface();
            Settings settings = new Settings();
            this.frameWriter.settings(settings);
        }
        this.clientFrameHandler = new ClientFrameHandler();
        this.executor.execute(this.clientFrameHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        boolean normalClose;
        Object object = this.lock;
        synchronized (object) {
            normalClose = !this.goAway;
        }
        if (normalClose) {
            if (this.frameWriter != null) {
                this.frameWriter.goAway(0, ErrorCode.NO_ERROR, new byte[0]);
            }
            this.onGoAway(Integer.MAX_VALUE, Status.INTERNAL.withDescription("Transport stopped"));
        }
        this.stopIfNecessary();
    }

    @VisibleForTesting
    ClientFrameHandler getHandler() {
        return this.clientFrameHandler;
    }

    Map<Integer, OkHttpClientStream> getStreams() {
        return this.streams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getPendingStreamSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams.size();
        }
    }

    void onIoException(IOException failureCause) {
        log.log(Level.SEVERE, "Transport failed", failureCause);
        this.onGoAway(0, Status.INTERNAL.withCause((Throwable)failureCause));
    }

    private void onError(ErrorCode errorCode, String moreDetail) {
        this.frameWriter.goAway(0, errorCode, new byte[0]);
        this.onGoAway(0, OkHttpClientTransport.toGrpcStatus(errorCode).augmentDescription(moreDetail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onGoAway(int lastKnownStreamId, Status status) {
        LinkedList<PendingStream> pendingStreamsCopy;
        boolean notifyShutdown;
        ArrayList<OkHttpClientStream> goAwayStreams = new ArrayList<OkHttpClientStream>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            notifyShutdown = !this.goAway;
            this.goAway = true;
            this.goAwayStatus = status;
            Map<Integer, OkHttpClientStream> map = this.streams;
            synchronized (map) {
                Iterator<Map.Entry<Integer, OkHttpClientStream>> it = this.streams.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Integer, OkHttpClientStream> entry = it.next();
                    if (entry.getKey() <= lastKnownStreamId) continue;
                    goAwayStreams.add(entry.getValue());
                    it.remove();
                }
            }
            pendingStreamsCopy = this.pendingStreams;
            this.pendingStreams = new LinkedList();
        }
        if (notifyShutdown) {
            this.listener.transportShutdown();
        }
        for (OkHttpClientStream okHttpClientStream : goAwayStreams) {
            okHttpClientStream.transportReportStatus(status, false, new Metadata.Trailers());
        }
        for (PendingStream pendingStream : pendingStreamsCopy) {
            pendingStream.clientStream.transportReportStatus(status, true, new Metadata.Trailers());
            pendingStream.createdFuture.set(null);
        }
        this.stopIfNecessary();
    }

    void finishStream(int streamId, @Nullable Status status, @Nullable ErrorCode errorCode) {
        OkHttpClientStream stream = this.streams.remove(streamId);
        if (stream != null) {
            if (errorCode != null) {
                this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
            }
            if (status != null) {
                boolean isCancelled = status.getCode() == Status.Code.CANCELLED;
                stream.transportReportStatus(status, isCancelled, new Metadata.Trailers());
            }
            if (!this.startPendingStreams()) {
                this.stopIfNecessary();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopIfNecessary() {
        boolean shouldStop;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = shouldStop = this.goAway && this.streams.size() == 0;
            if (shouldStop) {
                if (this.stopped) {
                    shouldStop = false;
                }
                this.stopped = true;
            }
        }
        if (shouldStop && this.frameWriter != null) {
            this.frameWriter.close();
            try {
                this.socket.close();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Failed closing socket", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mayHaveCreatedStream(int streamId) {
        Object object = this.lock;
        synchronized (object) {
            return streamId < this.nextStreamId && (streamId & 1) == 1;
        }
    }

    @VisibleForTesting
    static Status toGrpcStatus(ErrorCode code) {
        return ERROR_CODE_TO_STATUS.get(code);
    }

    static {
        log = Logger.getLogger(OkHttpClientTransport.class.getName());
        HashMap<ErrorCode, Status> errorToStatus = new HashMap<ErrorCode, Status>();
        errorToStatus.put(ErrorCode.NO_ERROR, Status.OK);
        errorToStatus.put(ErrorCode.PROTOCOL_ERROR, Status.INTERNAL.withDescription("Protocol error"));
        errorToStatus.put(ErrorCode.INVALID_STREAM, Status.INTERNAL.withDescription("Invalid stream"));
        errorToStatus.put(ErrorCode.UNSUPPORTED_VERSION, Status.INTERNAL.withDescription("Unsupported version"));
        errorToStatus.put(ErrorCode.STREAM_IN_USE, Status.INTERNAL.withDescription("Stream in use"));
        errorToStatus.put(ErrorCode.STREAM_ALREADY_CLOSED, Status.INTERNAL.withDescription("Stream already closed"));
        errorToStatus.put(ErrorCode.INTERNAL_ERROR, Status.INTERNAL.withDescription("Internal error"));
        errorToStatus.put(ErrorCode.FLOW_CONTROL_ERROR, Status.INTERNAL.withDescription("Flow control error"));
        errorToStatus.put(ErrorCode.STREAM_CLOSED, Status.INTERNAL.withDescription("Stream closed"));
        errorToStatus.put(ErrorCode.FRAME_TOO_LARGE, Status.INTERNAL.withDescription("Frame too large"));
        errorToStatus.put(ErrorCode.REFUSED_STREAM, Status.INTERNAL.withDescription("Refused stream"));
        errorToStatus.put(ErrorCode.CANCEL, Status.CANCELLED.withDescription("Cancelled"));
        errorToStatus.put(ErrorCode.COMPRESSION_ERROR, Status.INTERNAL.withDescription("Compression error"));
        errorToStatus.put(ErrorCode.INVALID_CREDENTIALS, Status.PERMISSION_DENIED.withDescription("Invalid credentials"));
        ERROR_CODE_TO_STATUS = Collections.unmodifiableMap(errorToStatus);
    }

    private static class PendingStream {
        final OkHttpClientStream clientStream;
        final SettableFuture<Void> createdFuture;
        final List<Header> requestHeaders;

        PendingStream(OkHttpClientStream clientStream, SettableFuture<Void> createdFuture, List<Header> requestHeaders) {
            this.clientStream = clientStream;
            this.createdFuture = createdFuture;
            this.requestHeaders = requestHeaders;
        }
    }

    @VisibleForTesting
    class ClientFrameHandler
    implements FrameReader.Handler,
    Runnable {
        ClientFrameHandler() {
        }

        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName("OkHttpClientTransport");
            try {
                while (OkHttpClientTransport.this.frameReader.nextFrame((FrameReader.Handler)this)) {
                }
            }
            catch (IOException ioe) {
                OkHttpClientTransport.this.onIoException(ioe);
            }
            finally {
                try {
                    OkHttpClientTransport.this.frameReader.close();
                }
                catch (IOException ex) {
                    log.log(Level.INFO, "Exception closing frame reader", ex);
                }
                OkHttpClientTransport.this.listener.transportTerminated();
                Thread.currentThread().setName(threadName);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void data(boolean inFinished, int streamId, BufferedSource in, int length) throws IOException {
            OkHttpClientStream stream = (OkHttpClientStream)((Object)OkHttpClientTransport.this.streams.get(streamId));
            if (stream == null) {
                if (!OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received data for unknown stream: " + streamId);
                    return;
                }
                OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.INVALID_STREAM);
            } else {
                in.require((long)length);
                Buffer buf = new Buffer();
                buf.write(in.buffer(), (long)length);
                stream.transportDataReceived(buf, inFinished);
            }
            OkHttpClientTransport.this.connectionUnacknowledgedBytesRead = OkHttpClientTransport.this.connectionUnacknowledgedBytesRead + length;
            if (OkHttpClientTransport.this.connectionUnacknowledgedBytesRead >= 32768) {
                OkHttpClientTransport.this.frameWriter.windowUpdate(0, OkHttpClientTransport.this.connectionUnacknowledgedBytesRead);
                OkHttpClientTransport.this.connectionUnacknowledgedBytesRead = 0;
            }
        }

        public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock, HeadersMode headersMode) {
            OkHttpClientStream stream = (OkHttpClientStream)((Object)OkHttpClientTransport.this.streams.get(streamId));
            if (stream == null) {
                if (OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                    OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.INVALID_STREAM);
                } else {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received header for unknown stream: " + streamId);
                }
                return;
            }
            stream.transportHeadersReceived(headerBlock, inFinished);
        }

        public void rstStream(int streamId, ErrorCode errorCode) {
            OkHttpClientTransport.this.finishStream(streamId, OkHttpClientTransport.toGrpcStatus(errorCode), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void settings(boolean clearPrevious, Settings settings) {
            if (OkHttpSettingsUtil.isSet(settings, 4)) {
                int receivedMaxConcurrentStreams = OkHttpSettingsUtil.get(settings, 4);
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.maxConcurrentStreams = receivedMaxConcurrentStreams;
                }
            }
            if (OkHttpSettingsUtil.isSet(settings, 7)) {
                int initialWindowSize = OkHttpSettingsUtil.get(settings, 7);
                OkHttpClientTransport.this.outboundFlow.initialOutboundWindowSize(initialWindowSize);
            }
            OkHttpClientTransport.this.frameWriter.ackSettings(settings);
        }

        public void ping(boolean ack, int payload1, int payload2) {
            if (!ack) {
                OkHttpClientTransport.this.frameWriter.ping(true, payload1, payload2);
            }
        }

        public void ackSettings() {
        }

        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            OkHttpClientTransport.this.onGoAway(lastGoodStreamId, Status.UNAVAILABLE.withDescription("Go away"));
        }

        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) throws IOException {
            OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.PROTOCOL_ERROR);
        }

        public void windowUpdate(int streamId, long delta) {
            if (delta == 0L) {
                String errorMsg = "Received 0 flow control window increment.";
                if (streamId == 0) {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, errorMsg);
                } else {
                    OkHttpClientTransport.this.finishStream(streamId, Status.INTERNAL.withDescription(errorMsg), ErrorCode.PROTOCOL_ERROR);
                }
                return;
            }
            if (streamId == 0) {
                OkHttpClientTransport.this.outboundFlow.windowUpdate(null, (int)delta);
                return;
            }
            OkHttpClientStream stream = (OkHttpClientStream)((Object)OkHttpClientTransport.this.streams.get(streamId));
            if (stream != null) {
                OkHttpClientTransport.this.outboundFlow.windowUpdate(stream, (int)delta);
            } else if (!OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received window_update for unknown stream: " + streamId);
            }
        }

        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        public void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
        }
    }
}

