/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Function;
import com.google.protobuf.ByteString;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.junit.Assert;

final class SoakClient {
    SoakClient() {
    }

    private static SoakIterationResult performOneSoakIteration(TestServiceGrpc.TestServiceBlockingStub soakStub, int soakRequestSize, int soakResponseSize) throws InterruptedException {
        long startNs = System.nanoTime();
        Status status = Status.OK;
        try {
            Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setResponseSize(soakResponseSize).setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[soakRequestSize]))).build();
            Messages.SimpleResponse goldenResponse = Messages.SimpleResponse.newBuilder().setPayload(Messages.Payload.newBuilder().setBody(ByteString.copyFrom((byte[])new byte[soakResponseSize]))).build();
            SoakClient.assertResponse(goldenResponse, soakStub.unaryCall(request));
        }
        catch (StatusRuntimeException e) {
            status = e.getStatus();
        }
        long elapsedNs = System.nanoTime() - startNs;
        return new SoakIterationResult(TimeUnit.NANOSECONDS.toMillis(elapsedNs), status);
    }

    public static void performSoakTest(String serverUri, int soakIterations, int maxFailures, int maxAcceptablePerIterationLatencyMs, int minTimeMsBetweenRpcs, int overallTimeoutSeconds, int soakRequestSize, int soakResponseSize, int numThreads, ManagedChannel sharedChannel, Function<ManagedChannel, ManagedChannel> maybeCreateChannel) throws InterruptedException {
        if (soakIterations % numThreads != 0) {
            throw new IllegalArgumentException("soakIterations must be evenly divisible by numThreads.");
        }
        long startNs = System.nanoTime();
        Thread[] threads = new Thread[numThreads];
        int soakIterationsPerThread = soakIterations / numThreads;
        ArrayList<ThreadResults> threadResultsList = new ArrayList<ThreadResults>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            threadResultsList.add(new ThreadResults());
        }
        for (int threadInd = 0; threadInd < numThreads; ++threadInd) {
            int currentThreadInd = threadInd;
            threads[threadInd] = new Thread(() -> {
                try {
                    SoakClient.executeSoakTestInThread(soakIterationsPerThread, startNs, minTimeMsBetweenRpcs, soakRequestSize, soakResponseSize, maxAcceptablePerIterationLatencyMs, overallTimeoutSeconds, serverUri, (ThreadResults)threadResultsList.get(currentThreadInd), sharedChannel, maybeCreateChannel);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Thread interrupted: " + e.getMessage(), e);
                }
            });
            threads[threadInd].start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        int totalFailures = 0;
        int iterationsDone = 0;
        Histogram latencies = new Histogram(4);
        for (ThreadResults threadResult : threadResultsList) {
            totalFailures += threadResult.getThreadFailures();
            iterationsDone += threadResult.getIterationsDone();
            latencies.add((AbstractHistogram)threadResult.getLatencies());
        }
        System.err.println(String.format(Locale.US, "(server_uri: %s) soak test ran: %d / %d iterations. total failures: %d. p50: %d ms, p90: %d ms, p100: %d ms", serverUri, iterationsDone, soakIterations, totalFailures, latencies.getValueAtPercentile(50.0), latencies.getValueAtPercentile(90.0), latencies.getValueAtPercentile(100.0)));
        String timeoutErrorMessage = String.format(Locale.US, "(server_uri: %s) soak test consumed all %d seconds of time and quit early, only having ran %d out of desired %d iterations.", serverUri, overallTimeoutSeconds, iterationsDone, soakIterations);
        Assert.assertEquals((String)timeoutErrorMessage, (long)iterationsDone, (long)soakIterations);
        String tooManyFailuresErrorMessage = String.format(Locale.US, "(server_uri: %s) soak test total failures: %d exceeds max failures threshold: %d.", serverUri, totalFailures, maxFailures);
        Assert.assertTrue((String)tooManyFailuresErrorMessage, (totalFailures <= maxFailures ? 1 : 0) != 0);
        sharedChannel.shutdownNow();
        sharedChannel.awaitTermination(10L, TimeUnit.SECONDS);
    }

    private static void executeSoakTestInThread(int soakIterationsPerThread, long startNs, int minTimeMsBetweenRpcs, int soakRequestSize, int soakResponseSize, int maxAcceptablePerIterationLatencyMs, int overallTimeoutSeconds, String serverUri, ThreadResults threadResults, ManagedChannel sharedChannel, Function<ManagedChannel, ManagedChannel> maybeCreateChannel) throws InterruptedException {
        ManagedChannel currentChannel = sharedChannel;
        for (int i = 0; i < soakIterationsPerThread && System.nanoTime() - startNs < TimeUnit.SECONDS.toNanos(overallTimeoutSeconds); ++i) {
            long earliestNextStartNs = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(minTimeMsBetweenRpcs);
            AtomicReference soakThreadClientCallCapture = new AtomicReference();
            currentChannel = (ManagedChannel)maybeCreateChannel.apply((Object)currentChannel);
            TestServiceGrpc.TestServiceBlockingStub currentStub = (TestServiceGrpc.TestServiceBlockingStub)TestServiceGrpc.newBlockingStub((Channel)currentChannel).withInterceptors(new ClientInterceptor[]{SoakClient.recordClientCallInterceptor(soakThreadClientCallCapture)});
            SoakIterationResult result = SoakClient.performOneSoakIteration(currentStub, soakRequestSize, soakResponseSize);
            SocketAddress peer = (SocketAddress)soakThreadClientCallCapture.get().getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            StringBuilder logStr = new StringBuilder(String.format(Locale.US, "thread id: %d soak iteration: %d elapsed_ms: %d peer: %s server_uri: %s", Thread.currentThread().getId(), i, result.getLatencyMs(), peer != null ? peer.toString() : "null", serverUri));
            if (!result.getStatus().equals((Object)Status.OK)) {
                threadResults.threadFailures++;
                logStr.append(String.format(" failed: %s", result.getStatus()));
            } else if (result.getLatencyMs() > (long)maxAcceptablePerIterationLatencyMs) {
                threadResults.threadFailures++;
                logStr.append(" exceeds max acceptable latency: " + maxAcceptablePerIterationLatencyMs);
            } else {
                logStr.append(" succeeded");
            }
            System.err.println(logStr.toString());
            threadResults.iterationsDone++;
            threadResults.getLatencies().recordValue(result.getLatencyMs());
            long remainingNs = earliestNextStartNs - System.nanoTime();
            if (remainingNs <= 0L) continue;
            TimeUnit.NANOSECONDS.sleep(remainingNs);
        }
    }

    private static void assertResponse(Messages.SimpleResponse expected, Messages.SimpleResponse actual) {
        SoakClient.assertPayload(expected.getPayload(), actual.getPayload());
        Assert.assertEquals((Object)expected.getUsername(), (Object)actual.getUsername());
        Assert.assertEquals((Object)expected.getOauthScope(), (Object)actual.getOauthScope());
    }

    private static void assertPayload(Messages.Payload expected, Messages.Payload actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((Object)expected.getBody(), (Object)actual.getBody());
        }
    }

    private static ClientInterceptor recordClientCallInterceptor(final AtomicReference<ClientCall<?, ?>> clientCallCapture) {
        return new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                ClientCall clientCall = next.newCall(method, callOptions);
                clientCallCapture.set(clientCall);
                return clientCall;
            }
        };
    }

    private static class ThreadResults {
        private int threadFailures = 0;
        private int iterationsDone = 0;
        private Histogram latencies = new Histogram(4);

        private ThreadResults() {
        }

        public int getThreadFailures() {
            return this.threadFailures;
        }

        public int getIterationsDone() {
            return this.iterationsDone;
        }

        public Histogram getLatencies() {
            return this.latencies;
        }
    }

    private static class SoakIterationResult {
        private long latencyMs = -1L;
        private Status status = Status.OK;

        public SoakIterationResult(long latencyMs, Status status) {
            this.latencyMs = latencyMs;
            this.status = status;
        }

        public long getLatencyMs() {
            return this.latencyMs;
        }

        public Status getStatus() {
            return this.status;
        }
    }
}

