/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import io.grpc.Metadata;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.testing.integration.Messages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.junit.Assert;

public class Util {
    public static final Metadata.Key<Messages.SimpleContext> METADATA_KEY = ProtoUtils.keyForProto((Message)Messages.SimpleContext.getDefaultInstance());
    public static final Metadata.Key<String> ECHO_INITIAL_METADATA_KEY = Metadata.Key.of((String)"x-grpc-test-echo-initial", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<byte[]> ECHO_TRAILING_METADATA_KEY = Metadata.Key.of((String)"x-grpc-test-echo-trailing-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
    private static boolean conscryptInstallAttempted;

    public static void assertEquals(MessageLite expected, MessageLite actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((Object)expected, (Object)actual);
        } else if (!expected.equals(actual)) {
            Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
            Assert.assertEquals((Object)expected, (Object)actual);
            Assert.fail((String)"Messages not equal, but assertEquals didn't throw");
        }
    }

    public static void assertEquals(List<? extends MessageLite> expected, List<? extends MessageLite> actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals(expected, actual);
        } else if (expected.size() != actual.size()) {
            Assert.assertEquals(expected, actual);
        } else {
            for (int i = 0; i < expected.size(); ++i) {
                Util.assertEquals(expected.get(i), actual.get(i));
            }
        }
    }

    public static void installConscryptIfAvailable() {
        Provider provider;
        Method newProvider;
        Class<?> conscrypt;
        if (conscryptInstallAttempted) {
            return;
        }
        try {
            conscrypt = Class.forName("org.conscrypt.Conscrypt");
        }
        catch (ClassNotFoundException ex) {
            conscryptInstallAttempted = true;
            return;
        }
        try {
            newProvider = conscrypt.getMethod("newProvider", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Could not find newProvider method on Conscrypt", ex);
        }
        try {
            provider = (Provider)newProvider.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Could not invoke Conscrypt.newProvider", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Could not invoke Conscrypt.newProvider", ex);
        }
        Security.addProvider(provider);
        conscryptInstallAttempted = true;
    }
}

