/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.MessageLite;
import com.google.protobuf.StringValue;
import io.grpc.Metadata;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public class Util {
    public static final Metadata.Key<StringValue> METADATA_KEY = Metadata.Key.of((String)"google.protobuf.StringValue-bin", (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)StringValue.getDefaultInstance()));
    public static final Metadata.Key<String> ECHO_INITIAL_METADATA_KEY = Metadata.Key.of((String)"x-grpc-test-echo-initial", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<byte[]> ECHO_TRAILING_METADATA_KEY = Metadata.Key.of((String)"x-grpc-test-echo-trailing-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);

    public static void assertEquals(MessageLite expected, MessageLite actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((Object)expected, (Object)actual);
        } else if (!expected.equals(actual)) {
            Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
            Assert.assertEquals((Object)expected, (Object)actual);
            Assert.fail((String)"Messages not equal, but assertEquals didn't throw");
        }
    }

    public static void assertEquals(List<? extends MessageLite> expected, List<? extends MessageLite> actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals(expected, actual);
        } else if (expected.size() != actual.size()) {
            Assert.assertEquals(expected, actual);
        } else {
            for (int i = 0; i < expected.size(); ++i) {
                Util.assertEquals(expected.get(i), actual.get(i));
            }
        }
    }

    static List<SocketAddress> getV6Addresses(int port) throws UnknownHostException {
        InetAddress[] addresses;
        ArrayList<SocketAddress> v6addresses = new ArrayList<SocketAddress>();
        for (InetAddress address : addresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())) {
            if (address.getAddress().length == 4) continue;
            v6addresses.add(new InetSocketAddress(address, port));
        }
        return v6addresses;
    }

    static SocketAddress getV4Address(int port) throws UnknownHostException {
        InetAddress[] addresses;
        for (InetAddress address : addresses = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())) {
            if (address.getAddress().length != 4) continue;
            return new InetSocketAddress(address, port);
        }
        return null;
    }

    public static int pickUnusedPort() {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            serverSocket.close();
            return port;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static enum AddressType {
        IPV4,
        IPV6,
        IPV4_IPV6;

    }
}

