/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import io.grpc.Channel;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.StatusRuntimeException;
import io.grpc.alts.ComputeEngineChannelBuilder;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.junit.Assert;

public final class GrpclbFallbackTestClient {
    private static final Logger logger = Logger.getLogger(GrpclbFallbackTestClient.class.getName());
    private String induceFallbackCmd = "exit 1";
    private String serverUri;
    private String customCredentialsType;
    private String testCase;
    private Boolean skipNetCmd = false;
    private int numWarmupRpcs;
    private int fallbackDeadlineSeconds = 1;
    private ManagedChannel channel;
    private TestServiceGrpc.TestServiceBlockingStub blockingStub;

    public static void main(String[] args) throws Exception {
        final GrpclbFallbackTestClient client = new GrpclbFallbackTestClient();
        client.parseArgs(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Shutting down");
                try {
                    client.tearDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            client.run();
        }
        finally {
            client.tearDown();
        }
        System.exit(0);
    }

    private void parseArgs(String[] args) {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("server_uri".equals(key)) {
                this.serverUri = value;
                continue;
            }
            if ("test_case".equals(key)) {
                this.testCase = value;
                continue;
            }
            if ("induce_fallback_cmd".equals(key)) {
                this.induceFallbackCmd = value;
                continue;
            }
            if ("custom_credentials_type".equals(key)) {
                this.customCredentialsType = value;
                continue;
            }
            if ("skip_net_cmd".equals(key)) {
                this.skipNetCmd = Boolean.valueOf(value);
                continue;
            }
            if ("num_warmup_rpcs".equals(key)) {
                this.numWarmupRpcs = Integer.valueOf(value);
                continue;
            }
            if ("fallback_deadline_seconds".equals(key)) {
                this.fallbackDeadlineSeconds = Integer.valueOf(value);
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (usage) {
            GrpclbFallbackTestClient c = new GrpclbFallbackTestClient();
            System.out.println("Usage: [ARGS...]\n\n  --server_uri                          Server target. Default: " + c.serverUri + "\n  --custom_credentials_type             Name of Credentials to use. Default: " + c.customCredentialsType + "\n  --induce_fallback_cmd Shell command to induce fallback, e.g. by making LB and/or backend addresses unroutable or black holed. Default: " + c.induceFallbackCmd + "\n  --skip_net_cmd                        Skip unroute and blackhole shell command to allow setting the net config outside of the test client. Default: " + c.skipNetCmd + "\n  --num_warmup_rpcs                     Number of RPCs to perform on a separate warmup channel before the actual test runs (each warmup RPC uses a 1 second deadline). Default: " + c.numWarmupRpcs + "\n  --fallback_deadline_seconds           Number of seconds to wait for fallback to occur after inducing fallback. Default: " + c.fallbackDeadlineSeconds + "\n  --test_case=TEST_CASE        Test case to run. Valid options are:\n      fallback_before_startup : fallback before startup e.g. due to LB/backend addresses being unreachable\n      fallback_after_startup : fallback after startup e.g. due to LB/backend addresses becoming unreachable\n      Default: " + c.testCase);
            System.exit(1);
        }
    }

    private ManagedChannel createChannel() {
        if (!this.customCredentialsType.equals("compute_engine_channel_creds")) {
            throw new AssertionError((Object)"This test currently only supports --custom_credentials_type=compute_engine_channel_creds. TODO: add support for other types.");
        }
        ComputeEngineChannelBuilder builder = ComputeEngineChannelBuilder.forTarget((String)this.serverUri);
        builder.keepAliveTime(3600L, TimeUnit.SECONDS);
        builder.keepAliveTimeout(20L, TimeUnit.SECONDS);
        return builder.build();
    }

    void initStub() {
        this.channel = this.createChannel();
        this.blockingStub = TestServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    private void tearDown() {
        try {
            if (this.channel != null) {
                this.channel.shutdownNow();
                this.channel.awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void runShellCmd(String cmd) throws Exception {
        if (this.skipNetCmd.booleanValue()) {
            logger.info("Skip net cmd because --skip_net_cmd is set to true");
            return;
        }
        logger.info("Run shell command: " + cmd);
        ProcessBuilder pb = new ProcessBuilder(cmd.split(" "));
        pb.redirectErrorStream(true);
        Process process = pb.start();
        logger.info("Shell command merged stdout and stderr: " + CharStreams.toString((Readable)new InputStreamReader(process.getInputStream(), Charsets.UTF_8)));
        int exitCode = process.waitFor();
        logger.info("Shell command exit code: " + exitCode);
        Assert.assertEquals((long)0L, (long)exitCode);
    }

    private Messages.GrpclbRouteType doRpcAndGetPath(TestServiceGrpc.TestServiceBlockingStub stub, Deadline deadline) {
        logger.info("doRpcAndGetPath deadline: " + deadline);
        Messages.SimpleRequest request = Messages.SimpleRequest.newBuilder().setFillGrpclbRouteType(true).build();
        Messages.GrpclbRouteType result = Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_UNKNOWN;
        try {
            Messages.SimpleResponse response = ((TestServiceGrpc.TestServiceBlockingStub)stub.withDeadline(deadline)).unaryCall(request);
            result = response.getGrpclbRouteType();
        }
        catch (StatusRuntimeException ex) {
            logger.warning("doRpcAndGetPath failed. Status: " + (Object)((Object)ex));
            return Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_UNKNOWN;
        }
        logger.info("doRpcAndGetPath. GrpclbRouteType result: " + (Object)((Object)result));
        if (result != Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_FALLBACK && result != Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_BACKEND) {
            throw new AssertionError((Object)"Received invalid LB route type. This suggests that the server hasn't implemented this test correctly.");
        }
        return result;
    }

    private void waitForFallbackAndDoRpcs(Deadline fallbackDeadline) throws Exception {
        int fallbackRetryCount = 0;
        boolean fallBack = false;
        while (!fallbackDeadline.isExpired()) {
            Messages.GrpclbRouteType grpclbRouteType = this.doRpcAndGetPath(this.blockingStub, Deadline.after((long)1L, (TimeUnit)TimeUnit.SECONDS));
            if (grpclbRouteType == Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_BACKEND) {
                throw new AssertionError((Object)"Got grpclb route type backend. Backends are supposed to be unreachable, so this test is broken");
            }
            if (grpclbRouteType == Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_FALLBACK) {
                logger.info("Made one successful RPC to a fallback. Now expect the same for the rest.");
                fallBack = true;
                break;
            }
            logger.info("Retryable RPC failure on iteration: " + fallbackRetryCount);
            ++fallbackRetryCount;
        }
        if (!fallBack) {
            throw new AssertionError((Object)"Didn't fall back within deadline");
        }
        for (int i = 0; i < 30; ++i) {
            Assert.assertEquals((Object)((Object)Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_FALLBACK), (Object)((Object)this.doRpcAndGetPath(this.blockingStub, Deadline.after((long)20L, (TimeUnit)TimeUnit.SECONDS))));
            Thread.sleep(1000L);
        }
    }

    private void runFallbackBeforeStartup() throws Exception {
        this.runShellCmd(this.induceFallbackCmd);
        Deadline fallbackDeadline = Deadline.after((long)this.fallbackDeadlineSeconds, (TimeUnit)TimeUnit.SECONDS);
        this.initStub();
        this.waitForFallbackAndDoRpcs(fallbackDeadline);
    }

    private void runFallbackAfterStartup() throws Exception {
        this.initStub();
        Assert.assertEquals((Object)((Object)Messages.GrpclbRouteType.GRPCLB_ROUTE_TYPE_BACKEND), (Object)((Object)this.doRpcAndGetPath(this.blockingStub, Deadline.after((long)20L, (TimeUnit)TimeUnit.SECONDS))));
        this.runShellCmd(this.induceFallbackCmd);
        Deadline fallbackDeadline = Deadline.after((long)this.fallbackDeadlineSeconds, (TimeUnit)TimeUnit.SECONDS);
        this.waitForFallbackAndDoRpcs(fallbackDeadline);
    }

    private void warmup() throws Exception {
        logger.info("Begin warmup, performing " + this.numWarmupRpcs + " RPCs on the warmup channel");
        ManagedChannel channel = this.createChannel();
        TestServiceGrpc.TestServiceBlockingStub stub = TestServiceGrpc.newBlockingStub((Channel)channel);
        for (int i = 0; i < this.numWarmupRpcs; ++i) {
            this.doRpcAndGetPath(stub, Deadline.after((long)1L, (TimeUnit)TimeUnit.SECONDS));
        }
        try {
            channel.shutdownNow();
            channel.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void run() throws Exception {
        this.warmup();
        logger.info("Begin test case: " + this.testCase);
        if (this.testCase.equals("fallback_before_startup")) {
            this.runFallbackBeforeStartup();
        } else if (this.testCase.equals("fallback_after_startup")) {
            this.runFallbackAfterStartup();
        } else {
            throw new RuntimeException("invalid testcase: " + this.testCase);
        }
        logger.info("Test case: " + this.testCase + " done!");
    }
}

