/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.base.Preconditions;

public enum TestCases {
    EMPTY_UNARY("empty (zero bytes) request and response"),
    CACHEABLE_UNARY("cacheable unary rpc sent using GET"),
    LARGE_UNARY("single request and (large) response"),
    CLIENT_COMPRESSED_UNARY("client compressed unary request"),
    SERVER_COMPRESSED_UNARY("server compressed unary response"),
    CLIENT_STREAMING("request streaming with single response"),
    CLIENT_COMPRESSED_STREAMING("client per-message compression on stream"),
    SERVER_STREAMING("single request with response streaming"),
    SERVER_COMPRESSED_STREAMING("server per-message compression on stream"),
    PING_PONG("full-duplex ping-pong streaming"),
    EMPTY_STREAM("A stream that has zero-messages in both directions"),
    COMPUTE_ENGINE_CREDS("large_unary with service_account auth"),
    SERVICE_ACCOUNT_CREDS("large_unary with compute engine auth"),
    JWT_TOKEN_CREDS("JWT-based auth"),
    OAUTH2_AUTH_TOKEN("raw oauth2 access token auth"),
    PER_RPC_CREDS("per rpc raw oauth2 access token auth"),
    CUSTOM_METADATA("unary and full duplex calls with metadata"),
    STATUS_CODE_AND_MESSAGE("request error code and message"),
    UNIMPLEMENTED_METHOD("call an unimplemented RPC method"),
    UNIMPLEMENTED_SERVICE("call an unimplemented RPC service"),
    CANCEL_AFTER_BEGIN("cancel stream after starting it"),
    CANCEL_AFTER_FIRST_RESPONSE("cancel on first response"),
    TIMEOUT_ON_SLEEPING_SERVER("timeout before receiving a response");

    private final String description;

    private TestCases(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    public static TestCases fromString(String s) {
        Preconditions.checkNotNull((Object)s, (Object)"s");
        return TestCases.valueOf(s.toUpperCase());
    }
}

