/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.InsecureServerCredentials;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.TlsChannelCredentials;
import io.grpc.alts.AltsChannelCredentials;
import io.grpc.alts.ComputeEngineChannelCredentials;
import io.grpc.alts.GoogleDefaultChannelCredentials;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.JsonParser;
import io.grpc.internal.testing.TestUtils;
import io.grpc.netty.InsecureFromHttp1ChannelCredentials;
import io.grpc.netty.InternalNettyChannelBuilder;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.okhttp.InternalOkHttpChannelBuilder;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.grpc.testing.integration.AbstractInteropTest;
import io.grpc.testing.integration.AltsHandshakerTestService;
import io.grpc.testing.integration.CustomBackendMetricsLoadBalancerProvider;
import io.grpc.testing.integration.TestCases;
import io.grpc.testing.integration.TestServiceGrpc;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class TestServiceClient {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private String serverHost = "localhost";
    private String serverHostOverride;
    private int serverPort = 8080;
    private String testCase = "empty_unary";
    private boolean useTls = true;
    private boolean useAlts = false;
    private boolean useH2cUpgrade = false;
    private String customCredentialsType;
    private boolean useTestCa;
    private boolean useOkHttp;
    private String defaultServiceAccount;
    private String serviceAccountKeyFile;
    private String oauthScope;
    private boolean fullStreamDecompression;
    private int localHandshakerPort = -1;
    private Map<String, ?> serviceConfig = null;
    private int soakIterations = 10;
    private int soakMaxFailures = 0;
    private int soakPerIterationMaxAcceptableLatencyMs = 1000;
    private int soakMinTimeMsBetweenRpcs = 0;
    private int soakOverallTimeoutSeconds = this.soakIterations * this.soakPerIterationMaxAcceptableLatencyMs / 1000;
    private static LoadBalancerProvider customBackendMetricsLoadBalancerProvider;
    private Tester tester = new Tester();

    public static void main(String[] args) throws Exception {
        TestUtils.installConscryptIfAvailable();
        TestServiceClient client = new TestServiceClient();
        client.parseArgs(args);
        customBackendMetricsLoadBalancerProvider = new CustomBackendMetricsLoadBalancerProvider();
        LoadBalancerRegistry.getDefaultRegistry().register(customBackendMetricsLoadBalancerProvider);
        client.setUp();
        try {
            client.run();
        }
        finally {
            client.tearDown();
        }
        System.exit(0);
    }

    @VisibleForTesting
    void parseArgs(String[] args) throws Exception {
        boolean usage = false;
        for (String arg : args) {
            if (!arg.startsWith("--")) {
                System.err.println("All arguments must start with '--': " + arg);
                usage = true;
                break;
            }
            String[] parts = arg.substring(2).split("=", 2);
            String key = parts[0];
            if ("help".equals(key)) {
                usage = true;
                break;
            }
            if (parts.length != 2) {
                System.err.println("All arguments must be of the form --arg=value");
                usage = true;
                break;
            }
            String value = parts[1];
            if ("server_host".equals(key)) {
                this.serverHost = value;
                continue;
            }
            if ("server_host_override".equals(key)) {
                this.serverHostOverride = value;
                continue;
            }
            if ("server_port".equals(key)) {
                this.serverPort = Integer.parseInt(value);
                continue;
            }
            if ("test_case".equals(key)) {
                this.testCase = value;
                continue;
            }
            if ("use_tls".equals(key)) {
                this.useTls = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_upgrade".equals(key)) {
                this.useH2cUpgrade = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_alts".equals(key)) {
                this.useAlts = Boolean.parseBoolean(value);
                continue;
            }
            if ("custom_credentials_type".equals(key)) {
                this.customCredentialsType = value;
                continue;
            }
            if ("use_test_ca".equals(key)) {
                this.useTestCa = Boolean.parseBoolean(value);
                continue;
            }
            if ("use_okhttp".equals(key)) {
                this.useOkHttp = Boolean.parseBoolean(value);
                continue;
            }
            if ("grpc_version".equals(key)) {
                if ("2".equals(value)) continue;
                System.err.println("Only grpc version 2 is supported");
                usage = true;
                break;
            }
            if ("default_service_account".equals(key)) {
                this.defaultServiceAccount = value;
                continue;
            }
            if ("service_account_key_file".equals(key)) {
                this.serviceAccountKeyFile = value;
                continue;
            }
            if ("oauth_scope".equals(key)) {
                this.oauthScope = value;
                continue;
            }
            if ("full_stream_decompression".equals(key)) {
                this.fullStreamDecompression = Boolean.parseBoolean(value);
                continue;
            }
            if ("local_handshaker_port".equals(key)) {
                this.localHandshakerPort = Integer.parseInt(value);
                continue;
            }
            if ("service_config_json".equals(key)) {
                Map map;
                this.serviceConfig = map = (Map)JsonParser.parse((String)value);
                continue;
            }
            if ("soak_iterations".equals(key)) {
                this.soakIterations = Integer.parseInt(value);
                continue;
            }
            if ("soak_max_failures".equals(key)) {
                this.soakMaxFailures = Integer.parseInt(value);
                continue;
            }
            if ("soak_per_iteration_max_acceptable_latency_ms".equals(key)) {
                this.soakPerIterationMaxAcceptableLatencyMs = Integer.parseInt(value);
                continue;
            }
            if ("soak_min_time_ms_between_rpcs".equals(key)) {
                this.soakMinTimeMsBetweenRpcs = Integer.parseInt(value);
                continue;
            }
            if ("soak_overall_timeout_seconds".equals(key)) {
                this.soakOverallTimeoutSeconds = Integer.parseInt(value);
                continue;
            }
            System.err.println("Unknown argument: " + key);
            usage = true;
            break;
        }
        if (this.useAlts || this.useH2cUpgrade) {
            this.useTls = false;
        }
        if (usage) {
            TestServiceClient c = new TestServiceClient();
            System.out.println("Usage: [ARGS...]\n\n  --server_host=HOST          Server to connect to. Default " + c.serverHost + "\n  --server_host_override=HOST Claimed identification expected of server.\n                              Defaults to server host\n  --server_port=PORT          Port to connect to. Default " + c.serverPort + "\n  --test_case=TESTCASE        Test case to run. Default " + c.testCase + "\n    Valid options:" + TestServiceClient.validTestCasesHelpText() + "\n  --use_tls=true|false        Whether to use TLS. Default " + c.useTls + "\n  --use_alts=true|false       Whether to use ALTS. Enable ALTS will disable TLS.\n                              Default " + c.useAlts + "\n  --local_handshaker_port=PORT\n                              Use local ALTS handshaker service on the specified \n                              port for testing. Only effective when --use_alts=true.\n  --use_upgrade=true|false    Whether to use the h2c Upgrade mechanism.\n                              Enabling h2c Upgrade will disable TLS.\n                              Default " + c.useH2cUpgrade + "\n  --custom_credentials_type   Custom credentials type to use. Default " + c.customCredentialsType + "\n  --use_test_ca=true|false    Whether to trust our fake CA. Requires --use_tls=true \n                              to have effect. Default " + c.useTestCa + "\n  --use_okhttp=true|false     Whether to use OkHttp instead of Netty. Default " + c.useOkHttp + "\n  --default_service_account   Email of GCE default service account. Default " + c.defaultServiceAccount + "\n  --service_account_key_file  Path to service account json key file." + c.serviceAccountKeyFile + "\n  --oauth_scope               Scope for OAuth tokens. Default " + c.oauthScope + "\n  --full_stream_decompression Enable full-stream decompression. Default " + c.fullStreamDecompression + "\n --service_config_json=SERVICE_CONFIG_JSON\n                              Disables service config lookups and sets the provided \n                              string as the default service config.\n --soak_iterations            The number of iterations to use for the two soak \n                              tests: rpc_soak and channel_soak. Default " + c.soakIterations + "\n --soak_max_failures          The number of iterations in soak tests that are \n                              allowed to fail (either due to non-OK status code or \n                              exceeding the per-iteration max acceptable latency). \n                              Default " + c.soakMaxFailures + "\n --soak_per_iteration_max_acceptable_latency_ms \n                              The number of milliseconds a single iteration in the \n                              two soak tests (rpc_soak and channel_soak) should \n                              take. Default " + c.soakPerIterationMaxAcceptableLatencyMs + "\n --soak_min_time_ms_between_rpcs \n                              The minimum time in milliseconds between consecutive \n                              RPCs in a soak test (rpc_soak or channel_soak), \n                              useful for limiting QPS. Default: " + c.soakMinTimeMsBetweenRpcs + "\n --soak_overall_timeout_seconds \n                              The overall number of seconds after which a soak test \n                              should stop and fail, if the desired number of \n                              iterations have not yet completed. Default " + c.soakOverallTimeoutSeconds);
            System.exit(1);
        }
    }

    @VisibleForTesting
    void setUp() {
        this.tester.setUp();
    }

    private synchronized void tearDown() {
        try {
            this.tester.tearDown();
            if (customBackendMetricsLoadBalancerProvider != null) {
                LoadBalancerRegistry.getDefaultRegistry().deregister(customBackendMetricsLoadBalancerProvider);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void run() {
        System.out.println("Running test " + this.testCase);
        try {
            this.runTest(TestCases.fromString(this.testCase));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        System.out.println("Test completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(TestCases testCase) throws Exception {
        switch (testCase) {
            case EMPTY_UNARY: {
                this.tester.emptyUnary();
                break;
            }
            case CACHEABLE_UNARY: {
                this.tester.cacheableUnary();
                break;
            }
            case LARGE_UNARY: {
                this.tester.largeUnary();
                break;
            }
            case CLIENT_COMPRESSED_UNARY: {
                this.tester.clientCompressedUnary(true);
                break;
            }
            case CLIENT_COMPRESSED_UNARY_NOPROBE: {
                this.tester.clientCompressedUnary(false);
                break;
            }
            case SERVER_COMPRESSED_UNARY: {
                this.tester.serverCompressedUnary();
                break;
            }
            case CLIENT_STREAMING: {
                this.tester.clientStreaming();
                break;
            }
            case CLIENT_COMPRESSED_STREAMING: {
                this.tester.clientCompressedStreaming(true);
                break;
            }
            case CLIENT_COMPRESSED_STREAMING_NOPROBE: {
                this.tester.clientCompressedStreaming(false);
                break;
            }
            case SERVER_STREAMING: {
                this.tester.serverStreaming();
                break;
            }
            case SERVER_COMPRESSED_STREAMING: {
                this.tester.serverCompressedStreaming();
                break;
            }
            case PING_PONG: {
                this.tester.pingPong();
                break;
            }
            case EMPTY_STREAM: {
                this.tester.emptyStream();
                break;
            }
            case COMPUTE_ENGINE_CREDS: {
                this.tester.computeEngineCreds(this.defaultServiceAccount, this.oauthScope);
                break;
            }
            case COMPUTE_ENGINE_CHANNEL_CREDENTIALS: {
                ManagedChannelBuilder builder = this.serverPort == 0 ? Grpc.newChannelBuilder((String)this.serverHost, (ChannelCredentials)ComputeEngineChannelCredentials.create()) : Grpc.newChannelBuilderForAddress((String)this.serverHost, (int)this.serverPort, (ChannelCredentials)ComputeEngineChannelCredentials.create());
                if (this.serviceConfig != null) {
                    builder.disableServiceConfigLookUp();
                    builder.defaultServiceConfig(this.serviceConfig);
                }
                ManagedChannel channel = builder.build();
                try {
                    TestServiceGrpc.TestServiceBlockingStub computeEngineStub = TestServiceGrpc.newBlockingStub((Channel)channel);
                    this.tester.computeEngineChannelCredentials(this.defaultServiceAccount, computeEngineStub);
                    break;
                }
                finally {
                    channel.shutdownNow();
                    channel.awaitTermination(5L, TimeUnit.SECONDS);
                }
            }
            case SERVICE_ACCOUNT_CREDS: {
                String jsonKey = Files.asCharSource((File)new File(this.serviceAccountKeyFile), (Charset)UTF_8).read();
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.serviceAccountCreds(jsonKey, credentialsStream, this.oauthScope);
                break;
            }
            case JWT_TOKEN_CREDS: {
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.jwtTokenCreds(credentialsStream);
                break;
            }
            case OAUTH2_AUTH_TOKEN: {
                String jsonKey = Files.asCharSource((File)new File(this.serviceAccountKeyFile), (Charset)UTF_8).read();
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.oauth2AuthToken(jsonKey, credentialsStream, this.oauthScope);
                break;
            }
            case PER_RPC_CREDS: {
                String jsonKey = Files.asCharSource((File)new File(this.serviceAccountKeyFile), (Charset)UTF_8).read();
                FileInputStream credentialsStream = new FileInputStream(new File(this.serviceAccountKeyFile));
                this.tester.perRpcCreds(jsonKey, credentialsStream, this.oauthScope);
                break;
            }
            case GOOGLE_DEFAULT_CREDENTIALS: {
                ManagedChannelBuilder builder = this.serverPort == 0 ? Grpc.newChannelBuilder((String)this.serverHost, (ChannelCredentials)GoogleDefaultChannelCredentials.create()) : Grpc.newChannelBuilderForAddress((String)this.serverHost, (int)this.serverPort, (ChannelCredentials)GoogleDefaultChannelCredentials.create());
                if (this.serviceConfig != null) {
                    builder.disableServiceConfigLookUp();
                    builder.defaultServiceConfig(this.serviceConfig);
                }
                ManagedChannel channel = builder.build();
                try {
                    TestServiceGrpc.TestServiceBlockingStub googleDefaultStub = TestServiceGrpc.newBlockingStub((Channel)channel);
                    this.tester.googleDefaultCredentials(this.defaultServiceAccount, googleDefaultStub);
                    break;
                }
                finally {
                    channel.shutdownNow();
                }
            }
            case CUSTOM_METADATA: {
                this.tester.customMetadata();
                break;
            }
            case STATUS_CODE_AND_MESSAGE: {
                this.tester.statusCodeAndMessage();
                break;
            }
            case SPECIAL_STATUS_MESSAGE: {
                this.tester.specialStatusMessage();
                break;
            }
            case UNIMPLEMENTED_METHOD: {
                this.tester.unimplementedMethod();
                break;
            }
            case UNIMPLEMENTED_SERVICE: {
                this.tester.unimplementedService();
                break;
            }
            case CANCEL_AFTER_BEGIN: {
                this.tester.cancelAfterBegin();
                break;
            }
            case CANCEL_AFTER_FIRST_RESPONSE: {
                this.tester.cancelAfterFirstResponse();
                break;
            }
            case TIMEOUT_ON_SLEEPING_SERVER: {
                this.tester.timeoutOnSleepingServer();
                break;
            }
            case VERY_LARGE_REQUEST: {
                this.tester.veryLargeRequest();
                break;
            }
            case PICK_FIRST_UNARY: {
                this.tester.pickFirstUnary();
                break;
            }
            case RPC_SOAK: {
                this.tester.performSoakTest(false, this.soakIterations, this.soakMaxFailures, this.soakPerIterationMaxAcceptableLatencyMs, this.soakMinTimeMsBetweenRpcs, this.soakOverallTimeoutSeconds);
                break;
            }
            case CHANNEL_SOAK: {
                this.tester.performSoakTest(true, this.soakIterations, this.soakMaxFailures, this.soakPerIterationMaxAcceptableLatencyMs, this.soakMinTimeMsBetweenRpcs, this.soakOverallTimeoutSeconds);
                break;
            }
            case ORCA_PER_RPC: {
                this.tester.testOrcaPerRpc();
                break;
            }
            case ORCA_OOB: {
                this.tester.testOrcaOob();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown test case: " + (Object)((Object)testCase));
            }
        }
    }

    private static String validTestCasesHelpText() {
        StringBuilder builder = new StringBuilder();
        for (TestCases testCase : TestCases.values()) {
            String strTestcase = testCase.name().toLowerCase();
            builder.append("\n      ").append(strTestcase).append(": ").append(testCase.description());
        }
        return builder.toString();
    }

    private class Tester
    extends AbstractInteropTest {
        private Tester() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected ManagedChannelBuilder<?> createChannelBuilder() {
            ChannelCredentials channelCredentials;
            boolean useGeneric = false;
            if (TestServiceClient.this.customCredentialsType != null) {
                useGeneric = true;
                if (TestServiceClient.this.customCredentialsType.equals("google_default_credentials")) {
                    channelCredentials = GoogleDefaultChannelCredentials.create();
                } else {
                    if (!TestServiceClient.this.customCredentialsType.equals("compute_engine_channel_creds")) throw new IllegalArgumentException("Unknown custom credentials: " + TestServiceClient.this.customCredentialsType);
                    channelCredentials = ComputeEngineChannelCredentials.create();
                }
            } else if (TestServiceClient.this.useAlts) {
                useGeneric = true;
                channelCredentials = TestServiceClient.this.localHandshakerPort > -1 ? AltsChannelCredentials.newBuilder().enableUntrustedAltsForTesting().setHandshakerAddressForTesting("localhost:" + TestServiceClient.this.localHandshakerPort).build() : AltsChannelCredentials.create();
            } else if (TestServiceClient.this.useTls) {
                if (!TestServiceClient.this.useTestCa) {
                    channelCredentials = TlsChannelCredentials.create();
                } else {
                    try {
                        channelCredentials = TlsChannelCredentials.newBuilder().trustManager(TestUtils.loadCert((String)"ca.pem")).build();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            } else if (TestServiceClient.this.useH2cUpgrade) {
                if (TestServiceClient.this.useOkHttp) {
                    throw new IllegalArgumentException("OkHttp does not support HTTP/1 upgrade");
                }
                channelCredentials = InsecureFromHttp1ChannelCredentials.create();
            } else {
                channelCredentials = InsecureChannelCredentials.create();
            }
            if (useGeneric) {
                ManagedChannelBuilder channelBuilder = TestServiceClient.this.serverPort == 0 ? Grpc.newChannelBuilder((String)TestServiceClient.this.serverHost, (ChannelCredentials)channelCredentials) : Grpc.newChannelBuilderForAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort, (ChannelCredentials)channelCredentials);
                if (TestServiceClient.this.serverHostOverride != null) {
                    channelBuilder.overrideAuthority(TestServiceClient.this.serverHostOverride);
                }
                if (TestServiceClient.this.serviceConfig == null) return channelBuilder;
                channelBuilder.disableServiceConfigLookUp();
                channelBuilder.defaultServiceConfig(TestServiceClient.this.serviceConfig);
                return channelBuilder;
            }
            if (!TestServiceClient.this.useOkHttp) {
                NettyChannelBuilder nettyBuilder = TestServiceClient.this.serverPort == 0 ? NettyChannelBuilder.forTarget((String)TestServiceClient.this.serverHost, (ChannelCredentials)channelCredentials) : NettyChannelBuilder.forAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort, (ChannelCredentials)channelCredentials);
                nettyBuilder.flowControlWindow(66560);
                if (TestServiceClient.this.serverHostOverride != null) {
                    nettyBuilder.overrideAuthority(TestServiceClient.this.serverHostOverride);
                }
                if (TestServiceClient.this.fullStreamDecompression) {
                    nettyBuilder.enableFullStreamDecompression();
                }
                InternalNettyChannelBuilder.setStatsEnabled((NettyChannelBuilder)nettyBuilder, (boolean)false);
                if (TestServiceClient.this.serviceConfig == null) return nettyBuilder.intercept(new ClientInterceptor[]{this.createCensusStatsClientInterceptor()});
                nettyBuilder.disableServiceConfigLookUp();
                nettyBuilder.defaultServiceConfig(TestServiceClient.this.serviceConfig);
                return nettyBuilder.intercept(new ClientInterceptor[]{this.createCensusStatsClientInterceptor()});
            }
            OkHttpChannelBuilder okBuilder = TestServiceClient.this.serverPort == 0 ? OkHttpChannelBuilder.forTarget((String)TestServiceClient.this.serverHost, (ChannelCredentials)channelCredentials) : OkHttpChannelBuilder.forAddress((String)TestServiceClient.this.serverHost, (int)TestServiceClient.this.serverPort, (ChannelCredentials)channelCredentials);
            if (TestServiceClient.this.serverHostOverride != null) {
                okBuilder.overrideAuthority(GrpcUtil.authorityFromHostAndPort((String)TestServiceClient.this.serverHostOverride, (int)TestServiceClient.this.serverPort));
            }
            if (TestServiceClient.this.fullStreamDecompression) {
                okBuilder.enableFullStreamDecompression();
            }
            InternalOkHttpChannelBuilder.setStatsEnabled((OkHttpChannelBuilder)okBuilder, (boolean)false);
            if (TestServiceClient.this.serviceConfig == null) return okBuilder.intercept(new ClientInterceptor[]{this.createCensusStatsClientInterceptor()});
            okBuilder.disableServiceConfigLookUp();
            okBuilder.defaultServiceConfig(TestServiceClient.this.serviceConfig);
            return okBuilder.intercept(new ClientInterceptor[]{this.createCensusStatsClientInterceptor()});
        }

        @Override
        protected boolean metricsExpected() {
            return false;
        }

        @Override
        @Nullable
        protected ServerBuilder<?> getHandshakerServerBuilder() {
            if (TestServiceClient.this.localHandshakerPort > -1) {
                return Grpc.newServerBuilderForPort((int)TestServiceClient.this.localHandshakerPort, (ServerCredentials)InsecureServerCredentials.create()).addService((BindableService)new AltsHandshakerTestService());
            }
            return null;
        }

        @Override
        protected int operationTimeoutMillis() {
            return 15000;
        }
    }
}

