/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing.integration;

import com.google.common.collect.Queues;
import com.google.protobuf.ByteString;
import com.google.protobuf.EmptyProtos;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.integration.Messages;
import io.grpc.testing.integration.TestServiceGrpc;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TestServiceImpl
implements TestServiceGrpc.TestService {
    private static final String UNCOMPRESSABLE_FILE = "/io/grpc/testing/integration/testdata/uncompressable.bin";
    private final Random random = new Random();
    private final ScheduledExecutorService executor;
    private final ByteString uncompressableBuffer;
    private final ByteString compressableBuffer;

    public TestServiceImpl(ScheduledExecutorService executor) {
        this.executor = executor;
        this.compressableBuffer = ByteString.copyFrom((byte[])new byte[1024]);
        this.uncompressableBuffer = this.createBufferFromFile(UNCOMPRESSABLE_FILE);
    }

    @Override
    public void emptyCall(EmptyProtos.Empty empty, StreamObserver<EmptyProtos.Empty> responseObserver) {
        responseObserver.onValue((Object)EmptyProtos.Empty.getDefaultInstance());
        responseObserver.onCompleted();
    }

    @Override
    public void unaryCall(Messages.SimpleRequest req, StreamObserver<Messages.SimpleResponse> responseObserver) {
        Messages.SimpleResponse.Builder responseBuilder = Messages.SimpleResponse.newBuilder();
        if (req.getResponseSize() != 0) {
            boolean compressable = this.compressableResponse(req.getResponseType());
            ByteString dataBuffer = compressable ? this.compressableBuffer : this.uncompressableBuffer;
            int offset = this.random.nextInt(compressable ? this.compressableBuffer.size() : this.uncompressableBuffer.size());
            ByteString payload = this.generatePayload(dataBuffer, offset, req.getResponseSize());
            responseBuilder.getPayloadBuilder().setType(compressable ? Messages.PayloadType.COMPRESSABLE : Messages.PayloadType.UNCOMPRESSABLE).setBody(payload);
        }
        responseObserver.onValue((Object)responseBuilder.build());
        responseObserver.onCompleted();
    }

    @Override
    public void streamingOutputCall(Messages.StreamingOutputCallRequest request, StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
        new ResponseDispatcher(responseObserver).enqueue(this.toChunkQueue(request)).completeInput();
    }

    @Override
    public StreamObserver<Messages.StreamingInputCallRequest> streamingInputCall(final StreamObserver<Messages.StreamingInputCallResponse> responseObserver) {
        return new StreamObserver<Messages.StreamingInputCallRequest>(){
            private int totalPayloadSize;

            public void onValue(Messages.StreamingInputCallRequest message) {
                this.totalPayloadSize += message.getPayload().getBody().size();
            }

            public void onCompleted() {
                responseObserver.onValue((Object)Messages.StreamingInputCallResponse.newBuilder().setAggregatedPayloadSize(this.totalPayloadSize).build());
                responseObserver.onCompleted();
            }

            public void onError(Throwable cause) {
                responseObserver.onError(cause);
            }
        };
    }

    @Override
    public StreamObserver<Messages.StreamingOutputCallRequest> fullDuplexCall(final StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
        final ResponseDispatcher dispatcher = new ResponseDispatcher(responseObserver);
        return new StreamObserver<Messages.StreamingOutputCallRequest>(){

            public void onValue(Messages.StreamingOutputCallRequest request) {
                dispatcher.enqueue(TestServiceImpl.this.toChunkQueue(request));
            }

            public void onCompleted() {
                dispatcher.completeInput();
            }

            public void onError(Throwable cause) {
                responseObserver.onError(cause);
            }
        };
    }

    @Override
    public StreamObserver<Messages.StreamingOutputCallRequest> halfDuplexCall(final StreamObserver<Messages.StreamingOutputCallResponse> responseObserver) {
        final LinkedList chunks = new LinkedList();
        return new StreamObserver<Messages.StreamingOutputCallRequest>(){

            public void onValue(Messages.StreamingOutputCallRequest request) {
                chunks.addAll(TestServiceImpl.this.toChunkQueue(request));
            }

            public void onCompleted() {
                new ResponseDispatcher((StreamObserver<Messages.StreamingOutputCallResponse>)responseObserver).enqueue(chunks).completeInput();
            }

            public void onError(Throwable cause) {
                responseObserver.onError(cause);
            }
        };
    }

    public Queue<Chunk> toChunkQueue(Messages.StreamingOutputCallRequest request) {
        LinkedList<Chunk> chunkQueue = new LinkedList<Chunk>();
        int offset = 0;
        boolean compressable = this.compressableResponse(request.getResponseType());
        for (Messages.ResponseParameters params : request.getResponseParametersList()) {
            chunkQueue.add(new Chunk(params.getIntervalUs(), offset, params.getSize(), compressable));
            offset = (offset + params.getSize()) % (compressable ? this.compressableBuffer.size() : this.uncompressableBuffer.size());
        }
        return chunkQueue;
    }

    private ByteString createBufferFromFile(String fileClassPath) {
        ByteString buffer = ByteString.EMPTY;
        InputStream inputStream = this.getClass().getResourceAsStream(fileClassPath);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to locate file on classpath: " + fileClassPath);
        }
        try {
            buffer = ByteString.readFrom((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return buffer;
    }

    private boolean compressableResponse(Messages.PayloadType responseType) {
        switch (responseType) {
            case COMPRESSABLE: {
                return true;
            }
            case RANDOM: {
                return this.random.nextBoolean();
            }
        }
        return false;
    }

    private ByteString generatePayload(ByteString dataBuffer, int offset, int size) {
        ByteString payload = ByteString.EMPTY;
        int begin = offset;
        int end = 0;
        for (int bytesLeft = size; bytesLeft > 0; bytesLeft -= end - begin) {
            end = Math.min(begin + bytesLeft, dataBuffer.size());
            payload = payload.concat(dataBuffer.substring(begin, end));
            begin = end % dataBuffer.size();
        }
        return payload;
    }

    private class Chunk {
        private final int delayMicroseconds;
        private final int offset;
        private final int length;
        private final boolean compressable;

        public Chunk(int delayMicroseconds, int offset, int length, boolean compressable) {
            this.delayMicroseconds = delayMicroseconds;
            this.offset = offset;
            this.length = length;
            this.compressable = compressable;
        }

        private Messages.StreamingOutputCallResponse toResponse() {
            Messages.StreamingOutputCallResponse.Builder responseBuilder = Messages.StreamingOutputCallResponse.newBuilder();
            ByteString dataBuffer = this.compressable ? TestServiceImpl.this.compressableBuffer : TestServiceImpl.this.uncompressableBuffer;
            ByteString payload = TestServiceImpl.this.generatePayload(dataBuffer, this.offset, this.length);
            responseBuilder.getPayloadBuilder().setType(this.compressable ? Messages.PayloadType.COMPRESSABLE : Messages.PayloadType.UNCOMPRESSABLE).setBody(payload);
            return responseBuilder.build();
        }
    }

    private class ResponseDispatcher {
        private final Queue<Chunk> chunks;
        private final StreamObserver<Messages.StreamingOutputCallResponse> responseStream;
        private volatile boolean isInputComplete;
        private boolean scheduled;
        private Runnable dispatchTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        ResponseDispatcher.this.dispatchChunk();
                    }
                    catch (RuntimeException e) {
                        ResponseDispatcher responseDispatcher = ResponseDispatcher.this;
                        synchronized (responseDispatcher) {
                            ResponseDispatcher.this.scheduled = false;
                        }
                        throw e;
                    }
                    ResponseDispatcher e = ResponseDispatcher.this;
                    synchronized (e) {
                        ResponseDispatcher.this.scheduled = false;
                        ResponseDispatcher.this.scheduleNextChunk();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };

        public ResponseDispatcher(StreamObserver<Messages.StreamingOutputCallResponse> responseStream) {
            this.chunks = Queues.newLinkedBlockingQueue();
            this.responseStream = responseStream;
        }

        public synchronized ResponseDispatcher enqueue(Queue<Chunk> moreChunks) {
            this.chunks.addAll(moreChunks);
            this.scheduleNextChunk();
            return this;
        }

        public ResponseDispatcher completeInput() {
            this.isInputComplete = true;
            this.scheduleNextChunk();
            return this;
        }

        private void dispatchChunk() {
            try {
                Chunk chunk = this.chunks.remove();
                this.responseStream.onValue((Object)chunk.toResponse());
            }
            catch (Throwable e) {
                this.responseStream.onError(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleNextChunk() {
            ResponseDispatcher responseDispatcher = this;
            synchronized (responseDispatcher) {
                if (this.scheduled) {
                    return;
                }
                Chunk nextChunk = this.chunks.peek();
                if (nextChunk != null) {
                    this.scheduled = true;
                    TestServiceImpl.this.executor.schedule(this.dispatchTask, (long)nextChunk.delayMicroseconds, TimeUnit.MICROSECONDS);
                    return;
                }
            }
            if (this.isInputComplete) {
                this.responseStream.onCompleted();
            }
        }
    }
}

