/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.logging;

import com.google.cloud.logging.LogEntry;
import com.google.common.annotations.VisibleForTesting;
import io.grpc.Internal;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.TraceId;

@Internal
public class TraceLoggingHelper {
    private final String tracePrefix;

    public TraceLoggingHelper(String projectId) {
        this.tracePrefix = "projects/" + projectId + "/traces/";
    }

    @VisibleForTesting
    void enhanceLogEntry(LogEntry.Builder builder, SpanContext spanContext) {
        TraceLoggingHelper.addTracingData(this.tracePrefix, spanContext, builder);
    }

    private static void addTracingData(String tracePrefix, SpanContext spanContext, LogEntry.Builder builder) {
        builder.setTrace(TraceLoggingHelper.formatTraceId(tracePrefix, spanContext.getTraceId()));
        builder.setSpanId(spanContext.getSpanId().toLowerBase16());
        builder.setTraceSampled(spanContext.getTraceOptions().isSampled());
    }

    private static String formatTraceId(String tracePrefix, TraceId traceId) {
        return tracePrefix + traceId.toLowerBase16();
    }
}

