/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability;

import io.grpc.Internal;
import io.opencensus.trace.Sampler;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@Internal
public interface ObservabilityConfig {
    public boolean isEnableCloudLogging();

    public boolean isEnableCloudMonitoring();

    public boolean isEnableCloudTracing();

    public String getProjectId();

    public List<LogFilter> getClientLogFilters();

    public List<LogFilter> getServerLogFilters();

    public Sampler getSampler();

    public Map<String, String> getCustomTags();

    @ThreadSafe
    public static class LogFilter {
        public final Set<String> services;
        public final Set<String> methods;
        public final boolean matchAll;
        public final int headerBytes;
        public final int messageBytes;
        public final boolean excludePattern;

        public LogFilter(Set<String> services, Set<String> serviceMethods, boolean matchAll, int headerBytes, int messageBytes, boolean excludePattern) {
            this.services = services;
            this.methods = serviceMethods;
            this.matchAll = matchAll;
            this.headerBytes = headerBytes;
            this.messageBytes = messageBytes;
            this.excludePattern = excludePattern;
        }
    }
}

