/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.internal.LongCounter;
import java.util.concurrent.atomic.AtomicLongArray;

final class ShardedAtomicLongCounter
implements LongCounter {
    private final AtomicLongArray counters;
    private final int mask;

    ShardedAtomicLongCounter(int numShardsHint) {
        int numShards = ShardedAtomicLongCounter.forcePower2(numShardsHint);
        this.counters = new AtomicLongArray(numShards);
        this.mask = numShards - 1;
    }

    static int forcePower2(int numShardsHint) {
        if (numShardsHint >= 64) {
            return 64;
        }
        if (numShardsHint >= 32) {
            return 32;
        }
        if (numShardsHint >= 16) {
            return 16;
        }
        return 8;
    }

    @VisibleForTesting
    int getCounterIdx(int hashCode) {
        return hashCode & this.mask;
    }

    @Override
    public void add(long delta) {
        this.counters.addAndGet(this.getCounterIdx(Thread.currentThread().hashCode()), delta);
    }

    @Override
    public long value() {
        long val = 0L;
        for (int i = 0; i < this.counters.length(); ++i) {
            val += this.counters.get(i);
        }
        return val;
    }
}

