/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.FailingClientStream;
import io.grpc.internal.TransportTracer;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;

    FailingClientTransport(Status error) {
        Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"error must not be OK");
        this.error = error;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
        return new FailingClientStream(this.error);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public Future<TransportTracer.Stats> getTransportStats() {
        SettableFuture ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }
}

