/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractStream2;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.MessageFramer;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.WritableBuffer;
import io.grpc.internal.WritableBufferAllocator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public abstract class AbstractClientStream2
extends AbstractStream2
implements ClientStream,
MessageFramer.Sink {
    private static final Logger log = Logger.getLogger(AbstractClientStream2.class.getName());
    private final MessageFramer framer;
    private boolean outboundClosed;
    private volatile boolean cancelled;

    protected AbstractClientStream2(WritableBufferAllocator bufferAllocator, StatsTraceContext statsTraceCtx) {
        this.framer = new MessageFramer(this, bufferAllocator, statsTraceCtx);
    }

    @Override
    public void setMaxOutboundMessageSize(int maxSize) {
        this.framer.setMaxOutboundMessageSize(maxSize);
    }

    @Override
    public void setMaxInboundMessageSize(int maxSize) {
        this.transportState().setMaxInboundMessageSize(maxSize);
    }

    @Override
    protected abstract TransportState transportState();

    @Override
    public void start(ClientStreamListener listener) {
        this.transportState().setListener(listener);
    }

    protected abstract Sink abstractClientStreamSink();

    @Override
    protected final MessageFramer framer() {
        return this.framer;
    }

    @Override
    public final void request(int numMessages) {
        this.abstractClientStreamSink().request(numMessages);
    }

    @Override
    public final void deliverFrame(WritableBuffer frame, boolean endOfStream, boolean flush) {
        Preconditions.checkArgument((frame != null || endOfStream ? 1 : 0) != 0, (Object)"null frame before EOS");
        this.abstractClientStreamSink().writeFrame(frame, endOfStream, flush);
    }

    @Override
    public final void halfClose() {
        if (!this.outboundClosed) {
            this.outboundClosed = true;
            this.endOfMessages();
        }
    }

    @Override
    public final void cancel(Status reason) {
        Preconditions.checkArgument((!reason.isOk() ? 1 : 0) != 0, (Object)"Should not cancel with OK status");
        this.cancelled = true;
        this.abstractClientStreamSink().cancel(reason);
    }

    @Override
    public final boolean isReady() {
        return super.isReady() && !this.cancelled;
    }

    protected static abstract class TransportState
    extends AbstractStream2.TransportState {
        private boolean listenerClosed;
        private ClientStreamListener listener;
        private Runnable deliveryStalledTask;
        private boolean headersReceived;
        private boolean statusReported;

        protected TransportState(int maxMessageSize, StatsTraceContext statsTraceCtx) {
            super(maxMessageSize, statsTraceCtx);
        }

        @VisibleForTesting
        public final void setListener(ClientStreamListener listener) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Already called setListener");
            this.listener = (ClientStreamListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        }

        @Override
        public final void deliveryStalled() {
            if (this.deliveryStalledTask != null) {
                this.deliveryStalledTask.run();
                this.deliveryStalledTask = null;
            }
        }

        @Override
        public final void endOfStream() {
            this.deliveryStalled();
        }

        @Override
        protected final ClientStreamListener listener() {
            return this.listener;
        }

        protected void inboundHeadersReceived(Metadata headers) {
            Preconditions.checkState((!this.statusReported ? 1 : 0) != 0, (Object)"Received headers on closed stream");
            this.headersReceived = true;
            this.listener().headersRead(headers);
        }

        protected void inboundDataReceived(ReadableBuffer frame) {
            Preconditions.checkNotNull((Object)frame, (Object)"frame");
            boolean needToCloseFrame = true;
            try {
                if (this.statusReported) {
                    log.log(Level.INFO, "Received data on closed stream");
                    return;
                }
                if (!this.headersReceived) {
                    this.transportReportStatus(Status.INTERNAL.withDescription("headers not received before payload"), false, new Metadata());
                    return;
                }
                needToCloseFrame = false;
                this.deframe(frame, false);
            }
            finally {
                if (needToCloseFrame) {
                    frame.close();
                }
            }
        }

        protected void inboundTrailersReceived(Metadata trailers, Status status) {
            Preconditions.checkNotNull((Object)status, (Object)"status");
            Preconditions.checkNotNull((Object)trailers, (Object)"trailers");
            if (this.statusReported) {
                log.log(Level.INFO, "Received trailers on closed stream:\n {1}\n {2}", new Object[]{status, trailers});
                return;
            }
            this.transportReportStatus(status, false, trailers);
        }

        public final void transportReportStatus(final Status status, boolean stopDelivery, final Metadata trailers) {
            Preconditions.checkNotNull((Object)status, (Object)"status");
            Preconditions.checkNotNull((Object)trailers, (Object)"trailers");
            if (this.statusReported && !stopDelivery) {
                return;
            }
            this.statusReported = true;
            this.onStreamDeallocated();
            if (stopDelivery || this.isDeframerStalled()) {
                this.deliveryStalledTask = null;
                this.closeListener(status, trailers);
            } else {
                this.deliveryStalledTask = new Runnable(){

                    @Override
                    public void run() {
                        TransportState.this.closeListener(status, trailers);
                    }
                };
            }
        }

        private void closeListener(Status status, Metadata trailers) {
            if (!this.listenerClosed) {
                this.listenerClosed = true;
                this.closeDeframer();
                this.listener().closed(status, trailers);
            }
        }
    }

    protected static interface Sink {
        public void writeFrame(@Nullable WritableBuffer var1, boolean var2, boolean var3);

        public void request(int var1);

        public void cancel(Status var1);
    }
}

