/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import io.grpc.Attributes;
import io.grpc.NameResolverProvider;
import io.grpc.internal.DnsNameResolver;
import io.grpc.internal.GrpcUtil;
import java.net.URI;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";

    @Override
    public DnsNameResolver newNameResolver(URI targetUri, Attributes params) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
            Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, params, GrpcUtil.SHARED_CHANNEL_EXECUTOR, GrpcUtil.getDefaultProxyDetector(), Stopwatch.createUnstarted());
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 5;
    }
}

