/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.Preconditions;
import com.google.instrumentation.stats.StatsContextFactory;
import io.grpc.inprocess.InProcessServer;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.internal.NoopStatsContextFactory;
import java.io.File;

public final class InProcessServerBuilder
extends AbstractServerImplBuilder<InProcessServerBuilder> {
    private final String name;

    public static InProcessServerBuilder forName(String name) {
        return new InProcessServerBuilder(name);
    }

    private InProcessServerBuilder(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        super.statsContextFactory(NoopStatsContextFactory.INSTANCE);
    }

    @Override
    protected InProcessServer buildTransportServer() {
        return new InProcessServer(this.name);
    }

    @Override
    public InProcessServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS not supported in InProcessServer");
    }

    @Override
    public InProcessServerBuilder statsContextFactory(StatsContextFactory statsFactory) {
        return this;
    }
}

