/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import java.net.SocketAddress;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ResolvedServerInfo {
    private final SocketAddress address;
    private final Attributes attributes;

    public ResolvedServerInfo(SocketAddress address) {
        this(address, Attributes.EMPTY);
    }

    public ResolvedServerInfo(SocketAddress address, Attributes attributes) {
        this.address = (SocketAddress)Preconditions.checkNotNull((Object)address);
        this.attributes = (Attributes)Preconditions.checkNotNull((Object)attributes);
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "[address=" + this.address + ", attrs=" + this.attributes + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolvedServerInfo that = (ResolvedServerInfo)o;
        return Objects.equal((Object)this.address, (Object)that.address) && Objects.equal((Object)this.attributes, (Object)that.attributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.address, this.attributes});
    }
}

