/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.NameResolver;
import io.grpc.ResolvedServerInfoGroup;
import io.grpc.Status;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@NotThreadSafe
public abstract class LoadBalancer2 {
    public abstract void handleResolvedAddresses(List<ResolvedServerInfoGroup> var1, Attributes var2);

    public abstract void handleNameResolutionError(Status var1);

    public abstract void handleSubchannelState(Subchannel var1, ConnectivityStateInfo var2);

    public abstract void shutdown();

    @ThreadSafe
    public static abstract class Factory {
        public abstract LoadBalancer2 newLoadBalancer(Helper var1);
    }

    @ThreadSafe
    public static abstract class Subchannel {
        public abstract void shutdown();

        public abstract void requestConnection();

        public abstract EquivalentAddressGroup getAddresses();

        public abstract Attributes getAttributes();
    }

    @ThreadSafe
    public static abstract class Helper {
        public abstract Subchannel createSubchannel(EquivalentAddressGroup var1, Attributes var2);

        public abstract ManagedChannel createOobChannel(EquivalentAddressGroup var1, String var2);

        public abstract void updatePicker(SubchannelPicker var1);

        public abstract void runSerialized(Runnable var1);

        public abstract NameResolver.Factory getNameResolverFactory();

        public abstract String getAuthority();
    }

    @Immutable
    public static final class PickResult {
        private static final PickResult NO_RESULT = new PickResult(null, Status.OK);
        @Nullable
        private final Subchannel subchannel;
        private final Status status;

        private PickResult(Subchannel subchannel, Status status) {
            this.subchannel = subchannel;
            this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
        }

        public static PickResult withSubchannel(Subchannel subchannel) {
            return new PickResult((Subchannel)Preconditions.checkNotNull((Object)subchannel, (Object)"subchannel"), Status.OK);
        }

        public static PickResult withError(Status error) {
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"error status shouldn't be OK");
            return new PickResult(null, error);
        }

        public static PickResult withNoResult() {
            return NO_RESULT;
        }

        @Nullable
        public Subchannel getSubchannel() {
            return this.subchannel;
        }

        public Status getStatus() {
            return this.status;
        }

        public String toString() {
            return "[subchannel=" + this.subchannel + " status=" + this.status + "]";
        }
    }

    @ThreadSafe
    public static abstract class SubchannelPicker {
        public abstract PickResult pickSubchannel(Attributes var1, Metadata var2);
    }
}

