/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.HandlerRegistry;
import io.grpc.MutableHandlerRegistry;
import io.grpc.MutableHandlerRegistryImpl;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import io.grpc.internal.Server;
import io.grpc.internal.ServerImpl;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private final HandlerRegistry registry;
    @Nullable
    private Executor executor;

    protected AbstractServerImplBuilder(HandlerRegistry registry) {
        this.registry = (HandlerRegistry)Preconditions.checkNotNull((Object)registry);
    }

    protected AbstractServerImplBuilder() {
        this.registry = new MutableHandlerRegistryImpl();
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        if (this.registry instanceof MutableHandlerRegistry) {
            ((MutableHandlerRegistry)this.registry).addService(service);
            return this.thisT();
        }
        throw new UnsupportedOperationException("Underlying HandlerRegistry is not mutable");
    }

    @Override
    public ServerImpl build() {
        Server transportServer = this.buildTransportServer();
        return new ServerImpl(this.executor, this.registry, transportServer);
    }

    protected abstract Server buildTransportServer();

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

