/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.transport;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import io.grpc.DeferredInputStream;
import io.grpc.transport.WritableBuffer;
import io.grpc.transport.WritableBufferAllocator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPOutputStream;

public class MessageFramer {
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED = 0;
    private static final byte COMPRESSED = 1;
    private final Sink sink;
    private WritableBuffer buffer;
    private final Compression compression;
    private final OutputStreamAdapter outputStreamAdapter = new OutputStreamAdapter();
    private final byte[] headerScratch = new byte[5];
    private final WritableBufferAllocator bufferAllocator;
    private boolean closed;

    public MessageFramer(Sink sink, WritableBufferAllocator bufferAllocator) {
        this(sink, bufferAllocator, Compression.NONE);
    }

    public MessageFramer(Sink sink, WritableBufferAllocator bufferAllocator, Compression compression) {
        this.sink = (Sink)Preconditions.checkNotNull((Object)sink, (Object)"sink");
        this.bufferAllocator = bufferAllocator;
        this.compression = (Compression)((Object)Preconditions.checkNotNull((Object)((Object)compression), (Object)"compression"));
    }

    public void writePayload(InputStream message, int messageLength) {
        try {
            switch (this.compression) {
                case NONE: {
                    this.writeFrame(message, messageLength, false);
                    break;
                }
                case GZIP: {
                    DirectAccessByteArrayOutputStream out = new DirectAccessByteArrayOutputStream();
                    this.gzipCompressTo(message, messageLength, out);
                    DeferredByteArrayInputStream compressedMessage = new DeferredByteArrayInputStream(out.getBuf(), 0, out.getCount());
                    this.writeFrame(compressedMessage, out.getCount(), true);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown compression type");
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gzipCompressTo(InputStream in, int messageLength, OutputStream out) throws IOException {
        GZIPOutputStream compressingStream = new GZIPOutputStream(out);
        try {
            long written = MessageFramer.writeToOutputStream(in, compressingStream);
            if ((long)messageLength != written) {
                throw new RuntimeException("Message length was inaccurate");
            }
        }
        finally {
            compressingStream.close();
        }
    }

    private void writeFrame(InputStream message, int messageLength, boolean compressed) throws IOException {
        this.verifyNotClosed();
        ByteBuffer header = ByteBuffer.wrap(this.headerScratch);
        header.put(compressed ? (byte)1 : 0);
        header.putInt(messageLength);
        if (this.buffer == null) {
            this.buffer = this.bufferAllocator.allocate(header.position() + messageLength);
        }
        this.writeRaw(this.headerScratch, 0, header.position());
        long written = MessageFramer.writeToOutputStream(message, this.outputStreamAdapter);
        if ((long)messageLength != written) {
            throw new RuntimeException("Message length was inaccurate");
        }
    }

    private static long writeToOutputStream(InputStream message, OutputStream outputStream) throws IOException {
        if (message instanceof DeferredInputStream) {
            return ((DeferredInputStream)message).flushTo(outputStream);
        }
        if (message instanceof DeferredByteArrayInputStream) {
            return ((DeferredByteArrayInputStream)message).flushTo(outputStream);
        }
        return ByteStreams.copy((InputStream)message, (OutputStream)outputStream);
    }

    private void writeRaw(byte[] b, int off, int len) {
        while (len > 0) {
            if (this.buffer != null && this.buffer.writableBytes() == 0) {
                this.commitToSink(false, false);
            }
            if (this.buffer == null) {
                this.buffer = this.bufferAllocator.allocate(len);
            }
            int toWrite = Math.min(len, this.buffer.writableBytes());
            this.buffer.write(b, off, toWrite);
            off += toWrite;
            len -= toWrite;
        }
    }

    public void flush() {
        if (this.buffer != null && this.buffer.readableBytes() > 0) {
            this.commitToSink(false, true);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (!this.isClosed()) {
            this.closed = true;
            if (this.buffer != null && this.buffer.readableBytes() == 0) {
                this.buffer.release();
                this.buffer = null;
            }
            this.commitToSink(true, true);
        }
    }

    public void dispose() {
        this.closed = true;
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    private void commitToSink(boolean endOfStream, boolean flush) {
        this.sink.deliverFrame(this.buffer, endOfStream, flush);
        this.buffer = null;
    }

    private void verifyNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Framer already closed");
        }
    }

    private static class DirectAccessByteArrayOutputStream
    extends ByteArrayOutputStream {
        private DirectAccessByteArrayOutputStream() {
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class DeferredByteArrayInputStream
    extends ByteArrayInputStream {
        public DeferredByteArrayInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        public int flushTo(OutputStream os) throws IOException {
            os.write(this.buf, this.pos, this.count - this.pos);
            return this.count - this.pos;
        }
    }

    private class OutputStreamAdapter
    extends OutputStream {
        private final byte[] singleByte = new byte[1];

        private OutputStreamAdapter() {
        }

        @Override
        public void write(int b) {
            this.singleByte[0] = (byte)b;
            this.write(this.singleByte, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            MessageFramer.this.writeRaw(b, off, len);
        }
    }

    public static enum Compression {
        NONE,
        GZIP;

    }

    public static interface Sink {
        public void deliverFrame(WritableBuffer var1, boolean var2, boolean var3);
    }
}

