/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.Compressor;
import io.grpc.Decompressor;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.NoopClientStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

class DelayedStream
implements ClientStream {
    private volatile ClientStream startedRealStream;
    @GuardedBy(value="this")
    private String authority;
    @GuardedBy(value="this")
    private ClientStreamListener listener;
    @GuardedBy(value="this")
    private ClientStream realStream;
    @GuardedBy(value="this")
    private Status error;
    @GuardedBy(value="this")
    private final List<PendingMessage> pendingMessages = new LinkedList<PendingMessage>();
    private boolean messageCompressionEnabled;
    @GuardedBy(value="this")
    private boolean pendingHalfClose;
    @GuardedBy(value="this")
    private int pendingFlowControlRequests;
    @GuardedBy(value="this")
    private boolean pendingFlush;
    @GuardedBy(value="this")
    private Compressor compressor;
    @GuardedBy(value="this")
    private Decompressor decompressor;

    DelayedStream() {
    }

    @Override
    public synchronized void setAuthority(String authority) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"must be called before start");
        Preconditions.checkNotNull((Object)authority, (Object)"authority");
        if (this.realStream == null) {
            this.authority = authority;
        } else {
            this.realStream.setAuthority(authority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ClientStreamListener listener) {
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
            this.listener = (ClientStreamListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            if (this.error != null) {
                listener.closed(this.error, new Metadata());
            }
            if (this.realStream != null) {
                this.startStream();
            }
        }
    }

    @GuardedBy(value="this")
    private void startStream() {
        Preconditions.checkState((this.realStream != null ? 1 : 0) != 0, (Object)"realStream");
        Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"listener");
        this.realStream.start(this.listener);
        if (this.decompressor != null) {
            this.realStream.setDecompressor(this.decompressor);
        }
        if (this.compressor != null) {
            this.realStream.setCompressor(this.compressor);
        }
        for (PendingMessage message : this.pendingMessages) {
            this.realStream.setMessageCompression(message.shouldBeCompressed);
            this.realStream.writeMessage(message.message);
        }
        this.realStream.setMessageCompression(this.messageCompressionEnabled);
        this.pendingMessages.clear();
        if (this.pendingHalfClose) {
            this.realStream.halfClose();
            this.pendingHalfClose = false;
        }
        if (this.pendingFlowControlRequests > 0) {
            this.realStream.request(this.pendingFlowControlRequests);
            this.pendingFlowControlRequests = 0;
        }
        if (this.pendingFlush) {
            this.realStream.flush();
            this.pendingFlush = false;
        }
        this.startedRealStream = this.realStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStream(ClientStream stream) {
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (this.error != null) {
                return;
            }
            Preconditions.checkState((this.realStream == null ? 1 : 0) != 0, (String)"Stream already created: %s", (Object[])new Object[]{this.realStream});
            this.realStream = (ClientStream)Preconditions.checkNotNull((Object)stream, (Object)"stream");
            if (this.listener != null) {
                this.startStream();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setError(Status reason) {
        DelayedStream delayedStream = this;
        synchronized (delayedStream) {
            if (this.error == null) {
                this.error = (Status)Preconditions.checkNotNull((Object)reason);
                this.realStream = NoopClientStream.INSTANCE;
                if (this.listener != null) {
                    this.listener.closed(this.error, new Metadata());
                    this.startStream();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMessage(InputStream message) {
        if (this.startedRealStream == null) {
            DelayedStream delayedStream = this;
            synchronized (delayedStream) {
                if (this.startedRealStream == null) {
                    this.pendingMessages.add(new PendingMessage(message, this.messageCompressionEnabled));
                    return;
                }
            }
        }
        this.startedRealStream.writeMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        if (this.startedRealStream == null) {
            DelayedStream delayedStream = this;
            synchronized (delayedStream) {
                if (this.startedRealStream == null) {
                    this.pendingFlush = true;
                    return;
                }
            }
        }
        this.startedRealStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Status reason) {
        if (this.startedRealStream == null) {
            DelayedStream delayedStream = this;
            synchronized (delayedStream) {
                if (this.startedRealStream == null) {
                    this.setError(reason);
                    return;
                }
            }
        }
        this.startedRealStream.cancel(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void halfClose() {
        if (this.startedRealStream == null) {
            DelayedStream delayedStream = this;
            synchronized (delayedStream) {
                if (this.startedRealStream == null) {
                    this.pendingHalfClose = true;
                    return;
                }
            }
        }
        this.startedRealStream.halfClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(int numMessages) {
        if (this.startedRealStream == null) {
            DelayedStream delayedStream = this;
            synchronized (delayedStream) {
                if (this.startedRealStream == null) {
                    this.pendingFlowControlRequests += numMessages;
                    return;
                }
            }
        }
        this.startedRealStream.request(numMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCompressor(Compressor compressor) {
        if (this.startedRealStream == null) {
            DelayedStream delayedStream = this;
            synchronized (delayedStream) {
                if (this.startedRealStream == null) {
                    this.compressor = compressor;
                    return;
                }
            }
        }
        this.startedRealStream.setCompressor(compressor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDecompressor(Decompressor decompressor) {
        if (this.startedRealStream == null) {
            DelayedStream delayedStream = this;
            synchronized (delayedStream) {
                if (this.startedRealStream == null) {
                    this.decompressor = decompressor;
                    return;
                }
            }
        }
        this.startedRealStream.setDecompressor(decompressor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReady() {
        if (this.startedRealStream == null) {
            DelayedStream delayedStream = this;
            synchronized (delayedStream) {
                if (this.startedRealStream == null) {
                    return false;
                }
            }
        }
        return this.startedRealStream.isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMessageCompression(boolean enable) {
        if (this.startedRealStream == null) {
            DelayedStream delayedStream = this;
            synchronized (delayedStream) {
                if (this.startedRealStream == null) {
                    this.messageCompressionEnabled = enable;
                    return;
                }
            }
        }
        this.startedRealStream.setMessageCompression(enable);
    }

    static final class PendingMessage {
        final InputStream message;
        final boolean shouldBeCompressed;

        public PendingMessage(InputStream message, boolean shouldBeCompressed) {
            this.message = message;
            this.shouldBeCompressed = shouldBeCompressed;
        }
    }
}

